﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from VehicleTemplate.tt />

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Core.Controller;
    using Eco.Core.Items;
    using Eco.Core.Utils;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.Components.Auth;
	using Eco.Gameplay.Components.Storage;
    using Eco.Gameplay.Components.VehicleModules;
    using Eco.Gameplay.GameActions;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Interactions;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Items.Recipes;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Occupancy;
    using Eco.Gameplay.Systems.Exhaustion;
    using Eco.Gameplay.Systems.NewTooltip;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Math;
    using Eco.Shared.Networking;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.Items;
    using Eco.Mods.Components.VehicleModules;
    using static Eco.Gameplay.Components.PartsComponent;

    [Serialized]
    [LocDisplayName("Medium Fishing Trawler")]
    [LocDescription("")]
    [IconGroup("World Object Minimap")]
    [Weight(25000)]
    [AirPollution(0.4f)]
    [WaterPlaceable]
    [Ecopedia("Crafted Objects", "Vehicles", createAsSubPage: true)]
    public partial class MediumFishingTrawlerItem : WorldObjectItem<MediumFishingTrawlerObject>, IPersistentData
    {
        public float InteractDistance => DefaultInteractDistance.WaterPlacement;
        public bool ShouldHighlight(Type block) => false;
        [Serialized, SyncToView, NewTooltipChildren(CacheAs.Instance, flags: TTFlags.AllowNonControllerTypeForChildren)] public object PersistentData { get; set; }
    }

    /// <summary>
    /// <para>Server side recipe definition for "MediumFishingTrawler".</para>
    /// <para>More information about RecipeFamily objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.RecipeFamily.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [RequiresSkill(typeof(ShipwrightSkill), 5)]
    [Ecopedia("Crafted Objects", "Vehicles", subPageName: "Medium Fishing Trawler Item")]
    public partial class MediumFishingTrawlerRecipe : RecipeFamily
    {
        public MediumFishingTrawlerRecipe()
        {
            var recipe = new Recipe();
            recipe.Init(
                name: "MediumFishingTrawler",  //noloc
                displayName: Localizer.DoStr("Medium Fishing Trawler"),

                // Defines the ingredients needed to craft this recipe. An ingredient items takes the following inputs
                // type of the item, the amount of the item, the skill required, and the talent used.
                ingredients: new List<IngredientElement>
                {
                    new IngredientElement(typeof(IronHullSheetItem), 8, typeof(ShipwrightSkill)),
                    new IngredientElement(typeof(WoodenHullPlanksItem), 4, typeof(ShipwrightSkill)),
                    new IngredientElement(typeof(HempMooringRopeItem), 8, typeof(ShipwrightSkill)),
                    new IngredientElement(typeof(MetalRudderItem), 1, true),
                    new IngredientElement(typeof(IronAxleItem), 1, true),
                    new IngredientElement(typeof(IronAnchorItem), 1, true),
                    new IngredientElement(typeof(PortableSteamEngineItem), 1, true),
                    new IngredientElement(typeof(MediumMetalShipFrameItem), 1, true),
                    new IngredientElement(typeof(LubricantItem), 2, true),
                },

                // Define our recipe output items.
                // For every output item there needs to be one CraftingElement entry with the type of the final item and the amount
                // to create.
                items: new List<CraftingElement>
                {
                    new CraftingElement<MediumFishingTrawlerItem>()
                });
            this.Recipes = new List<Recipe> { recipe };
            this.ExperienceOnCraft = 24; // Defines how much experience is gained when crafted.
            
            // Defines the amount of labor required and the required skill to add labor
            this.LaborInCalories = CreateLaborInCaloriesValue(1200, typeof(ShipwrightSkill));

            // Defines our crafting time for the recipe
            this.CraftMinutes = CreateCraftTimeValue(beneficiary: typeof(MediumFishingTrawlerRecipe), start: 15, skillType: typeof(ShipwrightSkill));

            // Perform pre/post initialization for user mods and initialize our recipe instance with the display name "Medium Fishing Trawler"
            this.ModsPreInitialize();
            this.Initialize(displayText: Localizer.DoStr("Medium Fishing Trawler"), recipeType: typeof(MediumFishingTrawlerRecipe));
            this.ModsPostInitialize();

            // Register our RecipeFamily instance with the crafting system so it can be crafted.
            CraftingComponent.AddRecipe(tableType: typeof(MediumShipyardObject), recipeFamily: this);
        }

        /// <summary>Hook for mods to customize RecipeFamily before initialization. You can change recipes, xp, labor, time here.</summary>
        partial void ModsPreInitialize();

        /// <summary>Hook for mods to customize RecipeFamily after initialization, but before registration. You can change skill requirements here.</summary>
        partial void ModsPostInitialize();
    }

    [Serialized]
    [RequireComponent(typeof(StandaloneAuthComponent))]
    [RequireComponent(typeof(FuelSupplyComponent))]
    [RequireComponent(typeof(FuelConsumptionComponent))]
    [RequireComponent(typeof(PublicStorageComponent))]
    [RequireComponent(typeof(TailingsReportComponent))]
    [RequireComponent(typeof(MovableLinkComponent))]
    [RequireComponent(typeof(AirPollutionComponent))]
    [RequireComponent(typeof(VehicleComponent))]
    [RequireComponent(typeof(BoatComponent))]
    [RequireComponent(typeof(LadderComponent))]
    [RequireComponent(typeof(FishingComponent))]
    [RequireComponent(typeof(ModularVehicleComponent))]
    [RequireComponent(typeof(MinimapComponent))]           
    [RequireComponent(typeof(PartsComponent))]
    [RepairRequiresSkill(typeof(ShipwrightSkill), 5)]
    [ExhaustableUnlessOverridenVehicle]
    [Ecopedia("Crafted Objects", "Vehicles", subPageName: "MediumFishingTrawler Item")]
    public partial class MediumFishingTrawlerObject : PhysicsWorldObject, IRepresentsItem
    {
        static MediumFishingTrawlerObject()
        {
            WorldObject.AddOccupancy<MediumFishingTrawlerObject>(new List<BlockOccupancy>(0));
        }
        public override float InteractDistance => DefaultInteractDistance.WaterPlacement;
        public override TableTextureMode TableTexture => TableTextureMode.Metal;
        public override bool PlacesBlocks            => false;
        public override LocString DisplayName { get { return Localizer.DoStr("Medium Fishing Trawler"); } }
        public Type RepresentedItemType { get { return typeof(MediumFishingTrawlerItem); } }

        private static string[] fuelTagList = new string[]
        {
            "Burnable Fuel",
        };
        private MediumFishingTrawlerObject() { }
        private static readonly Type[] SegmentTypeList = Array.Empty<Type>();
        private static readonly Type[] AttachmentTypeList = new Type[]
        {
            typeof(FlaxTrawlerNetItem),
            typeof(NylonTrawlerNetItem),
        };
        protected override void Initialize()
        {
            this.ModsPreInitialize();
            base.Initialize();         
            this.GetComponent<FuelSupplyComponent>().Initialize(2, fuelTagList);
            this.GetComponent<FuelConsumptionComponent>().Initialize(150);
            this.GetComponent<AirPollutionComponent>().Initialize(0.4f);
            this.GetComponent<VehicleComponent>().HumanPowered(0.5f);
            this.GetComponent<PublicStorageComponent>().Initialize(8, 1400000);
            this.GetComponent<FishingComponent>().Initialize(8, 1400000);
            this.GetComponent<ModularVehicleComponent>().Initialize(0, 1, SegmentTypeList, AttachmentTypeList);
            this.GetComponent<MinimapComponent>().InitAsMovable();
            this.GetComponent<MinimapComponent>().SetCategory(Localizer.DoStr("Vehicles"));
            this.GetComponent<VehicleComponent>().Initialize(10, 2,1, null, true);
            this.GetComponent<BoatComponent>().Size = BoatComponent.BoatSize.Large;
            this.GetComponent<VehicleComponent>().FailDriveMsg = Localizer.Do($"You are too hungry to drive {this.DisplayName}!");
            this.ModsPostInitialize();
                        {
                this.GetComponent<PartsComponent>().Config(() => LocString.Empty, new PartInfo[]
                {
                                        new() { TypeName = nameof(HempMooringRopeItem), Quantity = 2},
                                        new() { TypeName = nameof(PortableSteamEngineItem), Quantity = 1},
                                        new() { TypeName = nameof(LubricantItem), Quantity = 2},
                                    });
            }
        }

        /// <summary>Hook for mods to customize before initialization. You can change housing values here.</summary>
        partial void ModsPreInitialize();
        /// <summary>Hook for mods to customize after initialization.</summary>
        partial void ModsPostInitialize();
    }
}
