﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from VehicleTemplate.tt />

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Core.Controller;
    using Eco.Core.Items;
    using Eco.Core.Utils;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.Components.Auth;
	using Eco.Gameplay.Components.Storage;
    using Eco.Gameplay.Components.VehicleModules;
    using Eco.Gameplay.GameActions;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Interactions;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Items.Recipes;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Occupancy;
    using Eco.Gameplay.Systems.Exhaustion;
    using Eco.Gameplay.Systems.NewTooltip;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Math;
    using Eco.Shared.Networking;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.Items;
    using static Eco.Gameplay.Components.PartsComponent;

    [Serialized]
    [LocDisplayName("Wooden Transport Ship")]
    [LocDescription("")]
    [IconGroup("World Object Minimap")]
    [Weight(20000)]
    [WaterPlaceable]
    [Ecopedia("Crafted Objects", "Vehicles", createAsSubPage: true)]
    public partial class WoodenTransportShipItem : WorldObjectItem<WoodenTransportShipObject>, IPersistentData
    {
        public float InteractDistance => DefaultInteractDistance.WaterPlacement;
        public bool ShouldHighlight(Type block) => false;
        [Serialized, SyncToView, NewTooltipChildren(CacheAs.Instance, flags: TTFlags.AllowNonControllerTypeForChildren)] public object PersistentData { get; set; }
    }

    /// <summary>
    /// <para>Server side recipe definition for "WoodenTransportShip".</para>
    /// <para>More information about RecipeFamily objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.RecipeFamily.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [RequiresSkill(typeof(ShipwrightSkill), 2)]
    [Ecopedia("Crafted Objects", "Vehicles", subPageName: "Wooden Transport Ship Item")]
    public partial class WoodenTransportShipRecipe : RecipeFamily
    {
        public WoodenTransportShipRecipe()
        {
            var recipe = new Recipe();
            recipe.Init(
                name: "WoodenTransportShip",  //noloc
                displayName: Localizer.DoStr("Wooden Transport Ship"),

                // Defines the ingredients needed to craft this recipe. An ingredient items takes the following inputs
                // type of the item, the amount of the item, the skill required, and the talent used.
                ingredients: new List<IngredientElement>
                {
                    new IngredientElement(typeof(WoodenHullPlanksItem), 18, typeof(ShipwrightSkill)),
                    new IngredientElement(typeof(IronBarItem), 4, typeof(ShipwrightSkill)),
                    new IngredientElement(typeof(HempMooringRopeItem), 4, typeof(ShipwrightSkill)),
                    new IngredientElement(typeof(WoodenRudderItem), 1, true),
                    new IngredientElement(typeof(IronAxleItem), 1, true),
                    new IngredientElement(typeof(PortableSteamEngineItem), 1, true),
                    new IngredientElement(typeof(LargeWoodenShipFrameItem), 1, true),
                    new IngredientElement(typeof(LubricantItem), 2, true),
                },

                // Define our recipe output items.
                // For every output item there needs to be one CraftingElement entry with the type of the final item and the amount
                // to create.
                items: new List<CraftingElement>
                {
                    new CraftingElement<WoodenTransportShipItem>()
                });
            this.Recipes = new List<Recipe> { recipe };
            this.ExperienceOnCraft = 10; // Defines how much experience is gained when crafted.
            
            // Defines the amount of labor required and the required skill to add labor
            this.LaborInCalories = CreateLaborInCaloriesValue(1000, typeof(ShipwrightSkill));

            // Defines our crafting time for the recipe
            this.CraftMinutes = CreateCraftTimeValue(beneficiary: typeof(WoodenTransportShipRecipe), start: 15, skillType: typeof(ShipwrightSkill));

            // Perform pre/post initialization for user mods and initialize our recipe instance with the display name "Wooden Transport Ship"
            this.ModsPreInitialize();
            this.Initialize(displayText: Localizer.DoStr("Wooden Transport Ship"), recipeType: typeof(WoodenTransportShipRecipe));
            this.ModsPostInitialize();

            // Register our RecipeFamily instance with the crafting system so it can be crafted.
            CraftingComponent.AddRecipe(tableType: typeof(MediumShipyardObject), recipeFamily: this);
        }

        /// <summary>Hook for mods to customize RecipeFamily before initialization. You can change recipes, xp, labor, time here.</summary>
        partial void ModsPreInitialize();

        /// <summary>Hook for mods to customize RecipeFamily after initialization, but before registration. You can change skill requirements here.</summary>
        partial void ModsPostInitialize();
    }

    [Serialized]
    [RequireComponent(typeof(StandaloneAuthComponent))]
    [RequireComponent(typeof(FuelSupplyComponent))]
    [RequireComponent(typeof(FuelConsumptionComponent))]
    [RequireComponent(typeof(PublicStorageComponent))]
    [RequireComponent(typeof(TailingsReportComponent))]
    [RequireComponent(typeof(MovableLinkComponent))]
    [RequireComponent(typeof(VehicleComponent))]
    [RequireComponent(typeof(BoatComponent))]
    [RequireComponent(typeof(LadderComponent))]
    [RequireComponent(typeof(MinimapComponent))]           
    [RequireComponent(typeof(PartsComponent))]
    [RepairRequiresSkill(typeof(ShipwrightSkill), 2)]
    [Ecopedia("Crafted Objects", "Vehicles", subPageName: "WoodenTransportShip Item")]
    public partial class WoodenTransportShipObject : PhysicsWorldObject, IRepresentsItem
    {
        static WoodenTransportShipObject()
        {
            WorldObject.AddOccupancy<WoodenTransportShipObject>(new List<BlockOccupancy>(0));
        }
        public override float InteractDistance => DefaultInteractDistance.WaterPlacement;
        public override TableTextureMode TableTexture => TableTextureMode.Wood;
        public override bool PlacesBlocks            => false;
        public override LocString DisplayName { get { return Localizer.DoStr("Wooden Transport Ship"); } }
        public Type RepresentedItemType { get { return typeof(WoodenTransportShipItem); } }

        private static string[] fuelTagList = new string[]
        {
            "Burnable Fuel",
        };
        private WoodenTransportShipObject() { }
        protected override void Initialize()
        {
            this.ModsPreInitialize();
            base.Initialize();         
            this.GetComponent<FuelSupplyComponent>().Initialize(2, fuelTagList);
            this.GetComponent<FuelConsumptionComponent>().Initialize(150);
            this.GetComponent<VehicleComponent>().HumanPowered(0.5f);
            this.GetComponent<LinkComponent>().Initialize(15);
            this.GetComponent<PublicStorageComponent>().Initialize(48, 14000000);
            this.GetComponent<MinimapComponent>().InitAsMovable();
            this.GetComponent<MinimapComponent>().SetCategory(Localizer.DoStr("Vehicles"));
            this.GetComponent<VehicleComponent>().Initialize(10, 2,7, null, true);
            this.GetComponent<BoatComponent>().Size = BoatComponent.BoatSize.Large;
            this.GetComponent<VehicleComponent>().FailDriveMsg = Localizer.Do($"You are too hungry to drive {this.DisplayName}!");
            this.ModsPostInitialize();
                        {
                this.GetComponent<PartsComponent>().Config(() => LocString.Empty, new PartInfo[]
                {
                                        new() { TypeName = nameof(WoodenHullPlanksItem), Quantity = 4},
                                        new() { TypeName = nameof(PortableSteamEngineItem), Quantity = 1},
                                        new() { TypeName = nameof(LubricantItem), Quantity = 2},
                                    });
            }
        }

        /// <summary>Hook for mods to customize before initialization. You can change housing values here.</summary>
        partial void ModsPreInitialize();
        /// <summary>Hook for mods to customize after initialization.</summary>
        partial void ModsPostInitialize();
    }
}
