﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.

namespace Eco.Mods.TechTree
{
    using System.Linq;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.Players;

    public partial class FocusedWorkflowTalent : Talent
    {
        public override bool HasActiveRequirements { get { return true; } }
        public override bool Active(object obj, User user = null)
        {
            var cc = obj as CraftingComponent;
            if (cc != null)
                if (cc.Parent.TryGetComponent<RoomRequirementsComponent>(out var reqComp) && reqComp.LastRoomStats?.ContainedWorldObjects.Where(x => x.GetType() == cc.Parent.GetType()).Count() > 1)
                    return false;
            return true;
        }
    }
}
