﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.

namespace Eco.Mods.Organisms
{
    using System;
    using System.Collections.Generic;
	using Eco.Core.Items;
    using Eco.Gameplay.Animals;
	using Eco.Gameplay.GameActions;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Players;
    using Eco.Mods.TechTree;
    using Eco.Shared.Localization;
    using Eco.Shared.Networking;
    using Eco.Shared.SharedTypes;
    using Eco.Shared.States;
    using Eco.Shared.Utils;
    using Eco.Simulation.Agents;
    using Eco.Simulation.Agents.AI;
    using Eco.Simulation.Types;
    using Range = Eco.Shared.Math.Range;
    using Vector3 = System.Numerics.Vector3;

    public partial class Tortoise : AnimalEntity
    {
		public Tortoise(Animal parent, Vector3 pos, AnimalSpecies species, bool corpse, bool sick, int herdID) : base(parent, pos, species, corpse, sick, herdID) { }

		public static float BlockDamage(INetObject damager, float damage, AnimalEntity entity )
        {
            //Animal todo
            // turtle power! (or uhh tortoise power!)
            /*if (entity.State == AnimalState.Hiding)
            {
                damage /= 4;
                // TODO: sound effect of arrow bouncing off
                if (damager is Player damagerPlayer) damagerPlayer.MsgLoc($"{entity.Species.Name}: Arrow damage mitigated by tortoise shell!");
            }
            */
            return damage;
        }

        public override GameActionPack TryApplyDamage(GameActionPack pack, INetObject damager, float damage, InteractionTarget target, Item tool, out float damageReceived, Type damageDealer = null, float experienceMultiplier = 1f)
        {
            damage = BlockDamage(damager, damage, this);
            return base.TryApplyDamage(pack, damager, damage, target, tool, out damageReceived, damageDealer, experienceMultiplier);
        }
    }
}
