﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.

namespace Eco.Mods.Organisms
{
    using System;
    using System.Collections.Generic;
    using Eco.Mods.TechTree;
    using Eco.Simulation.Types;
    using Eco.World.Blocks;
    using Range = Eco.Shared.Math.Range;
    
    public partial class Oak : TreeEntity
    {
        public partial class OakSpecies : TreeSpecies
        {
            partial void SetDefaultProperties()
            {
                // Lifetime
                this.TreeHealth = 20f;
                this.LogHealth = 2f;
                // Resources
                this.ChanceToSpawnDebris = 0.4f;
                // Visuals
                this.BranchingDef = new List<TreeBranchDef>()
                {
                    new TreeBranchDef { Name = "Branch0", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.1f, 0.15f), GrowthEndTime = new Range(0.8f, 1f) },
                    new TreeBranchDef { Name = "Branch1", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.15f, 0.2f), GrowthEndTime = new Range(0.8f, 1f) },
                    new TreeBranchDef { Name = "Branch2", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.2f, 0.25f), GrowthEndTime = new Range(0.8f, 1f) },
                    new TreeBranchDef { Name = "Branch3", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.25f, 0.3f), GrowthEndTime = new Range(0.8f, 1f) },
                    new TreeBranchDef { Name = "Branch4", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.3f, 0.35f), GrowthEndTime = new Range(0.8f, 1f) },
                    new TreeBranchDef { Name = "Branch5", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.35f, 0.4f), GrowthEndTime = new Range(0.8f, 1f) },
                    new TreeBranchDef { Name = "Branch6", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.4f, 0.45f), GrowthEndTime = new Range(0.8f, 1f) },
                    new TreeBranchDef { Name = "Branch7", Health = 3f, LeafPoints = 1, GrowthStartTime = new Range(0.45f, 0.5f), GrowthEndTime = new Range(0.8f, 1f) },
                };
                this.TopBranchLeafPoints = 1;
                this.TopBranchHealth = 3;
                this.BranchRotations = new float[] {0f, 90f, 180f, 270f};
                this.RandomYRotation = false;
                this.BranchCount = new Range(2f, 4f);
                this.BlockType = typeof(TreeBlock);
                this.DebrisType = typeof(OakTreeDebrisBlock);
                this.DebrisResources = new Dictionary<Type, Range>()
                {
                    { typeof(WoodPulpItem), new Range(4, 5) },
                    { typeof(AcornItem), new Range(0, 1) },
                };
                this.TrunkResources = new Dictionary<Type, Range>()
                {
                    { typeof(WoodPulpItem), new Range(8, 10) }
                };
                this.XZScaleRange = new Range(.8f, 1.4f);
                this.YScaleRange = new Range(.8f, 1.4f);
                this.Density = 740f;
            }
        }
    }
}
