﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated />

namespace Eco.Mods
{
    // This is an auto-generated file
    // Do not modify this file directly

    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Pipes;
    using Eco.Mods.TechTree;
    using Eco.Shared.Localization;
    using Eco.Shared.Math;
    using Eco.Shared.Serialization;
    using Eco.World.Blocks;
    using Eco.World;
    using Eco.Gameplay.Occupancy;

    [Serialized, Category("Hidden")] // Admins can create this item. Server crash is possible without serialization.
    public class OccupancyInitItem : Item
    {
        static OccupancyInitItem()
        {
            WorldObjectOccupancy.InitializePart1();
            WorldObjectOccupancy.InitializePart2();
            WorldObjectOccupancy.InitializePart3();
            WorldObjectOccupancy.InitializePart4();
            WorldObjectOccupancy.InitializePart5();
        }
    }

    public static class WorldObjectOccupancy
    {
        public static void InitializePart1()
        {
            // AnvilObject
            WorldObject.AddOccupancy<AnvilObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // BakeryOvenObject
            WorldObject.AddOccupancy<BakeryOvenObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(1, 1, 0), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            });
            // BlastFurnaceObject
            WorldObject.AddOccupancy<BlastFurnaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(1, 4, 1), typeof(PipeSlotBlock), new Quaternion(-0.7071071f, 2.634177E-07f, 2.634179E-07f, 0.7071065f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(2, 0, 2), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, -0.7071068f, 0f, 0.7071068f), BlockOccupancyType.SewageOutputPort),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            });
            // BloomeryObject
            WorldObject.AddOccupancy<BloomeryObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // BookshelfObject
            WorldObject.AddOccupancy<BookshelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // ShelfCabinetObject
            WorldObject.AddOccupancy<ShelfCabinetObject>(new List<BlockOccupancy>(){
                new BlockOccupancy(new Vector3i(0, 0, 0)),
                new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // BrazierObject
            WorldObject.AddOccupancy<BrazierObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // ButcheryTableObject
            WorldObject.AddOccupancy<ButcheryTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // CampfireObject
            WorldObject.AddOccupancy<CampfireObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            });
            // CandleStandObject
            WorldObject.AddOccupancy<CandleStandObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CarpentryTableObject
            WorldObject.AddOccupancy<CarpentryTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // CarvedPumpkinObject
            WorldObject.AddOccupancy<CarvedPumpkinObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CastIronStoveObject
            WorldObject.AddOccupancy<CastIronStoveObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 1, -1), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CeilingCandleObject
            WorldObject.AddOccupancy<CeilingCandleObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CementKilnObject
            WorldObject.AddOccupancy<CementKilnObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(PipeSlotBlock), new Quaternion(-0.7071068f, 0f, 0f, 0.7071068f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            });
            // CombustionGeneratorObject
            WorldObject.AddOccupancy<CombustionGeneratorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(2, 2, 2), typeof(PipeSlotBlock), new Quaternion(-0.7071068f, 0f, 0f, 0.7071068f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(4, 0, 1), typeof(PipeSlotBlock), new Quaternion(0f, 0.7071068f, 0f, 0.7071068f), BlockOccupancyType.SewageOutputPort),
            new BlockOccupancy(new Vector3i(3, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 2)),
            });
            // ComputerLabObject
            WorldObject.AddOccupancy<ComputerLabObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // ConstructionPostObject
            WorldObject.AddOccupancy<ConstructionPostObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ContractBoardObject
            WorldObject.AddOccupancy<ContractBoardObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // CurrencyExchangeObject
            WorldObject.AddOccupancy<CurrencyExchangeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            });
            // DoorObject
            WorldObject.AddOccupancy<DoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            });
            // FramedGlassDoorObject
            WorldObject.AddOccupancy<FramedGlassDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // ElectricWallLampObject
            WorldObject.AddOccupancy<ElectricWallLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ElectronicsAssemblyObject
            WorldObject.AddOccupancy<ElectronicsAssemblyObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // FarmersTableObject
            WorldObject.AddOccupancy<FarmersTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // KilnObject
            WorldObject.AddOccupancy<KilnObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // KitchenObject
            WorldObject.AddOccupancy<KitchenObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LaboratoryObject
            WorldObject.AddOccupancy<LaboratoryObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(1, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, -0.7071068f, 0f, -0.7071068f), BlockOccupancyType.SewageOutputPort),
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, -0.7071068f, 0f, 0.7071068f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // LaserObject
            WorldObject.AddOccupancy<LaserObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            });
            // LatrineObject
            WorldObject.AddOccupancy<LatrineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MillObject
            WorldObject.AddOccupancy<MillObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // MintObject
            WorldObject.AddOccupancy<MintObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            });
            // OilRefineryObject
            WorldObject.AddOccupancy<OilRefineryObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(4, 0, 4), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.SewageOutputPort),
            new BlockOccupancy(new Vector3i(0, 7, 4), typeof(PipeSlotBlock), new Quaternion(-0.7071068f, 0f, 0f, 0.7071068f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(2, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.OilInputPort),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 6, 3)),
            new BlockOccupancy(new Vector3i(0, 6, 4)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 7, 2)),
            new BlockOccupancy(new Vector3i(0, 7, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 3)),
            new BlockOccupancy(new Vector3i(1, 4, 4)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 5, 2)),
            new BlockOccupancy(new Vector3i(1, 5, 3)),
            new BlockOccupancy(new Vector3i(1, 5, 4)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 6, 1)),
            new BlockOccupancy(new Vector3i(1, 6, 2)),
            new BlockOccupancy(new Vector3i(1, 6, 3)),
            new BlockOccupancy(new Vector3i(1, 6, 4)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 7, 1)),
            new BlockOccupancy(new Vector3i(1, 7, 2)),
            new BlockOccupancy(new Vector3i(1, 7, 3)),
            new BlockOccupancy(new Vector3i(1, 7, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 3)),
            new BlockOccupancy(new Vector3i(2, 4, 4)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 5, 2)),
            new BlockOccupancy(new Vector3i(2, 5, 3)),
            new BlockOccupancy(new Vector3i(2, 5, 4)),
            new BlockOccupancy(new Vector3i(2, 6, 0)),
            new BlockOccupancy(new Vector3i(2, 6, 1)),
            new BlockOccupancy(new Vector3i(2, 6, 2)),
            new BlockOccupancy(new Vector3i(2, 6, 3)),
            new BlockOccupancy(new Vector3i(2, 6, 4)),
            new BlockOccupancy(new Vector3i(2, 7, 0)),
            new BlockOccupancy(new Vector3i(2, 7, 1)),
            new BlockOccupancy(new Vector3i(2, 7, 2)),
            new BlockOccupancy(new Vector3i(2, 7, 3)),
            new BlockOccupancy(new Vector3i(2, 7, 4)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 4, 2)),
            new BlockOccupancy(new Vector3i(3, 4, 3)),
            new BlockOccupancy(new Vector3i(3, 4, 4)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 5, 2)),
            new BlockOccupancy(new Vector3i(3, 5, 3)),
            new BlockOccupancy(new Vector3i(3, 5, 4)),
            new BlockOccupancy(new Vector3i(3, 6, 0)),
            new BlockOccupancy(new Vector3i(3, 6, 1)),
            new BlockOccupancy(new Vector3i(3, 6, 2)),
            new BlockOccupancy(new Vector3i(3, 6, 3)),
            new BlockOccupancy(new Vector3i(3, 6, 4)),
            new BlockOccupancy(new Vector3i(3, 7, 0)),
            new BlockOccupancy(new Vector3i(3, 7, 1)),
            new BlockOccupancy(new Vector3i(3, 7, 2)),
            new BlockOccupancy(new Vector3i(3, 7, 3)),
            new BlockOccupancy(new Vector3i(3, 7, 4)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 4)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 2)),
            new BlockOccupancy(new Vector3i(4, 2, 3)),
            new BlockOccupancy(new Vector3i(4, 2, 4)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 2)),
            new BlockOccupancy(new Vector3i(4, 3, 3)),
            new BlockOccupancy(new Vector3i(4, 3, 4)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 4, 1)),
            new BlockOccupancy(new Vector3i(4, 4, 2)),
            new BlockOccupancy(new Vector3i(4, 4, 3)),
            new BlockOccupancy(new Vector3i(4, 4, 4)),
            new BlockOccupancy(new Vector3i(4, 5, 0)),
            new BlockOccupancy(new Vector3i(4, 5, 1)),
            new BlockOccupancy(new Vector3i(4, 5, 2)),
            new BlockOccupancy(new Vector3i(4, 5, 3)),
            new BlockOccupancy(new Vector3i(4, 5, 4)),
            new BlockOccupancy(new Vector3i(4, 6, 0)),
            new BlockOccupancy(new Vector3i(4, 6, 1)),
            new BlockOccupancy(new Vector3i(4, 6, 2)),
            new BlockOccupancy(new Vector3i(4, 6, 3)),
            new BlockOccupancy(new Vector3i(4, 6, 4)),
            new BlockOccupancy(new Vector3i(4, 7, 0)),
            new BlockOccupancy(new Vector3i(4, 7, 1)),
            new BlockOccupancy(new Vector3i(4, 7, 2)),
            new BlockOccupancy(new Vector3i(4, 7, 3)),
            new BlockOccupancy(new Vector3i(4, 7, 4)),
            });
            // PlanterPotRoundObject
            WorldObject.AddOccupancy<PlanterPotRoundObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // PlanterPotSquareObject
            WorldObject.AddOccupancy<PlanterPotSquareObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // PumpJackObject
            WorldObject.AddOccupancy<PumpJackObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            });
            // MasonryTableObject
            WorldObject.AddOccupancy<MasonryTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // ResearchTableObject
            WorldObject.AddOccupancy<ResearchTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // RollingMillObject
            WorldObject.AddOccupancy<RollingMillObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            //WorldObject.AddOccupancy<RollingMillObject>(new List<BlockOccupancy>(){
            //new BlockOccupancy(new Vector3i(0, 0, 0), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(0, 0, 1), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(0, 1, 0), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(0, 1, 1), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(0, 2, 0), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(0, 2, 1), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(1, 0, 0), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(1, 0, 1), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(1, 1, 0), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(1, 1, 1), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(1, 2, 0), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //new BlockOccupancy(new Vector3i(1, 2, 1), typeof(WorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            //});

            // RugLargeObject
            WorldObject.AddOccupancy<RugLargeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            });
            // RugMediumObject
            WorldObject.AddOccupancy<RugMediumObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            });
            // RugSmallObject
            WorldObject.AddOccupancy<RugSmallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            });
            // SaltBasketObject
            WorldObject.AddOccupancy<SaltBasketObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SawmillObject
            WorldObject.AddOccupancy<SawmillObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 3)),
            new BlockOccupancy(new Vector3i(5, 0, 0)),
            new BlockOccupancy(new Vector3i(5, 0, 1)),
            new BlockOccupancy(new Vector3i(5, 0, 2)),
            new BlockOccupancy(new Vector3i(5, 0, 3)),
            new BlockOccupancy(new Vector3i(5, 1, 0)),
            new BlockOccupancy(new Vector3i(5, 1, 1)),
            new BlockOccupancy(new Vector3i(5, 1, 2)),
            new BlockOccupancy(new Vector3i(5, 1, 3)),
            new BlockOccupancy(new Vector3i(6, 0, 0)),
            new BlockOccupancy(new Vector3i(6, 0, 1)),
            new BlockOccupancy(new Vector3i(6, 0, 2)),
            new BlockOccupancy(new Vector3i(6, 0, 3)),
            new BlockOccupancy(new Vector3i(6, 1, 0)),
            new BlockOccupancy(new Vector3i(6, 1, 1)),
            new BlockOccupancy(new Vector3i(6, 1, 2)),
            new BlockOccupancy(new Vector3i(6, 1, 3)),
            });
            // StockpileObject
            WorldObject.AddOccupancy<StockpileObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            });
            // StoneBrazierObject
            WorldObject.AddOccupancy<StoneBrazierObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StorageChestObject
            WorldObject.AddOccupancy<StorageChestObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // StoreObject
            WorldObject.AddOccupancy<StoreObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // StoveObject
            WorldObject.AddOccupancy<StoveObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(PipeSlotBlock), new Quaternion(-0.7071068f, 0f, 0f, 0.7071068f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            });
            // StreetlampObject
            WorldObject.AddOccupancy<StreetlampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            });
            // TailoringTableObject
            WorldObject.AddOccupancy<TailoringTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // TallowCandleObject
            WorldObject.AddOccupancy<TallowCandleObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // TallowLampObject
            WorldObject.AddOccupancy<TallowLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // TallowWallLampObject
            WorldObject.AddOccupancy<TallowWallLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // TransmissionPoleObject
            WorldObject.AddOccupancy<TransmissionPoleObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            });
            // TreasuryObject
            WorldObject.AddOccupancy<TreasuryObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),

            });
            // WainwrightTableObject
            WorldObject.AddOccupancy<WainwrightTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // WallCandleObject
            WorldObject.AddOccupancy<WallCandleObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WindmillObject
            WorldObject.AddOccupancy<WindmillObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, -3, 1)),
            new BlockOccupancy(new Vector3i(-3, -2, 1)),
            new BlockOccupancy(new Vector3i(-3, -1, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, -3, 1)),
            new BlockOccupancy(new Vector3i(-2, -2, 1)),
            new BlockOccupancy(new Vector3i(-2, -1, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, -3, 1)),
            new BlockOccupancy(new Vector3i(-1, -2, 1)),
            new BlockOccupancy(new Vector3i(-1, -1, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(0, -3, 1)),
            new BlockOccupancy(new Vector3i(0, -2, 1)),
            new BlockOccupancy(new Vector3i(0, -1, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(1, -3, 1)),
            new BlockOccupancy(new Vector3i(1, -2, 1)),
            new BlockOccupancy(new Vector3i(1, -1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(2, -3, 1)),
            new BlockOccupancy(new Vector3i(2, -2, 1)),
            new BlockOccupancy(new Vector3i(2, -1, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(3, -3, 1)),
            new BlockOccupancy(new Vector3i(3, -2, 1)),
            new BlockOccupancy(new Vector3i(3, -1, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(WaterWorldObjectBlock), Quaternion.Identity, BlockOccupancyType.CustomSurfaceAttachment),// Center block.
            });
            // WoodenFabricBedObject
            WorldObject.AddOccupancy<WoodenFabricBedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            });
            // WoodenStrawBedObject
            WorldObject.AddOccupancy<WoodenStrawBedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WorkbenchObject
            WorldObject.AddOccupancy<WorkbenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // WindTurbineObject
            WorldObject.AddOccupancy<WindTurbineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, 1)),
            new BlockOccupancy(new Vector3i(-3, 5, -1)),
            new BlockOccupancy(new Vector3i(-3, 5, 0)),
            new BlockOccupancy(new Vector3i(-3, 5, 1)),
            new BlockOccupancy(new Vector3i(-3, 6, -1)),
            new BlockOccupancy(new Vector3i(-3, 6, 0)),
            new BlockOccupancy(new Vector3i(-3, 6, 1)),
            new BlockOccupancy(new Vector3i(-3, 7, -1)),
            new BlockOccupancy(new Vector3i(-3, 7, 0)),
            new BlockOccupancy(new Vector3i(-3, 7, 1)),
            new BlockOccupancy(new Vector3i(-3, 8, -1)),
            new BlockOccupancy(new Vector3i(-3, 8, 0)),
            new BlockOccupancy(new Vector3i(-3, 8, 1)),
            new BlockOccupancy(new Vector3i(-3, 9, -1)),
            new BlockOccupancy(new Vector3i(-3, 9, 0)),
            new BlockOccupancy(new Vector3i(-3, 9, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 6, -1)),
            new BlockOccupancy(new Vector3i(-2, 6, 0)),
            new BlockOccupancy(new Vector3i(-2, 6, 1)),
            new BlockOccupancy(new Vector3i(-2, 7, -1)),
            new BlockOccupancy(new Vector3i(-2, 7, 0)),
            new BlockOccupancy(new Vector3i(-2, 7, 1)),
            new BlockOccupancy(new Vector3i(-2, 8, -1)),
            new BlockOccupancy(new Vector3i(-2, 8, 0)),
            new BlockOccupancy(new Vector3i(-2, 8, 1)),
            new BlockOccupancy(new Vector3i(-2, 9, -1)),
            new BlockOccupancy(new Vector3i(-2, 9, 0)),
            new BlockOccupancy(new Vector3i(-2, 9, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 6, -1)),
            new BlockOccupancy(new Vector3i(-1, 6, 0)),
            new BlockOccupancy(new Vector3i(-1, 6, 1)),
            new BlockOccupancy(new Vector3i(-1, 7, -1)),
            new BlockOccupancy(new Vector3i(-1, 7, 0)),
            new BlockOccupancy(new Vector3i(-1, 7, 1)),
            new BlockOccupancy(new Vector3i(-1, 8, -1)),
            new BlockOccupancy(new Vector3i(-1, 8, 0)),
            new BlockOccupancy(new Vector3i(-1, 8, 1)),
            new BlockOccupancy(new Vector3i(-1, 9, -1)),
            new BlockOccupancy(new Vector3i(-1, 9, 0)),
            new BlockOccupancy(new Vector3i(-1, 9, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 7, -1)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 8, -1)),
            new BlockOccupancy(new Vector3i(0, 8, 0)),
            new BlockOccupancy(new Vector3i(0, 8, 1)),
            new BlockOccupancy(new Vector3i(0, 9, -1)),
            new BlockOccupancy(new Vector3i(0, 9, 0)),
            new BlockOccupancy(new Vector3i(0, 9, 1)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 6, -1)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 6, 1)),
            new BlockOccupancy(new Vector3i(1, 7, -1)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 7, 1)),
            new BlockOccupancy(new Vector3i(1, 8, -1)),
            new BlockOccupancy(new Vector3i(1, 8, 0)),
            new BlockOccupancy(new Vector3i(1, 8, 1)),
            new BlockOccupancy(new Vector3i(1, 9, -1)),
            new BlockOccupancy(new Vector3i(1, 9, 0)),
            new BlockOccupancy(new Vector3i(1, 9, 1)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 6, -1)),
            new BlockOccupancy(new Vector3i(2, 6, 0)),
            new BlockOccupancy(new Vector3i(2, 6, 1)),
            new BlockOccupancy(new Vector3i(2, 7, -1)),
            new BlockOccupancy(new Vector3i(2, 7, 0)),
            new BlockOccupancy(new Vector3i(2, 7, 1)),
            new BlockOccupancy(new Vector3i(2, 8, -1)),
            new BlockOccupancy(new Vector3i(2, 8, 0)),
            new BlockOccupancy(new Vector3i(2, 8, 1)),
            new BlockOccupancy(new Vector3i(2, 9, -1)),
            new BlockOccupancy(new Vector3i(2, 9, 0)),
            new BlockOccupancy(new Vector3i(2, 9, 1)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 6, -1)),
            new BlockOccupancy(new Vector3i(3, 6, 0)),
            new BlockOccupancy(new Vector3i(3, 6, 1)),
            new BlockOccupancy(new Vector3i(3, 7, -1)),
            new BlockOccupancy(new Vector3i(3, 7, 0)),
            new BlockOccupancy(new Vector3i(3, 7, 1)),
            new BlockOccupancy(new Vector3i(3, 8, -1)),
            new BlockOccupancy(new Vector3i(3, 8, 0)),
            new BlockOccupancy(new Vector3i(3, 8, 1)),
            new BlockOccupancy(new Vector3i(3, 9, -1)),
            new BlockOccupancy(new Vector3i(3, 9, 0)),
            new BlockOccupancy(new Vector3i(3, 9, 1)),
            });
            // IceboxObject
            WorldObject.AddOccupancy<IceboxObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // RefrigeratorObject
            WorldObject.AddOccupancy<RefrigeratorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // TorchStandObject
            WorldObject.AddOccupancy<TorchStandObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WashboardObject
            WorldObject.AddOccupancy<WashboardObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WashingMachineObject
            WorldObject.AddOccupancy<WashingMachineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // PaddedChairObject
            WorldObject.AddOccupancy<PaddedChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CouchObject
            WorldObject.AddOccupancy<CouchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // EckoStatueObject
            WorldObject.AddOccupancy<EckoStatueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SolarGeneratorObject
            WorldObject.AddOccupancy<SolarGeneratorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(1, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, -1f, 0f, 0f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 3, 6)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 5)),
            new BlockOccupancy(new Vector3i(1, 0, 6)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 1, 6)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 2, 6)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 5)),
            new BlockOccupancy(new Vector3i(1, 3, 6)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 5)),
            new BlockOccupancy(new Vector3i(2, 0, 6)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 5)),
            new BlockOccupancy(new Vector3i(2, 1, 6)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 5)),
            new BlockOccupancy(new Vector3i(2, 2, 6)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 5)),
            new BlockOccupancy(new Vector3i(2, 3, 6)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 0, 5)),
            new BlockOccupancy(new Vector3i(3, 0, 6)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 5)),
            new BlockOccupancy(new Vector3i(3, 1, 6)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 5)),
            new BlockOccupancy(new Vector3i(3, 2, 6)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 5)),
            new BlockOccupancy(new Vector3i(3, 3, 6)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 3)),
            new BlockOccupancy(new Vector3i(4, 0, 4)),
            new BlockOccupancy(new Vector3i(4, 0, 5)),
            new BlockOccupancy(new Vector3i(4, 0, 6)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 4)),
            new BlockOccupancy(new Vector3i(4, 1, 5)),
            new BlockOccupancy(new Vector3i(4, 1, 6)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 2)),
            new BlockOccupancy(new Vector3i(4, 2, 3)),
            new BlockOccupancy(new Vector3i(4, 2, 4)),
            new BlockOccupancy(new Vector3i(4, 2, 5)),
            new BlockOccupancy(new Vector3i(4, 2, 6)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 2)),
            new BlockOccupancy(new Vector3i(4, 3, 3)),
            new BlockOccupancy(new Vector3i(4, 3, 4)),
            new BlockOccupancy(new Vector3i(4, 3, 5)),
            new BlockOccupancy(new Vector3i(4, 3, 6)),
            new BlockOccupancy(new Vector3i(5, 0, 0)),
            new BlockOccupancy(new Vector3i(5, 0, 1)),
            new BlockOccupancy(new Vector3i(5, 0, 2)),
            new BlockOccupancy(new Vector3i(5, 0, 3)),
            new BlockOccupancy(new Vector3i(5, 0, 4)),
            new BlockOccupancy(new Vector3i(5, 0, 5)),
            new BlockOccupancy(new Vector3i(5, 0, 6)),
            new BlockOccupancy(new Vector3i(5, 1, 0)),
            new BlockOccupancy(new Vector3i(5, 1, 1)),
            new BlockOccupancy(new Vector3i(5, 1, 2)),
            new BlockOccupancy(new Vector3i(5, 1, 3)),
            new BlockOccupancy(new Vector3i(5, 1, 4)),
            new BlockOccupancy(new Vector3i(5, 1, 5)),
            new BlockOccupancy(new Vector3i(5, 1, 6)),
            new BlockOccupancy(new Vector3i(5, 2, 0)),
            new BlockOccupancy(new Vector3i(5, 2, 1)),
            new BlockOccupancy(new Vector3i(5, 2, 2)),
            new BlockOccupancy(new Vector3i(5, 2, 3)),
            new BlockOccupancy(new Vector3i(5, 2, 4)),
            new BlockOccupancy(new Vector3i(5, 2, 5)),
            new BlockOccupancy(new Vector3i(5, 2, 6)),
            new BlockOccupancy(new Vector3i(5, 3, 0)),
            new BlockOccupancy(new Vector3i(5, 3, 1)),
            new BlockOccupancy(new Vector3i(5, 3, 2)),
            new BlockOccupancy(new Vector3i(5, 3, 3)),
            new BlockOccupancy(new Vector3i(5, 3, 4)),
            new BlockOccupancy(new Vector3i(5, 3, 5)),
            new BlockOccupancy(new Vector3i(5, 3, 6)),
            });
            // FisheryObject
            WorldObject.AddOccupancy<FisheryObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            });
            // SteelCeilingLightObject
            WorldObject.AddOccupancy<SteelCeilingLightObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            });
            // SteelFloorLampObject
            WorldObject.AddOccupancy<SteelFloorLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SteelTableLampObject
            WorldObject.AddOccupancy<SteelTableLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WoodenElevatorObject
            WorldObject.AddOccupancy<WoodenElevatorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            });
            // LargeStandingLumberSignObject
            WorldObject.AddOccupancy<LargeStandingLumberSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingStoneSignObject
            WorldObject.AddOccupancy<LargeStandingStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingLumberSignObject
            WorldObject.AddOccupancy<LargeHangingLumberSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingStoneSignObject
            WorldObject.AddOccupancy<LargeHangingStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingLumberSignObject
            WorldObject.AddOccupancy<SmallHangingLumberSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingStoneSignObject
            WorldObject.AddOccupancy<SmallHangingStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingLumberSignObject
            WorldObject.AddOccupancy<SmallStandingLumberSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingStoneSignObject
            WorldObject.AddOccupancy<SmallStandingStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LatheObject
            WorldObject.AddOccupancy<LatheObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            });
            // ScrewPressObject
            WorldObject.AddOccupancy<ScrewPressObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // ShaperObject
            WorldObject.AddOccupancy<ShaperObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // MachinistTableObject
            WorldObject.AddOccupancy<MachinistTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HewnDoorObject
            WorldObject.AddOccupancy<HewnDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // StoneDoorObject
            WorldObject.AddOccupancy<StoneDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // LumberDoorObject
            WorldObject.AddOccupancy<LumberDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // StuffedElkObject
            WorldObject.AddOccupancy<StuffedElkObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // SmallStockpileObject
            WorldObject.AddOccupancy<SmallStockpileObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // CampsiteObject
            WorldObject.AddOccupancy<CampsiteObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            });
            // StarterCampObject
            WorldObject.AddOccupancy<StarterCampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            });
            // ElectricLatheObject
            WorldObject.AddOccupancy<ElectricLatheObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -6)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -6)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            });
            // ElectricMachinistTableObject
            WorldObject.AddOccupancy<ElectricMachinistTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            });
            // ElectricPlanerObject
            WorldObject.AddOccupancy<ElectricPlanerObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-4, 0, -5)),
            new BlockOccupancy(new Vector3i(-4, 0, -4)),
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, -5)),
            new BlockOccupancy(new Vector3i(-4, 1, -4)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, -5)),
            new BlockOccupancy(new Vector3i(-4, 2, -4)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, -5)),
            new BlockOccupancy(new Vector3i(-4, 3, -4)),
            new BlockOccupancy(new Vector3i(-4, 3, -3)),
            new BlockOccupancy(new Vector3i(-4, 3, -2)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-4, 4, -5)),
            new BlockOccupancy(new Vector3i(-4, 4, -4)),
            new BlockOccupancy(new Vector3i(-4, 4, -3)),
            new BlockOccupancy(new Vector3i(-4, 4, -2)),
            new BlockOccupancy(new Vector3i(-4, 4, -1)),
            new BlockOccupancy(new Vector3i(-4, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, -5)),
            new BlockOccupancy(new Vector3i(-3, 0, -4)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -5)),
            new BlockOccupancy(new Vector3i(-3, 1, -4)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -5)),
            new BlockOccupancy(new Vector3i(-3, 2, -4)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, -5)),
            new BlockOccupancy(new Vector3i(-3, 3, -4)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, -5)),
            new BlockOccupancy(new Vector3i(-3, 4, -4)),
            new BlockOccupancy(new Vector3i(-3, 4, -3)),
            new BlockOccupancy(new Vector3i(-3, 4, -2)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, -5)),
            new BlockOccupancy(new Vector3i(-2, 3, -4)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, -5)),
            new BlockOccupancy(new Vector3i(-2, 4, -4)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, -5)),
            new BlockOccupancy(new Vector3i(-1, 3, -4)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, -5)),
            new BlockOccupancy(new Vector3i(-1, 4, -4)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            });
            // ElectricStampingPressObject
            WorldObject.AddOccupancy<ElectricStampingPressObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 1)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, 1)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, 1)),
            new BlockOccupancy(new Vector3i(-4, 3, -3)),
            new BlockOccupancy(new Vector3i(-4, 3, -2)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, 1)),
            new BlockOccupancy(new Vector3i(-4, 4, -3)),
            new BlockOccupancy(new Vector3i(-4, 4, -2)),
            new BlockOccupancy(new Vector3i(-4, 4, -1)),
            new BlockOccupancy(new Vector3i(-4, 4, 0)),
            new BlockOccupancy(new Vector3i(-4, 4, 1)),
            new BlockOccupancy(new Vector3i(-4, 5, -3)),
            new BlockOccupancy(new Vector3i(-4, 5, -2)),
            new BlockOccupancy(new Vector3i(-4, 5, -1)),
            new BlockOccupancy(new Vector3i(-4, 5, 0)),
            new BlockOccupancy(new Vector3i(-4, 5, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 4, -3)),
            new BlockOccupancy(new Vector3i(-3, 4, -2)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, 1)),
            new BlockOccupancy(new Vector3i(-3, 5, -3)),
            new BlockOccupancy(new Vector3i(-3, 5, -2)),
            new BlockOccupancy(new Vector3i(-3, 5, -1)),
            new BlockOccupancy(new Vector3i(-3, 5, 0)),
            new BlockOccupancy(new Vector3i(-3, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, -3)),
            new BlockOccupancy(new Vector3i(-2, 5, -2)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, -3)),
            new BlockOccupancy(new Vector3i(-1, 5, -2)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            });
            // ElkMountObject
            WorldObject.AddOccupancy<ElkMountObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // BisonMountObject
            WorldObject.AddOccupancy<BisonMountObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // ElkSkypiercerObject
            WorldObject.AddOccupancy<ElkSkypiercerObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AssemblyLineObject
            WorldObject.AddOccupancy<AssemblyLineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 1)),
            new BlockOccupancy(new Vector3i(-4, 0, 2)),
            new BlockOccupancy(new Vector3i(-4, 0, 3)),
            new BlockOccupancy(new Vector3i(-4, 0, 4)),
            new BlockOccupancy(new Vector3i(-4, 0, 5)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, 1)),
            new BlockOccupancy(new Vector3i(-4, 1, 2)),
            new BlockOccupancy(new Vector3i(-4, 1, 3)),
            new BlockOccupancy(new Vector3i(-4, 1, 4)),
            new BlockOccupancy(new Vector3i(-4, 1, 5)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, 1)),
            new BlockOccupancy(new Vector3i(-4, 2, 2)),
            new BlockOccupancy(new Vector3i(-4, 2, 3)),
            new BlockOccupancy(new Vector3i(-4, 2, 4)),
            new BlockOccupancy(new Vector3i(-4, 2, 5)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, 1)),
            new BlockOccupancy(new Vector3i(-4, 3, 2)),
            new BlockOccupancy(new Vector3i(-4, 3, 3)),
            new BlockOccupancy(new Vector3i(-4, 3, 4)),
            new BlockOccupancy(new Vector3i(-4, 3, 5)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, 2)),
            new BlockOccupancy(new Vector3i(-3, 0, 3)),
            new BlockOccupancy(new Vector3i(-3, 0, 4)),
            new BlockOccupancy(new Vector3i(-3, 0, 5)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 2)),
            new BlockOccupancy(new Vector3i(-3, 1, 3)),
            new BlockOccupancy(new Vector3i(-3, 1, 4)),
            new BlockOccupancy(new Vector3i(-3, 1, 5)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, 2)),
            new BlockOccupancy(new Vector3i(-3, 2, 3)),
            new BlockOccupancy(new Vector3i(-3, 2, 4)),
            new BlockOccupancy(new Vector3i(-3, 2, 5)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, 2)),
            new BlockOccupancy(new Vector3i(-3, 3, 3)),
            new BlockOccupancy(new Vector3i(-3, 3, 4)),
            new BlockOccupancy(new Vector3i(-3, 3, 5)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 0, 3)),
            new BlockOccupancy(new Vector3i(-2, 0, 4)),
            new BlockOccupancy(new Vector3i(-2, 0, 5)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 1, 4)),
            new BlockOccupancy(new Vector3i(-2, 1, 5)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, 4)),
            new BlockOccupancy(new Vector3i(-2, 2, 5)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, 3)),
            new BlockOccupancy(new Vector3i(-2, 3, 4)),
            new BlockOccupancy(new Vector3i(-2, 3, 5)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 4)),
            new BlockOccupancy(new Vector3i(-1, 0, 5)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 4)),
            new BlockOccupancy(new Vector3i(-1, 1, 5)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 4)),
            new BlockOccupancy(new Vector3i(-1, 2, 5)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 4)),
            new BlockOccupancy(new Vector3i(-1, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 5)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 5)),
            });
            // SteamEngineObject
            WorldObject.AddOccupancy<SteamEngineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(1, 2, 1), typeof(PipeSlotBlock), new Quaternion(-0.7071071f, 2.634177E-07f, 2.634179E-07f, 0.7071065f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(2, 0, 2), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            });
            // RoboticAssemblyLineObject
            WorldObject.AddOccupancy<RoboticAssemblyLineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, -3)),
            new BlockOccupancy(new Vector3i(-4, 3, -2)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            });
            // RealEstateDeskObject
            WorldObject.AddOccupancy<RealEstateDeskObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DistributionStationObject
            WorldObject.AddOccupancy<DistributionStationObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, 2)),
            new BlockOccupancy(new Vector3i(-3, 0, 3)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 2)),
            new BlockOccupancy(new Vector3i(-3, 1, 3)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, 2)),
            new BlockOccupancy(new Vector3i(-3, 2, 3)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, 2)),
            new BlockOccupancy(new Vector3i(-3, 3, 3)),
            new BlockOccupancy(new Vector3i(-3, 4, -3)),
            new BlockOccupancy(new Vector3i(-3, 4, -2)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, 1)),
            new BlockOccupancy(new Vector3i(-3, 4, 2)),
            new BlockOccupancy(new Vector3i(-3, 4, 3)),
            new BlockOccupancy(new Vector3i(-3, 5, -3)),
            new BlockOccupancy(new Vector3i(-3, 5, -2)),
            new BlockOccupancy(new Vector3i(-3, 5, -1)),
            new BlockOccupancy(new Vector3i(-3, 5, 0)),
            new BlockOccupancy(new Vector3i(-3, 5, 1)),
            new BlockOccupancy(new Vector3i(-3, 5, 2)),
            new BlockOccupancy(new Vector3i(-3, 5, 3)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 0, 3)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, 3)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, 2)),
            new BlockOccupancy(new Vector3i(-2, 4, 3)),
            new BlockOccupancy(new Vector3i(-2, 5, -3)),
            new BlockOccupancy(new Vector3i(-2, 5, -2)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, 2)),
            new BlockOccupancy(new Vector3i(-2, 5, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, 2)),
            new BlockOccupancy(new Vector3i(-1, 4, 3)),
            new BlockOccupancy(new Vector3i(-1, 5, -3)),
            new BlockOccupancy(new Vector3i(-1, 5, -2)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, 2)),
            new BlockOccupancy(new Vector3i(-1, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 3)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 5, 2)),
            new BlockOccupancy(new Vector3i(1, 5, 3)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 3)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 5, 2)),
            new BlockOccupancy(new Vector3i(2, 5, 3)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 4, 2)),
            new BlockOccupancy(new Vector3i(3, 4, 3)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 5, 2)),
            new BlockOccupancy(new Vector3i(3, 5, 3)),
            });
        }

        public static void InitializePart2()
        {
            // TinyStockpileObject
            WorldObject.AddOccupancy<TinyStockpileObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // LargeCorrugatedSteelDoorObject
            WorldObject.AddOccupancy<LargeCorrugatedSteelDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, -2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, -1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, -2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, -1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, -2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, -1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            });
            // LargeLumberDoorObject
            WorldObject.AddOccupancy<LargeLumberDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            });
            // LargeWindowedLumberDoorObject
            WorldObject.AddOccupancy<LargeWindowedLumberDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 4), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 3, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 3), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 2), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 2, 1), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            });
            // PipeEmitterObject
            WorldObject.AddOccupancy<PipeEmitterObject>(new List<BlockOccupancy>(){
            });
            // SinkObject
            WorldObject.AddOccupancy<SinkObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(-2, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.SewageOutputPort),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WasteFilterObject
            WorldObject.AddOccupancy<WasteFilterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, -0.7071068f, 0f, 0.7071068f), BlockOccupancyType.InputPort),
            new BlockOccupancy(new Vector3i(-2, 0, -2), typeof(PipeSlotBlock), new Quaternion(0f, -0.7071068f, 0f, 0.7071068f), BlockOccupancyType.OutputPort),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // CraneObject
            WorldObject.AddOccupancy<CraneObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 6, -1)),
            new BlockOccupancy(new Vector3i(-1, 6, 0)),
            new BlockOccupancy(new Vector3i(-1, 6, 1)),
            new BlockOccupancy(new Vector3i(-1, 7, -1)),
            new BlockOccupancy(new Vector3i(-1, 7, 0)),
            new BlockOccupancy(new Vector3i(-1, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 7, -1)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 6, -1)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 6, 1)),
            new BlockOccupancy(new Vector3i(1, 7, -1)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 7, 1)),
            });
            // ElectricWaterPumpObject
            WorldObject.AddOccupancy<ElectricWaterPumpObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.OutputPort),
            new BlockOccupancy(new Vector3i(0, 0, 1), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.InputPort),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // MechanicalWaterPumpObject
            WorldObject.AddOccupancy<MechanicalWaterPumpObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.OutputPort),
            new BlockOccupancy(new Vector3i(0, 0, 1), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.InputPort),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // BankObject
            WorldObject.AddOccupancy<BankObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // RegistrarObject
            WorldObject.AddOccupancy<RegistrarObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DirtRampObject
            WorldObject.AddOccupancy<DirtRampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // StoneRampObject
            WorldObject.AddOccupancy<StoneRampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeStandingSaguaroSignObject
            WorldObject.AddOccupancy<LargeStandingSaguaroSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingSaguaroSignObject
            WorldObject.AddOccupancy<LargeHangingSaguaroSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingSaguaroSignObject
            WorldObject.AddOccupancy<SmallHangingSaguaroSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingSaguaroSignObject
            WorldObject.AddOccupancy<SmallStandingSaguaroSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingJoshuaSignObject
            WorldObject.AddOccupancy<SmallStandingJoshuaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingJoshuaSignObject
            WorldObject.AddOccupancy<SmallHangingJoshuaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingJoshuaSignObject
            WorldObject.AddOccupancy<LargeHangingJoshuaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingJoshuaSignObject
            WorldObject.AddOccupancy<LargeStandingJoshuaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingBirchSignObject
            WorldObject.AddOccupancy<LargeStandingBirchSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingBirchSignObject
            WorldObject.AddOccupancy<LargeHangingBirchSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingBirchSignObject
            WorldObject.AddOccupancy<SmallHangingBirchSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingBirchSignObject
            WorldObject.AddOccupancy<SmallStandingBirchSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingCedarSignObject
            WorldObject.AddOccupancy<SmallStandingCedarSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingCedarSignObject
            WorldObject.AddOccupancy<SmallHangingCedarSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingCedarSignObject
            WorldObject.AddOccupancy<LargeHangingCedarSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingCedarSignObject
            WorldObject.AddOccupancy<LargeStandingCedarSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingCeibaSignObject
            WorldObject.AddOccupancy<LargeStandingCeibaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingCeibaSignObject
            WorldObject.AddOccupancy<LargeHangingCeibaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingCeibaSignObject
            WorldObject.AddOccupancy<SmallHangingCeibaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingCeibaSignObject
            WorldObject.AddOccupancy<SmallStandingCeibaSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingFirSignObject
            WorldObject.AddOccupancy<SmallStandingFirSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingFirSignObject
            WorldObject.AddOccupancy<SmallHangingFirSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingFirSignObject
            WorldObject.AddOccupancy<LargeHangingFirSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingFirSignObject
            WorldObject.AddOccupancy<LargeStandingFirSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingHardwoodSignObject
            WorldObject.AddOccupancy<LargeStandingHardwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingHardwoodSignObject
            WorldObject.AddOccupancy<LargeHangingHardwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingHardwoodSignObject
            WorldObject.AddOccupancy<SmallHangingHardwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingHardwoodSignObject
            WorldObject.AddOccupancy<SmallStandingHardwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingOakSignObject
            WorldObject.AddOccupancy<SmallStandingOakSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingOakSignObject
            WorldObject.AddOccupancy<SmallHangingOakSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingOakSignObject
            WorldObject.AddOccupancy<LargeHangingOakSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingOakSignObject
            WorldObject.AddOccupancy<LargeStandingOakSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingPalmSignObject
            WorldObject.AddOccupancy<LargeStandingPalmSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingPalmSignObject
            WorldObject.AddOccupancy<LargeHangingPalmSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingPalmSignObject
            WorldObject.AddOccupancy<SmallHangingPalmSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingPalmSignObject
            WorldObject.AddOccupancy<SmallStandingPalmSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingRedwoodSignObject
            WorldObject.AddOccupancy<SmallStandingRedwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingRedwoodSignObject
            WorldObject.AddOccupancy<SmallHangingRedwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingRedwoodSignObject
            WorldObject.AddOccupancy<LargeHangingRedwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingRedwoodSignObject
            WorldObject.AddOccupancy<LargeStandingRedwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingSpruceSignObject
            WorldObject.AddOccupancy<LargeStandingSpruceSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingSpruceSignObject
            WorldObject.AddOccupancy<LargeHangingSpruceSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingSpruceSignObject
            WorldObject.AddOccupancy<SmallHangingSpruceSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingSpruceSignObject
            WorldObject.AddOccupancy<SmallStandingSpruceSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingSoftwoodSignObject
            WorldObject.AddOccupancy<SmallStandingSoftwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingSoftwoodSignObject
            WorldObject.AddOccupancy<SmallHangingSoftwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingSoftwoodSignObject
            WorldObject.AddOccupancy<LargeHangingSoftwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingSoftwoodSignObject
            WorldObject.AddOccupancy<LargeStandingSoftwoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SoftwoodLumberDoorObject
            WorldObject.AddOccupancy<SoftwoodLumberDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // HardwoodLumberDoorObject
            WorldObject.AddOccupancy<HardwoodLumberDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeLumberDoorObject
            WorldObject.AddOccupancy<CompositeLumberDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeOakDoorObject
            WorldObject.AddOccupancy<CompositeOakDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositePalmDoorObject
            WorldObject.AddOccupancy<CompositePalmDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeSoftwoodDoorObject
            WorldObject.AddOccupancy<CompositeSoftwoodDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeRedwoodDoorObject
            WorldObject.AddOccupancy<CompositeRedwoodDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeBirchDoorObject
            WorldObject.AddOccupancy<CompositeBirchDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeSpruceDoorObject
            WorldObject.AddOccupancy<CompositeSpruceDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeFirDoorObject
            WorldObject.AddOccupancy<CompositeFirDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeHardwoodDoorObject
            WorldObject.AddOccupancy<CompositeHardwoodDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeCedarDoorObject
            WorldObject.AddOccupancy<CompositeCedarDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeCeibaDoorObject
            WorldObject.AddOccupancy<CompositeCeibaDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeJoshuaDoorObject
            WorldObject.AddOccupancy<CompositeJoshuaDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CompositeSaguaroDoorObject
            WorldObject.AddOccupancy<CompositeSaguaroDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // ZoningOfficeObject
            WorldObject.AddOccupancy<ZoningOfficeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CensusBureauObject
            WorldObject.AddOccupancy<CensusBureauObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            });
            // GovernmentOfficeObject
            WorldObject.AddOccupancy<GovernmentOfficeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // ExecutiveOfficeObject
            WorldObject.AddOccupancy<ExecutiveOfficeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CapitolObject
            WorldObject.AddOccupancy<CapitolObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            });
            // BoardOfElectionsObject
            WorldObject.AddOccupancy<BoardOfElectionsObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // BallotBoxObject
            WorldObject.AddOccupancy<BallotBoxObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredStoneBenchObject
            WorldObject.AddOccupancy<MortaredStoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredStoneChairObject
            WorldObject.AddOccupancy<MortaredStoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredStoneTableObject
            WorldObject.AddOccupancy<MortaredStoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // MortaredStoneFireplaceObject
            WorldObject.AddOccupancy<MortaredStoneFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarStoneFireplaceObject
            WorldObject.AddOccupancy<AshlarStoneFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarGneissFireplaceObject
            WorldObject.AddOccupancy<AshlarGneissFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredLimestoneFireplaceObject
            WorldObject.AddOccupancy<MortaredLimestoneFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarLimestoneFireplaceObject
            WorldObject.AddOccupancy<AshlarLimestoneFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // BrickFireplaceObject
            WorldObject.AddOccupancy<BrickFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarShaleFireplaceObject
            WorldObject.AddOccupancy<AshlarShaleFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredSandstoneFireplaceObject
            WorldObject.AddOccupancy<MortaredSandstoneFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarSandstoneFireplaceObject
            WorldObject.AddOccupancy<AshlarSandstoneFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarBasaltFireplaceObject
            WorldObject.AddOccupancy<AshlarBasaltFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredGraniteFireplaceObject
            WorldObject.AddOccupancy<MortaredGraniteFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarGraniteFireplaceObject
            WorldObject.AddOccupancy<AshlarGraniteFireplaceObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarStoneBenchObject
            WorldObject.AddOccupancy<AshlarStoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarStoneChairObject
            WorldObject.AddOccupancy<AshlarStoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarStoneTableObject
            WorldObject.AddOccupancy<AshlarStoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarGneissBenchObject
            WorldObject.AddOccupancy<AshlarGneissBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarGneissChairObject
            WorldObject.AddOccupancy<AshlarGneissChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarGneissTableObject
            WorldObject.AddOccupancy<AshlarGneissTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarLimestoneBenchObject
            WorldObject.AddOccupancy<AshlarLimestoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarLimestoneChairObject
            WorldObject.AddOccupancy<AshlarLimestoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarLimestoneTableObject
            WorldObject.AddOccupancy<AshlarLimestoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarShaleBenchObject
            WorldObject.AddOccupancy<AshlarShaleBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarShaleChairObject
            WorldObject.AddOccupancy<AshlarShaleChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarShaleTableObject
            WorldObject.AddOccupancy<AshlarShaleTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSandstoneBenchObject
            WorldObject.AddOccupancy<AshlarSandstoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarSandstoneChairObject
            WorldObject.AddOccupancy<AshlarSandstoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarSandstoneTableObject
            WorldObject.AddOccupancy<AshlarSandstoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarBasaltBenchObject
            WorldObject.AddOccupancy<AshlarBasaltBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarBasaltChairObject
            WorldObject.AddOccupancy<AshlarBasaltChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarBasaltTableObject
            WorldObject.AddOccupancy<AshlarBasaltTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarGraniteBenchObject
            WorldObject.AddOccupancy<AshlarGraniteBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarGraniteChairObject
            WorldObject.AddOccupancy<AshlarGraniteChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarGraniteTableObject
            WorldObject.AddOccupancy<AshlarGraniteTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AdornedAshlarGraniteBenchObject
            WorldObject.AddOccupancy<AdornedAshlarGraniteBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarGraniteChairObject
            WorldObject.AddOccupancy<AdornedAshlarGraniteChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarGraniteTableObject
            WorldObject.AddOccupancy<AdornedAshlarGraniteTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSmallGraniteFountainObject
            WorldObject.AddOccupancy<AshlarSmallGraniteFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarBasaltBenchObject
            WorldObject.AddOccupancy<AdornedAshlarBasaltBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarBasaltChairObject
            WorldObject.AddOccupancy<AdornedAshlarBasaltChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarBasaltTableObject
            WorldObject.AddOccupancy<AdornedAshlarBasaltTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSmallBasaltFountainObject
            WorldObject.AddOccupancy<AshlarSmallBasaltFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarSandstoneChairObject
            WorldObject.AddOccupancy<AdornedAshlarSandstoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarSandstoneBenchObject
            WorldObject.AddOccupancy<AdornedAshlarSandstoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarSandstoneTableObject
            WorldObject.AddOccupancy<AdornedAshlarSandstoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSmallSandstoneFountainObject
            WorldObject.AddOccupancy<AshlarSmallSandstoneFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarShaleChairObject
            WorldObject.AddOccupancy<AdornedAshlarShaleChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarShaleBenchObject
            WorldObject.AddOccupancy<AdornedAshlarShaleBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarShaleTableObject
            WorldObject.AddOccupancy<AdornedAshlarShaleTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSmallShaleFountainObject
            WorldObject.AddOccupancy<AshlarSmallShaleFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarLimestoneChairObject
            WorldObject.AddOccupancy<AdornedAshlarLimestoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarLimestoneBenchObject
            WorldObject.AddOccupancy<AdornedAshlarLimestoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarLimestoneTableObject
            WorldObject.AddOccupancy<AdornedAshlarLimestoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSmallLimestoneFountainObject
            WorldObject.AddOccupancy<AshlarSmallLimestoneFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarGneissChairObject
            WorldObject.AddOccupancy<AdornedAshlarGneissChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarGneissBenchObject
            WorldObject.AddOccupancy<AdornedAshlarGneissBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarGneissTableObject
            WorldObject.AddOccupancy<AdornedAshlarGneissTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSmallGneissFountainObject
            WorldObject.AddOccupancy<AshlarSmallGneissFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarStoneChairObject
            WorldObject.AddOccupancy<AdornedAshlarStoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarStoneBenchObject
            WorldObject.AddOccupancy<AdornedAshlarStoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdornedAshlarStoneTableObject
            WorldObject.AddOccupancy<AdornedAshlarStoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AshlarSmallStoneFountainObject
            WorldObject.AddOccupancy<AshlarSmallStoneFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AshlarLargeStoneFountainObject
            WorldObject.AddOccupancy<AshlarLargeStoneFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // AshlarLargeGneissFountainObject
            WorldObject.AddOccupancy<AshlarLargeGneissFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // AshlarLargeLimestoneFountainObject
            WorldObject.AddOccupancy<AshlarLargeLimestoneFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // AshlarLargeShaleFountainObject
            WorldObject.AddOccupancy<AshlarLargeShaleFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // AshlarLargeSandstoneFountainObject
            WorldObject.AddOccupancy<AshlarLargeSandstoneFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // AshlarLargeBasaltFountainObject
            WorldObject.AddOccupancy<AshlarLargeBasaltFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // AshlarLargeGraniteFountainObject
            WorldObject.AddOccupancy<AshlarLargeGraniteFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // HewnChairObject
            WorldObject.AddOccupancy<HewnChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HewnBenchObject
            WorldObject.AddOccupancy<HewnBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HewnTableObject
            WorldObject.AddOccupancy<HewnTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HewnSoftwoodChairObject
            WorldObject.AddOccupancy<HewnSoftwoodChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HewnSoftwoodBenchObject
            WorldObject.AddOccupancy<HewnSoftwoodBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HewnSoftwoodTableObject
            WorldObject.AddOccupancy<HewnSoftwoodTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HewnHardwoodChairObject
            WorldObject.AddOccupancy<HewnHardwoodChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HewnHardwoodBenchObject
            WorldObject.AddOccupancy<HewnHardwoodBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HewnHardwoodTableObject
            WorldObject.AddOccupancy<HewnHardwoodTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LumberChairObject
            WorldObject.AddOccupancy<LumberChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LumberBenchObject
            WorldObject.AddOccupancy<LumberBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LumberTableObject
            WorldObject.AddOccupancy<LumberTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SoftwoodLumberChairObject
            WorldObject.AddOccupancy<SoftwoodLumberChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SoftwoodLumberBenchObject
            WorldObject.AddOccupancy<SoftwoodLumberBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SoftwoodLumberTableObject
            WorldObject.AddOccupancy<SoftwoodLumberTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HardwoodLumberChairObject
            WorldObject.AddOccupancy<HardwoodLumberChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HardwoodLumberBenchObject
            WorldObject.AddOccupancy<HardwoodLumberBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HardwoodLumberTableObject
            WorldObject.AddOccupancy<HardwoodLumberTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeLumberChairObject
            WorldObject.AddOccupancy<CompositeLumberChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeLumberBenchObject
            WorldObject.AddOccupancy<CompositeLumberBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeLumberTableObject
            WorldObject.AddOccupancy<CompositeLumberTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeCedarChairObject
            WorldObject.AddOccupancy<CompositeCedarChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeCedarBenchObject
            WorldObject.AddOccupancy<CompositeCedarBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeCedarTableObject
            WorldObject.AddOccupancy<CompositeCedarTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeSoftwoodChairObject
            WorldObject.AddOccupancy<CompositeSoftwoodChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeSoftwoodBenchObject
            WorldObject.AddOccupancy<CompositeSoftwoodBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeSoftwoodTableObject
            WorldObject.AddOccupancy<CompositeSoftwoodTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeOakChairObject
            WorldObject.AddOccupancy<CompositeOakChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeOakBenchObject
            WorldObject.AddOccupancy<CompositeOakBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeOakTableObject
            WorldObject.AddOccupancy<CompositeOakTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeHardwoodChairObject
            WorldObject.AddOccupancy<CompositeHardwoodChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeHardwoodBenchObject
            WorldObject.AddOccupancy<CompositeHardwoodBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeHardwoodTableObject
            WorldObject.AddOccupancy<CompositeHardwoodTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositePalmChairObject
            WorldObject.AddOccupancy<CompositePalmChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositePalmBenchObject
            WorldObject.AddOccupancy<CompositePalmBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositePalmTableObject
            WorldObject.AddOccupancy<CompositePalmTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeRedwoodChairObject
            WorldObject.AddOccupancy<CompositeRedwoodChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeRedwoodBenchObject
            WorldObject.AddOccupancy<CompositeRedwoodBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeRedwoodTableObject
            WorldObject.AddOccupancy<CompositeRedwoodTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeSpruceChairObject
            WorldObject.AddOccupancy<CompositeSpruceChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeSpruceBenchObject
            WorldObject.AddOccupancy<CompositeSpruceBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeSpruceTableObject
            WorldObject.AddOccupancy<CompositeSpruceTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeBirchChairObject
            WorldObject.AddOccupancy<CompositeBirchChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeBirchBenchObject
            WorldObject.AddOccupancy<CompositeBirchBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeBirchTableObject
            WorldObject.AddOccupancy<CompositeBirchTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeFirChairObject
            WorldObject.AddOccupancy<CompositeFirChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeFirBenchObject
            WorldObject.AddOccupancy<CompositeFirBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeFirTableObject
            WorldObject.AddOccupancy<CompositeFirTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeCeibaChairObject
            WorldObject.AddOccupancy<CompositeCeibaChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeCeibaBenchObject
            WorldObject.AddOccupancy<CompositeCeibaBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeCeibaTableObject
            WorldObject.AddOccupancy<CompositeCeibaTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeSaguaroChairObject
            WorldObject.AddOccupancy<CompositeSaguaroChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeSaguaroBenchObject
            WorldObject.AddOccupancy<CompositeSaguaroBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeSaguaroTableObject
            WorldObject.AddOccupancy<CompositeSaguaroTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CompositeJoshuaChairObject
            WorldObject.AddOccupancy<CompositeJoshuaChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeJoshuaBenchObject
            WorldObject.AddOccupancy<CompositeJoshuaBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeJoshuaTableObject
            WorldObject.AddOccupancy<CompositeJoshuaTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ArrastraObject
            WorldObject.AddOccupancy<ArrastraObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            });
            // StampMillObject
            WorldObject.AddOccupancy<StampMillObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            });
            // JawCrusherObject
            WorldObject.AddOccupancy<JawCrusherObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            });
            // ScreeningMachineObject
            WorldObject.AddOccupancy<ScreeningMachineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 0, 3)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            });
            // RockerBoxObject
            WorldObject.AddOccupancy<RockerBoxObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // FrothFloatationCellObject
            WorldObject.AddOccupancy<FrothFloatationCellObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 3), typeof(PipeSlotBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.SewageOutputPort),
            new BlockOccupancy(new Vector3i(-2, 0, 0), typeof(PipeSlotBlock), new Quaternion(0f, 1f, 0f, 0f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, 2)),
            new BlockOccupancy(new Vector3i(-3, 0, 3)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 2)),
            new BlockOccupancy(new Vector3i(-3, 1, 3)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, 2)),
            new BlockOccupancy(new Vector3i(-3, 2, 3)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, 2)),
            new BlockOccupancy(new Vector3i(-3, 3, 3)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            });
            // SensorBasedBeltSorterObject
            WorldObject.AddOccupancy<SensorBasedBeltSorterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            });
            // MortaredSandstoneBenchObject
            WorldObject.AddOccupancy<MortaredSandstoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredSandstoneChairObject
            WorldObject.AddOccupancy<MortaredSandstoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredSandstoneTableObject
            WorldObject.AddOccupancy<MortaredSandstoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // MortaredLimestoneChairObject
            WorldObject.AddOccupancy<MortaredLimestoneChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredLimestoneBenchObject
            WorldObject.AddOccupancy<MortaredLimestoneBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredLimestoneTableObject
            WorldObject.AddOccupancy<MortaredLimestoneTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // MortaredGraniteChairObject
            WorldObject.AddOccupancy<MortaredGraniteChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredGraniteBenchObject
            WorldObject.AddOccupancy<MortaredGraniteBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // MortaredGraniteTableObject
            WorldObject.AddOccupancy<MortaredGraniteTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AmendmentsObject
            WorldObject.AddOccupancy<AmendmentsObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            });
            // CourtObject
            WorldObject.AddOccupancy<LargeCourtObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-5, 0, -5)),
            new BlockOccupancy(new Vector3i(-5, 0, -4)),
            new BlockOccupancy(new Vector3i(-5, 0, -3)),
            new BlockOccupancy(new Vector3i(-5, 0, -2)),
            new BlockOccupancy(new Vector3i(-5, 0, -1)),
            new BlockOccupancy(new Vector3i(-5, 0, 0)),
            new BlockOccupancy(new Vector3i(-5, 1, -5)),
            new BlockOccupancy(new Vector3i(-5, 1, -4)),
            new BlockOccupancy(new Vector3i(-5, 1, -3)),
            new BlockOccupancy(new Vector3i(-5, 1, -2)),
            new BlockOccupancy(new Vector3i(-5, 1, -1)),
            new BlockOccupancy(new Vector3i(-5, 1, 0)),
            new BlockOccupancy(new Vector3i(-5, 2, -5)),
            new BlockOccupancy(new Vector3i(-5, 2, -4)),
            new BlockOccupancy(new Vector3i(-5, 2, -3)),
            new BlockOccupancy(new Vector3i(-5, 2, -2)),
            new BlockOccupancy(new Vector3i(-5, 2, -1)),
            new BlockOccupancy(new Vector3i(-5, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, -5)),
            new BlockOccupancy(new Vector3i(-4, 0, -4)),
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, -5)),
            new BlockOccupancy(new Vector3i(-4, 1, -4)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, -5)),
            new BlockOccupancy(new Vector3i(-4, 2, -4)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, -5)),
            new BlockOccupancy(new Vector3i(-3, 0, -4)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -5)),
            new BlockOccupancy(new Vector3i(-3, 1, -4)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -5)),
            new BlockOccupancy(new Vector3i(-3, 2, -4)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // SheepMountObject
            WorldObject.AddOccupancy<SheepMountObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // ToolBenchObject
            WorldObject.AddOccupancy<ToolBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
        }

        public static void InitializePart3()
        {
            // LargeLumberStockpileObject
            WorldObject.AddOccupancy<LargeLumberStockpileObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-6, 0, -6)),
            new BlockOccupancy(new Vector3i(-6, 0, -5)),
            new BlockOccupancy(new Vector3i(-6, 0, -4)),
            new BlockOccupancy(new Vector3i(-6, 0, -3)),
            new BlockOccupancy(new Vector3i(-6, 0, -2)),
            new BlockOccupancy(new Vector3i(-6, 0, -1)),
            new BlockOccupancy(new Vector3i(-6, 0, 0)),
            new BlockOccupancy(new Vector3i(-6, 0, 1)),
            new BlockOccupancy(new Vector3i(-6, 0, 2)),
            new BlockOccupancy(new Vector3i(-6, 0, 3)),
            new BlockOccupancy(new Vector3i(-6, 0, 4)),
            new BlockOccupancy(new Vector3i(-6, 0, 5)),
            new BlockOccupancy(new Vector3i(-6, 1, -6)),
            new BlockOccupancy(new Vector3i(-6, 1, -5)),
            new BlockOccupancy(new Vector3i(-6, 1, -4)),
            new BlockOccupancy(new Vector3i(-6, 1, -3)),
            new BlockOccupancy(new Vector3i(-6, 1, -2)),
            new BlockOccupancy(new Vector3i(-6, 1, -1)),
            new BlockOccupancy(new Vector3i(-6, 1, 0)),
            new BlockOccupancy(new Vector3i(-6, 1, 1)),
            new BlockOccupancy(new Vector3i(-6, 1, 2)),
            new BlockOccupancy(new Vector3i(-6, 1, 3)),
            new BlockOccupancy(new Vector3i(-6, 1, 4)),
            new BlockOccupancy(new Vector3i(-6, 1, 5)),
            new BlockOccupancy(new Vector3i(-6, 2, -6)),
            new BlockOccupancy(new Vector3i(-6, 2, -5)),
            new BlockOccupancy(new Vector3i(-6, 2, -4)),
            new BlockOccupancy(new Vector3i(-6, 2, -3)),
            new BlockOccupancy(new Vector3i(-6, 2, -2)),
            new BlockOccupancy(new Vector3i(-6, 2, -1)),
            new BlockOccupancy(new Vector3i(-6, 2, 0)),
            new BlockOccupancy(new Vector3i(-6, 2, 1)),
            new BlockOccupancy(new Vector3i(-6, 2, 2)),
            new BlockOccupancy(new Vector3i(-6, 2, 3)),
            new BlockOccupancy(new Vector3i(-6, 2, 4)),
            new BlockOccupancy(new Vector3i(-6, 2, 5)),
            new BlockOccupancy(new Vector3i(-6, 3, -6)),
            new BlockOccupancy(new Vector3i(-6, 3, -5)),
            new BlockOccupancy(new Vector3i(-6, 3, -4)),
            new BlockOccupancy(new Vector3i(-6, 3, -3)),
            new BlockOccupancy(new Vector3i(-6, 3, -2)),
            new BlockOccupancy(new Vector3i(-6, 3, -1)),
            new BlockOccupancy(new Vector3i(-6, 3, 0)),
            new BlockOccupancy(new Vector3i(-6, 3, 1)),
            new BlockOccupancy(new Vector3i(-6, 3, 2)),
            new BlockOccupancy(new Vector3i(-6, 3, 3)),
            new BlockOccupancy(new Vector3i(-6, 3, 4)),
            new BlockOccupancy(new Vector3i(-6, 3, 5)),
            new BlockOccupancy(new Vector3i(-6, 4, -6)),
            new BlockOccupancy(new Vector3i(-6, 4, -5)),
            new BlockOccupancy(new Vector3i(-6, 4, -4)),
            new BlockOccupancy(new Vector3i(-6, 4, -3)),
            new BlockOccupancy(new Vector3i(-6, 4, -2)),
            new BlockOccupancy(new Vector3i(-6, 4, -1)),
            new BlockOccupancy(new Vector3i(-6, 4, 0)),
            new BlockOccupancy(new Vector3i(-6, 4, 1)),
            new BlockOccupancy(new Vector3i(-6, 4, 2)),
            new BlockOccupancy(new Vector3i(-6, 4, 3)),
            new BlockOccupancy(new Vector3i(-6, 4, 4)),
            new BlockOccupancy(new Vector3i(-6, 4, 5)),
            new BlockOccupancy(new Vector3i(-6, 5, -6)),
            new BlockOccupancy(new Vector3i(-6, 5, -5)),
            new BlockOccupancy(new Vector3i(-6, 5, -4)),
            new BlockOccupancy(new Vector3i(-6, 5, -3)),
            new BlockOccupancy(new Vector3i(-6, 5, -2)),
            new BlockOccupancy(new Vector3i(-6, 5, -1)),
            new BlockOccupancy(new Vector3i(-6, 5, 0)),
            new BlockOccupancy(new Vector3i(-6, 5, 1)),
            new BlockOccupancy(new Vector3i(-6, 5, 2)),
            new BlockOccupancy(new Vector3i(-6, 5, 3)),
            new BlockOccupancy(new Vector3i(-6, 5, 4)),
            new BlockOccupancy(new Vector3i(-6, 5, 5)),
            new BlockOccupancy(new Vector3i(-6, 6, -6)),
            new BlockOccupancy(new Vector3i(-6, 6, -5)),
            new BlockOccupancy(new Vector3i(-6, 6, -4)),
            new BlockOccupancy(new Vector3i(-6, 6, -3)),
            new BlockOccupancy(new Vector3i(-6, 6, -2)),
            new BlockOccupancy(new Vector3i(-6, 6, -1)),
            new BlockOccupancy(new Vector3i(-6, 6, 0)),
            new BlockOccupancy(new Vector3i(-6, 6, 1)),
            new BlockOccupancy(new Vector3i(-6, 6, 2)),
            new BlockOccupancy(new Vector3i(-6, 6, 3)),
            new BlockOccupancy(new Vector3i(-6, 6, 4)),
            new BlockOccupancy(new Vector3i(-6, 6, 5)),
            new BlockOccupancy(new Vector3i(-6, 7, -6)),
            new BlockOccupancy(new Vector3i(-6, 7, -5)),
            new BlockOccupancy(new Vector3i(-6, 7, -4)),
            new BlockOccupancy(new Vector3i(-6, 7, -3)),
            new BlockOccupancy(new Vector3i(-6, 7, -2)),
            new BlockOccupancy(new Vector3i(-6, 7, -1)),
            new BlockOccupancy(new Vector3i(-6, 7, 0)),
            new BlockOccupancy(new Vector3i(-6, 7, 1)),
            new BlockOccupancy(new Vector3i(-6, 7, 2)),
            new BlockOccupancy(new Vector3i(-6, 7, 3)),
            new BlockOccupancy(new Vector3i(-6, 7, 4)),
            new BlockOccupancy(new Vector3i(-6, 7, 5)),
            new BlockOccupancy(new Vector3i(-6, 8, -6)),
            new BlockOccupancy(new Vector3i(-6, 8, -5)),
            new BlockOccupancy(new Vector3i(-6, 8, -4)),
            new BlockOccupancy(new Vector3i(-6, 8, -3)),
            new BlockOccupancy(new Vector3i(-6, 8, -2)),
            new BlockOccupancy(new Vector3i(-6, 8, -1)),
            new BlockOccupancy(new Vector3i(-6, 8, 0)),
            new BlockOccupancy(new Vector3i(-6, 8, 1)),
            new BlockOccupancy(new Vector3i(-6, 8, 2)),
            new BlockOccupancy(new Vector3i(-6, 8, 3)),
            new BlockOccupancy(new Vector3i(-6, 8, 4)),
            new BlockOccupancy(new Vector3i(-6, 8, 5)),
            new BlockOccupancy(new Vector3i(-6, 9, -6)),
            new BlockOccupancy(new Vector3i(-6, 9, -5)),
            new BlockOccupancy(new Vector3i(-6, 9, -4)),
            new BlockOccupancy(new Vector3i(-6, 9, -3)),
            new BlockOccupancy(new Vector3i(-6, 9, -2)),
            new BlockOccupancy(new Vector3i(-6, 9, -1)),
            new BlockOccupancy(new Vector3i(-6, 9, 0)),
            new BlockOccupancy(new Vector3i(-6, 9, 1)),
            new BlockOccupancy(new Vector3i(-6, 9, 2)),
            new BlockOccupancy(new Vector3i(-6, 9, 3)),
            new BlockOccupancy(new Vector3i(-6, 9, 4)),
            new BlockOccupancy(new Vector3i(-6, 9, 5)),
            new BlockOccupancy(new Vector3i(-6, 10, -6)),
            new BlockOccupancy(new Vector3i(-6, 10, -5)),
            new BlockOccupancy(new Vector3i(-6, 10, -4)),
            new BlockOccupancy(new Vector3i(-6, 10, -3)),
            new BlockOccupancy(new Vector3i(-6, 10, -2)),
            new BlockOccupancy(new Vector3i(-6, 10, -1)),
            new BlockOccupancy(new Vector3i(-6, 10, 0)),
            new BlockOccupancy(new Vector3i(-6, 10, 1)),
            new BlockOccupancy(new Vector3i(-6, 10, 2)),
            new BlockOccupancy(new Vector3i(-6, 10, 3)),
            new BlockOccupancy(new Vector3i(-6, 10, 4)),
            new BlockOccupancy(new Vector3i(-6, 10, 5)),
            new BlockOccupancy(new Vector3i(-5, 0, -6)),
            new BlockOccupancy(new Vector3i(-5, 0, -5)),
            new BlockOccupancy(new Vector3i(-5, 0, -4)),
            new BlockOccupancy(new Vector3i(-5, 0, -3)),
            new BlockOccupancy(new Vector3i(-5, 0, -2)),
            new BlockOccupancy(new Vector3i(-5, 0, -1)),
            new BlockOccupancy(new Vector3i(-5, 0, 0)),
            new BlockOccupancy(new Vector3i(-5, 0, 1)),
            new BlockOccupancy(new Vector3i(-5, 0, 2)),
            new BlockOccupancy(new Vector3i(-5, 0, 3)),
            new BlockOccupancy(new Vector3i(-5, 0, 4)),
            new BlockOccupancy(new Vector3i(-5, 0, 5)),
            new BlockOccupancy(new Vector3i(-5, 1, -6)),
            new BlockOccupancy(new Vector3i(-5, 1, -5)),
            new BlockOccupancy(new Vector3i(-5, 1, -4)),
            new BlockOccupancy(new Vector3i(-5, 1, -3)),
            new BlockOccupancy(new Vector3i(-5, 1, -2)),
            new BlockOccupancy(new Vector3i(-5, 1, -1)),
            new BlockOccupancy(new Vector3i(-5, 1, 0)),
            new BlockOccupancy(new Vector3i(-5, 1, 1)),
            new BlockOccupancy(new Vector3i(-5, 1, 2)),
            new BlockOccupancy(new Vector3i(-5, 1, 3)),
            new BlockOccupancy(new Vector3i(-5, 1, 4)),
            new BlockOccupancy(new Vector3i(-5, 1, 5)),
            new BlockOccupancy(new Vector3i(-5, 2, -6)),
            new BlockOccupancy(new Vector3i(-5, 2, -5)),
            new BlockOccupancy(new Vector3i(-5, 2, -4)),
            new BlockOccupancy(new Vector3i(-5, 2, -3)),
            new BlockOccupancy(new Vector3i(-5, 2, -2)),
            new BlockOccupancy(new Vector3i(-5, 2, -1)),
            new BlockOccupancy(new Vector3i(-5, 2, 0)),
            new BlockOccupancy(new Vector3i(-5, 2, 1)),
            new BlockOccupancy(new Vector3i(-5, 2, 2)),
            new BlockOccupancy(new Vector3i(-5, 2, 3)),
            new BlockOccupancy(new Vector3i(-5, 2, 4)),
            new BlockOccupancy(new Vector3i(-5, 2, 5)),
            new BlockOccupancy(new Vector3i(-5, 3, -6)),
            new BlockOccupancy(new Vector3i(-5, 3, -5)),
            new BlockOccupancy(new Vector3i(-5, 3, -4)),
            new BlockOccupancy(new Vector3i(-5, 3, -3)),
            new BlockOccupancy(new Vector3i(-5, 3, -2)),
            new BlockOccupancy(new Vector3i(-5, 3, -1)),
            new BlockOccupancy(new Vector3i(-5, 3, 0)),
            new BlockOccupancy(new Vector3i(-5, 3, 1)),
            new BlockOccupancy(new Vector3i(-5, 3, 2)),
            new BlockOccupancy(new Vector3i(-5, 3, 3)),
            new BlockOccupancy(new Vector3i(-5, 3, 4)),
            new BlockOccupancy(new Vector3i(-5, 3, 5)),
            new BlockOccupancy(new Vector3i(-5, 4, -6)),
            new BlockOccupancy(new Vector3i(-5, 4, -5)),
            new BlockOccupancy(new Vector3i(-5, 4, -4)),
            new BlockOccupancy(new Vector3i(-5, 4, -3)),
            new BlockOccupancy(new Vector3i(-5, 4, -2)),
            new BlockOccupancy(new Vector3i(-5, 4, -1)),
            new BlockOccupancy(new Vector3i(-5, 4, 0)),
            new BlockOccupancy(new Vector3i(-5, 4, 1)),
            new BlockOccupancy(new Vector3i(-5, 4, 2)),
            new BlockOccupancy(new Vector3i(-5, 4, 3)),
            new BlockOccupancy(new Vector3i(-5, 4, 4)),
            new BlockOccupancy(new Vector3i(-5, 4, 5)),
            new BlockOccupancy(new Vector3i(-5, 5, -6)),
            new BlockOccupancy(new Vector3i(-5, 5, -5)),
            new BlockOccupancy(new Vector3i(-5, 5, -4)),
            new BlockOccupancy(new Vector3i(-5, 5, -3)),
            new BlockOccupancy(new Vector3i(-5, 5, -2)),
            new BlockOccupancy(new Vector3i(-5, 5, -1)),
            new BlockOccupancy(new Vector3i(-5, 5, 0)),
            new BlockOccupancy(new Vector3i(-5, 5, 1)),
            new BlockOccupancy(new Vector3i(-5, 5, 2)),
            new BlockOccupancy(new Vector3i(-5, 5, 3)),
            new BlockOccupancy(new Vector3i(-5, 5, 4)),
            new BlockOccupancy(new Vector3i(-5, 5, 5)),
            new BlockOccupancy(new Vector3i(-5, 6, -6)),
            new BlockOccupancy(new Vector3i(-5, 6, -5)),
            new BlockOccupancy(new Vector3i(-5, 6, -4)),
            new BlockOccupancy(new Vector3i(-5, 6, -3)),
            new BlockOccupancy(new Vector3i(-5, 6, -2)),
            new BlockOccupancy(new Vector3i(-5, 6, -1)),
            new BlockOccupancy(new Vector3i(-5, 6, 0)),
            new BlockOccupancy(new Vector3i(-5, 6, 1)),
            new BlockOccupancy(new Vector3i(-5, 6, 2)),
            new BlockOccupancy(new Vector3i(-5, 6, 3)),
            new BlockOccupancy(new Vector3i(-5, 6, 4)),
            new BlockOccupancy(new Vector3i(-5, 6, 5)),
            new BlockOccupancy(new Vector3i(-5, 7, -6)),
            new BlockOccupancy(new Vector3i(-5, 7, -5)),
            new BlockOccupancy(new Vector3i(-5, 7, -4)),
            new BlockOccupancy(new Vector3i(-5, 7, -3)),
            new BlockOccupancy(new Vector3i(-5, 7, -2)),
            new BlockOccupancy(new Vector3i(-5, 7, -1)),
            new BlockOccupancy(new Vector3i(-5, 7, 0)),
            new BlockOccupancy(new Vector3i(-5, 7, 1)),
            new BlockOccupancy(new Vector3i(-5, 7, 2)),
            new BlockOccupancy(new Vector3i(-5, 7, 3)),
            new BlockOccupancy(new Vector3i(-5, 7, 4)),
            new BlockOccupancy(new Vector3i(-5, 7, 5)),
            new BlockOccupancy(new Vector3i(-5, 8, -6)),
            new BlockOccupancy(new Vector3i(-5, 8, -5)),
            new BlockOccupancy(new Vector3i(-5, 8, -4)),
            new BlockOccupancy(new Vector3i(-5, 8, -3)),
            new BlockOccupancy(new Vector3i(-5, 8, -2)),
            new BlockOccupancy(new Vector3i(-5, 8, -1)),
            new BlockOccupancy(new Vector3i(-5, 8, 0)),
            new BlockOccupancy(new Vector3i(-5, 8, 1)),
            new BlockOccupancy(new Vector3i(-5, 8, 2)),
            new BlockOccupancy(new Vector3i(-5, 8, 3)),
            new BlockOccupancy(new Vector3i(-5, 8, 4)),
            new BlockOccupancy(new Vector3i(-5, 8, 5)),
            new BlockOccupancy(new Vector3i(-5, 9, -6)),
            new BlockOccupancy(new Vector3i(-5, 9, -5)),
            new BlockOccupancy(new Vector3i(-5, 9, -4)),
            new BlockOccupancy(new Vector3i(-5, 9, -3)),
            new BlockOccupancy(new Vector3i(-5, 9, -2)),
            new BlockOccupancy(new Vector3i(-5, 9, -1)),
            new BlockOccupancy(new Vector3i(-5, 9, 0)),
            new BlockOccupancy(new Vector3i(-5, 9, 1)),
            new BlockOccupancy(new Vector3i(-5, 9, 2)),
            new BlockOccupancy(new Vector3i(-5, 9, 3)),
            new BlockOccupancy(new Vector3i(-5, 9, 4)),
            new BlockOccupancy(new Vector3i(-5, 9, 5)),
            new BlockOccupancy(new Vector3i(-5, 10, -6)),
            new BlockOccupancy(new Vector3i(-5, 10, -5)),
            new BlockOccupancy(new Vector3i(-5, 10, -4)),
            new BlockOccupancy(new Vector3i(-5, 10, -3)),
            new BlockOccupancy(new Vector3i(-5, 10, -2)),
            new BlockOccupancy(new Vector3i(-5, 10, -1)),
            new BlockOccupancy(new Vector3i(-5, 10, 0)),
            new BlockOccupancy(new Vector3i(-5, 10, 1)),
            new BlockOccupancy(new Vector3i(-5, 10, 2)),
            new BlockOccupancy(new Vector3i(-5, 10, 3)),
            new BlockOccupancy(new Vector3i(-5, 10, 4)),
            new BlockOccupancy(new Vector3i(-5, 10, 5)),
            new BlockOccupancy(new Vector3i(-4, 0, -6)),
            new BlockOccupancy(new Vector3i(-4, 0, -5)),
            new BlockOccupancy(new Vector3i(-4, 0, -4)),
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 1)),
            new BlockOccupancy(new Vector3i(-4, 0, 2)),
            new BlockOccupancy(new Vector3i(-4, 0, 3)),
            new BlockOccupancy(new Vector3i(-4, 0, 4)),
            new BlockOccupancy(new Vector3i(-4, 0, 5)),
            new BlockOccupancy(new Vector3i(-4, 1, -6)),
            new BlockOccupancy(new Vector3i(-4, 1, -5)),
            new BlockOccupancy(new Vector3i(-4, 1, -4)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, 1)),
            new BlockOccupancy(new Vector3i(-4, 1, 2)),
            new BlockOccupancy(new Vector3i(-4, 1, 3)),
            new BlockOccupancy(new Vector3i(-4, 1, 4)),
            new BlockOccupancy(new Vector3i(-4, 1, 5)),
            new BlockOccupancy(new Vector3i(-4, 2, -6)),
            new BlockOccupancy(new Vector3i(-4, 2, -5)),
            new BlockOccupancy(new Vector3i(-4, 2, -4)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, 1)),
            new BlockOccupancy(new Vector3i(-4, 2, 2)),
            new BlockOccupancy(new Vector3i(-4, 2, 3)),
            new BlockOccupancy(new Vector3i(-4, 2, 4)),
            new BlockOccupancy(new Vector3i(-4, 2, 5)),
            new BlockOccupancy(new Vector3i(-4, 3, -6)),
            new BlockOccupancy(new Vector3i(-4, 3, -5)),
            new BlockOccupancy(new Vector3i(-4, 3, -4)),
            new BlockOccupancy(new Vector3i(-4, 3, -3)),
            new BlockOccupancy(new Vector3i(-4, 3, -2)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, 1)),
            new BlockOccupancy(new Vector3i(-4, 3, 2)),
            new BlockOccupancy(new Vector3i(-4, 3, 3)),
            new BlockOccupancy(new Vector3i(-4, 3, 4)),
            new BlockOccupancy(new Vector3i(-4, 3, 5)),
            new BlockOccupancy(new Vector3i(-4, 4, -6)),
            new BlockOccupancy(new Vector3i(-4, 4, -5)),
            new BlockOccupancy(new Vector3i(-4, 4, -4)),
            new BlockOccupancy(new Vector3i(-4, 4, -3)),
            new BlockOccupancy(new Vector3i(-4, 4, -2)),
            new BlockOccupancy(new Vector3i(-4, 4, -1)),
            new BlockOccupancy(new Vector3i(-4, 4, 0)),
            new BlockOccupancy(new Vector3i(-4, 4, 1)),
            new BlockOccupancy(new Vector3i(-4, 4, 2)),
            new BlockOccupancy(new Vector3i(-4, 4, 3)),
            new BlockOccupancy(new Vector3i(-4, 4, 4)),
            new BlockOccupancy(new Vector3i(-4, 4, 5)),
            new BlockOccupancy(new Vector3i(-4, 5, -6)),
            new BlockOccupancy(new Vector3i(-4, 5, -5)),
            new BlockOccupancy(new Vector3i(-4, 5, -4)),
            new BlockOccupancy(new Vector3i(-4, 5, -3)),
            new BlockOccupancy(new Vector3i(-4, 5, -2)),
            new BlockOccupancy(new Vector3i(-4, 5, -1)),
            new BlockOccupancy(new Vector3i(-4, 5, 0)),
            new BlockOccupancy(new Vector3i(-4, 5, 1)),
            new BlockOccupancy(new Vector3i(-4, 5, 2)),
            new BlockOccupancy(new Vector3i(-4, 5, 3)),
            new BlockOccupancy(new Vector3i(-4, 5, 4)),
            new BlockOccupancy(new Vector3i(-4, 5, 5)),
            new BlockOccupancy(new Vector3i(-4, 6, -6)),
            new BlockOccupancy(new Vector3i(-4, 6, -5)),
            new BlockOccupancy(new Vector3i(-4, 6, -4)),
            new BlockOccupancy(new Vector3i(-4, 6, -3)),
            new BlockOccupancy(new Vector3i(-4, 6, -2)),
            new BlockOccupancy(new Vector3i(-4, 6, -1)),
            new BlockOccupancy(new Vector3i(-4, 6, 0)),
            new BlockOccupancy(new Vector3i(-4, 6, 1)),
            new BlockOccupancy(new Vector3i(-4, 6, 2)),
            new BlockOccupancy(new Vector3i(-4, 6, 3)),
            new BlockOccupancy(new Vector3i(-4, 6, 4)),
            new BlockOccupancy(new Vector3i(-4, 6, 5)),
            new BlockOccupancy(new Vector3i(-4, 7, -6)),
            new BlockOccupancy(new Vector3i(-4, 7, -5)),
            new BlockOccupancy(new Vector3i(-4, 7, -4)),
            new BlockOccupancy(new Vector3i(-4, 7, -3)),
            new BlockOccupancy(new Vector3i(-4, 7, -2)),
            new BlockOccupancy(new Vector3i(-4, 7, -1)),
            new BlockOccupancy(new Vector3i(-4, 7, 0)),
            new BlockOccupancy(new Vector3i(-4, 7, 1)),
            new BlockOccupancy(new Vector3i(-4, 7, 2)),
            new BlockOccupancy(new Vector3i(-4, 7, 3)),
            new BlockOccupancy(new Vector3i(-4, 7, 4)),
            new BlockOccupancy(new Vector3i(-4, 7, 5)),
            new BlockOccupancy(new Vector3i(-4, 8, -6)),
            new BlockOccupancy(new Vector3i(-4, 8, -5)),
            new BlockOccupancy(new Vector3i(-4, 8, -4)),
            new BlockOccupancy(new Vector3i(-4, 8, -3)),
            new BlockOccupancy(new Vector3i(-4, 8, -2)),
            new BlockOccupancy(new Vector3i(-4, 8, -1)),
            new BlockOccupancy(new Vector3i(-4, 8, 0)),
            new BlockOccupancy(new Vector3i(-4, 8, 1)),
            new BlockOccupancy(new Vector3i(-4, 8, 2)),
            new BlockOccupancy(new Vector3i(-4, 8, 3)),
            new BlockOccupancy(new Vector3i(-4, 8, 4)),
            new BlockOccupancy(new Vector3i(-4, 8, 5)),
            new BlockOccupancy(new Vector3i(-4, 9, -6)),
            new BlockOccupancy(new Vector3i(-4, 9, -5)),
            new BlockOccupancy(new Vector3i(-4, 9, -4)),
            new BlockOccupancy(new Vector3i(-4, 9, -3)),
            new BlockOccupancy(new Vector3i(-4, 9, -2)),
            new BlockOccupancy(new Vector3i(-4, 9, -1)),
            new BlockOccupancy(new Vector3i(-4, 9, 0)),
            new BlockOccupancy(new Vector3i(-4, 9, 1)),
            new BlockOccupancy(new Vector3i(-4, 9, 2)),
            new BlockOccupancy(new Vector3i(-4, 9, 3)),
            new BlockOccupancy(new Vector3i(-4, 9, 4)),
            new BlockOccupancy(new Vector3i(-4, 9, 5)),
            new BlockOccupancy(new Vector3i(-4, 10, -6)),
            new BlockOccupancy(new Vector3i(-4, 10, -5)),
            new BlockOccupancy(new Vector3i(-4, 10, -4)),
            new BlockOccupancy(new Vector3i(-4, 10, -3)),
            new BlockOccupancy(new Vector3i(-4, 10, -2)),
            new BlockOccupancy(new Vector3i(-4, 10, -1)),
            new BlockOccupancy(new Vector3i(-4, 10, 0)),
            new BlockOccupancy(new Vector3i(-4, 10, 1)),
            new BlockOccupancy(new Vector3i(-4, 10, 2)),
            new BlockOccupancy(new Vector3i(-4, 10, 3)),
            new BlockOccupancy(new Vector3i(-4, 10, 4)),
            new BlockOccupancy(new Vector3i(-4, 10, 5)),
            new BlockOccupancy(new Vector3i(-3, 0, -6)),
            new BlockOccupancy(new Vector3i(-3, 0, -5)),
            new BlockOccupancy(new Vector3i(-3, 0, -4)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, 2)),
            new BlockOccupancy(new Vector3i(-3, 0, 3)),
            new BlockOccupancy(new Vector3i(-3, 0, 4)),
            new BlockOccupancy(new Vector3i(-3, 0, 5)),
            new BlockOccupancy(new Vector3i(-3, 1, -6)),
            new BlockOccupancy(new Vector3i(-3, 1, -5)),
            new BlockOccupancy(new Vector3i(-3, 1, -4)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 2)),
            new BlockOccupancy(new Vector3i(-3, 1, 3)),
            new BlockOccupancy(new Vector3i(-3, 1, 4)),
            new BlockOccupancy(new Vector3i(-3, 1, 5)),
            new BlockOccupancy(new Vector3i(-3, 2, -6)),
            new BlockOccupancy(new Vector3i(-3, 2, -5)),
            new BlockOccupancy(new Vector3i(-3, 2, -4)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, 2)),
            new BlockOccupancy(new Vector3i(-3, 2, 3)),
            new BlockOccupancy(new Vector3i(-3, 2, 4)),
            new BlockOccupancy(new Vector3i(-3, 2, 5)),
            new BlockOccupancy(new Vector3i(-3, 3, -6)),
            new BlockOccupancy(new Vector3i(-3, 3, -5)),
            new BlockOccupancy(new Vector3i(-3, 3, -4)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, 2)),
            new BlockOccupancy(new Vector3i(-3, 3, 3)),
            new BlockOccupancy(new Vector3i(-3, 3, 4)),
            new BlockOccupancy(new Vector3i(-3, 3, 5)),
            new BlockOccupancy(new Vector3i(-3, 4, -6)),
            new BlockOccupancy(new Vector3i(-3, 4, -5)),
            new BlockOccupancy(new Vector3i(-3, 4, -4)),
            new BlockOccupancy(new Vector3i(-3, 4, -3)),
            new BlockOccupancy(new Vector3i(-3, 4, -2)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, 1)),
            new BlockOccupancy(new Vector3i(-3, 4, 2)),
            new BlockOccupancy(new Vector3i(-3, 4, 3)),
            new BlockOccupancy(new Vector3i(-3, 4, 4)),
            new BlockOccupancy(new Vector3i(-3, 4, 5)),
            new BlockOccupancy(new Vector3i(-3, 5, -6)),
            new BlockOccupancy(new Vector3i(-3, 5, -5)),
            new BlockOccupancy(new Vector3i(-3, 5, -4)),
            new BlockOccupancy(new Vector3i(-3, 5, -3)),
            new BlockOccupancy(new Vector3i(-3, 5, -2)),
            new BlockOccupancy(new Vector3i(-3, 5, -1)),
            new BlockOccupancy(new Vector3i(-3, 5, 0)),
            new BlockOccupancy(new Vector3i(-3, 5, 1)),
            new BlockOccupancy(new Vector3i(-3, 5, 2)),
            new BlockOccupancy(new Vector3i(-3, 5, 3)),
            new BlockOccupancy(new Vector3i(-3, 5, 4)),
            new BlockOccupancy(new Vector3i(-3, 5, 5)),
            new BlockOccupancy(new Vector3i(-3, 6, -6)),
            new BlockOccupancy(new Vector3i(-3, 6, -5)),
            new BlockOccupancy(new Vector3i(-3, 6, -4)),
            new BlockOccupancy(new Vector3i(-3, 6, -3)),
            new BlockOccupancy(new Vector3i(-3, 6, -2)),
            new BlockOccupancy(new Vector3i(-3, 6, -1)),
            new BlockOccupancy(new Vector3i(-3, 6, 0)),
            new BlockOccupancy(new Vector3i(-3, 6, 1)),
            new BlockOccupancy(new Vector3i(-3, 6, 2)),
            new BlockOccupancy(new Vector3i(-3, 6, 3)),
            new BlockOccupancy(new Vector3i(-3, 6, 4)),
            new BlockOccupancy(new Vector3i(-3, 6, 5)),
            new BlockOccupancy(new Vector3i(-3, 7, -6)),
            new BlockOccupancy(new Vector3i(-3, 7, -5)),
            new BlockOccupancy(new Vector3i(-3, 7, -4)),
            new BlockOccupancy(new Vector3i(-3, 7, -3)),
            new BlockOccupancy(new Vector3i(-3, 7, -2)),
            new BlockOccupancy(new Vector3i(-3, 7, -1)),
            new BlockOccupancy(new Vector3i(-3, 7, 0)),
            new BlockOccupancy(new Vector3i(-3, 7, 1)),
            new BlockOccupancy(new Vector3i(-3, 7, 2)),
            new BlockOccupancy(new Vector3i(-3, 7, 3)),
            new BlockOccupancy(new Vector3i(-3, 7, 4)),
            new BlockOccupancy(new Vector3i(-3, 7, 5)),
            new BlockOccupancy(new Vector3i(-3, 8, -6)),
            new BlockOccupancy(new Vector3i(-3, 8, -5)),
            new BlockOccupancy(new Vector3i(-3, 8, -4)),
            new BlockOccupancy(new Vector3i(-3, 8, -3)),
            new BlockOccupancy(new Vector3i(-3, 8, -2)),
            new BlockOccupancy(new Vector3i(-3, 8, -1)),
            new BlockOccupancy(new Vector3i(-3, 8, 0)),
            new BlockOccupancy(new Vector3i(-3, 8, 1)),
            new BlockOccupancy(new Vector3i(-3, 8, 2)),
            new BlockOccupancy(new Vector3i(-3, 8, 3)),
            new BlockOccupancy(new Vector3i(-3, 8, 4)),
            new BlockOccupancy(new Vector3i(-3, 8, 5)),
            new BlockOccupancy(new Vector3i(-3, 9, -6)),
            new BlockOccupancy(new Vector3i(-3, 9, -5)),
            new BlockOccupancy(new Vector3i(-3, 9, -4)),
            new BlockOccupancy(new Vector3i(-3, 9, -3)),
            new BlockOccupancy(new Vector3i(-3, 9, -2)),
            new BlockOccupancy(new Vector3i(-3, 9, -1)),
            new BlockOccupancy(new Vector3i(-3, 9, 0)),
            new BlockOccupancy(new Vector3i(-3, 9, 1)),
            new BlockOccupancy(new Vector3i(-3, 9, 2)),
            new BlockOccupancy(new Vector3i(-3, 9, 3)),
            new BlockOccupancy(new Vector3i(-3, 9, 4)),
            new BlockOccupancy(new Vector3i(-3, 9, 5)),
            new BlockOccupancy(new Vector3i(-3, 10, -6)),
            new BlockOccupancy(new Vector3i(-3, 10, -5)),
            new BlockOccupancy(new Vector3i(-3, 10, -4)),
            new BlockOccupancy(new Vector3i(-3, 10, -3)),
            new BlockOccupancy(new Vector3i(-3, 10, -2)),
            new BlockOccupancy(new Vector3i(-3, 10, -1)),
            new BlockOccupancy(new Vector3i(-3, 10, 0)),
            new BlockOccupancy(new Vector3i(-3, 10, 1)),
            new BlockOccupancy(new Vector3i(-3, 10, 2)),
            new BlockOccupancy(new Vector3i(-3, 10, 3)),
            new BlockOccupancy(new Vector3i(-3, 10, 4)),
            new BlockOccupancy(new Vector3i(-3, 10, 5)),
            new BlockOccupancy(new Vector3i(-2, 0, -6)),
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 0, 3)),
            new BlockOccupancy(new Vector3i(-2, 0, 4)),
            new BlockOccupancy(new Vector3i(-2, 0, 5)),
            new BlockOccupancy(new Vector3i(-2, 1, -6)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 1, 4)),
            new BlockOccupancy(new Vector3i(-2, 1, 5)),
            new BlockOccupancy(new Vector3i(-2, 2, -6)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, 4)),
            new BlockOccupancy(new Vector3i(-2, 2, 5)),
            new BlockOccupancy(new Vector3i(-2, 3, -6)),
            new BlockOccupancy(new Vector3i(-2, 3, -5)),
            new BlockOccupancy(new Vector3i(-2, 3, -4)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, 3)),
            new BlockOccupancy(new Vector3i(-2, 3, 4)),
            new BlockOccupancy(new Vector3i(-2, 3, 5)),
            new BlockOccupancy(new Vector3i(-2, 4, -6)),
            new BlockOccupancy(new Vector3i(-2, 4, -5)),
            new BlockOccupancy(new Vector3i(-2, 4, -4)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, 2)),
            new BlockOccupancy(new Vector3i(-2, 4, 3)),
            new BlockOccupancy(new Vector3i(-2, 4, 4)),
            new BlockOccupancy(new Vector3i(-2, 4, 5)),
            new BlockOccupancy(new Vector3i(-2, 5, -6)),
            new BlockOccupancy(new Vector3i(-2, 5, -5)),
            new BlockOccupancy(new Vector3i(-2, 5, -4)),
            new BlockOccupancy(new Vector3i(-2, 5, -3)),
            new BlockOccupancy(new Vector3i(-2, 5, -2)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, 2)),
            new BlockOccupancy(new Vector3i(-2, 5, 3)),
            new BlockOccupancy(new Vector3i(-2, 5, 4)),
            new BlockOccupancy(new Vector3i(-2, 5, 5)),
            new BlockOccupancy(new Vector3i(-2, 6, -6)),
            new BlockOccupancy(new Vector3i(-2, 6, -5)),
            new BlockOccupancy(new Vector3i(-2, 6, -4)),
            new BlockOccupancy(new Vector3i(-2, 6, -3)),
            new BlockOccupancy(new Vector3i(-2, 6, -2)),
            new BlockOccupancy(new Vector3i(-2, 6, -1)),
            new BlockOccupancy(new Vector3i(-2, 6, 0)),
            new BlockOccupancy(new Vector3i(-2, 6, 1)),
            new BlockOccupancy(new Vector3i(-2, 6, 2)),
            new BlockOccupancy(new Vector3i(-2, 6, 3)),
            new BlockOccupancy(new Vector3i(-2, 6, 4)),
            new BlockOccupancy(new Vector3i(-2, 6, 5)),
            new BlockOccupancy(new Vector3i(-2, 7, -6)),
            new BlockOccupancy(new Vector3i(-2, 7, -5)),
            new BlockOccupancy(new Vector3i(-2, 7, -4)),
            new BlockOccupancy(new Vector3i(-2, 7, -3)),
            new BlockOccupancy(new Vector3i(-2, 7, -2)),
            new BlockOccupancy(new Vector3i(-2, 7, -1)),
            new BlockOccupancy(new Vector3i(-2, 7, 0)),
            new BlockOccupancy(new Vector3i(-2, 7, 1)),
            new BlockOccupancy(new Vector3i(-2, 7, 2)),
            new BlockOccupancy(new Vector3i(-2, 7, 3)),
            new BlockOccupancy(new Vector3i(-2, 7, 4)),
            new BlockOccupancy(new Vector3i(-2, 7, 5)),
            new BlockOccupancy(new Vector3i(-2, 8, -6)),
            new BlockOccupancy(new Vector3i(-2, 8, -5)),
            new BlockOccupancy(new Vector3i(-2, 8, -4)),
            new BlockOccupancy(new Vector3i(-2, 8, -3)),
            new BlockOccupancy(new Vector3i(-2, 8, -2)),
            new BlockOccupancy(new Vector3i(-2, 8, -1)),
            new BlockOccupancy(new Vector3i(-2, 8, 0)),
            new BlockOccupancy(new Vector3i(-2, 8, 1)),
            new BlockOccupancy(new Vector3i(-2, 8, 2)),
            new BlockOccupancy(new Vector3i(-2, 8, 3)),
            new BlockOccupancy(new Vector3i(-2, 8, 4)),
            new BlockOccupancy(new Vector3i(-2, 8, 5)),
            new BlockOccupancy(new Vector3i(-2, 9, -6)),
            new BlockOccupancy(new Vector3i(-2, 9, -5)),
            new BlockOccupancy(new Vector3i(-2, 9, -4)),
            new BlockOccupancy(new Vector3i(-2, 9, -3)),
            new BlockOccupancy(new Vector3i(-2, 9, -2)),
            new BlockOccupancy(new Vector3i(-2, 9, -1)),
            new BlockOccupancy(new Vector3i(-2, 9, 0)),
            new BlockOccupancy(new Vector3i(-2, 9, 1)),
            new BlockOccupancy(new Vector3i(-2, 9, 2)),
            new BlockOccupancy(new Vector3i(-2, 9, 3)),
            new BlockOccupancy(new Vector3i(-2, 9, 4)),
            new BlockOccupancy(new Vector3i(-2, 9, 5)),
            new BlockOccupancy(new Vector3i(-2, 10, -6)),
            new BlockOccupancy(new Vector3i(-2, 10, -5)),
            new BlockOccupancy(new Vector3i(-2, 10, -4)),
            new BlockOccupancy(new Vector3i(-2, 10, -3)),
            new BlockOccupancy(new Vector3i(-2, 10, -2)),
            new BlockOccupancy(new Vector3i(-2, 10, -1)),
            new BlockOccupancy(new Vector3i(-2, 10, 0)),
            new BlockOccupancy(new Vector3i(-2, 10, 1)),
            new BlockOccupancy(new Vector3i(-2, 10, 2)),
            new BlockOccupancy(new Vector3i(-2, 10, 3)),
            new BlockOccupancy(new Vector3i(-2, 10, 4)),
            new BlockOccupancy(new Vector3i(-2, 10, 5)),
            new BlockOccupancy(new Vector3i(-1, 0, -6)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 4)),
            new BlockOccupancy(new Vector3i(-1, 0, 5)),
            new BlockOccupancy(new Vector3i(-1, 1, -6)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 4)),
            new BlockOccupancy(new Vector3i(-1, 1, 5)),
            new BlockOccupancy(new Vector3i(-1, 2, -6)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 4)),
            new BlockOccupancy(new Vector3i(-1, 2, 5)),
            new BlockOccupancy(new Vector3i(-1, 3, -6)),
            new BlockOccupancy(new Vector3i(-1, 3, -5)),
            new BlockOccupancy(new Vector3i(-1, 3, -4)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 4)),
            new BlockOccupancy(new Vector3i(-1, 3, 5)),
            new BlockOccupancy(new Vector3i(-1, 4, -6)),
            new BlockOccupancy(new Vector3i(-1, 4, -5)),
            new BlockOccupancy(new Vector3i(-1, 4, -4)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, 2)),
            new BlockOccupancy(new Vector3i(-1, 4, 3)),
            new BlockOccupancy(new Vector3i(-1, 4, 4)),
            new BlockOccupancy(new Vector3i(-1, 4, 5)),
            new BlockOccupancy(new Vector3i(-1, 5, -6)),
            new BlockOccupancy(new Vector3i(-1, 5, -5)),
            new BlockOccupancy(new Vector3i(-1, 5, -4)),
            new BlockOccupancy(new Vector3i(-1, 5, -3)),
            new BlockOccupancy(new Vector3i(-1, 5, -2)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, 2)),
            new BlockOccupancy(new Vector3i(-1, 5, 3)),
            new BlockOccupancy(new Vector3i(-1, 5, 4)),
            new BlockOccupancy(new Vector3i(-1, 5, 5)),
            new BlockOccupancy(new Vector3i(-1, 6, -6)),
            new BlockOccupancy(new Vector3i(-1, 6, -5)),
            new BlockOccupancy(new Vector3i(-1, 6, -4)),
            new BlockOccupancy(new Vector3i(-1, 6, -3)),
            new BlockOccupancy(new Vector3i(-1, 6, -2)),
            new BlockOccupancy(new Vector3i(-1, 6, -1)),
            new BlockOccupancy(new Vector3i(-1, 6, 0)),
            new BlockOccupancy(new Vector3i(-1, 6, 1)),
            new BlockOccupancy(new Vector3i(-1, 6, 2)),
            new BlockOccupancy(new Vector3i(-1, 6, 3)),
            new BlockOccupancy(new Vector3i(-1, 6, 4)),
            new BlockOccupancy(new Vector3i(-1, 6, 5)),
            new BlockOccupancy(new Vector3i(-1, 7, -6)),
            new BlockOccupancy(new Vector3i(-1, 7, -5)),
            new BlockOccupancy(new Vector3i(-1, 7, -4)),
            new BlockOccupancy(new Vector3i(-1, 7, -3)),
            new BlockOccupancy(new Vector3i(-1, 7, -2)),
            new BlockOccupancy(new Vector3i(-1, 7, -1)),
            new BlockOccupancy(new Vector3i(-1, 7, 0)),
            new BlockOccupancy(new Vector3i(-1, 7, 1)),
            new BlockOccupancy(new Vector3i(-1, 7, 2)),
            new BlockOccupancy(new Vector3i(-1, 7, 3)),
            new BlockOccupancy(new Vector3i(-1, 7, 4)),
            new BlockOccupancy(new Vector3i(-1, 7, 5)),
            new BlockOccupancy(new Vector3i(-1, 8, -6)),
            new BlockOccupancy(new Vector3i(-1, 8, -5)),
            new BlockOccupancy(new Vector3i(-1, 8, -4)),
            new BlockOccupancy(new Vector3i(-1, 8, -3)),
            new BlockOccupancy(new Vector3i(-1, 8, -2)),
            new BlockOccupancy(new Vector3i(-1, 8, -1)),
            new BlockOccupancy(new Vector3i(-1, 8, 0)),
            new BlockOccupancy(new Vector3i(-1, 8, 1)),
            new BlockOccupancy(new Vector3i(-1, 8, 2)),
            new BlockOccupancy(new Vector3i(-1, 8, 3)),
            new BlockOccupancy(new Vector3i(-1, 8, 4)),
            new BlockOccupancy(new Vector3i(-1, 8, 5)),
            new BlockOccupancy(new Vector3i(-1, 9, -6)),
            new BlockOccupancy(new Vector3i(-1, 9, -5)),
            new BlockOccupancy(new Vector3i(-1, 9, -4)),
            new BlockOccupancy(new Vector3i(-1, 9, -3)),
            new BlockOccupancy(new Vector3i(-1, 9, -2)),
            new BlockOccupancy(new Vector3i(-1, 9, -1)),
            new BlockOccupancy(new Vector3i(-1, 9, 0)),
            new BlockOccupancy(new Vector3i(-1, 9, 1)),
            new BlockOccupancy(new Vector3i(-1, 9, 2)),
            new BlockOccupancy(new Vector3i(-1, 9, 3)),
            new BlockOccupancy(new Vector3i(-1, 9, 4)),
            new BlockOccupancy(new Vector3i(-1, 9, 5)),
            new BlockOccupancy(new Vector3i(-1, 10, -6)),
            new BlockOccupancy(new Vector3i(-1, 10, -5)),
            new BlockOccupancy(new Vector3i(-1, 10, -4)),
            new BlockOccupancy(new Vector3i(-1, 10, -3)),
            new BlockOccupancy(new Vector3i(-1, 10, -2)),
            new BlockOccupancy(new Vector3i(-1, 10, -1)),
            new BlockOccupancy(new Vector3i(-1, 10, 0)),
            new BlockOccupancy(new Vector3i(-1, 10, 1)),
            new BlockOccupancy(new Vector3i(-1, 10, 2)),
            new BlockOccupancy(new Vector3i(-1, 10, 3)),
            new BlockOccupancy(new Vector3i(-1, 10, 4)),
            new BlockOccupancy(new Vector3i(-1, 10, 5)),
            new BlockOccupancy(new Vector3i(0, 0, -6)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 3, -6)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 4, -6)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 4, 5)),
            new BlockOccupancy(new Vector3i(0, 5, -6)),
            new BlockOccupancy(new Vector3i(0, 5, -5)),
            new BlockOccupancy(new Vector3i(0, 5, -4)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 5, 5)),
            new BlockOccupancy(new Vector3i(0, 6, -6)),
            new BlockOccupancy(new Vector3i(0, 6, -5)),
            new BlockOccupancy(new Vector3i(0, 6, -4)),
            new BlockOccupancy(new Vector3i(0, 6, -3)),
            new BlockOccupancy(new Vector3i(0, 6, -2)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 6, 3)),
            new BlockOccupancy(new Vector3i(0, 6, 4)),
            new BlockOccupancy(new Vector3i(0, 6, 5)),
            new BlockOccupancy(new Vector3i(0, 7, -6)),
            new BlockOccupancy(new Vector3i(0, 7, -5)),
            new BlockOccupancy(new Vector3i(0, 7, -4)),
            new BlockOccupancy(new Vector3i(0, 7, -3)),
            new BlockOccupancy(new Vector3i(0, 7, -2)),
            new BlockOccupancy(new Vector3i(0, 7, -1)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 7, 2)),
            new BlockOccupancy(new Vector3i(0, 7, 3)),
            new BlockOccupancy(new Vector3i(0, 7, 4)),
            new BlockOccupancy(new Vector3i(0, 7, 5)),
            new BlockOccupancy(new Vector3i(0, 8, -6)),
            new BlockOccupancy(new Vector3i(0, 8, -5)),
            new BlockOccupancy(new Vector3i(0, 8, -4)),
            new BlockOccupancy(new Vector3i(0, 8, -3)),
            new BlockOccupancy(new Vector3i(0, 8, -2)),
            new BlockOccupancy(new Vector3i(0, 8, -1)),
            new BlockOccupancy(new Vector3i(0, 8, 0)),
            new BlockOccupancy(new Vector3i(0, 8, 1)),
            new BlockOccupancy(new Vector3i(0, 8, 2)),
            new BlockOccupancy(new Vector3i(0, 8, 3)),
            new BlockOccupancy(new Vector3i(0, 8, 4)),
            new BlockOccupancy(new Vector3i(0, 8, 5)),
            new BlockOccupancy(new Vector3i(0, 9, -6)),
            new BlockOccupancy(new Vector3i(0, 9, -5)),
            new BlockOccupancy(new Vector3i(0, 9, -4)),
            new BlockOccupancy(new Vector3i(0, 9, -3)),
            new BlockOccupancy(new Vector3i(0, 9, -2)),
            new BlockOccupancy(new Vector3i(0, 9, -1)),
            new BlockOccupancy(new Vector3i(0, 9, 0)),
            new BlockOccupancy(new Vector3i(0, 9, 1)),
            new BlockOccupancy(new Vector3i(0, 9, 2)),
            new BlockOccupancy(new Vector3i(0, 9, 3)),
            new BlockOccupancy(new Vector3i(0, 9, 4)),
            new BlockOccupancy(new Vector3i(0, 9, 5)),
            new BlockOccupancy(new Vector3i(0, 10, -6)),
            new BlockOccupancy(new Vector3i(0, 10, -5)),
            new BlockOccupancy(new Vector3i(0, 10, -4)),
            new BlockOccupancy(new Vector3i(0, 10, -3)),
            new BlockOccupancy(new Vector3i(0, 10, -2)),
            new BlockOccupancy(new Vector3i(0, 10, -1)),
            new BlockOccupancy(new Vector3i(0, 10, 0)),
            new BlockOccupancy(new Vector3i(0, 10, 1)),
            new BlockOccupancy(new Vector3i(0, 10, 2)),
            new BlockOccupancy(new Vector3i(0, 10, 3)),
            new BlockOccupancy(new Vector3i(0, 10, 4)),
            new BlockOccupancy(new Vector3i(0, 10, 5)),
            new BlockOccupancy(new Vector3i(1, 0, -6)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 5)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 3, -6)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 5)),
            new BlockOccupancy(new Vector3i(1, 4, -6)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 3)),
            new BlockOccupancy(new Vector3i(1, 4, 4)),
            new BlockOccupancy(new Vector3i(1, 4, 5)),
            new BlockOccupancy(new Vector3i(1, 5, -6)),
            new BlockOccupancy(new Vector3i(1, 5, -5)),
            new BlockOccupancy(new Vector3i(1, 5, -4)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 5, 2)),
            new BlockOccupancy(new Vector3i(1, 5, 3)),
            new BlockOccupancy(new Vector3i(1, 5, 4)),
            new BlockOccupancy(new Vector3i(1, 5, 5)),
            new BlockOccupancy(new Vector3i(1, 6, -6)),
            new BlockOccupancy(new Vector3i(1, 6, -5)),
            new BlockOccupancy(new Vector3i(1, 6, -4)),
            new BlockOccupancy(new Vector3i(1, 6, -3)),
            new BlockOccupancy(new Vector3i(1, 6, -2)),
            new BlockOccupancy(new Vector3i(1, 6, -1)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 6, 1)),
            new BlockOccupancy(new Vector3i(1, 6, 2)),
            new BlockOccupancy(new Vector3i(1, 6, 3)),
            new BlockOccupancy(new Vector3i(1, 6, 4)),
            new BlockOccupancy(new Vector3i(1, 6, 5)),
            new BlockOccupancy(new Vector3i(1, 7, -6)),
            new BlockOccupancy(new Vector3i(1, 7, -5)),
            new BlockOccupancy(new Vector3i(1, 7, -4)),
            new BlockOccupancy(new Vector3i(1, 7, -3)),
            new BlockOccupancy(new Vector3i(1, 7, -2)),
            new BlockOccupancy(new Vector3i(1, 7, -1)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 7, 1)),
            new BlockOccupancy(new Vector3i(1, 7, 2)),
            new BlockOccupancy(new Vector3i(1, 7, 3)),
            new BlockOccupancy(new Vector3i(1, 7, 4)),
            new BlockOccupancy(new Vector3i(1, 7, 5)),
            new BlockOccupancy(new Vector3i(1, 8, -6)),
            new BlockOccupancy(new Vector3i(1, 8, -5)),
            new BlockOccupancy(new Vector3i(1, 8, -4)),
            new BlockOccupancy(new Vector3i(1, 8, -3)),
            new BlockOccupancy(new Vector3i(1, 8, -2)),
            new BlockOccupancy(new Vector3i(1, 8, -1)),
            new BlockOccupancy(new Vector3i(1, 8, 0)),
            new BlockOccupancy(new Vector3i(1, 8, 1)),
            new BlockOccupancy(new Vector3i(1, 8, 2)),
            new BlockOccupancy(new Vector3i(1, 8, 3)),
            new BlockOccupancy(new Vector3i(1, 8, 4)),
            new BlockOccupancy(new Vector3i(1, 8, 5)),
            new BlockOccupancy(new Vector3i(1, 9, -6)),
            new BlockOccupancy(new Vector3i(1, 9, -5)),
            new BlockOccupancy(new Vector3i(1, 9, -4)),
            new BlockOccupancy(new Vector3i(1, 9, -3)),
            new BlockOccupancy(new Vector3i(1, 9, -2)),
            new BlockOccupancy(new Vector3i(1, 9, -1)),
            new BlockOccupancy(new Vector3i(1, 9, 0)),
            new BlockOccupancy(new Vector3i(1, 9, 1)),
            new BlockOccupancy(new Vector3i(1, 9, 2)),
            new BlockOccupancy(new Vector3i(1, 9, 3)),
            new BlockOccupancy(new Vector3i(1, 9, 4)),
            new BlockOccupancy(new Vector3i(1, 9, 5)),
            new BlockOccupancy(new Vector3i(1, 10, -6)),
            new BlockOccupancy(new Vector3i(1, 10, -5)),
            new BlockOccupancy(new Vector3i(1, 10, -4)),
            new BlockOccupancy(new Vector3i(1, 10, -3)),
            new BlockOccupancy(new Vector3i(1, 10, -2)),
            new BlockOccupancy(new Vector3i(1, 10, -1)),
            new BlockOccupancy(new Vector3i(1, 10, 0)),
            new BlockOccupancy(new Vector3i(1, 10, 1)),
            new BlockOccupancy(new Vector3i(1, 10, 2)),
            new BlockOccupancy(new Vector3i(1, 10, 3)),
            new BlockOccupancy(new Vector3i(1, 10, 4)),
            new BlockOccupancy(new Vector3i(1, 10, 5)),
            new BlockOccupancy(new Vector3i(2, 0, -6)),
            new BlockOccupancy(new Vector3i(2, 0, -5)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 5)),
            new BlockOccupancy(new Vector3i(2, 1, -6)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 5)),
            new BlockOccupancy(new Vector3i(2, 2, -6)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 5)),
            new BlockOccupancy(new Vector3i(2, 3, -6)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 5)),
            new BlockOccupancy(new Vector3i(2, 4, -6)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 3)),
            new BlockOccupancy(new Vector3i(2, 4, 4)),
            new BlockOccupancy(new Vector3i(2, 4, 5)),
            new BlockOccupancy(new Vector3i(2, 5, -6)),
            new BlockOccupancy(new Vector3i(2, 5, -5)),
            new BlockOccupancy(new Vector3i(2, 5, -4)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 5, 2)),
            new BlockOccupancy(new Vector3i(2, 5, 3)),
            new BlockOccupancy(new Vector3i(2, 5, 4)),
            new BlockOccupancy(new Vector3i(2, 5, 5)),
            new BlockOccupancy(new Vector3i(2, 6, -6)),
            new BlockOccupancy(new Vector3i(2, 6, -5)),
            new BlockOccupancy(new Vector3i(2, 6, -4)),
            new BlockOccupancy(new Vector3i(2, 6, -3)),
            new BlockOccupancy(new Vector3i(2, 6, -2)),
            new BlockOccupancy(new Vector3i(2, 6, -1)),
            new BlockOccupancy(new Vector3i(2, 6, 0)),
            new BlockOccupancy(new Vector3i(2, 6, 1)),
            new BlockOccupancy(new Vector3i(2, 6, 2)),
            new BlockOccupancy(new Vector3i(2, 6, 3)),
            new BlockOccupancy(new Vector3i(2, 6, 4)),
            new BlockOccupancy(new Vector3i(2, 6, 5)),
            new BlockOccupancy(new Vector3i(2, 7, -6)),
            new BlockOccupancy(new Vector3i(2, 7, -5)),
            new BlockOccupancy(new Vector3i(2, 7, -4)),
            new BlockOccupancy(new Vector3i(2, 7, -3)),
            new BlockOccupancy(new Vector3i(2, 7, -2)),
            new BlockOccupancy(new Vector3i(2, 7, -1)),
            new BlockOccupancy(new Vector3i(2, 7, 0)),
            new BlockOccupancy(new Vector3i(2, 7, 1)),
            new BlockOccupancy(new Vector3i(2, 7, 2)),
            new BlockOccupancy(new Vector3i(2, 7, 3)),
            new BlockOccupancy(new Vector3i(2, 7, 4)),
            new BlockOccupancy(new Vector3i(2, 7, 5)),
            new BlockOccupancy(new Vector3i(2, 8, -6)),
            new BlockOccupancy(new Vector3i(2, 8, -5)),
            new BlockOccupancy(new Vector3i(2, 8, -4)),
            new BlockOccupancy(new Vector3i(2, 8, -3)),
            new BlockOccupancy(new Vector3i(2, 8, -2)),
            new BlockOccupancy(new Vector3i(2, 8, -1)),
            new BlockOccupancy(new Vector3i(2, 8, 0)),
            new BlockOccupancy(new Vector3i(2, 8, 1)),
            new BlockOccupancy(new Vector3i(2, 8, 2)),
            new BlockOccupancy(new Vector3i(2, 8, 3)),
            new BlockOccupancy(new Vector3i(2, 8, 4)),
            new BlockOccupancy(new Vector3i(2, 8, 5)),
            new BlockOccupancy(new Vector3i(2, 9, -6)),
            new BlockOccupancy(new Vector3i(2, 9, -5)),
            new BlockOccupancy(new Vector3i(2, 9, -4)),
            new BlockOccupancy(new Vector3i(2, 9, -3)),
            new BlockOccupancy(new Vector3i(2, 9, -2)),
            new BlockOccupancy(new Vector3i(2, 9, -1)),
            new BlockOccupancy(new Vector3i(2, 9, 0)),
            new BlockOccupancy(new Vector3i(2, 9, 1)),
            new BlockOccupancy(new Vector3i(2, 9, 2)),
            new BlockOccupancy(new Vector3i(2, 9, 3)),
            new BlockOccupancy(new Vector3i(2, 9, 4)),
            new BlockOccupancy(new Vector3i(2, 9, 5)),
            new BlockOccupancy(new Vector3i(2, 10, -6)),
            new BlockOccupancy(new Vector3i(2, 10, -5)),
            new BlockOccupancy(new Vector3i(2, 10, -4)),
            new BlockOccupancy(new Vector3i(2, 10, -3)),
            new BlockOccupancy(new Vector3i(2, 10, -2)),
            new BlockOccupancy(new Vector3i(2, 10, -1)),
            new BlockOccupancy(new Vector3i(2, 10, 0)),
            new BlockOccupancy(new Vector3i(2, 10, 1)),
            new BlockOccupancy(new Vector3i(2, 10, 2)),
            new BlockOccupancy(new Vector3i(2, 10, 3)),
            new BlockOccupancy(new Vector3i(2, 10, 4)),
            new BlockOccupancy(new Vector3i(2, 10, 5)),
            new BlockOccupancy(new Vector3i(3, 0, -6)),
            new BlockOccupancy(new Vector3i(3, 0, -5)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 0, 5)),
            new BlockOccupancy(new Vector3i(3, 1, -6)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 5)),
            new BlockOccupancy(new Vector3i(3, 2, -6)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 5)),
            new BlockOccupancy(new Vector3i(3, 3, -6)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 5)),
            new BlockOccupancy(new Vector3i(3, 4, -6)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 4, 2)),
            new BlockOccupancy(new Vector3i(3, 4, 3)),
            new BlockOccupancy(new Vector3i(3, 4, 4)),
            new BlockOccupancy(new Vector3i(3, 4, 5)),
            new BlockOccupancy(new Vector3i(3, 5, -6)),
            new BlockOccupancy(new Vector3i(3, 5, -5)),
            new BlockOccupancy(new Vector3i(3, 5, -4)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 5, 2)),
            new BlockOccupancy(new Vector3i(3, 5, 3)),
            new BlockOccupancy(new Vector3i(3, 5, 4)),
            new BlockOccupancy(new Vector3i(3, 5, 5)),
            new BlockOccupancy(new Vector3i(3, 6, -6)),
            new BlockOccupancy(new Vector3i(3, 6, -5)),
            new BlockOccupancy(new Vector3i(3, 6, -4)),
            new BlockOccupancy(new Vector3i(3, 6, -3)),
            new BlockOccupancy(new Vector3i(3, 6, -2)),
            new BlockOccupancy(new Vector3i(3, 6, -1)),
            new BlockOccupancy(new Vector3i(3, 6, 0)),
            new BlockOccupancy(new Vector3i(3, 6, 1)),
            new BlockOccupancy(new Vector3i(3, 6, 2)),
            new BlockOccupancy(new Vector3i(3, 6, 3)),
            new BlockOccupancy(new Vector3i(3, 6, 4)),
            new BlockOccupancy(new Vector3i(3, 6, 5)),
            new BlockOccupancy(new Vector3i(3, 7, -6)),
            new BlockOccupancy(new Vector3i(3, 7, -5)),
            new BlockOccupancy(new Vector3i(3, 7, -4)),
            new BlockOccupancy(new Vector3i(3, 7, -3)),
            new BlockOccupancy(new Vector3i(3, 7, -2)),
            new BlockOccupancy(new Vector3i(3, 7, -1)),
            new BlockOccupancy(new Vector3i(3, 7, 0)),
            new BlockOccupancy(new Vector3i(3, 7, 1)),
            new BlockOccupancy(new Vector3i(3, 7, 2)),
            new BlockOccupancy(new Vector3i(3, 7, 3)),
            new BlockOccupancy(new Vector3i(3, 7, 4)),
            new BlockOccupancy(new Vector3i(3, 7, 5)),
            new BlockOccupancy(new Vector3i(3, 8, -6)),
            new BlockOccupancy(new Vector3i(3, 8, -5)),
            new BlockOccupancy(new Vector3i(3, 8, -4)),
            new BlockOccupancy(new Vector3i(3, 8, -3)),
            new BlockOccupancy(new Vector3i(3, 8, -2)),
            new BlockOccupancy(new Vector3i(3, 8, -1)),
            new BlockOccupancy(new Vector3i(3, 8, 0)),
            new BlockOccupancy(new Vector3i(3, 8, 1)),
            new BlockOccupancy(new Vector3i(3, 8, 2)),
            new BlockOccupancy(new Vector3i(3, 8, 3)),
            new BlockOccupancy(new Vector3i(3, 8, 4)),
            new BlockOccupancy(new Vector3i(3, 8, 5)),
            new BlockOccupancy(new Vector3i(3, 9, -6)),
            new BlockOccupancy(new Vector3i(3, 9, -5)),
            new BlockOccupancy(new Vector3i(3, 9, -4)),
            new BlockOccupancy(new Vector3i(3, 9, -3)),
            new BlockOccupancy(new Vector3i(3, 9, -2)),
            new BlockOccupancy(new Vector3i(3, 9, -1)),
            new BlockOccupancy(new Vector3i(3, 9, 0)),
            new BlockOccupancy(new Vector3i(3, 9, 1)),
            new BlockOccupancy(new Vector3i(3, 9, 2)),
            new BlockOccupancy(new Vector3i(3, 9, 3)),
            new BlockOccupancy(new Vector3i(3, 9, 4)),
            new BlockOccupancy(new Vector3i(3, 9, 5)),
            new BlockOccupancy(new Vector3i(3, 10, -6)),
            new BlockOccupancy(new Vector3i(3, 10, -5)),
            new BlockOccupancy(new Vector3i(3, 10, -4)),
            new BlockOccupancy(new Vector3i(3, 10, -3)),
            new BlockOccupancy(new Vector3i(3, 10, -2)),
            new BlockOccupancy(new Vector3i(3, 10, -1)),
            new BlockOccupancy(new Vector3i(3, 10, 0)),
            new BlockOccupancy(new Vector3i(3, 10, 1)),
            new BlockOccupancy(new Vector3i(3, 10, 2)),
            new BlockOccupancy(new Vector3i(3, 10, 3)),
            new BlockOccupancy(new Vector3i(3, 10, 4)),
            new BlockOccupancy(new Vector3i(3, 10, 5)),
            new BlockOccupancy(new Vector3i(4, 0, -6)),
            new BlockOccupancy(new Vector3i(4, 0, -5)),
            new BlockOccupancy(new Vector3i(4, 0, -4)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 3)),
            new BlockOccupancy(new Vector3i(4, 0, 4)),
            new BlockOccupancy(new Vector3i(4, 0, 5)),
            new BlockOccupancy(new Vector3i(4, 1, -6)),
            new BlockOccupancy(new Vector3i(4, 1, -5)),
            new BlockOccupancy(new Vector3i(4, 1, -4)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 4)),
            new BlockOccupancy(new Vector3i(4, 1, 5)),
            new BlockOccupancy(new Vector3i(4, 2, -6)),
            new BlockOccupancy(new Vector3i(4, 2, -5)),
            new BlockOccupancy(new Vector3i(4, 2, -4)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 2)),
            new BlockOccupancy(new Vector3i(4, 2, 3)),
            new BlockOccupancy(new Vector3i(4, 2, 4)),
            new BlockOccupancy(new Vector3i(4, 2, 5)),
            new BlockOccupancy(new Vector3i(4, 3, -6)),
            new BlockOccupancy(new Vector3i(4, 3, -5)),
            new BlockOccupancy(new Vector3i(4, 3, -4)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 2)),
            new BlockOccupancy(new Vector3i(4, 3, 3)),
            new BlockOccupancy(new Vector3i(4, 3, 4)),
            new BlockOccupancy(new Vector3i(4, 3, 5)),
            new BlockOccupancy(new Vector3i(4, 4, -6)),
            new BlockOccupancy(new Vector3i(4, 4, -5)),
            new BlockOccupancy(new Vector3i(4, 4, -4)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 4, 1)),
            new BlockOccupancy(new Vector3i(4, 4, 2)),
            new BlockOccupancy(new Vector3i(4, 4, 3)),
            new BlockOccupancy(new Vector3i(4, 4, 4)),
            new BlockOccupancy(new Vector3i(4, 4, 5)),
            new BlockOccupancy(new Vector3i(4, 5, -6)),
            new BlockOccupancy(new Vector3i(4, 5, -5)),
            new BlockOccupancy(new Vector3i(4, 5, -4)),
            new BlockOccupancy(new Vector3i(4, 5, -3)),
            new BlockOccupancy(new Vector3i(4, 5, -2)),
            new BlockOccupancy(new Vector3i(4, 5, -1)),
            new BlockOccupancy(new Vector3i(4, 5, 0)),
            new BlockOccupancy(new Vector3i(4, 5, 1)),
            new BlockOccupancy(new Vector3i(4, 5, 2)),
            new BlockOccupancy(new Vector3i(4, 5, 3)),
            new BlockOccupancy(new Vector3i(4, 5, 4)),
            new BlockOccupancy(new Vector3i(4, 5, 5)),
            new BlockOccupancy(new Vector3i(4, 6, -6)),
            new BlockOccupancy(new Vector3i(4, 6, -5)),
            new BlockOccupancy(new Vector3i(4, 6, -4)),
            new BlockOccupancy(new Vector3i(4, 6, -3)),
            new BlockOccupancy(new Vector3i(4, 6, -2)),
            new BlockOccupancy(new Vector3i(4, 6, -1)),
            new BlockOccupancy(new Vector3i(4, 6, 0)),
            new BlockOccupancy(new Vector3i(4, 6, 1)),
            new BlockOccupancy(new Vector3i(4, 6, 2)),
            new BlockOccupancy(new Vector3i(4, 6, 3)),
            new BlockOccupancy(new Vector3i(4, 6, 4)),
            new BlockOccupancy(new Vector3i(4, 6, 5)),
            new BlockOccupancy(new Vector3i(4, 7, -6)),
            new BlockOccupancy(new Vector3i(4, 7, -5)),
            new BlockOccupancy(new Vector3i(4, 7, -4)),
            new BlockOccupancy(new Vector3i(4, 7, -3)),
            new BlockOccupancy(new Vector3i(4, 7, -2)),
            new BlockOccupancy(new Vector3i(4, 7, -1)),
            new BlockOccupancy(new Vector3i(4, 7, 0)),
            new BlockOccupancy(new Vector3i(4, 7, 1)),
            new BlockOccupancy(new Vector3i(4, 7, 2)),
            new BlockOccupancy(new Vector3i(4, 7, 3)),
            new BlockOccupancy(new Vector3i(4, 7, 4)),
            new BlockOccupancy(new Vector3i(4, 7, 5)),
            new BlockOccupancy(new Vector3i(4, 8, -6)),
            new BlockOccupancy(new Vector3i(4, 8, -5)),
            new BlockOccupancy(new Vector3i(4, 8, -4)),
            new BlockOccupancy(new Vector3i(4, 8, -3)),
            new BlockOccupancy(new Vector3i(4, 8, -2)),
            new BlockOccupancy(new Vector3i(4, 8, -1)),
            new BlockOccupancy(new Vector3i(4, 8, 0)),
            new BlockOccupancy(new Vector3i(4, 8, 1)),
            new BlockOccupancy(new Vector3i(4, 8, 2)),
            new BlockOccupancy(new Vector3i(4, 8, 3)),
            new BlockOccupancy(new Vector3i(4, 8, 4)),
            new BlockOccupancy(new Vector3i(4, 8, 5)),
            new BlockOccupancy(new Vector3i(4, 9, -6)),
            new BlockOccupancy(new Vector3i(4, 9, -5)),
            new BlockOccupancy(new Vector3i(4, 9, -4)),
            new BlockOccupancy(new Vector3i(4, 9, -3)),
            new BlockOccupancy(new Vector3i(4, 9, -2)),
            new BlockOccupancy(new Vector3i(4, 9, -1)),
            new BlockOccupancy(new Vector3i(4, 9, 0)),
            new BlockOccupancy(new Vector3i(4, 9, 1)),
            new BlockOccupancy(new Vector3i(4, 9, 2)),
            new BlockOccupancy(new Vector3i(4, 9, 3)),
            new BlockOccupancy(new Vector3i(4, 9, 4)),
            new BlockOccupancy(new Vector3i(4, 9, 5)),
            new BlockOccupancy(new Vector3i(4, 10, -6)),
            new BlockOccupancy(new Vector3i(4, 10, -5)),
            new BlockOccupancy(new Vector3i(4, 10, -4)),
            new BlockOccupancy(new Vector3i(4, 10, -3)),
            new BlockOccupancy(new Vector3i(4, 10, -2)),
            new BlockOccupancy(new Vector3i(4, 10, -1)),
            new BlockOccupancy(new Vector3i(4, 10, 0)),
            new BlockOccupancy(new Vector3i(4, 10, 1)),
            new BlockOccupancy(new Vector3i(4, 10, 2)),
            new BlockOccupancy(new Vector3i(4, 10, 3)),
            new BlockOccupancy(new Vector3i(4, 10, 4)),
            new BlockOccupancy(new Vector3i(4, 10, 5)),
            new BlockOccupancy(new Vector3i(5, 0, -6)),
            new BlockOccupancy(new Vector3i(5, 0, -5)),
            new BlockOccupancy(new Vector3i(5, 0, -4)),
            new BlockOccupancy(new Vector3i(5, 0, -3)),
            new BlockOccupancy(new Vector3i(5, 0, -2)),
            new BlockOccupancy(new Vector3i(5, 0, -1)),
            new BlockOccupancy(new Vector3i(5, 0, 0)),
            new BlockOccupancy(new Vector3i(5, 0, 1)),
            new BlockOccupancy(new Vector3i(5, 0, 2)),
            new BlockOccupancy(new Vector3i(5, 0, 3)),
            new BlockOccupancy(new Vector3i(5, 0, 4)),
            new BlockOccupancy(new Vector3i(5, 0, 5)),
            new BlockOccupancy(new Vector3i(5, 1, -6)),
            new BlockOccupancy(new Vector3i(5, 1, -5)),
            new BlockOccupancy(new Vector3i(5, 1, -4)),
            new BlockOccupancy(new Vector3i(5, 1, -3)),
            new BlockOccupancy(new Vector3i(5, 1, -2)),
            new BlockOccupancy(new Vector3i(5, 1, -1)),
            new BlockOccupancy(new Vector3i(5, 1, 0)),
            new BlockOccupancy(new Vector3i(5, 1, 1)),
            new BlockOccupancy(new Vector3i(5, 1, 2)),
            new BlockOccupancy(new Vector3i(5, 1, 3)),
            new BlockOccupancy(new Vector3i(5, 1, 4)),
            new BlockOccupancy(new Vector3i(5, 1, 5)),
            new BlockOccupancy(new Vector3i(5, 2, -6)),
            new BlockOccupancy(new Vector3i(5, 2, -5)),
            new BlockOccupancy(new Vector3i(5, 2, -4)),
            new BlockOccupancy(new Vector3i(5, 2, -3)),
            new BlockOccupancy(new Vector3i(5, 2, -2)),
            new BlockOccupancy(new Vector3i(5, 2, -1)),
            new BlockOccupancy(new Vector3i(5, 2, 0)),
            new BlockOccupancy(new Vector3i(5, 2, 1)),
            new BlockOccupancy(new Vector3i(5, 2, 2)),
            new BlockOccupancy(new Vector3i(5, 2, 3)),
            new BlockOccupancy(new Vector3i(5, 2, 4)),
            new BlockOccupancy(new Vector3i(5, 2, 5)),
            new BlockOccupancy(new Vector3i(5, 3, -6)),
            new BlockOccupancy(new Vector3i(5, 3, -5)),
            new BlockOccupancy(new Vector3i(5, 3, -4)),
            new BlockOccupancy(new Vector3i(5, 3, -3)),
            new BlockOccupancy(new Vector3i(5, 3, -2)),
            new BlockOccupancy(new Vector3i(5, 3, -1)),
            new BlockOccupancy(new Vector3i(5, 3, 0)),
            new BlockOccupancy(new Vector3i(5, 3, 1)),
            new BlockOccupancy(new Vector3i(5, 3, 2)),
            new BlockOccupancy(new Vector3i(5, 3, 3)),
            new BlockOccupancy(new Vector3i(5, 3, 4)),
            new BlockOccupancy(new Vector3i(5, 3, 5)),
            new BlockOccupancy(new Vector3i(5, 4, -6)),
            new BlockOccupancy(new Vector3i(5, 4, -5)),
            new BlockOccupancy(new Vector3i(5, 4, -4)),
            new BlockOccupancy(new Vector3i(5, 4, -3)),
            new BlockOccupancy(new Vector3i(5, 4, -2)),
            new BlockOccupancy(new Vector3i(5, 4, -1)),
            new BlockOccupancy(new Vector3i(5, 4, 0)),
            new BlockOccupancy(new Vector3i(5, 4, 1)),
            new BlockOccupancy(new Vector3i(5, 4, 2)),
            new BlockOccupancy(new Vector3i(5, 4, 3)),
            new BlockOccupancy(new Vector3i(5, 4, 4)),
            new BlockOccupancy(new Vector3i(5, 4, 5)),
            new BlockOccupancy(new Vector3i(5, 5, -6)),
            new BlockOccupancy(new Vector3i(5, 5, -5)),
            new BlockOccupancy(new Vector3i(5, 5, -4)),
            new BlockOccupancy(new Vector3i(5, 5, -3)),
            new BlockOccupancy(new Vector3i(5, 5, -2)),
            new BlockOccupancy(new Vector3i(5, 5, -1)),
            new BlockOccupancy(new Vector3i(5, 5, 0)),
            new BlockOccupancy(new Vector3i(5, 5, 1)),
            new BlockOccupancy(new Vector3i(5, 5, 2)),
            new BlockOccupancy(new Vector3i(5, 5, 3)),
            new BlockOccupancy(new Vector3i(5, 5, 4)),
            new BlockOccupancy(new Vector3i(5, 5, 5)),
            new BlockOccupancy(new Vector3i(5, 6, -6)),
            new BlockOccupancy(new Vector3i(5, 6, -5)),
            new BlockOccupancy(new Vector3i(5, 6, -4)),
            new BlockOccupancy(new Vector3i(5, 6, -3)),
            new BlockOccupancy(new Vector3i(5, 6, -2)),
            new BlockOccupancy(new Vector3i(5, 6, -1)),
            new BlockOccupancy(new Vector3i(5, 6, 0)),
            new BlockOccupancy(new Vector3i(5, 6, 1)),
            new BlockOccupancy(new Vector3i(5, 6, 2)),
            new BlockOccupancy(new Vector3i(5, 6, 3)),
            new BlockOccupancy(new Vector3i(5, 6, 4)),
            new BlockOccupancy(new Vector3i(5, 6, 5)),
            new BlockOccupancy(new Vector3i(5, 7, -6)),
            new BlockOccupancy(new Vector3i(5, 7, -5)),
            new BlockOccupancy(new Vector3i(5, 7, -4)),
            new BlockOccupancy(new Vector3i(5, 7, -3)),
            new BlockOccupancy(new Vector3i(5, 7, -2)),
            new BlockOccupancy(new Vector3i(5, 7, -1)),
            new BlockOccupancy(new Vector3i(5, 7, 0)),
            new BlockOccupancy(new Vector3i(5, 7, 1)),
            new BlockOccupancy(new Vector3i(5, 7, 2)),
            new BlockOccupancy(new Vector3i(5, 7, 3)),
            new BlockOccupancy(new Vector3i(5, 7, 4)),
            new BlockOccupancy(new Vector3i(5, 7, 5)),
            new BlockOccupancy(new Vector3i(5, 8, -6)),
            new BlockOccupancy(new Vector3i(5, 8, -5)),
            new BlockOccupancy(new Vector3i(5, 8, -4)),
            new BlockOccupancy(new Vector3i(5, 8, -3)),
            new BlockOccupancy(new Vector3i(5, 8, -2)),
            new BlockOccupancy(new Vector3i(5, 8, -1)),
            new BlockOccupancy(new Vector3i(5, 8, 0)),
            new BlockOccupancy(new Vector3i(5, 8, 1)),
            new BlockOccupancy(new Vector3i(5, 8, 2)),
            new BlockOccupancy(new Vector3i(5, 8, 3)),
            new BlockOccupancy(new Vector3i(5, 8, 4)),
            new BlockOccupancy(new Vector3i(5, 8, 5)),
            new BlockOccupancy(new Vector3i(5, 9, -6)),
            new BlockOccupancy(new Vector3i(5, 9, -5)),
            new BlockOccupancy(new Vector3i(5, 9, -4)),
            new BlockOccupancy(new Vector3i(5, 9, -3)),
            new BlockOccupancy(new Vector3i(5, 9, -2)),
            new BlockOccupancy(new Vector3i(5, 9, -1)),
            new BlockOccupancy(new Vector3i(5, 9, 0)),
            new BlockOccupancy(new Vector3i(5, 9, 1)),
            new BlockOccupancy(new Vector3i(5, 9, 2)),
            new BlockOccupancy(new Vector3i(5, 9, 3)),
            new BlockOccupancy(new Vector3i(5, 9, 4)),
            new BlockOccupancy(new Vector3i(5, 9, 5)),
            new BlockOccupancy(new Vector3i(5, 10, -6)),
            new BlockOccupancy(new Vector3i(5, 10, -5)),
            new BlockOccupancy(new Vector3i(5, 10, -4)),
            new BlockOccupancy(new Vector3i(5, 10, -3)),
            new BlockOccupancy(new Vector3i(5, 10, -2)),
            new BlockOccupancy(new Vector3i(5, 10, -1)),
            new BlockOccupancy(new Vector3i(5, 10, 0)),
            new BlockOccupancy(new Vector3i(5, 10, 1)),
            new BlockOccupancy(new Vector3i(5, 10, 2)),
            new BlockOccupancy(new Vector3i(5, 10, 3)),
            new BlockOccupancy(new Vector3i(5, 10, 4)),
            new BlockOccupancy(new Vector3i(5, 10, 5)),
            });
            // LumberStockpileObject
            WorldObject.AddOccupancy<LumberStockpileObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-5, 0, -5)),
            new BlockOccupancy(new Vector3i(-5, 0, -4)),
            new BlockOccupancy(new Vector3i(-5, 0, -3)),
            new BlockOccupancy(new Vector3i(-5, 0, -2)),
            new BlockOccupancy(new Vector3i(-5, 0, -1)),
            new BlockOccupancy(new Vector3i(-5, 0, 0)),
            new BlockOccupancy(new Vector3i(-5, 0, 1)),
            new BlockOccupancy(new Vector3i(-5, 0, 2)),
            new BlockOccupancy(new Vector3i(-5, 0, 3)),
            new BlockOccupancy(new Vector3i(-5, 0, 4)),
            new BlockOccupancy(new Vector3i(-5, 1, -5)),
            new BlockOccupancy(new Vector3i(-5, 1, -4)),
            new BlockOccupancy(new Vector3i(-5, 1, -3)),
            new BlockOccupancy(new Vector3i(-5, 1, -2)),
            new BlockOccupancy(new Vector3i(-5, 1, -1)),
            new BlockOccupancy(new Vector3i(-5, 1, 0)),
            new BlockOccupancy(new Vector3i(-5, 1, 1)),
            new BlockOccupancy(new Vector3i(-5, 1, 2)),
            new BlockOccupancy(new Vector3i(-5, 1, 3)),
            new BlockOccupancy(new Vector3i(-5, 1, 4)),
            new BlockOccupancy(new Vector3i(-5, 2, -5)),
            new BlockOccupancy(new Vector3i(-5, 2, -4)),
            new BlockOccupancy(new Vector3i(-5, 2, -3)),
            new BlockOccupancy(new Vector3i(-5, 2, -2)),
            new BlockOccupancy(new Vector3i(-5, 2, -1)),
            new BlockOccupancy(new Vector3i(-5, 2, 0)),
            new BlockOccupancy(new Vector3i(-5, 2, 1)),
            new BlockOccupancy(new Vector3i(-5, 2, 2)),
            new BlockOccupancy(new Vector3i(-5, 2, 3)),
            new BlockOccupancy(new Vector3i(-5, 2, 4)),
            new BlockOccupancy(new Vector3i(-5, 3, -5)),
            new BlockOccupancy(new Vector3i(-5, 3, -4)),
            new BlockOccupancy(new Vector3i(-5, 3, -3)),
            new BlockOccupancy(new Vector3i(-5, 3, -2)),
            new BlockOccupancy(new Vector3i(-5, 3, -1)),
            new BlockOccupancy(new Vector3i(-5, 3, 0)),
            new BlockOccupancy(new Vector3i(-5, 3, 1)),
            new BlockOccupancy(new Vector3i(-5, 3, 2)),
            new BlockOccupancy(new Vector3i(-5, 3, 3)),
            new BlockOccupancy(new Vector3i(-5, 3, 4)),
            new BlockOccupancy(new Vector3i(-5, 4, -5)),
            new BlockOccupancy(new Vector3i(-5, 4, -4)),
            new BlockOccupancy(new Vector3i(-5, 4, -3)),
            new BlockOccupancy(new Vector3i(-5, 4, -2)),
            new BlockOccupancy(new Vector3i(-5, 4, -1)),
            new BlockOccupancy(new Vector3i(-5, 4, 0)),
            new BlockOccupancy(new Vector3i(-5, 4, 1)),
            new BlockOccupancy(new Vector3i(-5, 4, 2)),
            new BlockOccupancy(new Vector3i(-5, 4, 3)),
            new BlockOccupancy(new Vector3i(-5, 4, 4)),
            new BlockOccupancy(new Vector3i(-5, 5, -5)),
            new BlockOccupancy(new Vector3i(-5, 5, -4)),
            new BlockOccupancy(new Vector3i(-5, 5, -3)),
            new BlockOccupancy(new Vector3i(-5, 5, -2)),
            new BlockOccupancy(new Vector3i(-5, 5, -1)),
            new BlockOccupancy(new Vector3i(-5, 5, 0)),
            new BlockOccupancy(new Vector3i(-5, 5, 1)),
            new BlockOccupancy(new Vector3i(-5, 5, 2)),
            new BlockOccupancy(new Vector3i(-5, 5, 3)),
            new BlockOccupancy(new Vector3i(-5, 5, 4)),
            new BlockOccupancy(new Vector3i(-5, 6, -5)),
            new BlockOccupancy(new Vector3i(-5, 6, -4)),
            new BlockOccupancy(new Vector3i(-5, 6, -3)),
            new BlockOccupancy(new Vector3i(-5, 6, -2)),
            new BlockOccupancy(new Vector3i(-5, 6, -1)),
            new BlockOccupancy(new Vector3i(-5, 6, 0)),
            new BlockOccupancy(new Vector3i(-5, 6, 1)),
            new BlockOccupancy(new Vector3i(-5, 6, 2)),
            new BlockOccupancy(new Vector3i(-5, 6, 3)),
            new BlockOccupancy(new Vector3i(-5, 6, 4)),
            new BlockOccupancy(new Vector3i(-5, 7, -5)),
            new BlockOccupancy(new Vector3i(-5, 7, -4)),
            new BlockOccupancy(new Vector3i(-5, 7, -3)),
            new BlockOccupancy(new Vector3i(-5, 7, -2)),
            new BlockOccupancy(new Vector3i(-5, 7, -1)),
            new BlockOccupancy(new Vector3i(-5, 7, 0)),
            new BlockOccupancy(new Vector3i(-5, 7, 1)),
            new BlockOccupancy(new Vector3i(-5, 7, 2)),
            new BlockOccupancy(new Vector3i(-5, 7, 3)),
            new BlockOccupancy(new Vector3i(-5, 7, 4)),
            new BlockOccupancy(new Vector3i(-5, 8, -5)),
            new BlockOccupancy(new Vector3i(-5, 8, -4)),
            new BlockOccupancy(new Vector3i(-5, 8, -3)),
            new BlockOccupancy(new Vector3i(-5, 8, -2)),
            new BlockOccupancy(new Vector3i(-5, 8, -1)),
            new BlockOccupancy(new Vector3i(-5, 8, 0)),
            new BlockOccupancy(new Vector3i(-5, 8, 1)),
            new BlockOccupancy(new Vector3i(-5, 8, 2)),
            new BlockOccupancy(new Vector3i(-5, 8, 3)),
            new BlockOccupancy(new Vector3i(-5, 8, 4)),
            new BlockOccupancy(new Vector3i(-4, 0, -5)),
            new BlockOccupancy(new Vector3i(-4, 0, -4)),
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 1)),
            new BlockOccupancy(new Vector3i(-4, 0, 2)),
            new BlockOccupancy(new Vector3i(-4, 0, 3)),
            new BlockOccupancy(new Vector3i(-4, 0, 4)),
            new BlockOccupancy(new Vector3i(-4, 1, -5)),
            new BlockOccupancy(new Vector3i(-4, 1, -4)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, 1)),
            new BlockOccupancy(new Vector3i(-4, 1, 2)),
            new BlockOccupancy(new Vector3i(-4, 1, 3)),
            new BlockOccupancy(new Vector3i(-4, 1, 4)),
            new BlockOccupancy(new Vector3i(-4, 2, -5)),
            new BlockOccupancy(new Vector3i(-4, 2, -4)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, 1)),
            new BlockOccupancy(new Vector3i(-4, 2, 2)),
            new BlockOccupancy(new Vector3i(-4, 2, 3)),
            new BlockOccupancy(new Vector3i(-4, 2, 4)),
            new BlockOccupancy(new Vector3i(-4, 3, -5)),
            new BlockOccupancy(new Vector3i(-4, 3, -4)),
            new BlockOccupancy(new Vector3i(-4, 3, -3)),
            new BlockOccupancy(new Vector3i(-4, 3, -2)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, 1)),
            new BlockOccupancy(new Vector3i(-4, 3, 2)),
            new BlockOccupancy(new Vector3i(-4, 3, 3)),
            new BlockOccupancy(new Vector3i(-4, 3, 4)),
            new BlockOccupancy(new Vector3i(-4, 4, -5)),
            new BlockOccupancy(new Vector3i(-4, 4, -4)),
            new BlockOccupancy(new Vector3i(-4, 4, -3)),
            new BlockOccupancy(new Vector3i(-4, 4, -2)),
            new BlockOccupancy(new Vector3i(-4, 4, -1)),
            new BlockOccupancy(new Vector3i(-4, 4, 0)),
            new BlockOccupancy(new Vector3i(-4, 4, 1)),
            new BlockOccupancy(new Vector3i(-4, 4, 2)),
            new BlockOccupancy(new Vector3i(-4, 4, 3)),
            new BlockOccupancy(new Vector3i(-4, 4, 4)),
            new BlockOccupancy(new Vector3i(-4, 5, -5)),
            new BlockOccupancy(new Vector3i(-4, 5, -4)),
            new BlockOccupancy(new Vector3i(-4, 5, -3)),
            new BlockOccupancy(new Vector3i(-4, 5, -2)),
            new BlockOccupancy(new Vector3i(-4, 5, -1)),
            new BlockOccupancy(new Vector3i(-4, 5, 0)),
            new BlockOccupancy(new Vector3i(-4, 5, 1)),
            new BlockOccupancy(new Vector3i(-4, 5, 2)),
            new BlockOccupancy(new Vector3i(-4, 5, 3)),
            new BlockOccupancy(new Vector3i(-4, 5, 4)),
            new BlockOccupancy(new Vector3i(-4, 6, -5)),
            new BlockOccupancy(new Vector3i(-4, 6, -4)),
            new BlockOccupancy(new Vector3i(-4, 6, -3)),
            new BlockOccupancy(new Vector3i(-4, 6, -2)),
            new BlockOccupancy(new Vector3i(-4, 6, -1)),
            new BlockOccupancy(new Vector3i(-4, 6, 0)),
            new BlockOccupancy(new Vector3i(-4, 6, 1)),
            new BlockOccupancy(new Vector3i(-4, 6, 2)),
            new BlockOccupancy(new Vector3i(-4, 6, 3)),
            new BlockOccupancy(new Vector3i(-4, 6, 4)),
            new BlockOccupancy(new Vector3i(-4, 7, -5)),
            new BlockOccupancy(new Vector3i(-4, 7, -4)),
            new BlockOccupancy(new Vector3i(-4, 7, -3)),
            new BlockOccupancy(new Vector3i(-4, 7, -2)),
            new BlockOccupancy(new Vector3i(-4, 7, -1)),
            new BlockOccupancy(new Vector3i(-4, 7, 0)),
            new BlockOccupancy(new Vector3i(-4, 7, 1)),
            new BlockOccupancy(new Vector3i(-4, 7, 2)),
            new BlockOccupancy(new Vector3i(-4, 7, 3)),
            new BlockOccupancy(new Vector3i(-4, 7, 4)),
            new BlockOccupancy(new Vector3i(-4, 8, -5)),
            new BlockOccupancy(new Vector3i(-4, 8, -4)),
            new BlockOccupancy(new Vector3i(-4, 8, -3)),
            new BlockOccupancy(new Vector3i(-4, 8, -2)),
            new BlockOccupancy(new Vector3i(-4, 8, -1)),
            new BlockOccupancy(new Vector3i(-4, 8, 0)),
            new BlockOccupancy(new Vector3i(-4, 8, 1)),
            new BlockOccupancy(new Vector3i(-4, 8, 2)),
            new BlockOccupancy(new Vector3i(-4, 8, 3)),
            new BlockOccupancy(new Vector3i(-4, 8, 4)),
            new BlockOccupancy(new Vector3i(-3, 0, -5)),
            new BlockOccupancy(new Vector3i(-3, 0, -4)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, 2)),
            new BlockOccupancy(new Vector3i(-3, 0, 3)),
            new BlockOccupancy(new Vector3i(-3, 0, 4)),
            new BlockOccupancy(new Vector3i(-3, 1, -5)),
            new BlockOccupancy(new Vector3i(-3, 1, -4)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 2)),
            new BlockOccupancy(new Vector3i(-3, 1, 3)),
            new BlockOccupancy(new Vector3i(-3, 1, 4)),
            new BlockOccupancy(new Vector3i(-3, 2, -5)),
            new BlockOccupancy(new Vector3i(-3, 2, -4)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, 2)),
            new BlockOccupancy(new Vector3i(-3, 2, 3)),
            new BlockOccupancy(new Vector3i(-3, 2, 4)),
            new BlockOccupancy(new Vector3i(-3, 3, -5)),
            new BlockOccupancy(new Vector3i(-3, 3, -4)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, 2)),
            new BlockOccupancy(new Vector3i(-3, 3, 3)),
            new BlockOccupancy(new Vector3i(-3, 3, 4)),
            new BlockOccupancy(new Vector3i(-3, 4, -5)),
            new BlockOccupancy(new Vector3i(-3, 4, -4)),
            new BlockOccupancy(new Vector3i(-3, 4, -3)),
            new BlockOccupancy(new Vector3i(-3, 4, -2)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, 1)),
            new BlockOccupancy(new Vector3i(-3, 4, 2)),
            new BlockOccupancy(new Vector3i(-3, 4, 3)),
            new BlockOccupancy(new Vector3i(-3, 4, 4)),
            new BlockOccupancy(new Vector3i(-3, 5, -5)),
            new BlockOccupancy(new Vector3i(-3, 5, -4)),
            new BlockOccupancy(new Vector3i(-3, 5, -3)),
            new BlockOccupancy(new Vector3i(-3, 5, -2)),
            new BlockOccupancy(new Vector3i(-3, 5, -1)),
            new BlockOccupancy(new Vector3i(-3, 5, 0)),
            new BlockOccupancy(new Vector3i(-3, 5, 1)),
            new BlockOccupancy(new Vector3i(-3, 5, 2)),
            new BlockOccupancy(new Vector3i(-3, 5, 3)),
            new BlockOccupancy(new Vector3i(-3, 5, 4)),
            new BlockOccupancy(new Vector3i(-3, 6, -5)),
            new BlockOccupancy(new Vector3i(-3, 6, -4)),
            new BlockOccupancy(new Vector3i(-3, 6, -3)),
            new BlockOccupancy(new Vector3i(-3, 6, -2)),
            new BlockOccupancy(new Vector3i(-3, 6, -1)),
            new BlockOccupancy(new Vector3i(-3, 6, 0)),
            new BlockOccupancy(new Vector3i(-3, 6, 1)),
            new BlockOccupancy(new Vector3i(-3, 6, 2)),
            new BlockOccupancy(new Vector3i(-3, 6, 3)),
            new BlockOccupancy(new Vector3i(-3, 6, 4)),
            new BlockOccupancy(new Vector3i(-3, 7, -5)),
            new BlockOccupancy(new Vector3i(-3, 7, -4)),
            new BlockOccupancy(new Vector3i(-3, 7, -3)),
            new BlockOccupancy(new Vector3i(-3, 7, -2)),
            new BlockOccupancy(new Vector3i(-3, 7, -1)),
            new BlockOccupancy(new Vector3i(-3, 7, 0)),
            new BlockOccupancy(new Vector3i(-3, 7, 1)),
            new BlockOccupancy(new Vector3i(-3, 7, 2)),
            new BlockOccupancy(new Vector3i(-3, 7, 3)),
            new BlockOccupancy(new Vector3i(-3, 7, 4)),
            new BlockOccupancy(new Vector3i(-3, 8, -5)),
            new BlockOccupancy(new Vector3i(-3, 8, -4)),
            new BlockOccupancy(new Vector3i(-3, 8, -3)),
            new BlockOccupancy(new Vector3i(-3, 8, -2)),
            new BlockOccupancy(new Vector3i(-3, 8, -1)),
            new BlockOccupancy(new Vector3i(-3, 8, 0)),
            new BlockOccupancy(new Vector3i(-3, 8, 1)),
            new BlockOccupancy(new Vector3i(-3, 8, 2)),
            new BlockOccupancy(new Vector3i(-3, 8, 3)),
            new BlockOccupancy(new Vector3i(-3, 8, 4)),
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 0, 3)),
            new BlockOccupancy(new Vector3i(-2, 0, 4)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 1, 4)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, 4)),
            new BlockOccupancy(new Vector3i(-2, 3, -5)),
            new BlockOccupancy(new Vector3i(-2, 3, -4)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, 3)),
            new BlockOccupancy(new Vector3i(-2, 3, 4)),
            new BlockOccupancy(new Vector3i(-2, 4, -5)),
            new BlockOccupancy(new Vector3i(-2, 4, -4)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, 2)),
            new BlockOccupancy(new Vector3i(-2, 4, 3)),
            new BlockOccupancy(new Vector3i(-2, 4, 4)),
            new BlockOccupancy(new Vector3i(-2, 5, -5)),
            new BlockOccupancy(new Vector3i(-2, 5, -4)),
            new BlockOccupancy(new Vector3i(-2, 5, -3)),
            new BlockOccupancy(new Vector3i(-2, 5, -2)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, 2)),
            new BlockOccupancy(new Vector3i(-2, 5, 3)),
            new BlockOccupancy(new Vector3i(-2, 5, 4)),
            new BlockOccupancy(new Vector3i(-2, 6, -5)),
            new BlockOccupancy(new Vector3i(-2, 6, -4)),
            new BlockOccupancy(new Vector3i(-2, 6, -3)),
            new BlockOccupancy(new Vector3i(-2, 6, -2)),
            new BlockOccupancy(new Vector3i(-2, 6, -1)),
            new BlockOccupancy(new Vector3i(-2, 6, 0)),
            new BlockOccupancy(new Vector3i(-2, 6, 1)),
            new BlockOccupancy(new Vector3i(-2, 6, 2)),
            new BlockOccupancy(new Vector3i(-2, 6, 3)),
            new BlockOccupancy(new Vector3i(-2, 6, 4)),
            new BlockOccupancy(new Vector3i(-2, 7, -5)),
            new BlockOccupancy(new Vector3i(-2, 7, -4)),
            new BlockOccupancy(new Vector3i(-2, 7, -3)),
            new BlockOccupancy(new Vector3i(-2, 7, -2)),
            new BlockOccupancy(new Vector3i(-2, 7, -1)),
            new BlockOccupancy(new Vector3i(-2, 7, 0)),
            new BlockOccupancy(new Vector3i(-2, 7, 1)),
            new BlockOccupancy(new Vector3i(-2, 7, 2)),
            new BlockOccupancy(new Vector3i(-2, 7, 3)),
            new BlockOccupancy(new Vector3i(-2, 7, 4)),
            new BlockOccupancy(new Vector3i(-2, 8, -5)),
            new BlockOccupancy(new Vector3i(-2, 8, -4)),
            new BlockOccupancy(new Vector3i(-2, 8, -3)),
            new BlockOccupancy(new Vector3i(-2, 8, -2)),
            new BlockOccupancy(new Vector3i(-2, 8, -1)),
            new BlockOccupancy(new Vector3i(-2, 8, 0)),
            new BlockOccupancy(new Vector3i(-2, 8, 1)),
            new BlockOccupancy(new Vector3i(-2, 8, 2)),
            new BlockOccupancy(new Vector3i(-2, 8, 3)),
            new BlockOccupancy(new Vector3i(-2, 8, 4)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 4)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 4)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 4)),
            new BlockOccupancy(new Vector3i(-1, 3, -5)),
            new BlockOccupancy(new Vector3i(-1, 3, -4)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 4)),
            new BlockOccupancy(new Vector3i(-1, 4, -5)),
            new BlockOccupancy(new Vector3i(-1, 4, -4)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, 2)),
            new BlockOccupancy(new Vector3i(-1, 4, 3)),
            new BlockOccupancy(new Vector3i(-1, 4, 4)),
            new BlockOccupancy(new Vector3i(-1, 5, -5)),
            new BlockOccupancy(new Vector3i(-1, 5, -4)),
            new BlockOccupancy(new Vector3i(-1, 5, -3)),
            new BlockOccupancy(new Vector3i(-1, 5, -2)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, 2)),
            new BlockOccupancy(new Vector3i(-1, 5, 3)),
            new BlockOccupancy(new Vector3i(-1, 5, 4)),
            new BlockOccupancy(new Vector3i(-1, 6, -5)),
            new BlockOccupancy(new Vector3i(-1, 6, -4)),
            new BlockOccupancy(new Vector3i(-1, 6, -3)),
            new BlockOccupancy(new Vector3i(-1, 6, -2)),
            new BlockOccupancy(new Vector3i(-1, 6, -1)),
            new BlockOccupancy(new Vector3i(-1, 6, 0)),
            new BlockOccupancy(new Vector3i(-1, 6, 1)),
            new BlockOccupancy(new Vector3i(-1, 6, 2)),
            new BlockOccupancy(new Vector3i(-1, 6, 3)),
            new BlockOccupancy(new Vector3i(-1, 6, 4)),
            new BlockOccupancy(new Vector3i(-1, 7, -5)),
            new BlockOccupancy(new Vector3i(-1, 7, -4)),
            new BlockOccupancy(new Vector3i(-1, 7, -3)),
            new BlockOccupancy(new Vector3i(-1, 7, -2)),
            new BlockOccupancy(new Vector3i(-1, 7, -1)),
            new BlockOccupancy(new Vector3i(-1, 7, 0)),
            new BlockOccupancy(new Vector3i(-1, 7, 1)),
            new BlockOccupancy(new Vector3i(-1, 7, 2)),
            new BlockOccupancy(new Vector3i(-1, 7, 3)),
            new BlockOccupancy(new Vector3i(-1, 7, 4)),
            new BlockOccupancy(new Vector3i(-1, 8, -5)),
            new BlockOccupancy(new Vector3i(-1, 8, -4)),
            new BlockOccupancy(new Vector3i(-1, 8, -3)),
            new BlockOccupancy(new Vector3i(-1, 8, -2)),
            new BlockOccupancy(new Vector3i(-1, 8, -1)),
            new BlockOccupancy(new Vector3i(-1, 8, 0)),
            new BlockOccupancy(new Vector3i(-1, 8, 1)),
            new BlockOccupancy(new Vector3i(-1, 8, 2)),
            new BlockOccupancy(new Vector3i(-1, 8, 3)),
            new BlockOccupancy(new Vector3i(-1, 8, 4)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 5, -5)),
            new BlockOccupancy(new Vector3i(0, 5, -4)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 6, -5)),
            new BlockOccupancy(new Vector3i(0, 6, -4)),
            new BlockOccupancy(new Vector3i(0, 6, -3)),
            new BlockOccupancy(new Vector3i(0, 6, -2)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 6, 3)),
            new BlockOccupancy(new Vector3i(0, 6, 4)),
            new BlockOccupancy(new Vector3i(0, 7, -5)),
            new BlockOccupancy(new Vector3i(0, 7, -4)),
            new BlockOccupancy(new Vector3i(0, 7, -3)),
            new BlockOccupancy(new Vector3i(0, 7, -2)),
            new BlockOccupancy(new Vector3i(0, 7, -1)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 7, 2)),
            new BlockOccupancy(new Vector3i(0, 7, 3)),
            new BlockOccupancy(new Vector3i(0, 7, 4)),
            new BlockOccupancy(new Vector3i(0, 8, -5)),
            new BlockOccupancy(new Vector3i(0, 8, -4)),
            new BlockOccupancy(new Vector3i(0, 8, -3)),
            new BlockOccupancy(new Vector3i(0, 8, -2)),
            new BlockOccupancy(new Vector3i(0, 8, -1)),
            new BlockOccupancy(new Vector3i(0, 8, 0)),
            new BlockOccupancy(new Vector3i(0, 8, 1)),
            new BlockOccupancy(new Vector3i(0, 8, 2)),
            new BlockOccupancy(new Vector3i(0, 8, 3)),
            new BlockOccupancy(new Vector3i(0, 8, 4)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 3)),
            new BlockOccupancy(new Vector3i(1, 4, 4)),
            new BlockOccupancy(new Vector3i(1, 5, -5)),
            new BlockOccupancy(new Vector3i(1, 5, -4)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 5, 2)),
            new BlockOccupancy(new Vector3i(1, 5, 3)),
            new BlockOccupancy(new Vector3i(1, 5, 4)),
            new BlockOccupancy(new Vector3i(1, 6, -5)),
            new BlockOccupancy(new Vector3i(1, 6, -4)),
            new BlockOccupancy(new Vector3i(1, 6, -3)),
            new BlockOccupancy(new Vector3i(1, 6, -2)),
            new BlockOccupancy(new Vector3i(1, 6, -1)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 6, 1)),
            new BlockOccupancy(new Vector3i(1, 6, 2)),
            new BlockOccupancy(new Vector3i(1, 6, 3)),
            new BlockOccupancy(new Vector3i(1, 6, 4)),
            new BlockOccupancy(new Vector3i(1, 7, -5)),
            new BlockOccupancy(new Vector3i(1, 7, -4)),
            new BlockOccupancy(new Vector3i(1, 7, -3)),
            new BlockOccupancy(new Vector3i(1, 7, -2)),
            new BlockOccupancy(new Vector3i(1, 7, -1)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 7, 1)),
            new BlockOccupancy(new Vector3i(1, 7, 2)),
            new BlockOccupancy(new Vector3i(1, 7, 3)),
            new BlockOccupancy(new Vector3i(1, 7, 4)),
            new BlockOccupancy(new Vector3i(1, 8, -5)),
            new BlockOccupancy(new Vector3i(1, 8, -4)),
            new BlockOccupancy(new Vector3i(1, 8, -3)),
            new BlockOccupancy(new Vector3i(1, 8, -2)),
            new BlockOccupancy(new Vector3i(1, 8, -1)),
            new BlockOccupancy(new Vector3i(1, 8, 0)),
            new BlockOccupancy(new Vector3i(1, 8, 1)),
            new BlockOccupancy(new Vector3i(1, 8, 2)),
            new BlockOccupancy(new Vector3i(1, 8, 3)),
            new BlockOccupancy(new Vector3i(1, 8, 4)),
            new BlockOccupancy(new Vector3i(2, 0, -5)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 3)),
            new BlockOccupancy(new Vector3i(2, 4, 4)),
            new BlockOccupancy(new Vector3i(2, 5, -5)),
            new BlockOccupancy(new Vector3i(2, 5, -4)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 5, 2)),
            new BlockOccupancy(new Vector3i(2, 5, 3)),
            new BlockOccupancy(new Vector3i(2, 5, 4)),
            new BlockOccupancy(new Vector3i(2, 6, -5)),
            new BlockOccupancy(new Vector3i(2, 6, -4)),
            new BlockOccupancy(new Vector3i(2, 6, -3)),
            new BlockOccupancy(new Vector3i(2, 6, -2)),
            new BlockOccupancy(new Vector3i(2, 6, -1)),
            new BlockOccupancy(new Vector3i(2, 6, 0)),
            new BlockOccupancy(new Vector3i(2, 6, 1)),
            new BlockOccupancy(new Vector3i(2, 6, 2)),
            new BlockOccupancy(new Vector3i(2, 6, 3)),
            new BlockOccupancy(new Vector3i(2, 6, 4)),
            new BlockOccupancy(new Vector3i(2, 7, -5)),
            new BlockOccupancy(new Vector3i(2, 7, -4)),
            new BlockOccupancy(new Vector3i(2, 7, -3)),
            new BlockOccupancy(new Vector3i(2, 7, -2)),
            new BlockOccupancy(new Vector3i(2, 7, -1)),
            new BlockOccupancy(new Vector3i(2, 7, 0)),
            new BlockOccupancy(new Vector3i(2, 7, 1)),
            new BlockOccupancy(new Vector3i(2, 7, 2)),
            new BlockOccupancy(new Vector3i(2, 7, 3)),
            new BlockOccupancy(new Vector3i(2, 7, 4)),
            new BlockOccupancy(new Vector3i(2, 8, -5)),
            new BlockOccupancy(new Vector3i(2, 8, -4)),
            new BlockOccupancy(new Vector3i(2, 8, -3)),
            new BlockOccupancy(new Vector3i(2, 8, -2)),
            new BlockOccupancy(new Vector3i(2, 8, -1)),
            new BlockOccupancy(new Vector3i(2, 8, 0)),
            new BlockOccupancy(new Vector3i(2, 8, 1)),
            new BlockOccupancy(new Vector3i(2, 8, 2)),
            new BlockOccupancy(new Vector3i(2, 8, 3)),
            new BlockOccupancy(new Vector3i(2, 8, 4)),
            new BlockOccupancy(new Vector3i(3, 0, -5)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 4, 2)),
            new BlockOccupancy(new Vector3i(3, 4, 3)),
            new BlockOccupancy(new Vector3i(3, 4, 4)),
            new BlockOccupancy(new Vector3i(3, 5, -5)),
            new BlockOccupancy(new Vector3i(3, 5, -4)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 5, 2)),
            new BlockOccupancy(new Vector3i(3, 5, 3)),
            new BlockOccupancy(new Vector3i(3, 5, 4)),
            new BlockOccupancy(new Vector3i(3, 6, -5)),
            new BlockOccupancy(new Vector3i(3, 6, -4)),
            new BlockOccupancy(new Vector3i(3, 6, -3)),
            new BlockOccupancy(new Vector3i(3, 6, -2)),
            new BlockOccupancy(new Vector3i(3, 6, -1)),
            new BlockOccupancy(new Vector3i(3, 6, 0)),
            new BlockOccupancy(new Vector3i(3, 6, 1)),
            new BlockOccupancy(new Vector3i(3, 6, 2)),
            new BlockOccupancy(new Vector3i(3, 6, 3)),
            new BlockOccupancy(new Vector3i(3, 6, 4)),
            new BlockOccupancy(new Vector3i(3, 7, -5)),
            new BlockOccupancy(new Vector3i(3, 7, -4)),
            new BlockOccupancy(new Vector3i(3, 7, -3)),
            new BlockOccupancy(new Vector3i(3, 7, -2)),
            new BlockOccupancy(new Vector3i(3, 7, -1)),
            new BlockOccupancy(new Vector3i(3, 7, 0)),
            new BlockOccupancy(new Vector3i(3, 7, 1)),
            new BlockOccupancy(new Vector3i(3, 7, 2)),
            new BlockOccupancy(new Vector3i(3, 7, 3)),
            new BlockOccupancy(new Vector3i(3, 7, 4)),
            new BlockOccupancy(new Vector3i(3, 8, -5)),
            new BlockOccupancy(new Vector3i(3, 8, -4)),
            new BlockOccupancy(new Vector3i(3, 8, -3)),
            new BlockOccupancy(new Vector3i(3, 8, -2)),
            new BlockOccupancy(new Vector3i(3, 8, -1)),
            new BlockOccupancy(new Vector3i(3, 8, 0)),
            new BlockOccupancy(new Vector3i(3, 8, 1)),
            new BlockOccupancy(new Vector3i(3, 8, 2)),
            new BlockOccupancy(new Vector3i(3, 8, 3)),
            new BlockOccupancy(new Vector3i(3, 8, 4)),
            new BlockOccupancy(new Vector3i(4, 0, -5)),
            new BlockOccupancy(new Vector3i(4, 0, -4)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 3)),
            new BlockOccupancy(new Vector3i(4, 0, 4)),
            new BlockOccupancy(new Vector3i(4, 1, -5)),
            new BlockOccupancy(new Vector3i(4, 1, -4)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 4)),
            new BlockOccupancy(new Vector3i(4, 2, -5)),
            new BlockOccupancy(new Vector3i(4, 2, -4)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 2)),
            new BlockOccupancy(new Vector3i(4, 2, 3)),
            new BlockOccupancy(new Vector3i(4, 2, 4)),
            new BlockOccupancy(new Vector3i(4, 3, -5)),
            new BlockOccupancy(new Vector3i(4, 3, -4)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 2)),
            new BlockOccupancy(new Vector3i(4, 3, 3)),
            new BlockOccupancy(new Vector3i(4, 3, 4)),
            new BlockOccupancy(new Vector3i(4, 4, -5)),
            new BlockOccupancy(new Vector3i(4, 4, -4)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 4, 1)),
            new BlockOccupancy(new Vector3i(4, 4, 2)),
            new BlockOccupancy(new Vector3i(4, 4, 3)),
            new BlockOccupancy(new Vector3i(4, 4, 4)),
            new BlockOccupancy(new Vector3i(4, 5, -5)),
            new BlockOccupancy(new Vector3i(4, 5, -4)),
            new BlockOccupancy(new Vector3i(4, 5, -3)),
            new BlockOccupancy(new Vector3i(4, 5, -2)),
            new BlockOccupancy(new Vector3i(4, 5, -1)),
            new BlockOccupancy(new Vector3i(4, 5, 0)),
            new BlockOccupancy(new Vector3i(4, 5, 1)),
            new BlockOccupancy(new Vector3i(4, 5, 2)),
            new BlockOccupancy(new Vector3i(4, 5, 3)),
            new BlockOccupancy(new Vector3i(4, 5, 4)),
            new BlockOccupancy(new Vector3i(4, 6, -5)),
            new BlockOccupancy(new Vector3i(4, 6, -4)),
            new BlockOccupancy(new Vector3i(4, 6, -3)),
            new BlockOccupancy(new Vector3i(4, 6, -2)),
            new BlockOccupancy(new Vector3i(4, 6, -1)),
            new BlockOccupancy(new Vector3i(4, 6, 0)),
            new BlockOccupancy(new Vector3i(4, 6, 1)),
            new BlockOccupancy(new Vector3i(4, 6, 2)),
            new BlockOccupancy(new Vector3i(4, 6, 3)),
            new BlockOccupancy(new Vector3i(4, 6, 4)),
            new BlockOccupancy(new Vector3i(4, 7, -5)),
            new BlockOccupancy(new Vector3i(4, 7, -4)),
            new BlockOccupancy(new Vector3i(4, 7, -3)),
            new BlockOccupancy(new Vector3i(4, 7, -2)),
            new BlockOccupancy(new Vector3i(4, 7, -1)),
            new BlockOccupancy(new Vector3i(4, 7, 0)),
            new BlockOccupancy(new Vector3i(4, 7, 1)),
            new BlockOccupancy(new Vector3i(4, 7, 2)),
            new BlockOccupancy(new Vector3i(4, 7, 3)),
            new BlockOccupancy(new Vector3i(4, 7, 4)),
            new BlockOccupancy(new Vector3i(4, 8, -5)),
            new BlockOccupancy(new Vector3i(4, 8, -4)),
            new BlockOccupancy(new Vector3i(4, 8, -3)),
            new BlockOccupancy(new Vector3i(4, 8, -2)),
            new BlockOccupancy(new Vector3i(4, 8, -1)),
            new BlockOccupancy(new Vector3i(4, 8, 0)),
            new BlockOccupancy(new Vector3i(4, 8, 1)),
            new BlockOccupancy(new Vector3i(4, 8, 2)),
            new BlockOccupancy(new Vector3i(4, 8, 3)),
            new BlockOccupancy(new Vector3i(4, 8, 4)),
            });
            // AshlarGneissDoorObject
            WorldObject.AddOccupancy<AshlarGneissDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // AshlarBasaltDoorObject
            WorldObject.AddOccupancy<AshlarBasaltDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // MortaredStoneDoorObject
            WorldObject.AddOccupancy<MortaredStoneDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // AshlarGraniteDoorObject
            WorldObject.AddOccupancy<AshlarGraniteDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // AshlarLimestoneDoorObject
            WorldObject.AddOccupancy<AshlarLimestoneDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // AshlarSandstoneDoorObject
            WorldObject.AddOccupancy<AshlarSandstoneDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // AshlarShaleDoorObject
            WorldObject.AddOccupancy<AshlarShaleDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // AshlarStoneDoorObject
            WorldObject.AddOccupancy<AshlarStoneDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // LargeStandingAshlarStoneSignObject
            WorldObject.AddOccupancy<LargeStandingAshlarStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingAshlarGneissSignObject
            WorldObject.AddOccupancy<LargeStandingAshlarGneissSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingAshlarLimestoneSignObject
            WorldObject.AddOccupancy<LargeStandingAshlarLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingAshlarShaleSignObject
            WorldObject.AddOccupancy<LargeStandingAshlarShaleSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingAshlarSandstoneSignObject
            WorldObject.AddOccupancy<LargeStandingAshlarSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingAshlarBasaltSignObject
            WorldObject.AddOccupancy<LargeStandingAshlarBasaltSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingAshlarGraniteSignObject
            WorldObject.AddOccupancy<LargeStandingAshlarGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingAshlarGraniteSignObject
            WorldObject.AddOccupancy<LargeHangingAshlarGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallStandingAshlarGraniteSignObject
            WorldObject.AddOccupancy<SmallStandingAshlarGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingAshlarGraniteSignObject
            WorldObject.AddOccupancy<SmallHangingAshlarGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingAshlarBasaltSignObject
            WorldObject.AddOccupancy<SmallStandingAshlarBasaltSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingAshlarBasaltSignObject
            WorldObject.AddOccupancy<LargeHangingAshlarBasaltSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingAshlarBasaltSignObject
            WorldObject.AddOccupancy<SmallHangingAshlarBasaltSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingAshlarSandstoneSignObject
            WorldObject.AddOccupancy<SmallStandingAshlarSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingAshlarSandstoneSignObject
            WorldObject.AddOccupancy<SmallHangingAshlarSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingAshlarSandstoneSignObject
            WorldObject.AddOccupancy<LargeHangingAshlarSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallStandingAshlarShaleSignObject
            WorldObject.AddOccupancy<SmallStandingAshlarShaleSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingAshlarShaleSignObject
            WorldObject.AddOccupancy<SmallHangingAshlarShaleSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingAshlarShaleSignObject
            WorldObject.AddOccupancy<LargeHangingAshlarShaleSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingAshlarLimestoneSignObject
            WorldObject.AddOccupancy<LargeHangingAshlarLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallStandingAshlarLimestoneSignObject
            WorldObject.AddOccupancy<SmallStandingAshlarLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingAshlarLimestoneSignObject
            WorldObject.AddOccupancy<SmallHangingAshlarLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingAshlarGneissSignObject
            WorldObject.AddOccupancy<LargeHangingAshlarGneissSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallStandingAshlarGneissSignObject
            WorldObject.AddOccupancy<SmallStandingAshlarGneissSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingAshlarGneissSignObject
            WorldObject.AddOccupancy<SmallHangingAshlarGneissSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingAshlarStoneSignObject
            WorldObject.AddOccupancy<SmallStandingAshlarStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingAshlarStoneSignObject
            WorldObject.AddOccupancy<SmallHangingAshlarStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
        }

        public static void InitializePart4()
        {
            // LargeHangingAshlarStoneSignObject
            WorldObject.AddOccupancy<LargeHangingAshlarStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdvancedMasonryTableObject
            WorldObject.AddOccupancy<AdvancedMasonryTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdvancedCarpentryTableObject
            WorldObject.AddOccupancy<AdvancedCarpentryTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            });
            // LimestoneBisonStatueObject
            WorldObject.AddOccupancy<LimestoneBisonStatueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // LimestoneOtterStatueObject
            WorldObject.AddOccupancy<LimestoneOtterStatueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LimestoneOwlStatueObject
            WorldObject.AddOccupancy<LimestoneOwlStatueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LimestoneWolfStatueObject
            WorldObject.AddOccupancy<LimestoneWolfStatueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WoodenCeilingLightObject
            WorldObject.AddOccupancy<WoodenCeilingLightObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WoodenFloorLampObject
            WorldObject.AddOccupancy<WoodenFloorLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WoodenTableLampObject
            WorldObject.AddOccupancy<WoodenTableLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingMortaredLimestoneSignObject
            WorldObject.AddOccupancy<SmallHangingMortaredLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingMortaredLimestoneSignObject
            WorldObject.AddOccupancy<SmallStandingMortaredLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingMortaredStoneSignObject
            WorldObject.AddOccupancy<SmallStandingMortaredStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingMortaredStoneSignObject
            WorldObject.AddOccupancy<SmallHangingMortaredStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // StuffedBisonObject
            WorldObject.AddOccupancy<StuffedBisonObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // StuffedWolfObject
            WorldObject.AddOccupancy<StuffedWolfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StuffedJaguarObject
            WorldObject.AddOccupancy<StuffedJaguarObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StuffedGoatObject
            WorldObject.AddOccupancy<StuffedGoatObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StuffedAlligatorObject
            WorldObject.AddOccupancy<StuffedAlligatorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingMortaredSandstoneSignObject
            WorldObject.AddOccupancy<SmallHangingMortaredSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingMortaredSandstoneSignObject
            WorldObject.AddOccupancy<SmallStandingMortaredSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallStandingMortaredGraniteSignObject
            WorldObject.AddOccupancy<SmallStandingMortaredGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallHangingMortaredGraniteSignObject
            WorldObject.AddOccupancy<SmallHangingMortaredGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeStandingMortaredGraniteSignObject
            WorldObject.AddOccupancy<LargeStandingMortaredGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingMortaredGraniteSignObject
            WorldObject.AddOccupancy<LargeHangingMortaredGraniteSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingMortaredSandstoneSignObject
            WorldObject.AddOccupancy<LargeHangingMortaredSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingMortaredSandstoneSignObject
            WorldObject.AddOccupancy<LargeStandingMortaredSandstoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StreetSignObject
            WorldObject.AddOccupancy<StreetSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // StopSignObject
            WorldObject.AddOccupancy<StopSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // ModernDoubleStreetLightObject
            WorldObject.AddOccupancy<ModernDoubleStreetLightObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 6, -2)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            });
            // ModernStreetLightObject
            WorldObject.AddOccupancy<ModernStreetLightObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            });
            // SmallSinkObject
            WorldObject.AddOccupancy<SmallSinkObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // ToiletObject
            WorldObject.AddOccupancy<ToiletObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // BathtubObject
            WorldObject.AddOccupancy<BathtubObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // LargeStandingMortaredStoneSignObject
            WorldObject.AddOccupancy<LargeStandingMortaredStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingMortaredStoneSignObject
            WorldObject.AddOccupancy<LargeHangingMortaredStoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingMortaredLimestoneSignObject
            WorldObject.AddOccupancy<LargeStandingMortaredLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeHangingMortaredLimestoneSignObject
            WorldObject.AddOccupancy<LargeHangingMortaredLimestoneSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // FlatSteelDoorObject
            WorldObject.AddOccupancy<FlatSteelDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // HewnSoftwoodDoorObject
            WorldObject.AddOccupancy<HewnSoftwoodDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // HewnHardwoodDoorObject
            WorldObject.AddOccupancy<HewnHardwoodDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // MortaredGraniteDoorObject
            WorldObject.AddOccupancy<MortaredGraniteDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // MortaredSandstoneDoorObject
            WorldObject.AddOccupancy<MortaredSandstoneDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // MortaredLimestoneDoorObject
            WorldObject.AddOccupancy<MortaredLimestoneDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CorrugatedSteelFenceDoorObject
            WorldObject.AddOccupancy<CorrugatedSteelFenceDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CorrugatedSteelDoorObject
            WorldObject.AddOccupancy<CorrugatedSteelDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // IndustrialElevatorObject
            WorldObject.AddOccupancy<IndustrialElevatorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -11)),
            new BlockOccupancy(new Vector3i(0, 0, -10)),
            new BlockOccupancy(new Vector3i(0, 0, -9)),
            new BlockOccupancy(new Vector3i(0, 0, -8)),
            new BlockOccupancy(new Vector3i(0, 0, -7)),
            new BlockOccupancy(new Vector3i(0, 0, -6)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -11)),
            new BlockOccupancy(new Vector3i(0, 1, -10)),
            new BlockOccupancy(new Vector3i(0, 1, -9)),
            new BlockOccupancy(new Vector3i(0, 1, -8)),
            new BlockOccupancy(new Vector3i(0, 1, -7)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -11)),
            new BlockOccupancy(new Vector3i(0, 2, -10)),
            new BlockOccupancy(new Vector3i(0, 2, -9)),
            new BlockOccupancy(new Vector3i(0, 2, -8)),
            new BlockOccupancy(new Vector3i(0, 2, -7)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -11)),
            new BlockOccupancy(new Vector3i(0, 3, -10)),
            new BlockOccupancy(new Vector3i(0, 3, -9)),
            new BlockOccupancy(new Vector3i(0, 3, -8)),
            new BlockOccupancy(new Vector3i(0, 3, -7)),
            new BlockOccupancy(new Vector3i(0, 3, -6)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, -11)),
            new BlockOccupancy(new Vector3i(0, 4, -10)),
            new BlockOccupancy(new Vector3i(0, 4, -9)),
            new BlockOccupancy(new Vector3i(0, 4, -8)),
            new BlockOccupancy(new Vector3i(0, 4, -7)),
            new BlockOccupancy(new Vector3i(0, 4, -6)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 5, -11)),
            new BlockOccupancy(new Vector3i(0, 5, -10)),
            new BlockOccupancy(new Vector3i(0, 5, -9)),
            new BlockOccupancy(new Vector3i(0, 5, -8)),
            new BlockOccupancy(new Vector3i(0, 5, -7)),
            new BlockOccupancy(new Vector3i(0, 5, -6)),
            new BlockOccupancy(new Vector3i(0, 5, -5)),
            new BlockOccupancy(new Vector3i(0, 5, -4)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -11)),
            new BlockOccupancy(new Vector3i(1, 0, -10)),
            new BlockOccupancy(new Vector3i(1, 0, -9)),
            new BlockOccupancy(new Vector3i(1, 0, -8)),
            new BlockOccupancy(new Vector3i(1, 0, -7)),
            new BlockOccupancy(new Vector3i(1, 0, -6)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -11)),
            new BlockOccupancy(new Vector3i(1, 1, -10)),
            new BlockOccupancy(new Vector3i(1, 1, -9)),
            new BlockOccupancy(new Vector3i(1, 1, -8)),
            new BlockOccupancy(new Vector3i(1, 1, -7)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -11)),
            new BlockOccupancy(new Vector3i(1, 2, -10)),
            new BlockOccupancy(new Vector3i(1, 2, -9)),
            new BlockOccupancy(new Vector3i(1, 2, -8)),
            new BlockOccupancy(new Vector3i(1, 2, -7)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 3, -11)),
            new BlockOccupancy(new Vector3i(1, 3, -10)),
            new BlockOccupancy(new Vector3i(1, 3, -9)),
            new BlockOccupancy(new Vector3i(1, 3, -8)),
            new BlockOccupancy(new Vector3i(1, 3, -7)),
            new BlockOccupancy(new Vector3i(1, 3, -6)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 4, -11)),
            new BlockOccupancy(new Vector3i(1, 4, -10)),
            new BlockOccupancy(new Vector3i(1, 4, -9)),
            new BlockOccupancy(new Vector3i(1, 4, -8)),
            new BlockOccupancy(new Vector3i(1, 4, -7)),
            new BlockOccupancy(new Vector3i(1, 4, -6)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 5, -11)),
            new BlockOccupancy(new Vector3i(1, 5, -10)),
            new BlockOccupancy(new Vector3i(1, 5, -9)),
            new BlockOccupancy(new Vector3i(1, 5, -8)),
            new BlockOccupancy(new Vector3i(1, 5, -7)),
            new BlockOccupancy(new Vector3i(1, 5, -6)),
            new BlockOccupancy(new Vector3i(1, 5, -5)),
            new BlockOccupancy(new Vector3i(1, 5, -4)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -11)),
            new BlockOccupancy(new Vector3i(2, 0, -10)),
            new BlockOccupancy(new Vector3i(2, 0, -9)),
            new BlockOccupancy(new Vector3i(2, 0, -8)),
            new BlockOccupancy(new Vector3i(2, 0, -7)),
            new BlockOccupancy(new Vector3i(2, 0, -6)),
            new BlockOccupancy(new Vector3i(2, 0, -5)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -11)),
            new BlockOccupancy(new Vector3i(2, 1, -10)),
            new BlockOccupancy(new Vector3i(2, 1, -9)),
            new BlockOccupancy(new Vector3i(2, 1, -8)),
            new BlockOccupancy(new Vector3i(2, 1, -7)),
            new BlockOccupancy(new Vector3i(2, 1, -6)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -11)),
            new BlockOccupancy(new Vector3i(2, 2, -10)),
            new BlockOccupancy(new Vector3i(2, 2, -9)),
            new BlockOccupancy(new Vector3i(2, 2, -8)),
            new BlockOccupancy(new Vector3i(2, 2, -7)),
            new BlockOccupancy(new Vector3i(2, 2, -6)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 3, -11)),
            new BlockOccupancy(new Vector3i(2, 3, -10)),
            new BlockOccupancy(new Vector3i(2, 3, -9)),
            new BlockOccupancy(new Vector3i(2, 3, -8)),
            new BlockOccupancy(new Vector3i(2, 3, -7)),
            new BlockOccupancy(new Vector3i(2, 3, -6)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 4, -11)),
            new BlockOccupancy(new Vector3i(2, 4, -10)),
            new BlockOccupancy(new Vector3i(2, 4, -9)),
            new BlockOccupancy(new Vector3i(2, 4, -8)),
            new BlockOccupancy(new Vector3i(2, 4, -7)),
            new BlockOccupancy(new Vector3i(2, 4, -6)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 5, -11)),
            new BlockOccupancy(new Vector3i(2, 5, -10)),
            new BlockOccupancy(new Vector3i(2, 5, -9)),
            new BlockOccupancy(new Vector3i(2, 5, -8)),
            new BlockOccupancy(new Vector3i(2, 5, -7)),
            new BlockOccupancy(new Vector3i(2, 5, -6)),
            new BlockOccupancy(new Vector3i(2, 5, -5)),
            new BlockOccupancy(new Vector3i(2, 5, -4)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -11)),
            new BlockOccupancy(new Vector3i(3, 0, -10)),
            new BlockOccupancy(new Vector3i(3, 0, -9)),
            new BlockOccupancy(new Vector3i(3, 0, -8)),
            new BlockOccupancy(new Vector3i(3, 0, -7)),
            new BlockOccupancy(new Vector3i(3, 0, -6)),
            new BlockOccupancy(new Vector3i(3, 0, -5)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -11)),
            new BlockOccupancy(new Vector3i(3, 1, -10)),
            new BlockOccupancy(new Vector3i(3, 1, -9)),
            new BlockOccupancy(new Vector3i(3, 1, -8)),
            new BlockOccupancy(new Vector3i(3, 1, -7)),
            new BlockOccupancy(new Vector3i(3, 1, -6)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -11)),
            new BlockOccupancy(new Vector3i(3, 2, -10)),
            new BlockOccupancy(new Vector3i(3, 2, -9)),
            new BlockOccupancy(new Vector3i(3, 2, -8)),
            new BlockOccupancy(new Vector3i(3, 2, -7)),
            new BlockOccupancy(new Vector3i(3, 2, -6)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 3, -11)),
            new BlockOccupancy(new Vector3i(3, 3, -10)),
            new BlockOccupancy(new Vector3i(3, 3, -9)),
            new BlockOccupancy(new Vector3i(3, 3, -8)),
            new BlockOccupancy(new Vector3i(3, 3, -7)),
            new BlockOccupancy(new Vector3i(3, 3, -6)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 4, -11)),
            new BlockOccupancy(new Vector3i(3, 4, -10)),
            new BlockOccupancy(new Vector3i(3, 4, -9)),
            new BlockOccupancy(new Vector3i(3, 4, -8)),
            new BlockOccupancy(new Vector3i(3, 4, -7)),
            new BlockOccupancy(new Vector3i(3, 4, -6)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 5, -11)),
            new BlockOccupancy(new Vector3i(3, 5, -10)),
            new BlockOccupancy(new Vector3i(3, 5, -9)),
            new BlockOccupancy(new Vector3i(3, 5, -8)),
            new BlockOccupancy(new Vector3i(3, 5, -7)),
            new BlockOccupancy(new Vector3i(3, 5, -6)),
            new BlockOccupancy(new Vector3i(3, 5, -5)),
            new BlockOccupancy(new Vector3i(3, 5, -4)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(4, 0, -11)),
            new BlockOccupancy(new Vector3i(4, 0, -10)),
            new BlockOccupancy(new Vector3i(4, 0, -9)),
            new BlockOccupancy(new Vector3i(4, 0, -8)),
            new BlockOccupancy(new Vector3i(4, 0, -7)),
            new BlockOccupancy(new Vector3i(4, 0, -6)),
            new BlockOccupancy(new Vector3i(4, 0, -5)),
            new BlockOccupancy(new Vector3i(4, 0, -4)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 1, -11)),
            new BlockOccupancy(new Vector3i(4, 1, -10)),
            new BlockOccupancy(new Vector3i(4, 1, -9)),
            new BlockOccupancy(new Vector3i(4, 1, -8)),
            new BlockOccupancy(new Vector3i(4, 1, -7)),
            new BlockOccupancy(new Vector3i(4, 1, -6)),
            new BlockOccupancy(new Vector3i(4, 1, -5)),
            new BlockOccupancy(new Vector3i(4, 1, -4)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 2, -11)),
            new BlockOccupancy(new Vector3i(4, 2, -10)),
            new BlockOccupancy(new Vector3i(4, 2, -9)),
            new BlockOccupancy(new Vector3i(4, 2, -8)),
            new BlockOccupancy(new Vector3i(4, 2, -7)),
            new BlockOccupancy(new Vector3i(4, 2, -6)),
            new BlockOccupancy(new Vector3i(4, 2, -5)),
            new BlockOccupancy(new Vector3i(4, 2, -4)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 3, -11)),
            new BlockOccupancy(new Vector3i(4, 3, -10)),
            new BlockOccupancy(new Vector3i(4, 3, -9)),
            new BlockOccupancy(new Vector3i(4, 3, -8)),
            new BlockOccupancy(new Vector3i(4, 3, -7)),
            new BlockOccupancy(new Vector3i(4, 3, -6)),
            new BlockOccupancy(new Vector3i(4, 3, -5)),
            new BlockOccupancy(new Vector3i(4, 3, -4)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 4, -11)),
            new BlockOccupancy(new Vector3i(4, 4, -10)),
            new BlockOccupancy(new Vector3i(4, 4, -9)),
            new BlockOccupancy(new Vector3i(4, 4, -8)),
            new BlockOccupancy(new Vector3i(4, 4, -7)),
            new BlockOccupancy(new Vector3i(4, 4, -6)),
            new BlockOccupancy(new Vector3i(4, 4, -5)),
            new BlockOccupancy(new Vector3i(4, 4, -4)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 5, -11)),
            new BlockOccupancy(new Vector3i(4, 5, -10)),
            new BlockOccupancy(new Vector3i(4, 5, -9)),
            new BlockOccupancy(new Vector3i(4, 5, -8)),
            new BlockOccupancy(new Vector3i(4, 5, -7)),
            new BlockOccupancy(new Vector3i(4, 5, -6)),
            new BlockOccupancy(new Vector3i(4, 5, -5)),
            new BlockOccupancy(new Vector3i(4, 5, -4)),
            new BlockOccupancy(new Vector3i(4, 5, -3)),
            new BlockOccupancy(new Vector3i(4, 5, -2)),
            new BlockOccupancy(new Vector3i(4, 5, -1)),
            new BlockOccupancy(new Vector3i(4, 5, 0)),
            new BlockOccupancy(new Vector3i(5, 0, -11)),
            new BlockOccupancy(new Vector3i(5, 0, -10)),
            new BlockOccupancy(new Vector3i(5, 0, -9)),
            new BlockOccupancy(new Vector3i(5, 0, -8)),
            new BlockOccupancy(new Vector3i(5, 0, -7)),
            new BlockOccupancy(new Vector3i(5, 0, -6)),
            new BlockOccupancy(new Vector3i(5, 0, -5)),
            new BlockOccupancy(new Vector3i(5, 0, -4)),
            new BlockOccupancy(new Vector3i(5, 0, -3)),
            new BlockOccupancy(new Vector3i(5, 0, -2)),
            new BlockOccupancy(new Vector3i(5, 0, -1)),
            new BlockOccupancy(new Vector3i(5, 0, 0)),
            new BlockOccupancy(new Vector3i(5, 1, -11)),
            new BlockOccupancy(new Vector3i(5, 1, -10)),
            new BlockOccupancy(new Vector3i(5, 1, -9)),
            new BlockOccupancy(new Vector3i(5, 1, -8)),
            new BlockOccupancy(new Vector3i(5, 1, -7)),
            new BlockOccupancy(new Vector3i(5, 1, -6)),
            new BlockOccupancy(new Vector3i(5, 1, -5)),
            new BlockOccupancy(new Vector3i(5, 1, -4)),
            new BlockOccupancy(new Vector3i(5, 1, -3)),
            new BlockOccupancy(new Vector3i(5, 1, -2)),
            new BlockOccupancy(new Vector3i(5, 1, -1)),
            new BlockOccupancy(new Vector3i(5, 1, 0)),
            new BlockOccupancy(new Vector3i(5, 2, -11)),
            new BlockOccupancy(new Vector3i(5, 2, -10)),
            new BlockOccupancy(new Vector3i(5, 2, -9)),
            new BlockOccupancy(new Vector3i(5, 2, -8)),
            new BlockOccupancy(new Vector3i(5, 2, -7)),
            new BlockOccupancy(new Vector3i(5, 2, -6)),
            new BlockOccupancy(new Vector3i(5, 2, -5)),
            new BlockOccupancy(new Vector3i(5, 2, -4)),
            new BlockOccupancy(new Vector3i(5, 2, -3)),
            new BlockOccupancy(new Vector3i(5, 2, -2)),
            new BlockOccupancy(new Vector3i(5, 2, -1)),
            new BlockOccupancy(new Vector3i(5, 2, 0)),
            new BlockOccupancy(new Vector3i(5, 3, -11)),
            new BlockOccupancy(new Vector3i(5, 3, -10)),
            new BlockOccupancy(new Vector3i(5, 3, -9)),
            new BlockOccupancy(new Vector3i(5, 3, -8)),
            new BlockOccupancy(new Vector3i(5, 3, -7)),
            new BlockOccupancy(new Vector3i(5, 3, -6)),
            new BlockOccupancy(new Vector3i(5, 3, -5)),
            new BlockOccupancy(new Vector3i(5, 3, -4)),
            new BlockOccupancy(new Vector3i(5, 3, -3)),
            new BlockOccupancy(new Vector3i(5, 3, -2)),
            new BlockOccupancy(new Vector3i(5, 3, -1)),
            new BlockOccupancy(new Vector3i(5, 3, 0)),
            new BlockOccupancy(new Vector3i(5, 4, -11)),
            new BlockOccupancy(new Vector3i(5, 4, -10)),
            new BlockOccupancy(new Vector3i(5, 4, -9)),
            new BlockOccupancy(new Vector3i(5, 4, -8)),
            new BlockOccupancy(new Vector3i(5, 4, -7)),
            new BlockOccupancy(new Vector3i(5, 4, -6)),
            new BlockOccupancy(new Vector3i(5, 4, -5)),
            new BlockOccupancy(new Vector3i(5, 4, -4)),
            new BlockOccupancy(new Vector3i(5, 4, -3)),
            new BlockOccupancy(new Vector3i(5, 4, -2)),
            new BlockOccupancy(new Vector3i(5, 4, -1)),
            new BlockOccupancy(new Vector3i(5, 4, 0)),
            new BlockOccupancy(new Vector3i(5, 5, -11)),
            new BlockOccupancy(new Vector3i(5, 5, -10)),
            new BlockOccupancy(new Vector3i(5, 5, -9)),
            new BlockOccupancy(new Vector3i(5, 5, -8)),
            new BlockOccupancy(new Vector3i(5, 5, -7)),
            new BlockOccupancy(new Vector3i(5, 5, -6)),
            new BlockOccupancy(new Vector3i(5, 5, -5)),
            new BlockOccupancy(new Vector3i(5, 5, -4)),
            new BlockOccupancy(new Vector3i(5, 5, -3)),
            new BlockOccupancy(new Vector3i(5, 5, -2)),
            new BlockOccupancy(new Vector3i(5, 5, -1)),
            new BlockOccupancy(new Vector3i(5, 5, 0)),
            new BlockOccupancy(new Vector3i(6, 0, -11)),
            new BlockOccupancy(new Vector3i(6, 0, -10)),
            new BlockOccupancy(new Vector3i(6, 0, -9)),
            new BlockOccupancy(new Vector3i(6, 0, -8)),
            new BlockOccupancy(new Vector3i(6, 0, -7)),
            new BlockOccupancy(new Vector3i(6, 0, -6)),
            new BlockOccupancy(new Vector3i(6, 0, -5)),
            new BlockOccupancy(new Vector3i(6, 0, -4)),
            new BlockOccupancy(new Vector3i(6, 0, -3)),
            new BlockOccupancy(new Vector3i(6, 0, -2)),
            new BlockOccupancy(new Vector3i(6, 0, -1)),
            new BlockOccupancy(new Vector3i(6, 0, 0)),
            new BlockOccupancy(new Vector3i(6, 1, -11)),
            new BlockOccupancy(new Vector3i(6, 1, -10)),
            new BlockOccupancy(new Vector3i(6, 1, -9)),
            new BlockOccupancy(new Vector3i(6, 1, -8)),
            new BlockOccupancy(new Vector3i(6, 1, -7)),
            new BlockOccupancy(new Vector3i(6, 1, -6)),
            new BlockOccupancy(new Vector3i(6, 1, -5)),
            new BlockOccupancy(new Vector3i(6, 1, -4)),
            new BlockOccupancy(new Vector3i(6, 1, -3)),
            new BlockOccupancy(new Vector3i(6, 1, -2)),
            new BlockOccupancy(new Vector3i(6, 1, -1)),
            new BlockOccupancy(new Vector3i(6, 1, 0)),
            new BlockOccupancy(new Vector3i(6, 2, -11)),
            new BlockOccupancy(new Vector3i(6, 2, -10)),
            new BlockOccupancy(new Vector3i(6, 2, -9)),
            new BlockOccupancy(new Vector3i(6, 2, -8)),
            new BlockOccupancy(new Vector3i(6, 2, -7)),
            new BlockOccupancy(new Vector3i(6, 2, -6)),
            new BlockOccupancy(new Vector3i(6, 2, -5)),
            new BlockOccupancy(new Vector3i(6, 2, -4)),
            new BlockOccupancy(new Vector3i(6, 2, -3)),
            new BlockOccupancy(new Vector3i(6, 2, -2)),
            new BlockOccupancy(new Vector3i(6, 2, -1)),
            new BlockOccupancy(new Vector3i(6, 2, 0)),
            new BlockOccupancy(new Vector3i(6, 3, -11)),
            new BlockOccupancy(new Vector3i(6, 3, -10)),
            new BlockOccupancy(new Vector3i(6, 3, -9)),
            new BlockOccupancy(new Vector3i(6, 3, -8)),
            new BlockOccupancy(new Vector3i(6, 3, -7)),
            new BlockOccupancy(new Vector3i(6, 3, -6)),
            new BlockOccupancy(new Vector3i(6, 3, -5)),
            new BlockOccupancy(new Vector3i(6, 3, -4)),
            new BlockOccupancy(new Vector3i(6, 3, -3)),
            new BlockOccupancy(new Vector3i(6, 3, -2)),
            new BlockOccupancy(new Vector3i(6, 3, -1)),
            new BlockOccupancy(new Vector3i(6, 3, 0)),
            new BlockOccupancy(new Vector3i(6, 4, -11)),
            new BlockOccupancy(new Vector3i(6, 4, -10)),
            new BlockOccupancy(new Vector3i(6, 4, -9)),
            new BlockOccupancy(new Vector3i(6, 4, -8)),
            new BlockOccupancy(new Vector3i(6, 4, -7)),
            new BlockOccupancy(new Vector3i(6, 4, -6)),
            new BlockOccupancy(new Vector3i(6, 4, -5)),
            new BlockOccupancy(new Vector3i(6, 4, -4)),
            new BlockOccupancy(new Vector3i(6, 4, -3)),
            new BlockOccupancy(new Vector3i(6, 4, -2)),
            new BlockOccupancy(new Vector3i(6, 4, -1)),
            new BlockOccupancy(new Vector3i(6, 4, 0)),
            new BlockOccupancy(new Vector3i(6, 5, -11)),
            new BlockOccupancy(new Vector3i(6, 5, -10)),
            new BlockOccupancy(new Vector3i(6, 5, -9)),
            new BlockOccupancy(new Vector3i(6, 5, -8)),
            new BlockOccupancy(new Vector3i(6, 5, -7)),
            new BlockOccupancy(new Vector3i(6, 5, -6)),
            new BlockOccupancy(new Vector3i(6, 5, -5)),
            new BlockOccupancy(new Vector3i(6, 5, -4)),
            new BlockOccupancy(new Vector3i(6, 5, -3)),
            new BlockOccupancy(new Vector3i(6, 5, -2)),
            new BlockOccupancy(new Vector3i(6, 5, -1)),
            new BlockOccupancy(new Vector3i(6, 5, 0)),
            new BlockOccupancy(new Vector3i(7, 0, -11)),
            new BlockOccupancy(new Vector3i(7, 0, -10)),
            new BlockOccupancy(new Vector3i(7, 0, -9)),
            new BlockOccupancy(new Vector3i(7, 0, -8)),
            new BlockOccupancy(new Vector3i(7, 0, -7)),
            new BlockOccupancy(new Vector3i(7, 0, -6)),
            new BlockOccupancy(new Vector3i(7, 0, -5)),
            new BlockOccupancy(new Vector3i(7, 0, -4)),
            new BlockOccupancy(new Vector3i(7, 0, -3)),
            new BlockOccupancy(new Vector3i(7, 0, -2)),
            new BlockOccupancy(new Vector3i(7, 0, -1)),
            new BlockOccupancy(new Vector3i(7, 0, 0)),
            new BlockOccupancy(new Vector3i(7, 1, -11)),
            new BlockOccupancy(new Vector3i(7, 1, -10)),
            new BlockOccupancy(new Vector3i(7, 1, -9)),
            new BlockOccupancy(new Vector3i(7, 1, -8)),
            new BlockOccupancy(new Vector3i(7, 1, -7)),
            new BlockOccupancy(new Vector3i(7, 1, -6)),
            new BlockOccupancy(new Vector3i(7, 1, -5)),
            new BlockOccupancy(new Vector3i(7, 1, -4)),
            new BlockOccupancy(new Vector3i(7, 1, -3)),
            new BlockOccupancy(new Vector3i(7, 1, -2)),
            new BlockOccupancy(new Vector3i(7, 1, -1)),
            new BlockOccupancy(new Vector3i(7, 1, 0)),
            new BlockOccupancy(new Vector3i(7, 2, -11)),
            new BlockOccupancy(new Vector3i(7, 2, -10)),
            new BlockOccupancy(new Vector3i(7, 2, -9)),
            new BlockOccupancy(new Vector3i(7, 2, -8)),
            new BlockOccupancy(new Vector3i(7, 2, -7)),
            new BlockOccupancy(new Vector3i(7, 2, -6)),
            new BlockOccupancy(new Vector3i(7, 2, -5)),
            new BlockOccupancy(new Vector3i(7, 2, -4)),
            new BlockOccupancy(new Vector3i(7, 2, -3)),
            new BlockOccupancy(new Vector3i(7, 2, -2)),
            new BlockOccupancy(new Vector3i(7, 2, -1)),
            new BlockOccupancy(new Vector3i(7, 2, 0)),
            new BlockOccupancy(new Vector3i(7, 3, -11)),
            new BlockOccupancy(new Vector3i(7, 3, -10)),
            new BlockOccupancy(new Vector3i(7, 3, -9)),
            new BlockOccupancy(new Vector3i(7, 3, -8)),
            new BlockOccupancy(new Vector3i(7, 3, -7)),
            new BlockOccupancy(new Vector3i(7, 3, -6)),
            new BlockOccupancy(new Vector3i(7, 3, -5)),
            new BlockOccupancy(new Vector3i(7, 3, -4)),
            new BlockOccupancy(new Vector3i(7, 3, -3)),
            new BlockOccupancy(new Vector3i(7, 3, -2)),
            new BlockOccupancy(new Vector3i(7, 3, -1)),
            new BlockOccupancy(new Vector3i(7, 3, 0)),
            new BlockOccupancy(new Vector3i(7, 4, -11)),
            new BlockOccupancy(new Vector3i(7, 4, -10)),
            new BlockOccupancy(new Vector3i(7, 4, -9)),
            new BlockOccupancy(new Vector3i(7, 4, -8)),
            new BlockOccupancy(new Vector3i(7, 4, -7)),
            new BlockOccupancy(new Vector3i(7, 4, -6)),
            new BlockOccupancy(new Vector3i(7, 4, -5)),
            new BlockOccupancy(new Vector3i(7, 4, -4)),
            new BlockOccupancy(new Vector3i(7, 4, -3)),
            new BlockOccupancy(new Vector3i(7, 4, -2)),
            new BlockOccupancy(new Vector3i(7, 4, -1)),
            new BlockOccupancy(new Vector3i(7, 4, 0)),
            new BlockOccupancy(new Vector3i(7, 5, -11)),
            new BlockOccupancy(new Vector3i(7, 5, -10)),
            new BlockOccupancy(new Vector3i(7, 5, -9)),
            new BlockOccupancy(new Vector3i(7, 5, -8)),
            new BlockOccupancy(new Vector3i(7, 5, -7)),
            new BlockOccupancy(new Vector3i(7, 5, -6)),
            new BlockOccupancy(new Vector3i(7, 5, -5)),
            new BlockOccupancy(new Vector3i(7, 5, -4)),
            new BlockOccupancy(new Vector3i(7, 5, -3)),
            new BlockOccupancy(new Vector3i(7, 5, -2)),
            new BlockOccupancy(new Vector3i(7, 5, -1)),
            new BlockOccupancy(new Vector3i(7, 5, 0)), 
            });
        }
        public static void InitializePart5()
        {
            // StorageSiloObject
            WorldObject.AddOccupancy<StorageSiloObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 6, -3)),
            new BlockOccupancy(new Vector3i(0, 6, -2)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 7, -3)),
            new BlockOccupancy(new Vector3i(0, 7, -2)),
            new BlockOccupancy(new Vector3i(0, 7, -1)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 6, -3)),
            new BlockOccupancy(new Vector3i(1, 6, -2)),
            new BlockOccupancy(new Vector3i(1, 6, -1)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 7, -3)),
            new BlockOccupancy(new Vector3i(1, 7, -2)),
            new BlockOccupancy(new Vector3i(1, 7, -1)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 6, -3)),
            new BlockOccupancy(new Vector3i(2, 6, -2)),
            new BlockOccupancy(new Vector3i(2, 6, -1)),
            new BlockOccupancy(new Vector3i(2, 6, 0)),
            new BlockOccupancy(new Vector3i(2, 7, -3)),
            new BlockOccupancy(new Vector3i(2, 7, -2)),
            new BlockOccupancy(new Vector3i(2, 7, -1)),
            new BlockOccupancy(new Vector3i(2, 7, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 6, -3)),
            new BlockOccupancy(new Vector3i(3, 6, -2)),
            new BlockOccupancy(new Vector3i(3, 6, -1)),
            new BlockOccupancy(new Vector3i(3, 6, 0)),
            new BlockOccupancy(new Vector3i(3, 7, -3)),
            new BlockOccupancy(new Vector3i(3, 7, -2)),
            new BlockOccupancy(new Vector3i(3, 7, -1)),
            new BlockOccupancy(new Vector3i(3, 7, 0)),
            });
            // PoweredStorageSiloObject
            WorldObject.AddOccupancy<PoweredStorageSiloObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 6, -3)),
            new BlockOccupancy(new Vector3i(0, 6, -2)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 7, -3)),
            new BlockOccupancy(new Vector3i(0, 7, -2)),
            new BlockOccupancy(new Vector3i(0, 7, -1)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 6, -3)),
            new BlockOccupancy(new Vector3i(1, 6, -2)),
            new BlockOccupancy(new Vector3i(1, 6, -1)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 7, -3)),
            new BlockOccupancy(new Vector3i(1, 7, -2)),
            new BlockOccupancy(new Vector3i(1, 7, -1)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 6, -3)),
            new BlockOccupancy(new Vector3i(2, 6, -2)),
            new BlockOccupancy(new Vector3i(2, 6, -1)),
            new BlockOccupancy(new Vector3i(2, 6, 0)),
            new BlockOccupancy(new Vector3i(2, 7, -3)),
            new BlockOccupancy(new Vector3i(2, 7, -2)),
            new BlockOccupancy(new Vector3i(2, 7, -1)),
            new BlockOccupancy(new Vector3i(2, 7, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 6, -3)),
            new BlockOccupancy(new Vector3i(3, 6, -2)),
            new BlockOccupancy(new Vector3i(3, 6, -1)),
            new BlockOccupancy(new Vector3i(3, 6, 0)),
            new BlockOccupancy(new Vector3i(3, 7, -3)),
            new BlockOccupancy(new Vector3i(3, 7, -2)),
            new BlockOccupancy(new Vector3i(3, 7, -1)),
            new BlockOccupancy(new Vector3i(3, 7, 0)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 5, -3)),
            new BlockOccupancy(new Vector3i(4, 5, -2)),
            new BlockOccupancy(new Vector3i(4, 5, -1)),
            new BlockOccupancy(new Vector3i(4, 5, 0)),
            new BlockOccupancy(new Vector3i(4, 6, -3)),
            new BlockOccupancy(new Vector3i(4, 6, -2)),
            new BlockOccupancy(new Vector3i(4, 6, -1)),
            new BlockOccupancy(new Vector3i(4, 6, 0)),
            new BlockOccupancy(new Vector3i(4, 7, -3)),
            new BlockOccupancy(new Vector3i(4, 7, -2)),
            new BlockOccupancy(new Vector3i(4, 7, -1)),
            new BlockOccupancy(new Vector3i(4, 7, 0)),
            });
            // HangingSteelPlainSignObject
            WorldObject.AddOccupancy<HangingSteelPlainSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HangingSteelMineSignObject
            WorldObject.AddOccupancy<HangingSteelMineSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HangingSteelShopSignObject
            WorldObject.AddOccupancy<HangingSteelShopSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HangingSteelFramedSignObject
            WorldObject.AddOccupancy<HangingSteelFramedSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StandingLongSteelSignObject
            WorldObject.AddOccupancy<StandingLongSteelSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HangingLongSteelSignObject
            WorldObject.AddOccupancy<HangingLongSteelSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StandingSteelBrickSignObject
            WorldObject.AddOccupancy<StandingSteelBrickSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StandingGlassSignObject
            WorldObject.AddOccupancy<StandingGlassSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AutomaticLoomObject
            WorldObject.AddOccupancy<AutomaticLoomObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            });
            // SpinMelterObject
            WorldObject.AddOccupancy<SpinMelterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // AdvancedTailoringTableObject
            WorldObject.AddOccupancy<AdvancedTailoringTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // ElevatorCallPostObject
            WorldObject.AddOccupancy<ElevatorCallPostObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShippingContainerBlueObject
            WorldObject.AddOccupancy<ShippingContainerBlueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            });
            // ShippingContainerGreenObject
            WorldObject.AddOccupancy<ShippingContainerGreenObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            });
            // ShippingContainerRedObject
            WorldObject.AddOccupancy<ShippingContainerRedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            });
            // DumpsterCompostObject
            WorldObject.AddOccupancy<DumpsterCompostObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // DumpsterGarbageObject
            WorldObject.AddOccupancy<DumpsterGarbageObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // DumpsterRecycleObject
            WorldObject.AddOccupancy<DumpsterRecycleObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // LoomObject
            WorldObject.AddOccupancy<LoomObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // LimestonePodiumObject
            WorldObject.AddOccupancy<LimestonePodiumObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SteelPodiumObject
            WorldObject.AddOccupancy<SteelPodiumObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SteelRowSeatingObject
            WorldObject.AddOccupancy<SteelRowSeatingObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            });
            // BlackboardObject
            WorldObject.AddOccupancy<BlackboardObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // TeachersDeskT2Object
            WorldObject.AddOccupancy<TeachersDeskT2Object>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // TeachersDeskT1Object
            WorldObject.AddOccupancy<TeachersDeskT1Object>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StudentsDeskT2Object
            WorldObject.AddOccupancy<StudentsDeskT2Object>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WoodenPodiumObject
            WorldObject.AddOccupancy<WoodenPodiumObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HugeSteelBannerSignObject
            WorldObject.AddOccupancy<HugeSteelBannerSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 4)),
            new BlockOccupancy(new Vector3i(-1, 0, 5)),
            new BlockOccupancy(new Vector3i(-1, 0, 6)),
            new BlockOccupancy(new Vector3i(-1, 0, 7)),
            new BlockOccupancy(new Vector3i(-1, 0, 8)),
            new BlockOccupancy(new Vector3i(-1, 0, 9)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 4)),
            new BlockOccupancy(new Vector3i(-1, 1, 5)),
            new BlockOccupancy(new Vector3i(-1, 1, 6)),
            new BlockOccupancy(new Vector3i(-1, 1, 7)),
            new BlockOccupancy(new Vector3i(-1, 1, 8)),
            new BlockOccupancy(new Vector3i(-1, 1, 9)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 4)),
            new BlockOccupancy(new Vector3i(-1, 2, 5)),
            new BlockOccupancy(new Vector3i(-1, 2, 6)),
            new BlockOccupancy(new Vector3i(-1, 2, 7)),
            new BlockOccupancy(new Vector3i(-1, 2, 8)),
            new BlockOccupancy(new Vector3i(-1, 2, 9)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 4)),
            new BlockOccupancy(new Vector3i(-1, 3, 5)),
            new BlockOccupancy(new Vector3i(-1, 3, 6)),
            new BlockOccupancy(new Vector3i(-1, 3, 7)),
            new BlockOccupancy(new Vector3i(-1, 3, 8)),
            new BlockOccupancy(new Vector3i(-1, 3, 9)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, 2)),
            new BlockOccupancy(new Vector3i(-1, 4, 3)),
            new BlockOccupancy(new Vector3i(-1, 4, 4)),
            new BlockOccupancy(new Vector3i(-1, 4, 5)),
            new BlockOccupancy(new Vector3i(-1, 4, 6)),
            new BlockOccupancy(new Vector3i(-1, 4, 7)),
            new BlockOccupancy(new Vector3i(-1, 4, 8)),
            new BlockOccupancy(new Vector3i(-1, 4, 9)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, 2)),
            new BlockOccupancy(new Vector3i(-1, 5, 3)),
            new BlockOccupancy(new Vector3i(-1, 5, 4)),
            new BlockOccupancy(new Vector3i(-1, 5, 5)),
            new BlockOccupancy(new Vector3i(-1, 5, 6)),
            new BlockOccupancy(new Vector3i(-1, 5, 7)),
            new BlockOccupancy(new Vector3i(-1, 5, 8)),
            new BlockOccupancy(new Vector3i(-1, 5, 9)),
            new BlockOccupancy(new Vector3i(-1, 6, 0)),
            new BlockOccupancy(new Vector3i(-1, 6, 1)),
            new BlockOccupancy(new Vector3i(-1, 6, 2)),
            new BlockOccupancy(new Vector3i(-1, 6, 3)),
            new BlockOccupancy(new Vector3i(-1, 6, 4)),
            new BlockOccupancy(new Vector3i(-1, 6, 5)),
            new BlockOccupancy(new Vector3i(-1, 6, 6)),
            new BlockOccupancy(new Vector3i(-1, 6, 7)),
            new BlockOccupancy(new Vector3i(-1, 6, 8)),
            new BlockOccupancy(new Vector3i(-1, 6, 9)),
            new BlockOccupancy(new Vector3i(-1, 7, 0)),
            new BlockOccupancy(new Vector3i(-1, 7, 1)),
            new BlockOccupancy(new Vector3i(-1, 7, 2)),
            new BlockOccupancy(new Vector3i(-1, 7, 3)),
            new BlockOccupancy(new Vector3i(-1, 7, 4)),
            new BlockOccupancy(new Vector3i(-1, 7, 5)),
            new BlockOccupancy(new Vector3i(-1, 7, 6)),
            new BlockOccupancy(new Vector3i(-1, 7, 7)),
            new BlockOccupancy(new Vector3i(-1, 7, 8)),
            new BlockOccupancy(new Vector3i(-1, 7, 9)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 0, 7)),
            new BlockOccupancy(new Vector3i(0, 0, 8)),
            new BlockOccupancy(new Vector3i(0, 0, 9)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 7)),
            new BlockOccupancy(new Vector3i(0, 1, 8)),
            new BlockOccupancy(new Vector3i(0, 1, 9)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 7)),
            new BlockOccupancy(new Vector3i(0, 2, 8)),
            new BlockOccupancy(new Vector3i(0, 2, 9)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 3, 6)),
            new BlockOccupancy(new Vector3i(0, 3, 7)),
            new BlockOccupancy(new Vector3i(0, 3, 8)),
            new BlockOccupancy(new Vector3i(0, 3, 9)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 4, 5)),
            new BlockOccupancy(new Vector3i(0, 4, 6)),
            new BlockOccupancy(new Vector3i(0, 4, 7)),
            new BlockOccupancy(new Vector3i(0, 4, 8)),
            new BlockOccupancy(new Vector3i(0, 4, 9)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 5, 5)),
            new BlockOccupancy(new Vector3i(0, 5, 6)),
            new BlockOccupancy(new Vector3i(0, 5, 7)),
            new BlockOccupancy(new Vector3i(0, 5, 8)),
            new BlockOccupancy(new Vector3i(0, 5, 9)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 6, 3)),
            new BlockOccupancy(new Vector3i(0, 6, 4)),
            new BlockOccupancy(new Vector3i(0, 6, 5)),
            new BlockOccupancy(new Vector3i(0, 6, 6)),
            new BlockOccupancy(new Vector3i(0, 6, 7)),
            new BlockOccupancy(new Vector3i(0, 6, 8)),
            new BlockOccupancy(new Vector3i(0, 6, 9)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 7, 2)),
            new BlockOccupancy(new Vector3i(0, 7, 3)),
            new BlockOccupancy(new Vector3i(0, 7, 4)),
            new BlockOccupancy(new Vector3i(0, 7, 5)),
            new BlockOccupancy(new Vector3i(0, 7, 6)),
            new BlockOccupancy(new Vector3i(0, 7, 7)),
            new BlockOccupancy(new Vector3i(0, 7, 8)),
            new BlockOccupancy(new Vector3i(0, 7, 9)),
            });
            // HugeWoodenBannerSignObject
            WorldObject.AddOccupancy<HugeWoodenBannerSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 5, 5)),
            new BlockOccupancy(new Vector3i(0, 5, 6)),
            new BlockOccupancy(new Vector3i(0, 5, 7)),
            new BlockOccupancy(new Vector3i(0, 5, 8)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 6, 3)),
            new BlockOccupancy(new Vector3i(0, 6, 4)),
            new BlockOccupancy(new Vector3i(0, 6, 5)),
            new BlockOccupancy(new Vector3i(0, 6, 6)),
            new BlockOccupancy(new Vector3i(0, 6, 7)),
            new BlockOccupancy(new Vector3i(0, 6, 8)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 7, 2)),
            new BlockOccupancy(new Vector3i(0, 7, 3)),
            new BlockOccupancy(new Vector3i(0, 7, 4)),
            new BlockOccupancy(new Vector3i(0, 7, 5)),
            new BlockOccupancy(new Vector3i(0, 7, 6)),
            new BlockOccupancy(new Vector3i(0, 7, 7)),
            new BlockOccupancy(new Vector3i(0, 7, 8)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 8, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 9)),
            new BlockOccupancy(new Vector3i(0, 1, 9)),
            new BlockOccupancy(new Vector3i(0, 2, 9)),
            new BlockOccupancy(new Vector3i(0, 3, 9)),
            new BlockOccupancy(new Vector3i(0, 4, 9)),
            new BlockOccupancy(new Vector3i(0, 5, 9)),
            new BlockOccupancy(new Vector3i(0, 6, 9)),
            new BlockOccupancy(new Vector3i(0, 7, 9)),
            new BlockOccupancy(new Vector3i(0, 8, 9)),

            });
            // HugeIronBannerSignObject
            WorldObject.AddOccupancy<HugeIronBannerSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 0, 7)),
            new BlockOccupancy(new Vector3i(0, 0, 8)),
            new BlockOccupancy(new Vector3i(0, 0, 9)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 7)),
            new BlockOccupancy(new Vector3i(0, 1, 8)),
            new BlockOccupancy(new Vector3i(0, 1, 9)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 7)),
            new BlockOccupancy(new Vector3i(0, 2, 8)),
            new BlockOccupancy(new Vector3i(0, 2, 9)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 3, 6)),
            new BlockOccupancy(new Vector3i(0, 3, 7)),
            new BlockOccupancy(new Vector3i(0, 3, 8)),
            new BlockOccupancy(new Vector3i(0, 3, 9)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 4, 5)),
            new BlockOccupancy(new Vector3i(0, 4, 6)),
            new BlockOccupancy(new Vector3i(0, 4, 7)),
            new BlockOccupancy(new Vector3i(0, 4, 8)),
            new BlockOccupancy(new Vector3i(0, 4, 9)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 5, 5)),
            new BlockOccupancy(new Vector3i(0, 5, 6)),
            new BlockOccupancy(new Vector3i(0, 5, 7)),
            new BlockOccupancy(new Vector3i(0, 5, 8)),
            new BlockOccupancy(new Vector3i(0, 5, 9)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 6, 3)),
            new BlockOccupancy(new Vector3i(0, 6, 4)),
            new BlockOccupancy(new Vector3i(0, 6, 5)),
            new BlockOccupancy(new Vector3i(0, 6, 6)),
            new BlockOccupancy(new Vector3i(0, 6, 7)),
            new BlockOccupancy(new Vector3i(0, 6, 8)),
            new BlockOccupancy(new Vector3i(0, 6, 9)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 7, 2)),
            new BlockOccupancy(new Vector3i(0, 7, 3)),
            new BlockOccupancy(new Vector3i(0, 7, 4)),
            new BlockOccupancy(new Vector3i(0, 7, 5)),
            new BlockOccupancy(new Vector3i(0, 7, 6)),
            new BlockOccupancy(new Vector3i(0, 7, 7)),
            new BlockOccupancy(new Vector3i(0, 7, 8)),
            new BlockOccupancy(new Vector3i(0, 7, 9)),
            new BlockOccupancy(new Vector3i(0, 8, 0)),
            new BlockOccupancy(new Vector3i(0, 8, 1)),
            new BlockOccupancy(new Vector3i(0, 8, 2)),
            new BlockOccupancy(new Vector3i(0, 8, 3)),
            new BlockOccupancy(new Vector3i(0, 8, 4)),
            new BlockOccupancy(new Vector3i(0, 8, 5)),
            new BlockOccupancy(new Vector3i(0, 8, 6)),
            new BlockOccupancy(new Vector3i(0, 8, 7)),
            new BlockOccupancy(new Vector3i(0, 8, 8)),
            new BlockOccupancy(new Vector3i(0, 8, 9)),
            });
            // HugeIronSignObject
            WorldObject.AddOccupancy<HugeIronSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 0, 7)),
            new BlockOccupancy(new Vector3i(0, 0, 8)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 7)),
            new BlockOccupancy(new Vector3i(0, 1, 8)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 7)),
            new BlockOccupancy(new Vector3i(0, 2, 8)),
            });
            // HugeSteelSignObject
            WorldObject.AddOccupancy<HugeSteelSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            });
            // HugeBannerSignObject
            WorldObject.AddOccupancy<HugeBannerSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 0, 7)),
            new BlockOccupancy(new Vector3i(0, 0, 8)),
            new BlockOccupancy(new Vector3i(0, 0, 9)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 7)),
            new BlockOccupancy(new Vector3i(0, 1, 8)),
            new BlockOccupancy(new Vector3i(0, 1, 9)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 7)),
            new BlockOccupancy(new Vector3i(0, 2, 8)),
            new BlockOccupancy(new Vector3i(0, 2, 9)),
            });
            // SmallMeetingChairObject
            WorldObject.AddOccupancy<SmallMeetingChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallMeetingTableObject
            WorldObject.AddOccupancy<SmallMeetingTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SteelKitchenLampObject
            WorldObject.AddOccupancy<SteelKitchenLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, -1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            
            // WoodKitchenLampObject
            WorldObject.AddOccupancy<WoodenKitchenLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, -1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SteelHangingFixtureObject
            WorldObject.AddOccupancy<SteelHangingFixtureObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, -1, -1)),
            new BlockOccupancy(new Vector3i(-1, -1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, -1, -1)),
            new BlockOccupancy(new Vector3i(0, -1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SteelAbstractFixtureObject
            WorldObject.AddOccupancy<SteelAbstractFixtureObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // InjectionMoldMachineObject
            WorldObject.AddOccupancy<InjectionMoldMachineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // OfficeMailboxObject
            WorldObject.AddOccupancy<OfficeMailboxObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // PrintingPressObject
            WorldObject.AddOccupancy<PrintingPressObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // PaperMachineObject
            WorldObject.AddOccupancy<PaperMachineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -7)),
            new BlockOccupancy(new Vector3i(0, 0, -6)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -7)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -7)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -7)),
            new BlockOccupancy(new Vector3i(0, 3, -6)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, -7)),
            new BlockOccupancy(new Vector3i(0, 4, -6)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -7)),
            new BlockOccupancy(new Vector3i(1, 0, -6)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -7)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -7)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 3, -7)),
            new BlockOccupancy(new Vector3i(1, 3, -6)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 4, -7)),
            new BlockOccupancy(new Vector3i(1, 4, -6)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -7)),
            new BlockOccupancy(new Vector3i(2, 0, -6)),
            new BlockOccupancy(new Vector3i(2, 0, -5)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -7)),
            new BlockOccupancy(new Vector3i(2, 1, -6)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -7)),
            new BlockOccupancy(new Vector3i(2, 2, -6)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 3, -7)),
            new BlockOccupancy(new Vector3i(2, 3, -6)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 4, -7)),
            new BlockOccupancy(new Vector3i(2, 4, -6)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -7)),
            new BlockOccupancy(new Vector3i(3, 0, -6)),
            new BlockOccupancy(new Vector3i(3, 0, -5)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -7)),
            new BlockOccupancy(new Vector3i(3, 1, -6)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -7)),
            new BlockOccupancy(new Vector3i(3, 2, -6)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 3, -7)),
            new BlockOccupancy(new Vector3i(3, 3, -6)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 4, -7)),
            new BlockOccupancy(new Vector3i(3, 4, -6)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            });
            // EaselObject
            WorldObject.AddOccupancy<EaselObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // MailboxObject
            WorldObject.AddOccupancy<MailboxObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CastIronRoyalBedObject
            WorldObject.AddOccupancy<CastIronRoyalBedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // CastIronBedObject
            WorldObject.AddOccupancy<CastIronBedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // TowelRackObject
            WorldObject.AddOccupancy<TowelRackObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeBathMatObject
            WorldObject.AddOccupancy<LargeBathMatObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // SmallBathMatObject
            WorldObject.AddOccupancy<SmallBathMatObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // NylonFutonBedObject
            WorldObject.AddOccupancy<NylonFutonBedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // HewnNightstandObject
            WorldObject.AddOccupancy<HewnNightstandObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            });
            // HewnDresserObject
            WorldObject.AddOccupancy<HewnDresserObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            });
            // NylonFutonCouchObject
            WorldObject.AddOccupancy<NylonFutonCouchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // UpholsteredCouchObject
            WorldObject.AddOccupancy<UpholsteredCouchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // UpholsteredChairObject
            WorldObject.AddOccupancy<UpholsteredChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // FishTrapObject
            WorldObject.AddOccupancy<FishTrapObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // SteelHangingLampObject
            WorldObject.AddOccupancy<SteelHangingLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, -1, -1)),
            new BlockOccupancy(new Vector3i(-1, -1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, -1, -1)),
            new BlockOccupancy(new Vector3i(0, -1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SteelSquareFixtureObject
            WorldObject.AddOccupancy<SteelSquareFixtureObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CastIronBenchObject
            WorldObject.AddOccupancy<CastIronBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // CastIronChairObject
            WorldObject.AddOccupancy<CastIronChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CastIronTableObject
            WorldObject.AddOccupancy<CastIronTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LargeWoodenBookshelfObject
            WorldObject.AddOccupancy<LargeWoodenBookshelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // MasculineMannequinObject
            WorldObject.AddOccupancy<MasculineMannequinObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // FeminineMannequinObject
            WorldObject.AddOccupancy<FeminineMannequinObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // CanningAssemblyObject
            WorldObject.AddOccupancy<CanningAssemblyObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-5, 0, -5)),
            new BlockOccupancy(new Vector3i(-5, 0, -4)),
            new BlockOccupancy(new Vector3i(-5, 0, -3)),
            new BlockOccupancy(new Vector3i(-5, 0, -2)),
            new BlockOccupancy(new Vector3i(-5, 0, -1)),
            new BlockOccupancy(new Vector3i(-5, 0, 0)),
            new BlockOccupancy(new Vector3i(-5, 1, -5)),
            new BlockOccupancy(new Vector3i(-5, 1, -4)),
            new BlockOccupancy(new Vector3i(-5, 1, -3)),
            new BlockOccupancy(new Vector3i(-5, 1, -2)),
            new BlockOccupancy(new Vector3i(-5, 1, -1)),
            new BlockOccupancy(new Vector3i(-5, 1, 0)),
            new BlockOccupancy(new Vector3i(-5, 2, -5)),
            new BlockOccupancy(new Vector3i(-5, 2, -4)),
            new BlockOccupancy(new Vector3i(-5, 2, -3)),
            new BlockOccupancy(new Vector3i(-5, 2, -2)),
            new BlockOccupancy(new Vector3i(-5, 2, -1)),
            new BlockOccupancy(new Vector3i(-5, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, -5)),
            new BlockOccupancy(new Vector3i(-4, 0, -4)),
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, -5)),
            new BlockOccupancy(new Vector3i(-4, 1, -4)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, -5)),
            new BlockOccupancy(new Vector3i(-4, 2, -4)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, -5)),
            new BlockOccupancy(new Vector3i(-3, 0, -4)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, -5)),
            new BlockOccupancy(new Vector3i(-3, 1, -4)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, -5)),
            new BlockOccupancy(new Vector3i(-3, 2, -4)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // PotteryTableObject
            WorldObject.AddOccupancy<PotteryTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // IndustrialRefrigeratorObject
            WorldObject.AddOccupancy<IndustrialRefrigeratorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            });
            // StudentsDeskT1Object
            WorldObject.AddOccupancy<StudentsDeskT1Object>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StudentsDeskT3Object
            WorldObject.AddOccupancy<StudentsDeskT3Object>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // TeachersDeskT3Object
            WorldObject.AddOccupancy<TeachersDeskT3Object>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SteelSearchlightObject
            WorldObject.AddOccupancy<SteelSearchlightObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // PictureFrameObject
            WorldObject.AddOccupancy<PictureFrameObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HardwoodLumberDresserObject
            WorldObject.AddOccupancy<HardwoodLumberDresserObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LumberDresserObject
            WorldObject.AddOccupancy<LumberDresserObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SoftwoodLumberDresserObject
            WorldObject.AddOccupancy<SoftwoodLumberDresserObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CompositeLumberDresserObject
            WorldObject.AddOccupancy<CompositeLumberDresserObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SteamTruckObject
            WorldObject.AddOccupancy<SteamTruckObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            });
            // HandPlowObject
            WorldObject.AddOccupancy<HandPlowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // PoweredCartObject
            WorldObject.AddOccupancy<PoweredCartObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            });
            // SkidSteerObject
            WorldObject.AddOccupancy<SkidSteerObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            });
            // SmallWoodCartObject
            WorldObject.AddOccupancy<SmallWoodCartObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            });
            // SteamTractorObject
            WorldObject.AddOccupancy<SteamTractorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            });
            // TrailerTruckObject
            WorldObject.AddOccupancy<TrailerTruckObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 5)),
            new BlockOccupancy(new Vector3i(1, 0, 6)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 1, 6)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 2, 6)),
            });
            // TruckObject
            WorldObject.AddOccupancy<TruckObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            });
            // WheelbarrowObject
            WorldObject.AddOccupancy<WheelbarrowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            });
            // WoodCartObject
            WorldObject.AddOccupancy<WoodCartObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            });
            // WoodShopCartObject
            WorldObject.AddOccupancy<WoodShopCartObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            });
            // ExcavatorObject
            WorldObject.AddOccupancy<ExcavatorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 0, 7)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 7)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 7)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 3, 6)),
            new BlockOccupancy(new Vector3i(0, 3, 7)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 5)),
            new BlockOccupancy(new Vector3i(1, 0, 6)),
            new BlockOccupancy(new Vector3i(1, 0, 7)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 1, 6)),
            new BlockOccupancy(new Vector3i(1, 1, 7)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 2, 6)),
            new BlockOccupancy(new Vector3i(1, 2, 7)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 5)),
            new BlockOccupancy(new Vector3i(1, 3, 6)),
            new BlockOccupancy(new Vector3i(1, 3, 7)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 5)),
            new BlockOccupancy(new Vector3i(2, 0, 6)),
            new BlockOccupancy(new Vector3i(2, 0, 7)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 5)),
            new BlockOccupancy(new Vector3i(2, 1, 6)),
            new BlockOccupancy(new Vector3i(2, 1, 7)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 5)),
            new BlockOccupancy(new Vector3i(2, 2, 6)),
            new BlockOccupancy(new Vector3i(2, 2, 7)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 5)),
            new BlockOccupancy(new Vector3i(2, 3, 6)),
            new BlockOccupancy(new Vector3i(2, 3, 7)),
            });
            // GlassworksObject
            WorldObject.AddOccupancy<GlassworksObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 0, -4)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 1, -4)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 2, -4)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 3, -4)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 4, -4)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            });
            // SmallWoodenBoatObject
            WorldObject.AddOccupancy<SmallWoodenBoatObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            });
            // WoodenBargeObject
            WorldObject.AddOccupancy<WoodenBargeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 0, 7)),
            new BlockOccupancy(new Vector3i(0, 0, 8)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 7)),
            new BlockOccupancy(new Vector3i(0, 1, 8)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 7)),
            new BlockOccupancy(new Vector3i(0, 2, 8)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 3, 6)),
            new BlockOccupancy(new Vector3i(0, 3, 7)),
            new BlockOccupancy(new Vector3i(0, 3, 8)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 4, 5)),
            new BlockOccupancy(new Vector3i(0, 4, 6)),
            new BlockOccupancy(new Vector3i(0, 4, 7)),
            new BlockOccupancy(new Vector3i(0, 4, 8)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 5)),
            new BlockOccupancy(new Vector3i(1, 0, 6)),
            new BlockOccupancy(new Vector3i(1, 0, 7)),
            new BlockOccupancy(new Vector3i(1, 0, 8)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 1, 6)),
            new BlockOccupancy(new Vector3i(1, 1, 7)),
            new BlockOccupancy(new Vector3i(1, 1, 8)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 2, 6)),
            new BlockOccupancy(new Vector3i(1, 2, 7)),
            new BlockOccupancy(new Vector3i(1, 2, 8)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 5)),
            new BlockOccupancy(new Vector3i(1, 3, 6)),
            new BlockOccupancy(new Vector3i(1, 3, 7)),
            new BlockOccupancy(new Vector3i(1, 3, 8)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 3)),
            new BlockOccupancy(new Vector3i(1, 4, 4)),
            new BlockOccupancy(new Vector3i(1, 4, 5)),
            new BlockOccupancy(new Vector3i(1, 4, 6)),
            new BlockOccupancy(new Vector3i(1, 4, 7)),
            new BlockOccupancy(new Vector3i(1, 4, 8)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 5)),
            new BlockOccupancy(new Vector3i(2, 0, 6)),
            new BlockOccupancy(new Vector3i(2, 0, 7)),
            new BlockOccupancy(new Vector3i(2, 0, 8)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 5)),
            new BlockOccupancy(new Vector3i(2, 1, 6)),
            new BlockOccupancy(new Vector3i(2, 1, 7)),
            new BlockOccupancy(new Vector3i(2, 1, 8)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 5)),
            new BlockOccupancy(new Vector3i(2, 2, 6)),
            new BlockOccupancy(new Vector3i(2, 2, 7)),
            new BlockOccupancy(new Vector3i(2, 2, 8)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 5)),
            new BlockOccupancy(new Vector3i(2, 3, 6)),
            new BlockOccupancy(new Vector3i(2, 3, 7)),
            new BlockOccupancy(new Vector3i(2, 3, 8)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 3)),
            new BlockOccupancy(new Vector3i(2, 4, 4)),
            new BlockOccupancy(new Vector3i(2, 4, 5)),
            new BlockOccupancy(new Vector3i(2, 4, 6)),
            new BlockOccupancy(new Vector3i(2, 4, 7)),
            new BlockOccupancy(new Vector3i(2, 4, 8)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 0, 5)),
            new BlockOccupancy(new Vector3i(3, 0, 6)),
            new BlockOccupancy(new Vector3i(3, 0, 7)),
            new BlockOccupancy(new Vector3i(3, 0, 8)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 5)),
            new BlockOccupancy(new Vector3i(3, 1, 6)),
            new BlockOccupancy(new Vector3i(3, 1, 7)),
            new BlockOccupancy(new Vector3i(3, 1, 8)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 5)),
            new BlockOccupancy(new Vector3i(3, 2, 6)),
            new BlockOccupancy(new Vector3i(3, 2, 7)),
            new BlockOccupancy(new Vector3i(3, 2, 8)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 5)),
            new BlockOccupancy(new Vector3i(3, 3, 6)),
            new BlockOccupancy(new Vector3i(3, 3, 7)),
            new BlockOccupancy(new Vector3i(3, 3, 8)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 4, 2)),
            new BlockOccupancy(new Vector3i(3, 4, 3)),
            new BlockOccupancy(new Vector3i(3, 4, 4)),
            new BlockOccupancy(new Vector3i(3, 4, 5)),
            new BlockOccupancy(new Vector3i(3, 4, 6)),
            new BlockOccupancy(new Vector3i(3, 4, 7)),
            new BlockOccupancy(new Vector3i(3, 4, 8)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 3)),
            new BlockOccupancy(new Vector3i(4, 0, 4)),
            new BlockOccupancy(new Vector3i(4, 0, 5)),
            new BlockOccupancy(new Vector3i(4, 0, 6)),
            new BlockOccupancy(new Vector3i(4, 0, 7)),
            new BlockOccupancy(new Vector3i(4, 0, 8)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 4)),
            new BlockOccupancy(new Vector3i(4, 1, 5)),
            new BlockOccupancy(new Vector3i(4, 1, 6)),
            new BlockOccupancy(new Vector3i(4, 1, 7)),
            new BlockOccupancy(new Vector3i(4, 1, 8)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 2)),
            new BlockOccupancy(new Vector3i(4, 2, 3)),
            new BlockOccupancy(new Vector3i(4, 2, 4)),
            new BlockOccupancy(new Vector3i(4, 2, 5)),
            new BlockOccupancy(new Vector3i(4, 2, 6)),
            new BlockOccupancy(new Vector3i(4, 2, 7)),
            new BlockOccupancy(new Vector3i(4, 2, 8)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 2)),
            new BlockOccupancy(new Vector3i(4, 3, 3)),
            new BlockOccupancy(new Vector3i(4, 3, 4)),
            new BlockOccupancy(new Vector3i(4, 3, 5)),
            new BlockOccupancy(new Vector3i(4, 3, 6)),
            new BlockOccupancy(new Vector3i(4, 3, 7)),
            new BlockOccupancy(new Vector3i(4, 3, 8)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 4, 1)),
            new BlockOccupancy(new Vector3i(4, 4, 2)),
            new BlockOccupancy(new Vector3i(4, 4, 3)),
            new BlockOccupancy(new Vector3i(4, 4, 4)),
            new BlockOccupancy(new Vector3i(4, 4, 5)),
            new BlockOccupancy(new Vector3i(4, 4, 6)),
            new BlockOccupancy(new Vector3i(4, 4, 7)),
            new BlockOccupancy(new Vector3i(4, 4, 8)),
            new BlockOccupancy(new Vector3i(5, 0, 0)),
            new BlockOccupancy(new Vector3i(5, 0, 1)),
            new BlockOccupancy(new Vector3i(5, 0, 2)),
            new BlockOccupancy(new Vector3i(5, 0, 3)),
            new BlockOccupancy(new Vector3i(5, 0, 4)),
            new BlockOccupancy(new Vector3i(5, 0, 5)),
            new BlockOccupancy(new Vector3i(5, 0, 6)),
            new BlockOccupancy(new Vector3i(5, 0, 7)),
            new BlockOccupancy(new Vector3i(5, 0, 8)),
            new BlockOccupancy(new Vector3i(5, 1, 0)),
            new BlockOccupancy(new Vector3i(5, 1, 1)),
            new BlockOccupancy(new Vector3i(5, 1, 2)),
            new BlockOccupancy(new Vector3i(5, 1, 3)),
            new BlockOccupancy(new Vector3i(5, 1, 4)),
            new BlockOccupancy(new Vector3i(5, 1, 5)),
            new BlockOccupancy(new Vector3i(5, 1, 6)),
            new BlockOccupancy(new Vector3i(5, 1, 7)),
            new BlockOccupancy(new Vector3i(5, 1, 8)),
            new BlockOccupancy(new Vector3i(5, 2, 0)),
            new BlockOccupancy(new Vector3i(5, 2, 1)),
            new BlockOccupancy(new Vector3i(5, 2, 2)),
            new BlockOccupancy(new Vector3i(5, 2, 3)),
            new BlockOccupancy(new Vector3i(5, 2, 4)),
            new BlockOccupancy(new Vector3i(5, 2, 5)),
            new BlockOccupancy(new Vector3i(5, 2, 6)),
            new BlockOccupancy(new Vector3i(5, 2, 7)),
            new BlockOccupancy(new Vector3i(5, 2, 8)),
            new BlockOccupancy(new Vector3i(5, 3, 0)),
            new BlockOccupancy(new Vector3i(5, 3, 1)),
            new BlockOccupancy(new Vector3i(5, 3, 2)),
            new BlockOccupancy(new Vector3i(5, 3, 3)),
            new BlockOccupancy(new Vector3i(5, 3, 4)),
            new BlockOccupancy(new Vector3i(5, 3, 5)),
            new BlockOccupancy(new Vector3i(5, 3, 6)),
            new BlockOccupancy(new Vector3i(5, 3, 7)),
            new BlockOccupancy(new Vector3i(5, 3, 8)),
            new BlockOccupancy(new Vector3i(5, 4, 0)),
            new BlockOccupancy(new Vector3i(5, 4, 1)),
            new BlockOccupancy(new Vector3i(5, 4, 2)),
            new BlockOccupancy(new Vector3i(5, 4, 3)),
            new BlockOccupancy(new Vector3i(5, 4, 4)),
            new BlockOccupancy(new Vector3i(5, 4, 5)),
            new BlockOccupancy(new Vector3i(5, 4, 6)),
            new BlockOccupancy(new Vector3i(5, 4, 7)),
            new BlockOccupancy(new Vector3i(5, 4, 8)),
            new BlockOccupancy(new Vector3i(6, 0, 0)),
            new BlockOccupancy(new Vector3i(6, 0, 1)),
            new BlockOccupancy(new Vector3i(6, 0, 2)),
            new BlockOccupancy(new Vector3i(6, 0, 3)),
            new BlockOccupancy(new Vector3i(6, 0, 4)),
            new BlockOccupancy(new Vector3i(6, 0, 5)),
            new BlockOccupancy(new Vector3i(6, 0, 6)),
            new BlockOccupancy(new Vector3i(6, 0, 7)),
            new BlockOccupancy(new Vector3i(6, 0, 8)),
            new BlockOccupancy(new Vector3i(6, 1, 0)),
            new BlockOccupancy(new Vector3i(6, 1, 1)),
            new BlockOccupancy(new Vector3i(6, 1, 2)),
            new BlockOccupancy(new Vector3i(6, 1, 3)),
            new BlockOccupancy(new Vector3i(6, 1, 4)),
            new BlockOccupancy(new Vector3i(6, 1, 5)),
            new BlockOccupancy(new Vector3i(6, 1, 6)),
            new BlockOccupancy(new Vector3i(6, 1, 7)),
            new BlockOccupancy(new Vector3i(6, 1, 8)),
            new BlockOccupancy(new Vector3i(6, 2, 0)),
            new BlockOccupancy(new Vector3i(6, 2, 1)),
            new BlockOccupancy(new Vector3i(6, 2, 2)),
            new BlockOccupancy(new Vector3i(6, 2, 3)),
            new BlockOccupancy(new Vector3i(6, 2, 4)),
            new BlockOccupancy(new Vector3i(6, 2, 5)),
            new BlockOccupancy(new Vector3i(6, 2, 6)),
            new BlockOccupancy(new Vector3i(6, 2, 7)),
            new BlockOccupancy(new Vector3i(6, 2, 8)),
            new BlockOccupancy(new Vector3i(6, 3, 0)),
            new BlockOccupancy(new Vector3i(6, 3, 1)),
            new BlockOccupancy(new Vector3i(6, 3, 2)),
            new BlockOccupancy(new Vector3i(6, 3, 3)),
            new BlockOccupancy(new Vector3i(6, 3, 4)),
            new BlockOccupancy(new Vector3i(6, 3, 5)),
            new BlockOccupancy(new Vector3i(6, 3, 6)),
            new BlockOccupancy(new Vector3i(6, 3, 7)),
            new BlockOccupancy(new Vector3i(6, 3, 8)),
            new BlockOccupancy(new Vector3i(6, 4, 0)),
            new BlockOccupancy(new Vector3i(6, 4, 1)),
            new BlockOccupancy(new Vector3i(6, 4, 2)),
            new BlockOccupancy(new Vector3i(6, 4, 3)),
            new BlockOccupancy(new Vector3i(6, 4, 4)),
            new BlockOccupancy(new Vector3i(6, 4, 5)),
            new BlockOccupancy(new Vector3i(6, 4, 6)),
            new BlockOccupancy(new Vector3i(6, 4, 7)),
            new BlockOccupancy(new Vector3i(6, 4, 8)),
            });
            // WoodenTransportShipObject
            WorldObject.AddOccupancy<WoodenTransportShipObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 4)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            });
            // SmallCanoeObject
            WorldObject.AddOccupancy<SmallCanoeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            });
            // MediumShipyardObject
            WorldObject.AddOccupancy<MediumShipyardObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-4, 0, -7)),
            new BlockOccupancy(new Vector3i(-4, 0, -6)),
            new BlockOccupancy(new Vector3i(-4, 0, -5)),
            new BlockOccupancy(new Vector3i(-4, 0, -4)),
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 1)),
            new BlockOccupancy(new Vector3i(-4, 0, 2)),
            new BlockOccupancy(new Vector3i(-4, 0, 3)),
            new BlockOccupancy(new Vector3i(-4, 0, 4)),
            new BlockOccupancy(new Vector3i(-4, 0, 5)),
            new BlockOccupancy(new Vector3i(-4, 0, 6)),
            new BlockOccupancy(new Vector3i(-4, 0, 7)),
            new BlockOccupancy(new Vector3i(-4, 0, 8)),
            new BlockOccupancy(new Vector3i(-4, 1, -7)),
            new BlockOccupancy(new Vector3i(-4, 1, -6)),
            new BlockOccupancy(new Vector3i(-4, 1, -5)),
            new BlockOccupancy(new Vector3i(-4, 1, -4)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, 1)),
            new BlockOccupancy(new Vector3i(-4, 1, 2)),
            new BlockOccupancy(new Vector3i(-4, 1, 3)),
            new BlockOccupancy(new Vector3i(-4, 1, 4)),
            new BlockOccupancy(new Vector3i(-4, 1, 5)),
            new BlockOccupancy(new Vector3i(-4, 1, 6)),
            new BlockOccupancy(new Vector3i(-4, 1, 7)),
            new BlockOccupancy(new Vector3i(-4, 1, 8)),
            new BlockOccupancy(new Vector3i(-4, 2, -7)),
            new BlockOccupancy(new Vector3i(-4, 2, -6)),
            new BlockOccupancy(new Vector3i(-4, 2, -5)),
            new BlockOccupancy(new Vector3i(-4, 2, -4)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, 1)),
            new BlockOccupancy(new Vector3i(-4, 2, 2)),
            new BlockOccupancy(new Vector3i(-4, 2, 3)),
            new BlockOccupancy(new Vector3i(-4, 2, 4)),
            new BlockOccupancy(new Vector3i(-4, 2, 5)),
            new BlockOccupancy(new Vector3i(-4, 2, 6)),
            new BlockOccupancy(new Vector3i(-4, 2, 7)),
            new BlockOccupancy(new Vector3i(-4, 2, 8)),
            new BlockOccupancy(new Vector3i(-4, 3, -7)),
            new BlockOccupancy(new Vector3i(-4, 3, -6)),
            new BlockOccupancy(new Vector3i(-4, 3, -5)),
            new BlockOccupancy(new Vector3i(-4, 3, -4)),
            new BlockOccupancy(new Vector3i(-4, 3, -3)),
            new BlockOccupancy(new Vector3i(-4, 3, -2)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, 1)),
            new BlockOccupancy(new Vector3i(-4, 3, 2)),
            new BlockOccupancy(new Vector3i(-4, 3, 3)),
            new BlockOccupancy(new Vector3i(-4, 3, 4)),
            new BlockOccupancy(new Vector3i(-4, 3, 5)),
            new BlockOccupancy(new Vector3i(-4, 3, 6)),
            new BlockOccupancy(new Vector3i(-4, 3, 7)),
            new BlockOccupancy(new Vector3i(-4, 3, 8)),
            new BlockOccupancy(new Vector3i(-4, 4, -7)),
            new BlockOccupancy(new Vector3i(-4, 4, -6)),
            new BlockOccupancy(new Vector3i(-4, 4, -5)),
            new BlockOccupancy(new Vector3i(-4, 4, -4)),
            new BlockOccupancy(new Vector3i(-4, 4, -3)),
            new BlockOccupancy(new Vector3i(-4, 4, -2)),
            new BlockOccupancy(new Vector3i(-4, 4, -1)),
            new BlockOccupancy(new Vector3i(-4, 4, 0)),
            new BlockOccupancy(new Vector3i(-4, 4, 1)),
            new BlockOccupancy(new Vector3i(-4, 4, 2)),
            new BlockOccupancy(new Vector3i(-4, 4, 3)),
            new BlockOccupancy(new Vector3i(-4, 4, 4)),
            new BlockOccupancy(new Vector3i(-4, 4, 5)),
            new BlockOccupancy(new Vector3i(-4, 4, 6)),
            new BlockOccupancy(new Vector3i(-4, 4, 7)),
            new BlockOccupancy(new Vector3i(-4, 4, 8)),
            new BlockOccupancy(new Vector3i(-4, 5, -7)),
            new BlockOccupancy(new Vector3i(-4, 5, -6)),
            new BlockOccupancy(new Vector3i(-4, 5, -5)),
            new BlockOccupancy(new Vector3i(-4, 5, -4)),
            new BlockOccupancy(new Vector3i(-4, 5, -3)),
            new BlockOccupancy(new Vector3i(-4, 5, -2)),
            new BlockOccupancy(new Vector3i(-4, 5, -1)),
            new BlockOccupancy(new Vector3i(-4, 5, 0)),
            new BlockOccupancy(new Vector3i(-4, 5, 1)),
            new BlockOccupancy(new Vector3i(-4, 5, 2)),
            new BlockOccupancy(new Vector3i(-4, 5, 3)),
            new BlockOccupancy(new Vector3i(-4, 5, 4)),
            new BlockOccupancy(new Vector3i(-4, 5, 5)),
            new BlockOccupancy(new Vector3i(-4, 5, 6)),
            new BlockOccupancy(new Vector3i(-4, 5, 7)),
            new BlockOccupancy(new Vector3i(-4, 5, 8)),
            new BlockOccupancy(new Vector3i(-3, 0, -7)),
            new BlockOccupancy(new Vector3i(-3, 0, -6)),
            new BlockOccupancy(new Vector3i(-3, 0, -5)),
            new BlockOccupancy(new Vector3i(-3, 0, -4)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, 2)),
            new BlockOccupancy(new Vector3i(-3, 0, 3)),
            new BlockOccupancy(new Vector3i(-3, 0, 4)),
            new BlockOccupancy(new Vector3i(-3, 0, 5)),
            new BlockOccupancy(new Vector3i(-3, 0, 6)),
            new BlockOccupancy(new Vector3i(-3, 0, 7)),
            new BlockOccupancy(new Vector3i(-3, 0, 8)),
            new BlockOccupancy(new Vector3i(-3, 1, -7)),
            new BlockOccupancy(new Vector3i(-3, 1, -6)),
            new BlockOccupancy(new Vector3i(-3, 1, -5)),
            new BlockOccupancy(new Vector3i(-3, 1, -4)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, 2)),
            new BlockOccupancy(new Vector3i(-3, 1, 3)),
            new BlockOccupancy(new Vector3i(-3, 1, 4)),
            new BlockOccupancy(new Vector3i(-3, 1, 5)),
            new BlockOccupancy(new Vector3i(-3, 1, 6)),
            new BlockOccupancy(new Vector3i(-3, 1, 7)),
            new BlockOccupancy(new Vector3i(-3, 1, 8)),
            new BlockOccupancy(new Vector3i(-3, 2, -7)),
            new BlockOccupancy(new Vector3i(-3, 2, -6)),
            new BlockOccupancy(new Vector3i(-3, 2, -5)),
            new BlockOccupancy(new Vector3i(-3, 2, -4)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, 2)),
            new BlockOccupancy(new Vector3i(-3, 2, 3)),
            new BlockOccupancy(new Vector3i(-3, 2, 4)),
            new BlockOccupancy(new Vector3i(-3, 2, 5)),
            new BlockOccupancy(new Vector3i(-3, 2, 6)),
            new BlockOccupancy(new Vector3i(-3, 2, 7)),
            new BlockOccupancy(new Vector3i(-3, 2, 8)),
            new BlockOccupancy(new Vector3i(-3, 3, -7)),
            new BlockOccupancy(new Vector3i(-3, 3, -6)),
            new BlockOccupancy(new Vector3i(-3, 3, -5)),
            new BlockOccupancy(new Vector3i(-3, 3, -4)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, 2)),
            new BlockOccupancy(new Vector3i(-3, 3, 3)),
            new BlockOccupancy(new Vector3i(-3, 3, 4)),
            new BlockOccupancy(new Vector3i(-3, 3, 5)),
            new BlockOccupancy(new Vector3i(-3, 3, 6)),
            new BlockOccupancy(new Vector3i(-3, 3, 7)),
            new BlockOccupancy(new Vector3i(-3, 3, 8)),
            new BlockOccupancy(new Vector3i(-3, 4, -7)),
            new BlockOccupancy(new Vector3i(-3, 4, -6)),
            new BlockOccupancy(new Vector3i(-3, 4, -5)),
            new BlockOccupancy(new Vector3i(-3, 4, -4)),
            new BlockOccupancy(new Vector3i(-3, 4, -3)),
            new BlockOccupancy(new Vector3i(-3, 4, -2)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, 1)),
            new BlockOccupancy(new Vector3i(-3, 4, 2)),
            new BlockOccupancy(new Vector3i(-3, 4, 3)),
            new BlockOccupancy(new Vector3i(-3, 4, 4)),
            new BlockOccupancy(new Vector3i(-3, 4, 5)),
            new BlockOccupancy(new Vector3i(-3, 4, 6)),
            new BlockOccupancy(new Vector3i(-3, 4, 7)),
            new BlockOccupancy(new Vector3i(-3, 4, 8)),
            new BlockOccupancy(new Vector3i(-3, 5, -7)),
            new BlockOccupancy(new Vector3i(-3, 5, -6)),
            new BlockOccupancy(new Vector3i(-3, 5, -5)),
            new BlockOccupancy(new Vector3i(-3, 5, -4)),
            new BlockOccupancy(new Vector3i(-3, 5, -3)),
            new BlockOccupancy(new Vector3i(-3, 5, -2)),
            new BlockOccupancy(new Vector3i(-3, 5, -1)),
            new BlockOccupancy(new Vector3i(-3, 5, 0)),
            new BlockOccupancy(new Vector3i(-3, 5, 1)),
            new BlockOccupancy(new Vector3i(-3, 5, 2)),
            new BlockOccupancy(new Vector3i(-3, 5, 3)),
            new BlockOccupancy(new Vector3i(-3, 5, 4)),
            new BlockOccupancy(new Vector3i(-3, 5, 5)),
            new BlockOccupancy(new Vector3i(-3, 5, 6)),
            new BlockOccupancy(new Vector3i(-3, 5, 7)),
            new BlockOccupancy(new Vector3i(-3, 5, 8)),
            new BlockOccupancy(new Vector3i(-2, 0, -7)),
            new BlockOccupancy(new Vector3i(-2, 0, -6)),
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 0, 3)),
            new BlockOccupancy(new Vector3i(-2, 0, 4)),
            new BlockOccupancy(new Vector3i(-2, 0, 5)),
            new BlockOccupancy(new Vector3i(-2, 0, 6)),
            new BlockOccupancy(new Vector3i(-2, 0, 7)),
            new BlockOccupancy(new Vector3i(-2, 0, 8)),
            new BlockOccupancy(new Vector3i(-2, 1, -7)),
            new BlockOccupancy(new Vector3i(-2, 1, -6)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 1, 4)),
            new BlockOccupancy(new Vector3i(-2, 1, 5)),
            new BlockOccupancy(new Vector3i(-2, 1, 6)),
            new BlockOccupancy(new Vector3i(-2, 1, 7)),
            new BlockOccupancy(new Vector3i(-2, 1, 8)),
            new BlockOccupancy(new Vector3i(-2, 2, -7)),
            new BlockOccupancy(new Vector3i(-2, 2, -6)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, 4)),
            new BlockOccupancy(new Vector3i(-2, 2, 5)),
            new BlockOccupancy(new Vector3i(-2, 2, 6)),
            new BlockOccupancy(new Vector3i(-2, 2, 7)),
            new BlockOccupancy(new Vector3i(-2, 2, 8)),
            new BlockOccupancy(new Vector3i(-2, 3, -7)),
            new BlockOccupancy(new Vector3i(-2, 3, -6)),
            new BlockOccupancy(new Vector3i(-2, 3, -5)),
            new BlockOccupancy(new Vector3i(-2, 3, -4)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, 3)),
            new BlockOccupancy(new Vector3i(-2, 3, 4)),
            new BlockOccupancy(new Vector3i(-2, 3, 5)),
            new BlockOccupancy(new Vector3i(-2, 3, 6)),
            new BlockOccupancy(new Vector3i(-2, 3, 7)),
            new BlockOccupancy(new Vector3i(-2, 3, 8)),
            new BlockOccupancy(new Vector3i(-2, 4, -7)),
            new BlockOccupancy(new Vector3i(-2, 4, -6)),
            new BlockOccupancy(new Vector3i(-2, 4, -5)),
            new BlockOccupancy(new Vector3i(-2, 4, -4)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, 2)),
            new BlockOccupancy(new Vector3i(-2, 4, 3)),
            new BlockOccupancy(new Vector3i(-2, 4, 4)),
            new BlockOccupancy(new Vector3i(-2, 4, 5)),
            new BlockOccupancy(new Vector3i(-2, 4, 6)),
            new BlockOccupancy(new Vector3i(-2, 4, 7)),
            new BlockOccupancy(new Vector3i(-2, 4, 8)),
            new BlockOccupancy(new Vector3i(-2, 5, -7)),
            new BlockOccupancy(new Vector3i(-2, 5, -6)),
            new BlockOccupancy(new Vector3i(-2, 5, -5)),
            new BlockOccupancy(new Vector3i(-2, 5, -4)),
            new BlockOccupancy(new Vector3i(-2, 5, -3)),
            new BlockOccupancy(new Vector3i(-2, 5, -2)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, 2)),
            new BlockOccupancy(new Vector3i(-2, 5, 3)),
            new BlockOccupancy(new Vector3i(-2, 5, 4)),
            new BlockOccupancy(new Vector3i(-2, 5, 5)),
            new BlockOccupancy(new Vector3i(-2, 5, 6)),
            new BlockOccupancy(new Vector3i(-2, 5, 7)),
            new BlockOccupancy(new Vector3i(-2, 5, 8)),
            new BlockOccupancy(new Vector3i(-1, 0, -7)),
            new BlockOccupancy(new Vector3i(-1, 0, -6)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 3)),
            new BlockOccupancy(new Vector3i(-1, 0, 4)),
            new BlockOccupancy(new Vector3i(-1, 0, 5)),
            new BlockOccupancy(new Vector3i(-1, 0, 6)),
            new BlockOccupancy(new Vector3i(-1, 0, 7)),
            new BlockOccupancy(new Vector3i(-1, 0, 8)),
            new BlockOccupancy(new Vector3i(-1, 1, -7)),
            new BlockOccupancy(new Vector3i(-1, 1, -6)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 4)),
            new BlockOccupancy(new Vector3i(-1, 1, 5)),
            new BlockOccupancy(new Vector3i(-1, 1, 6)),
            new BlockOccupancy(new Vector3i(-1, 1, 7)),
            new BlockOccupancy(new Vector3i(-1, 1, 8)),
            new BlockOccupancy(new Vector3i(-1, 2, -7)),
            new BlockOccupancy(new Vector3i(-1, 2, -6)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 4)),
            new BlockOccupancy(new Vector3i(-1, 2, 5)),
            new BlockOccupancy(new Vector3i(-1, 2, 6)),
            new BlockOccupancy(new Vector3i(-1, 2, 7)),
            new BlockOccupancy(new Vector3i(-1, 2, 8)),
            new BlockOccupancy(new Vector3i(-1, 3, -7)),
            new BlockOccupancy(new Vector3i(-1, 3, -6)),
            new BlockOccupancy(new Vector3i(-1, 3, -5)),
            new BlockOccupancy(new Vector3i(-1, 3, -4)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 4)),
            new BlockOccupancy(new Vector3i(-1, 3, 5)),
            new BlockOccupancy(new Vector3i(-1, 3, 6)),
            new BlockOccupancy(new Vector3i(-1, 3, 7)),
            new BlockOccupancy(new Vector3i(-1, 3, 8)),
            new BlockOccupancy(new Vector3i(-1, 4, -7)),
            new BlockOccupancy(new Vector3i(-1, 4, -6)),
            new BlockOccupancy(new Vector3i(-1, 4, -5)),
            new BlockOccupancy(new Vector3i(-1, 4, -4)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, 2)),
            new BlockOccupancy(new Vector3i(-1, 4, 3)),
            new BlockOccupancy(new Vector3i(-1, 4, 4)),
            new BlockOccupancy(new Vector3i(-1, 4, 5)),
            new BlockOccupancy(new Vector3i(-1, 4, 6)),
            new BlockOccupancy(new Vector3i(-1, 4, 7)),
            new BlockOccupancy(new Vector3i(-1, 4, 8)),
            new BlockOccupancy(new Vector3i(-1, 5, -7)),
            new BlockOccupancy(new Vector3i(-1, 5, -6)),
            new BlockOccupancy(new Vector3i(-1, 5, -5)),
            new BlockOccupancy(new Vector3i(-1, 5, -4)),
            new BlockOccupancy(new Vector3i(-1, 5, -3)),
            new BlockOccupancy(new Vector3i(-1, 5, -2)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, 2)),
            new BlockOccupancy(new Vector3i(-1, 5, 3)),
            new BlockOccupancy(new Vector3i(-1, 5, 4)),
            new BlockOccupancy(new Vector3i(-1, 5, 5)),
            new BlockOccupancy(new Vector3i(-1, 5, 6)),
            new BlockOccupancy(new Vector3i(-1, 5, 7)),
            new BlockOccupancy(new Vector3i(-1, 5, 8)),
            new BlockOccupancy(new Vector3i(0, 0, -7)),
            new BlockOccupancy(new Vector3i(0, 0, -6)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 0, 4)),
            new BlockOccupancy(new Vector3i(0, 0, 5)),
            new BlockOccupancy(new Vector3i(0, 0, 6)),
            new BlockOccupancy(new Vector3i(0, 0, 7)),
            new BlockOccupancy(new Vector3i(0, 0, 8)),
            new BlockOccupancy(new Vector3i(0, 1, -7)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 1, 6)),
            new BlockOccupancy(new Vector3i(0, 1, 7)),
            new BlockOccupancy(new Vector3i(0, 1, 8)),
            new BlockOccupancy(new Vector3i(0, 2, -7)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 2, 6)),
            new BlockOccupancy(new Vector3i(0, 2, 7)),
            new BlockOccupancy(new Vector3i(0, 2, 8)),
            new BlockOccupancy(new Vector3i(0, 3, -7)),
            new BlockOccupancy(new Vector3i(0, 3, -6)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 3, 6)),
            new BlockOccupancy(new Vector3i(0, 3, 7)),
            new BlockOccupancy(new Vector3i(0, 3, 8)),
            new BlockOccupancy(new Vector3i(0, 4, -7)),
            new BlockOccupancy(new Vector3i(0, 4, -6)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 4, 5)),
            new BlockOccupancy(new Vector3i(0, 4, 6)),
            new BlockOccupancy(new Vector3i(0, 4, 7)),
            new BlockOccupancy(new Vector3i(0, 4, 8)),
            new BlockOccupancy(new Vector3i(0, 5, -7)),
            new BlockOccupancy(new Vector3i(0, 5, -6)),
            new BlockOccupancy(new Vector3i(0, 5, -5)),
            new BlockOccupancy(new Vector3i(0, 5, -4)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 5, 5)),
            new BlockOccupancy(new Vector3i(0, 5, 6)),
            new BlockOccupancy(new Vector3i(0, 5, 7)),
            new BlockOccupancy(new Vector3i(0, 5, 8)),
            new BlockOccupancy(new Vector3i(1, 0, -7)),
            new BlockOccupancy(new Vector3i(1, 0, -6)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 4)),
            new BlockOccupancy(new Vector3i(1, 0, 5)),
            new BlockOccupancy(new Vector3i(1, 0, 6)),
            new BlockOccupancy(new Vector3i(1, 0, 7)),
            new BlockOccupancy(new Vector3i(1, 0, 8)),
            new BlockOccupancy(new Vector3i(1, 1, -7)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 1, 6)),
            new BlockOccupancy(new Vector3i(1, 1, 7)),
            new BlockOccupancy(new Vector3i(1, 1, 8)),
            new BlockOccupancy(new Vector3i(1, 2, -7)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 2, 6)),
            new BlockOccupancy(new Vector3i(1, 2, 7)),
            new BlockOccupancy(new Vector3i(1, 2, 8)),
            new BlockOccupancy(new Vector3i(1, 3, -7)),
            new BlockOccupancy(new Vector3i(1, 3, -6)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 5)),
            new BlockOccupancy(new Vector3i(1, 3, 6)),
            new BlockOccupancy(new Vector3i(1, 3, 7)),
            new BlockOccupancy(new Vector3i(1, 3, 8)),
            new BlockOccupancy(new Vector3i(1, 4, -7)),
            new BlockOccupancy(new Vector3i(1, 4, -6)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 3)),
            new BlockOccupancy(new Vector3i(1, 4, 4)),
            new BlockOccupancy(new Vector3i(1, 4, 5)),
            new BlockOccupancy(new Vector3i(1, 4, 6)),
            new BlockOccupancy(new Vector3i(1, 4, 7)),
            new BlockOccupancy(new Vector3i(1, 4, 8)),
            new BlockOccupancy(new Vector3i(1, 5, -7)),
            new BlockOccupancy(new Vector3i(1, 5, -6)),
            new BlockOccupancy(new Vector3i(1, 5, -5)),
            new BlockOccupancy(new Vector3i(1, 5, -4)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 5, 2)),
            new BlockOccupancy(new Vector3i(1, 5, 3)),
            new BlockOccupancy(new Vector3i(1, 5, 4)),
            new BlockOccupancy(new Vector3i(1, 5, 5)),
            new BlockOccupancy(new Vector3i(1, 5, 6)),
            new BlockOccupancy(new Vector3i(1, 5, 7)),
            new BlockOccupancy(new Vector3i(1, 5, 8)),
            new BlockOccupancy(new Vector3i(2, 0, -7)),
            new BlockOccupancy(new Vector3i(2, 0, -6)),
            new BlockOccupancy(new Vector3i(2, 0, -5)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 4)),
            new BlockOccupancy(new Vector3i(2, 0, 5)),
            new BlockOccupancy(new Vector3i(2, 0, 6)),
            new BlockOccupancy(new Vector3i(2, 0, 7)),
            new BlockOccupancy(new Vector3i(2, 0, 8)),
            new BlockOccupancy(new Vector3i(2, 1, -7)),
            new BlockOccupancy(new Vector3i(2, 1, -6)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 5)),
            new BlockOccupancy(new Vector3i(2, 1, 6)),
            new BlockOccupancy(new Vector3i(2, 1, 7)),
            new BlockOccupancy(new Vector3i(2, 1, 8)),
            new BlockOccupancy(new Vector3i(2, 2, -7)),
            new BlockOccupancy(new Vector3i(2, 2, -6)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 5)),
            new BlockOccupancy(new Vector3i(2, 2, 6)),
            new BlockOccupancy(new Vector3i(2, 2, 7)),
            new BlockOccupancy(new Vector3i(2, 2, 8)),
            new BlockOccupancy(new Vector3i(2, 3, -7)),
            new BlockOccupancy(new Vector3i(2, 3, -6)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 5)),
            new BlockOccupancy(new Vector3i(2, 3, 6)),
            new BlockOccupancy(new Vector3i(2, 3, 7)),
            new BlockOccupancy(new Vector3i(2, 3, 8)),
            new BlockOccupancy(new Vector3i(2, 4, -7)),
            new BlockOccupancy(new Vector3i(2, 4, -6)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 3)),
            new BlockOccupancy(new Vector3i(2, 4, 4)),
            new BlockOccupancy(new Vector3i(2, 4, 5)),
            new BlockOccupancy(new Vector3i(2, 4, 6)),
            new BlockOccupancy(new Vector3i(2, 4, 7)),
            new BlockOccupancy(new Vector3i(2, 4, 8)),
            new BlockOccupancy(new Vector3i(2, 5, -7)),
            new BlockOccupancy(new Vector3i(2, 5, -6)),
            new BlockOccupancy(new Vector3i(2, 5, -5)),
            new BlockOccupancy(new Vector3i(2, 5, -4)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 5, 2)),
            new BlockOccupancy(new Vector3i(2, 5, 3)),
            new BlockOccupancy(new Vector3i(2, 5, 4)),
            new BlockOccupancy(new Vector3i(2, 5, 5)),
            new BlockOccupancy(new Vector3i(2, 5, 6)),
            new BlockOccupancy(new Vector3i(2, 5, 7)),
            new BlockOccupancy(new Vector3i(2, 5, 8)),
            new BlockOccupancy(new Vector3i(3, 0, -7)),
            new BlockOccupancy(new Vector3i(3, 0, -6)),
            new BlockOccupancy(new Vector3i(3, 0, -5)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 4)),
            new BlockOccupancy(new Vector3i(3, 0, 5)),
            new BlockOccupancy(new Vector3i(3, 0, 6)),
            new BlockOccupancy(new Vector3i(3, 0, 7)),
            new BlockOccupancy(new Vector3i(3, 0, 8)),
            new BlockOccupancy(new Vector3i(3, 1, -7)),
            new BlockOccupancy(new Vector3i(3, 1, -6)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 5)),
            new BlockOccupancy(new Vector3i(3, 1, 6)),
            new BlockOccupancy(new Vector3i(3, 1, 7)),
            new BlockOccupancy(new Vector3i(3, 1, 8)),
            new BlockOccupancy(new Vector3i(3, 2, -7)),
            new BlockOccupancy(new Vector3i(3, 2, -6)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 5)),
            new BlockOccupancy(new Vector3i(3, 2, 6)),
            new BlockOccupancy(new Vector3i(3, 2, 7)),
            new BlockOccupancy(new Vector3i(3, 2, 8)),
            new BlockOccupancy(new Vector3i(3, 3, -7)),
            new BlockOccupancy(new Vector3i(3, 3, -6)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 5)),
            new BlockOccupancy(new Vector3i(3, 3, 6)),
            new BlockOccupancy(new Vector3i(3, 3, 7)),
            new BlockOccupancy(new Vector3i(3, 3, 8)),
            new BlockOccupancy(new Vector3i(3, 4, -7)),
            new BlockOccupancy(new Vector3i(3, 4, -6)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 4, 2)),
            new BlockOccupancy(new Vector3i(3, 4, 3)),
            new BlockOccupancy(new Vector3i(3, 4, 4)),
            new BlockOccupancy(new Vector3i(3, 4, 5)),
            new BlockOccupancy(new Vector3i(3, 4, 6)),
            new BlockOccupancy(new Vector3i(3, 4, 7)),
            new BlockOccupancy(new Vector3i(3, 4, 8)),
            new BlockOccupancy(new Vector3i(3, 5, -7)),
            new BlockOccupancy(new Vector3i(3, 5, -6)),
            new BlockOccupancy(new Vector3i(3, 5, -5)),
            new BlockOccupancy(new Vector3i(3, 5, -4)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 5, 2)),
            new BlockOccupancy(new Vector3i(3, 5, 3)),
            new BlockOccupancy(new Vector3i(3, 5, 4)),
            new BlockOccupancy(new Vector3i(3, 5, 5)),
            new BlockOccupancy(new Vector3i(3, 5, 6)),
            new BlockOccupancy(new Vector3i(3, 5, 7)),
            new BlockOccupancy(new Vector3i(3, 5, 8)),
            new BlockOccupancy(new Vector3i(4, 0, -7)),
            new BlockOccupancy(new Vector3i(4, 0, -6)),
            new BlockOccupancy(new Vector3i(4, 0, -5)),
            new BlockOccupancy(new Vector3i(4, 0, -4)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 2)),
            new BlockOccupancy(new Vector3i(4, 0, 3)),
            new BlockOccupancy(new Vector3i(4, 0, 4)),
            new BlockOccupancy(new Vector3i(4, 0, 5)),
            new BlockOccupancy(new Vector3i(4, 0, 6)),
            new BlockOccupancy(new Vector3i(4, 0, 7)),
            new BlockOccupancy(new Vector3i(4, 0, 8)),
            new BlockOccupancy(new Vector3i(4, 1, -7)),
            new BlockOccupancy(new Vector3i(4, 1, -6)),
            new BlockOccupancy(new Vector3i(4, 1, -5)),
            new BlockOccupancy(new Vector3i(4, 1, -4)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 2)),
            new BlockOccupancy(new Vector3i(4, 1, 3)),
            new BlockOccupancy(new Vector3i(4, 1, 4)),
            new BlockOccupancy(new Vector3i(4, 1, 5)),
            new BlockOccupancy(new Vector3i(4, 1, 6)),
            new BlockOccupancy(new Vector3i(4, 1, 7)),
            new BlockOccupancy(new Vector3i(4, 1, 8)),
            new BlockOccupancy(new Vector3i(4, 2, -7)),
            new BlockOccupancy(new Vector3i(4, 2, -6)),
            new BlockOccupancy(new Vector3i(4, 2, -5)),
            new BlockOccupancy(new Vector3i(4, 2, -4)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 2)),
            new BlockOccupancy(new Vector3i(4, 2, 3)),
            new BlockOccupancy(new Vector3i(4, 2, 4)),
            new BlockOccupancy(new Vector3i(4, 2, 5)),
            new BlockOccupancy(new Vector3i(4, 2, 6)),
            new BlockOccupancy(new Vector3i(4, 2, 7)),
            new BlockOccupancy(new Vector3i(4, 2, 8)),
            new BlockOccupancy(new Vector3i(4, 3, -7)),
            new BlockOccupancy(new Vector3i(4, 3, -6)),
            new BlockOccupancy(new Vector3i(4, 3, -5)),
            new BlockOccupancy(new Vector3i(4, 3, -4)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 2)),
            new BlockOccupancy(new Vector3i(4, 3, 3)),
            new BlockOccupancy(new Vector3i(4, 3, 4)),
            new BlockOccupancy(new Vector3i(4, 3, 5)),
            new BlockOccupancy(new Vector3i(4, 3, 6)),
            new BlockOccupancy(new Vector3i(4, 3, 7)),
            new BlockOccupancy(new Vector3i(4, 3, 8)),
            new BlockOccupancy(new Vector3i(4, 4, -7)),
            new BlockOccupancy(new Vector3i(4, 4, -6)),
            new BlockOccupancy(new Vector3i(4, 4, -5)),
            new BlockOccupancy(new Vector3i(4, 4, -4)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 4, 1)),
            new BlockOccupancy(new Vector3i(4, 4, 2)),
            new BlockOccupancy(new Vector3i(4, 4, 3)),
            new BlockOccupancy(new Vector3i(4, 4, 4)),
            new BlockOccupancy(new Vector3i(4, 4, 5)),
            new BlockOccupancy(new Vector3i(4, 4, 6)),
            new BlockOccupancy(new Vector3i(4, 4, 7)),
            new BlockOccupancy(new Vector3i(4, 4, 8)),
            new BlockOccupancy(new Vector3i(4, 5, -7)),
            new BlockOccupancy(new Vector3i(4, 5, -6)),
            new BlockOccupancy(new Vector3i(4, 5, -5)),
            new BlockOccupancy(new Vector3i(4, 5, -4)),
            new BlockOccupancy(new Vector3i(4, 5, -3)),
            new BlockOccupancy(new Vector3i(4, 5, -2)),
            new BlockOccupancy(new Vector3i(4, 5, -1)),
            new BlockOccupancy(new Vector3i(4, 5, 0)),
            new BlockOccupancy(new Vector3i(4, 5, 1)),
            new BlockOccupancy(new Vector3i(4, 5, 2)),
            new BlockOccupancy(new Vector3i(4, 5, 3)),
            new BlockOccupancy(new Vector3i(4, 5, 4)),
            new BlockOccupancy(new Vector3i(4, 5, 5)),
            new BlockOccupancy(new Vector3i(4, 5, 6)),
            new BlockOccupancy(new Vector3i(4, 5, 7)),
            new BlockOccupancy(new Vector3i(4, 5, 8)),
            });
            // PlasticBuoyObject
            WorldObject.AddOccupancy<PlasticBuoyObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SteelBuoyObject
            WorldObject.AddOccupancy<SteelBuoyObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallCourtObject
            WorldObject.AddOccupancy<SmallCourtObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // IndustrialGeneratorObject
            WorldObject.AddOccupancy<IndustrialGeneratorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(2, 4, -6), typeof(PipeSlotBlock), new Quaternion(-0.7071068f, 0f, 0f, 0.7071068f), BlockOccupancyType.ChimneyOut),
            new BlockOccupancy(new Vector3i(0, 0, -6), typeof(PipeSlotBlock), new Quaternion(0f, -0.7071069f, 0f, 0.7071068f), BlockOccupancyType.SewageOutputPort),
            new BlockOccupancy(new Vector3i(0, 0, -4), typeof(PipeSlotBlock), new Quaternion(0f, 0.7071068f, 0f, -0.7071068f), BlockOccupancyType.WaterInputPort),
            new BlockOccupancy(new Vector3i(0, 0, -8)),
            new BlockOccupancy(new Vector3i(0, 0, -7)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -8)),
            new BlockOccupancy(new Vector3i(0, 1, -7)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, -8)),
            new BlockOccupancy(new Vector3i(0, 2, -7)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, -8)),
            new BlockOccupancy(new Vector3i(0, 3, -7)),
            new BlockOccupancy(new Vector3i(0, 3, -6)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, -8)),
            new BlockOccupancy(new Vector3i(0, 4, -7)),
            new BlockOccupancy(new Vector3i(0, 4, -6)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -8)),
            new BlockOccupancy(new Vector3i(1, 0, -7)),
            new BlockOccupancy(new Vector3i(1, 0, -6)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -8)),
            new BlockOccupancy(new Vector3i(1, 1, -7)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 2, -8)),
            new BlockOccupancy(new Vector3i(1, 2, -7)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 3, -8)),
            new BlockOccupancy(new Vector3i(1, 3, -7)),
            new BlockOccupancy(new Vector3i(1, 3, -6)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 4, -8)),
            new BlockOccupancy(new Vector3i(1, 4, -7)),
            new BlockOccupancy(new Vector3i(1, 4, -6)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -8)),
            new BlockOccupancy(new Vector3i(2, 0, -7)),
            new BlockOccupancy(new Vector3i(2, 0, -6)),
            new BlockOccupancy(new Vector3i(2, 0, -5)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, -8)),
            new BlockOccupancy(new Vector3i(2, 1, -7)),
            new BlockOccupancy(new Vector3i(2, 1, -6)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 2, -8)),
            new BlockOccupancy(new Vector3i(2, 2, -7)),
            new BlockOccupancy(new Vector3i(2, 2, -6)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 3, -8)),
            new BlockOccupancy(new Vector3i(2, 3, -7)),
            new BlockOccupancy(new Vector3i(2, 3, -6)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 4, -8)),
            new BlockOccupancy(new Vector3i(2, 4, -7)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 0, -8)),
            new BlockOccupancy(new Vector3i(3, 0, -7)),
            new BlockOccupancy(new Vector3i(3, 0, -6)),
            new BlockOccupancy(new Vector3i(3, 0, -5)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 1, -8)),
            new BlockOccupancy(new Vector3i(3, 1, -7)),
            new BlockOccupancy(new Vector3i(3, 1, -6)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 2, -8)),
            new BlockOccupancy(new Vector3i(3, 2, -7)),
            new BlockOccupancy(new Vector3i(3, 2, -6)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 3, -8)),
            new BlockOccupancy(new Vector3i(3, 3, -7)),
            new BlockOccupancy(new Vector3i(3, 3, -6)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 4, -8)),
            new BlockOccupancy(new Vector3i(3, 4, -7)),
            new BlockOccupancy(new Vector3i(3, 4, -6)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 0, -8)),
            new BlockOccupancy(new Vector3i(4, 0, -7)),
            new BlockOccupancy(new Vector3i(4, 0, -6)),
            new BlockOccupancy(new Vector3i(4, 0, -5)),
            new BlockOccupancy(new Vector3i(4, 0, -4)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 1, -8)),
            new BlockOccupancy(new Vector3i(4, 1, -7)),
            new BlockOccupancy(new Vector3i(4, 1, -6)),
            new BlockOccupancy(new Vector3i(4, 1, -5)),
            new BlockOccupancy(new Vector3i(4, 1, -4)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 2, -8)),
            new BlockOccupancy(new Vector3i(4, 2, -7)),
            new BlockOccupancy(new Vector3i(4, 2, -6)),
            new BlockOccupancy(new Vector3i(4, 2, -5)),
            new BlockOccupancy(new Vector3i(4, 2, -4)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 3, -8)),
            new BlockOccupancy(new Vector3i(4, 3, -7)),
            new BlockOccupancy(new Vector3i(4, 3, -6)),
            new BlockOccupancy(new Vector3i(4, 3, -5)),
            new BlockOccupancy(new Vector3i(4, 3, -4)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 4, -8)),
            new BlockOccupancy(new Vector3i(4, 4, -7)),
            new BlockOccupancy(new Vector3i(4, 4, -6)),
            new BlockOccupancy(new Vector3i(4, 4, -5)),
            new BlockOccupancy(new Vector3i(4, 4, -4)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            });
            // FiberScutchingStationObject
            WorldObject.AddOccupancy<FiberScutchingStationObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            });
            // OrnateGoldFrameTallObject
            WorldObject.AddOccupancy<OrnateGoldFrameTallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // OrnateGoldFrameWideObject
            WorldObject.AddOccupancy<OrnateGoldFrameWideObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // CopperFrameTallObject
            WorldObject.AddOccupancy<CopperFrameTallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // GoldFrameTallObject
            WorldObject.AddOccupancy<GoldFrameTallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // IronFrameTallObject
            WorldObject.AddOccupancy<IronFrameTallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WoodenFrameTallObject
            WorldObject.AddOccupancy<WoodenFrameTallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CopperFrameWideObject
            WorldObject.AddOccupancy<CopperFrameWideObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // GoldFrameWideObject
            WorldObject.AddOccupancy<GoldFrameWideObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // IronFrameWideObject
            WorldObject.AddOccupancy<IronFrameWideObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // OrnateIronFrameWideObject
            WorldObject.AddOccupancy<OrnateIronFrameWideObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // OrnateWoodenFrameWideObject
            WorldObject.AddOccupancy<OrnateWoodenFrameWideObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // WoodenFrameWideObject
            WorldObject.AddOccupancy<WoodenFrameWideObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // OrnateIronFrameTallObject
            WorldObject.AddOccupancy<OrnateIronFrameTallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // OrnateWoodenFrameTallObject
            WorldObject.AddOccupancy<OrnateWoodenFrameTallObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DecorativeShipWheelObject
            WorldObject.AddOccupancy<DecorativeShipWheelObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // DecorativeAnchorObject
            WorldObject.AddOccupancy<DecorativeAnchorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DecorativeGlassBuoyBlueObject
            WorldObject.AddOccupancy<DecorativeGlassBuoyBlueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DecorativeGlassBuoyGreenObject
            WorldObject.AddOccupancy<DecorativeGlassBuoyGreenObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DecorativeGlassBuoyRedObject
            WorldObject.AddOccupancy<DecorativeGlassBuoyRedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DecorativeGlassBuoyVioletObject
            WorldObject.AddOccupancy<DecorativeGlassBuoyVioletObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DecorativeGlassBuoyYellowObject
            WorldObject.AddOccupancy<DecorativeGlassBuoyYellowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // DecorativeHangingBuoyObject
            WorldObject.AddOccupancy<DecorativeHangingBuoyObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // FishRackObject
            WorldObject.AddOccupancy<FishRackObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            });
            // LargeCottonBuntingFestiveObject
            WorldObject.AddOccupancy<LargeCottonBuntingFestiveObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeCottonBuntingRedObject
            WorldObject.AddOccupancy<LargeCottonBuntingRedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeCottonBuntingRegalObject
            WorldObject.AddOccupancy<LargeCottonBuntingRegalObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeCottonBuntingVibrantObject
            WorldObject.AddOccupancy<LargeCottonBuntingVibrantObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeNylonBuntingGreenObject
            WorldObject.AddOccupancy<LargeNylonBuntingGreenObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeNylonBuntingPurpleObject
            WorldObject.AddOccupancy<LargeNylonBuntingPurpleObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeNylonBuntingYellowObject
            WorldObject.AddOccupancy<LargeNylonBuntingYellowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargePaperLanternObject
            WorldObject.AddOccupancy<LargePaperLanternObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallPaperLanternObject
            WorldObject.AddOccupancy<SmallPaperLanternObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CottonStreamerStripesObject
            WorldObject.AddOccupancy<CottonStreamerStripesObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-5, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CottonStreamerStarsObject
            WorldObject.AddOccupancy<CottonStreamerStarsObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-5, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeFestivePaperLanternObject
            WorldObject.AddOccupancy<LargeFestivePaperLanternObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, -1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // OutpostNettingObject
            WorldObject.AddOccupancy<OutpostNettingObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // EmbassyDeskObject
            WorldObject.AddOccupancy<EmbassyDeskObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // FederationFoundationObject
            WorldObject.AddOccupancy<FederationFoundationObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            });
            // TownFoundationObject
            WorldObject.AddOccupancy<TownFoundationObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // CountryFoundationObject
            WorldObject.AddOccupancy<CountryFoundationObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            });
            // TripodCameraObject
            WorldObject.AddOccupancy<TripodCameraObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // OutpostTableObject
            WorldObject.AddOccupancy<OutpostTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // IndustrialBargeObject
            WorldObject.AddOccupancy<IndustrialBargeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-4, 0, -16)),
            new BlockOccupancy(new Vector3i(-4, 0, -15)),
            new BlockOccupancy(new Vector3i(-4, 0, -14)),
            new BlockOccupancy(new Vector3i(-4, 0, -13)),
            new BlockOccupancy(new Vector3i(-4, 0, -12)),
            new BlockOccupancy(new Vector3i(-4, 0, -11)),
            new BlockOccupancy(new Vector3i(-4, 0, -10)),
            new BlockOccupancy(new Vector3i(-4, 0, -9)),
            new BlockOccupancy(new Vector3i(-4, 0, -8)),
            new BlockOccupancy(new Vector3i(-4, 0, -7)),
            new BlockOccupancy(new Vector3i(-4, 0, -6)),
            new BlockOccupancy(new Vector3i(-4, 0, -5)),
            new BlockOccupancy(new Vector3i(-4, 0, -4)),
            new BlockOccupancy(new Vector3i(-4, 0, -3)),
            new BlockOccupancy(new Vector3i(-4, 0, -2)),
            new BlockOccupancy(new Vector3i(-4, 0, -1)),
            new BlockOccupancy(new Vector3i(-4, 0, 0)),
            new BlockOccupancy(new Vector3i(-4, 0, 1)),
            new BlockOccupancy(new Vector3i(-4, 1, -16)),
            new BlockOccupancy(new Vector3i(-4, 1, -15)),
            new BlockOccupancy(new Vector3i(-4, 1, -14)),
            new BlockOccupancy(new Vector3i(-4, 1, -13)),
            new BlockOccupancy(new Vector3i(-4, 1, -12)),
            new BlockOccupancy(new Vector3i(-4, 1, -11)),
            new BlockOccupancy(new Vector3i(-4, 1, -10)),
            new BlockOccupancy(new Vector3i(-4, 1, -9)),
            new BlockOccupancy(new Vector3i(-4, 1, -8)),
            new BlockOccupancy(new Vector3i(-4, 1, -7)),
            new BlockOccupancy(new Vector3i(-4, 1, -6)),
            new BlockOccupancy(new Vector3i(-4, 1, -5)),
            new BlockOccupancy(new Vector3i(-4, 1, -4)),
            new BlockOccupancy(new Vector3i(-4, 1, -3)),
            new BlockOccupancy(new Vector3i(-4, 1, -2)),
            new BlockOccupancy(new Vector3i(-4, 1, -1)),
            new BlockOccupancy(new Vector3i(-4, 1, 0)),
            new BlockOccupancy(new Vector3i(-4, 1, 1)),
            new BlockOccupancy(new Vector3i(-4, 2, -16)),
            new BlockOccupancy(new Vector3i(-4, 2, -15)),
            new BlockOccupancy(new Vector3i(-4, 2, -14)),
            new BlockOccupancy(new Vector3i(-4, 2, -13)),
            new BlockOccupancy(new Vector3i(-4, 2, -12)),
            new BlockOccupancy(new Vector3i(-4, 2, -11)),
            new BlockOccupancy(new Vector3i(-4, 2, -10)),
            new BlockOccupancy(new Vector3i(-4, 2, -9)),
            new BlockOccupancy(new Vector3i(-4, 2, -8)),
            new BlockOccupancy(new Vector3i(-4, 2, -7)),
            new BlockOccupancy(new Vector3i(-4, 2, -6)),
            new BlockOccupancy(new Vector3i(-4, 2, -5)),
            new BlockOccupancy(new Vector3i(-4, 2, -4)),
            new BlockOccupancy(new Vector3i(-4, 2, -3)),
            new BlockOccupancy(new Vector3i(-4, 2, -2)),
            new BlockOccupancy(new Vector3i(-4, 2, -1)),
            new BlockOccupancy(new Vector3i(-4, 2, 0)),
            new BlockOccupancy(new Vector3i(-4, 2, 1)),
            new BlockOccupancy(new Vector3i(-4, 3, -16)),
            new BlockOccupancy(new Vector3i(-4, 3, -15)),
            new BlockOccupancy(new Vector3i(-4, 3, -14)),
            new BlockOccupancy(new Vector3i(-4, 3, -13)),
            new BlockOccupancy(new Vector3i(-4, 3, -12)),
            new BlockOccupancy(new Vector3i(-4, 3, -11)),
            new BlockOccupancy(new Vector3i(-4, 3, -10)),
            new BlockOccupancy(new Vector3i(-4, 3, -9)),
            new BlockOccupancy(new Vector3i(-4, 3, -8)),
            new BlockOccupancy(new Vector3i(-4, 3, -7)),
            new BlockOccupancy(new Vector3i(-4, 3, -6)),
            new BlockOccupancy(new Vector3i(-4, 3, -5)),
            new BlockOccupancy(new Vector3i(-4, 3, -4)),
            new BlockOccupancy(new Vector3i(-4, 3, -3)),
            new BlockOccupancy(new Vector3i(-4, 3, -2)),
            new BlockOccupancy(new Vector3i(-4, 3, -1)),
            new BlockOccupancy(new Vector3i(-4, 3, 0)),
            new BlockOccupancy(new Vector3i(-4, 3, 1)),
            new BlockOccupancy(new Vector3i(-4, 4, -16)),
            new BlockOccupancy(new Vector3i(-4, 4, -15)),
            new BlockOccupancy(new Vector3i(-4, 4, -14)),
            new BlockOccupancy(new Vector3i(-4, 4, -13)),
            new BlockOccupancy(new Vector3i(-4, 4, -12)),
            new BlockOccupancy(new Vector3i(-4, 4, -11)),
            new BlockOccupancy(new Vector3i(-4, 4, -10)),
            new BlockOccupancy(new Vector3i(-4, 4, -9)),
            new BlockOccupancy(new Vector3i(-4, 4, -8)),
            new BlockOccupancy(new Vector3i(-4, 4, -7)),
            new BlockOccupancy(new Vector3i(-4, 4, -6)),
            new BlockOccupancy(new Vector3i(-4, 4, -5)),
            new BlockOccupancy(new Vector3i(-4, 4, -4)),
            new BlockOccupancy(new Vector3i(-4, 4, -3)),
            new BlockOccupancy(new Vector3i(-4, 4, -2)),
            new BlockOccupancy(new Vector3i(-4, 4, -1)),
            new BlockOccupancy(new Vector3i(-4, 4, 0)),
            new BlockOccupancy(new Vector3i(-4, 4, 1)),
            new BlockOccupancy(new Vector3i(-4, 5, -16)),
            new BlockOccupancy(new Vector3i(-4, 5, -15)),
            new BlockOccupancy(new Vector3i(-4, 5, -14)),
            new BlockOccupancy(new Vector3i(-4, 5, -13)),
            new BlockOccupancy(new Vector3i(-4, 5, -12)),
            new BlockOccupancy(new Vector3i(-4, 5, -11)),
            new BlockOccupancy(new Vector3i(-4, 5, -10)),
            new BlockOccupancy(new Vector3i(-4, 5, -9)),
            new BlockOccupancy(new Vector3i(-4, 5, -8)),
            new BlockOccupancy(new Vector3i(-4, 5, -7)),
            new BlockOccupancy(new Vector3i(-4, 5, -6)),
            new BlockOccupancy(new Vector3i(-4, 5, -5)),
            new BlockOccupancy(new Vector3i(-4, 5, -4)),
            new BlockOccupancy(new Vector3i(-4, 5, -3)),
            new BlockOccupancy(new Vector3i(-4, 5, -2)),
            new BlockOccupancy(new Vector3i(-4, 5, -1)),
            new BlockOccupancy(new Vector3i(-4, 5, 0)),
            new BlockOccupancy(new Vector3i(-4, 5, 1)),
            new BlockOccupancy(new Vector3i(-3, 0, -16)),
            new BlockOccupancy(new Vector3i(-3, 0, -15)),
            new BlockOccupancy(new Vector3i(-3, 0, -14)),
            new BlockOccupancy(new Vector3i(-3, 0, -13)),
            new BlockOccupancy(new Vector3i(-3, 0, -12)),
            new BlockOccupancy(new Vector3i(-3, 0, -11)),
            new BlockOccupancy(new Vector3i(-3, 0, -10)),
            new BlockOccupancy(new Vector3i(-3, 0, -9)),
            new BlockOccupancy(new Vector3i(-3, 0, -8)),
            new BlockOccupancy(new Vector3i(-3, 0, -7)),
            new BlockOccupancy(new Vector3i(-3, 0, -6)),
            new BlockOccupancy(new Vector3i(-3, 0, -5)),
            new BlockOccupancy(new Vector3i(-3, 0, -4)),
            new BlockOccupancy(new Vector3i(-3, 0, -3)),
            new BlockOccupancy(new Vector3i(-3, 0, -2)),
            new BlockOccupancy(new Vector3i(-3, 0, -1)),
            new BlockOccupancy(new Vector3i(-3, 0, 0)),
            new BlockOccupancy(new Vector3i(-3, 0, 1)),
            new BlockOccupancy(new Vector3i(-3, 1, -16)),
            new BlockOccupancy(new Vector3i(-3, 1, -15)),
            new BlockOccupancy(new Vector3i(-3, 1, -14)),
            new BlockOccupancy(new Vector3i(-3, 1, -13)),
            new BlockOccupancy(new Vector3i(-3, 1, -12)),
            new BlockOccupancy(new Vector3i(-3, 1, -11)),
            new BlockOccupancy(new Vector3i(-3, 1, -10)),
            new BlockOccupancy(new Vector3i(-3, 1, -9)),
            new BlockOccupancy(new Vector3i(-3, 1, -8)),
            new BlockOccupancy(new Vector3i(-3, 1, -7)),
            new BlockOccupancy(new Vector3i(-3, 1, -6)),
            new BlockOccupancy(new Vector3i(-3, 1, -5)),
            new BlockOccupancy(new Vector3i(-3, 1, -4)),
            new BlockOccupancy(new Vector3i(-3, 1, -3)),
            new BlockOccupancy(new Vector3i(-3, 1, -2)),
            new BlockOccupancy(new Vector3i(-3, 1, -1)),
            new BlockOccupancy(new Vector3i(-3, 1, 0)),
            new BlockOccupancy(new Vector3i(-3, 1, 1)),
            new BlockOccupancy(new Vector3i(-3, 2, -16)),
            new BlockOccupancy(new Vector3i(-3, 2, -15)),
            new BlockOccupancy(new Vector3i(-3, 2, -14)),
            new BlockOccupancy(new Vector3i(-3, 2, -13)),
            new BlockOccupancy(new Vector3i(-3, 2, -12)),
            new BlockOccupancy(new Vector3i(-3, 2, -11)),
            new BlockOccupancy(new Vector3i(-3, 2, -10)),
            new BlockOccupancy(new Vector3i(-3, 2, -9)),
            new BlockOccupancy(new Vector3i(-3, 2, -8)),
            new BlockOccupancy(new Vector3i(-3, 2, -7)),
            new BlockOccupancy(new Vector3i(-3, 2, -6)),
            new BlockOccupancy(new Vector3i(-3, 2, -5)),
            new BlockOccupancy(new Vector3i(-3, 2, -4)),
            new BlockOccupancy(new Vector3i(-3, 2, -3)),
            new BlockOccupancy(new Vector3i(-3, 2, -2)),
            new BlockOccupancy(new Vector3i(-3, 2, -1)),
            new BlockOccupancy(new Vector3i(-3, 2, 0)),
            new BlockOccupancy(new Vector3i(-3, 2, 1)),
            new BlockOccupancy(new Vector3i(-3, 3, -16)),
            new BlockOccupancy(new Vector3i(-3, 3, -15)),
            new BlockOccupancy(new Vector3i(-3, 3, -14)),
            new BlockOccupancy(new Vector3i(-3, 3, -13)),
            new BlockOccupancy(new Vector3i(-3, 3, -12)),
            new BlockOccupancy(new Vector3i(-3, 3, -11)),
            new BlockOccupancy(new Vector3i(-3, 3, -10)),
            new BlockOccupancy(new Vector3i(-3, 3, -9)),
            new BlockOccupancy(new Vector3i(-3, 3, -8)),
            new BlockOccupancy(new Vector3i(-3, 3, -7)),
            new BlockOccupancy(new Vector3i(-3, 3, -6)),
            new BlockOccupancy(new Vector3i(-3, 3, -5)),
            new BlockOccupancy(new Vector3i(-3, 3, -4)),
            new BlockOccupancy(new Vector3i(-3, 3, -3)),
            new BlockOccupancy(new Vector3i(-3, 3, -2)),
            new BlockOccupancy(new Vector3i(-3, 3, -1)),
            new BlockOccupancy(new Vector3i(-3, 3, 0)),
            new BlockOccupancy(new Vector3i(-3, 3, 1)),
            new BlockOccupancy(new Vector3i(-3, 4, -16)),
            new BlockOccupancy(new Vector3i(-3, 4, -15)),
            new BlockOccupancy(new Vector3i(-3, 4, -14)),
            new BlockOccupancy(new Vector3i(-3, 4, -13)),
            new BlockOccupancy(new Vector3i(-3, 4, -12)),
            new BlockOccupancy(new Vector3i(-3, 4, -11)),
            new BlockOccupancy(new Vector3i(-3, 4, -10)),
            new BlockOccupancy(new Vector3i(-3, 4, -9)),
            new BlockOccupancy(new Vector3i(-3, 4, -8)),
            new BlockOccupancy(new Vector3i(-3, 4, -7)),
            new BlockOccupancy(new Vector3i(-3, 4, -6)),
            new BlockOccupancy(new Vector3i(-3, 4, -5)),
            new BlockOccupancy(new Vector3i(-3, 4, -4)),
            new BlockOccupancy(new Vector3i(-3, 4, -3)),
            new BlockOccupancy(new Vector3i(-3, 4, -2)),
            new BlockOccupancy(new Vector3i(-3, 4, -1)),
            new BlockOccupancy(new Vector3i(-3, 4, 0)),
            new BlockOccupancy(new Vector3i(-3, 4, 1)),
            new BlockOccupancy(new Vector3i(-3, 5, -16)),
            new BlockOccupancy(new Vector3i(-3, 5, -15)),
            new BlockOccupancy(new Vector3i(-3, 5, -14)),
            new BlockOccupancy(new Vector3i(-3, 5, -13)),
            new BlockOccupancy(new Vector3i(-3, 5, -12)),
            new BlockOccupancy(new Vector3i(-3, 5, -11)),
            new BlockOccupancy(new Vector3i(-3, 5, -10)),
            new BlockOccupancy(new Vector3i(-3, 5, -9)),
            new BlockOccupancy(new Vector3i(-3, 5, -8)),
            new BlockOccupancy(new Vector3i(-3, 5, -7)),
            new BlockOccupancy(new Vector3i(-3, 5, -6)),
            new BlockOccupancy(new Vector3i(-3, 5, -5)),
            new BlockOccupancy(new Vector3i(-3, 5, -4)),
            new BlockOccupancy(new Vector3i(-3, 5, -3)),
            new BlockOccupancy(new Vector3i(-3, 5, -2)),
            new BlockOccupancy(new Vector3i(-3, 5, -1)),
            new BlockOccupancy(new Vector3i(-3, 5, 0)),
            new BlockOccupancy(new Vector3i(-3, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 0, -16)),
            new BlockOccupancy(new Vector3i(-2, 0, -15)),
            new BlockOccupancy(new Vector3i(-2, 0, -14)),
            new BlockOccupancy(new Vector3i(-2, 0, -13)),
            new BlockOccupancy(new Vector3i(-2, 0, -12)),
            new BlockOccupancy(new Vector3i(-2, 0, -11)),
            new BlockOccupancy(new Vector3i(-2, 0, -10)),
            new BlockOccupancy(new Vector3i(-2, 0, -9)),
            new BlockOccupancy(new Vector3i(-2, 0, -8)),
            new BlockOccupancy(new Vector3i(-2, 0, -7)),
            new BlockOccupancy(new Vector3i(-2, 0, -6)),
            new BlockOccupancy(new Vector3i(-2, 0, -5)),
            new BlockOccupancy(new Vector3i(-2, 0, -4)),
            new BlockOccupancy(new Vector3i(-2, 0, -3)),
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, -16)),
            new BlockOccupancy(new Vector3i(-2, 1, -15)),
            new BlockOccupancy(new Vector3i(-2, 1, -14)),
            new BlockOccupancy(new Vector3i(-2, 1, -13)),
            new BlockOccupancy(new Vector3i(-2, 1, -12)),
            new BlockOccupancy(new Vector3i(-2, 1, -11)),
            new BlockOccupancy(new Vector3i(-2, 1, -10)),
            new BlockOccupancy(new Vector3i(-2, 1, -9)),
            new BlockOccupancy(new Vector3i(-2, 1, -8)),
            new BlockOccupancy(new Vector3i(-2, 1, -7)),
            new BlockOccupancy(new Vector3i(-2, 1, -6)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, -16)),
            new BlockOccupancy(new Vector3i(-2, 2, -15)),
            new BlockOccupancy(new Vector3i(-2, 2, -14)),
            new BlockOccupancy(new Vector3i(-2, 2, -13)),
            new BlockOccupancy(new Vector3i(-2, 2, -12)),
            new BlockOccupancy(new Vector3i(-2, 2, -11)),
            new BlockOccupancy(new Vector3i(-2, 2, -10)),
            new BlockOccupancy(new Vector3i(-2, 2, -9)),
            new BlockOccupancy(new Vector3i(-2, 2, -8)),
            new BlockOccupancy(new Vector3i(-2, 2, -7)),
            new BlockOccupancy(new Vector3i(-2, 2, -6)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, -16)),
            new BlockOccupancy(new Vector3i(-2, 3, -15)),
            new BlockOccupancy(new Vector3i(-2, 3, -14)),
            new BlockOccupancy(new Vector3i(-2, 3, -13)),
            new BlockOccupancy(new Vector3i(-2, 3, -12)),
            new BlockOccupancy(new Vector3i(-2, 3, -11)),
            new BlockOccupancy(new Vector3i(-2, 3, -10)),
            new BlockOccupancy(new Vector3i(-2, 3, -9)),
            new BlockOccupancy(new Vector3i(-2, 3, -8)),
            new BlockOccupancy(new Vector3i(-2, 3, -7)),
            new BlockOccupancy(new Vector3i(-2, 3, -6)),
            new BlockOccupancy(new Vector3i(-2, 3, -5)),
            new BlockOccupancy(new Vector3i(-2, 3, -4)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, -16)),
            new BlockOccupancy(new Vector3i(-2, 4, -15)),
            new BlockOccupancy(new Vector3i(-2, 4, -14)),
            new BlockOccupancy(new Vector3i(-2, 4, -13)),
            new BlockOccupancy(new Vector3i(-2, 4, -12)),
            new BlockOccupancy(new Vector3i(-2, 4, -11)),
            new BlockOccupancy(new Vector3i(-2, 4, -10)),
            new BlockOccupancy(new Vector3i(-2, 4, -9)),
            new BlockOccupancy(new Vector3i(-2, 4, -8)),
            new BlockOccupancy(new Vector3i(-2, 4, -7)),
            new BlockOccupancy(new Vector3i(-2, 4, -6)),
            new BlockOccupancy(new Vector3i(-2, 4, -5)),
            new BlockOccupancy(new Vector3i(-2, 4, -4)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, -16)),
            new BlockOccupancy(new Vector3i(-2, 5, -15)),
            new BlockOccupancy(new Vector3i(-2, 5, -14)),
            new BlockOccupancy(new Vector3i(-2, 5, -13)),
            new BlockOccupancy(new Vector3i(-2, 5, -12)),
            new BlockOccupancy(new Vector3i(-2, 5, -11)),
            new BlockOccupancy(new Vector3i(-2, 5, -10)),
            new BlockOccupancy(new Vector3i(-2, 5, -9)),
            new BlockOccupancy(new Vector3i(-2, 5, -8)),
            new BlockOccupancy(new Vector3i(-2, 5, -7)),
            new BlockOccupancy(new Vector3i(-2, 5, -6)),
            new BlockOccupancy(new Vector3i(-2, 5, -5)),
            new BlockOccupancy(new Vector3i(-2, 5, -4)),
            new BlockOccupancy(new Vector3i(-2, 5, -3)),
            new BlockOccupancy(new Vector3i(-2, 5, -2)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, -16)),
            new BlockOccupancy(new Vector3i(-1, 0, -15)),
            new BlockOccupancy(new Vector3i(-1, 0, -14)),
            new BlockOccupancy(new Vector3i(-1, 0, -13)),
            new BlockOccupancy(new Vector3i(-1, 0, -12)),
            new BlockOccupancy(new Vector3i(-1, 0, -11)),
            new BlockOccupancy(new Vector3i(-1, 0, -10)),
            new BlockOccupancy(new Vector3i(-1, 0, -9)),
            new BlockOccupancy(new Vector3i(-1, 0, -8)),
            new BlockOccupancy(new Vector3i(-1, 0, -7)),
            new BlockOccupancy(new Vector3i(-1, 0, -6)),
            new BlockOccupancy(new Vector3i(-1, 0, -5)),
            new BlockOccupancy(new Vector3i(-1, 0, -4)),
            new BlockOccupancy(new Vector3i(-1, 0, -3)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -16)),
            new BlockOccupancy(new Vector3i(-1, 1, -15)),
            new BlockOccupancy(new Vector3i(-1, 1, -14)),
            new BlockOccupancy(new Vector3i(-1, 1, -13)),
            new BlockOccupancy(new Vector3i(-1, 1, -12)),
            new BlockOccupancy(new Vector3i(-1, 1, -11)),
            new BlockOccupancy(new Vector3i(-1, 1, -10)),
            new BlockOccupancy(new Vector3i(-1, 1, -9)),
            new BlockOccupancy(new Vector3i(-1, 1, -8)),
            new BlockOccupancy(new Vector3i(-1, 1, -7)),
            new BlockOccupancy(new Vector3i(-1, 1, -6)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -16)),
            new BlockOccupancy(new Vector3i(-1, 2, -15)),
            new BlockOccupancy(new Vector3i(-1, 2, -14)),
            new BlockOccupancy(new Vector3i(-1, 2, -13)),
            new BlockOccupancy(new Vector3i(-1, 2, -12)),
            new BlockOccupancy(new Vector3i(-1, 2, -11)),
            new BlockOccupancy(new Vector3i(-1, 2, -10)),
            new BlockOccupancy(new Vector3i(-1, 2, -9)),
            new BlockOccupancy(new Vector3i(-1, 2, -8)),
            new BlockOccupancy(new Vector3i(-1, 2, -7)),
            new BlockOccupancy(new Vector3i(-1, 2, -6)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, -16)),
            new BlockOccupancy(new Vector3i(-1, 3, -15)),
            new BlockOccupancy(new Vector3i(-1, 3, -14)),
            new BlockOccupancy(new Vector3i(-1, 3, -13)),
            new BlockOccupancy(new Vector3i(-1, 3, -12)),
            new BlockOccupancy(new Vector3i(-1, 3, -11)),
            new BlockOccupancy(new Vector3i(-1, 3, -10)),
            new BlockOccupancy(new Vector3i(-1, 3, -9)),
            new BlockOccupancy(new Vector3i(-1, 3, -8)),
            new BlockOccupancy(new Vector3i(-1, 3, -7)),
            new BlockOccupancy(new Vector3i(-1, 3, -6)),
            new BlockOccupancy(new Vector3i(-1, 3, -5)),
            new BlockOccupancy(new Vector3i(-1, 3, -4)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, -16)),
            new BlockOccupancy(new Vector3i(-1, 4, -15)),
            new BlockOccupancy(new Vector3i(-1, 4, -14)),
            new BlockOccupancy(new Vector3i(-1, 4, -13)),
            new BlockOccupancy(new Vector3i(-1, 4, -12)),
            new BlockOccupancy(new Vector3i(-1, 4, -11)),
            new BlockOccupancy(new Vector3i(-1, 4, -10)),
            new BlockOccupancy(new Vector3i(-1, 4, -9)),
            new BlockOccupancy(new Vector3i(-1, 4, -8)),
            new BlockOccupancy(new Vector3i(-1, 4, -7)),
            new BlockOccupancy(new Vector3i(-1, 4, -6)),
            new BlockOccupancy(new Vector3i(-1, 4, -5)),
            new BlockOccupancy(new Vector3i(-1, 4, -4)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, -16)),
            new BlockOccupancy(new Vector3i(-1, 5, -15)),
            new BlockOccupancy(new Vector3i(-1, 5, -14)),
            new BlockOccupancy(new Vector3i(-1, 5, -13)),
            new BlockOccupancy(new Vector3i(-1, 5, -12)),
            new BlockOccupancy(new Vector3i(-1, 5, -11)),
            new BlockOccupancy(new Vector3i(-1, 5, -10)),
            new BlockOccupancy(new Vector3i(-1, 5, -9)),
            new BlockOccupancy(new Vector3i(-1, 5, -8)),
            new BlockOccupancy(new Vector3i(-1, 5, -7)),
            new BlockOccupancy(new Vector3i(-1, 5, -6)),
            new BlockOccupancy(new Vector3i(-1, 5, -5)),
            new BlockOccupancy(new Vector3i(-1, 5, -4)),
            new BlockOccupancy(new Vector3i(-1, 5, -3)),
            new BlockOccupancy(new Vector3i(-1, 5, -2)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -16)),
            new BlockOccupancy(new Vector3i(0, 0, -15)),
            new BlockOccupancy(new Vector3i(0, 0, -14)),
            new BlockOccupancy(new Vector3i(0, 0, -13)),
            new BlockOccupancy(new Vector3i(0, 0, -12)),
            new BlockOccupancy(new Vector3i(0, 0, -11)),
            new BlockOccupancy(new Vector3i(0, 0, -10)),
            new BlockOccupancy(new Vector3i(0, 0, -9)),
            new BlockOccupancy(new Vector3i(0, 0, -8)),
            new BlockOccupancy(new Vector3i(0, 0, -7)),
            new BlockOccupancy(new Vector3i(0, 0, -6)),
            new BlockOccupancy(new Vector3i(0, 0, -5)),
            new BlockOccupancy(new Vector3i(0, 0, -4)),
            new BlockOccupancy(new Vector3i(0, 0, -3)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -16)),
            new BlockOccupancy(new Vector3i(0, 1, -15)),
            new BlockOccupancy(new Vector3i(0, 1, -14)),
            new BlockOccupancy(new Vector3i(0, 1, -13)),
            new BlockOccupancy(new Vector3i(0, 1, -12)),
            new BlockOccupancy(new Vector3i(0, 1, -11)),
            new BlockOccupancy(new Vector3i(0, 1, -10)),
            new BlockOccupancy(new Vector3i(0, 1, -9)),
            new BlockOccupancy(new Vector3i(0, 1, -8)),
            new BlockOccupancy(new Vector3i(0, 1, -7)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -16)),
            new BlockOccupancy(new Vector3i(0, 2, -15)),
            new BlockOccupancy(new Vector3i(0, 2, -14)),
            new BlockOccupancy(new Vector3i(0, 2, -13)),
            new BlockOccupancy(new Vector3i(0, 2, -12)),
            new BlockOccupancy(new Vector3i(0, 2, -11)),
            new BlockOccupancy(new Vector3i(0, 2, -10)),
            new BlockOccupancy(new Vector3i(0, 2, -9)),
            new BlockOccupancy(new Vector3i(0, 2, -8)),
            new BlockOccupancy(new Vector3i(0, 2, -7)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, -16)),
            new BlockOccupancy(new Vector3i(0, 3, -15)),
            new BlockOccupancy(new Vector3i(0, 3, -14)),
            new BlockOccupancy(new Vector3i(0, 3, -13)),
            new BlockOccupancy(new Vector3i(0, 3, -12)),
            new BlockOccupancy(new Vector3i(0, 3, -11)),
            new BlockOccupancy(new Vector3i(0, 3, -10)),
            new BlockOccupancy(new Vector3i(0, 3, -9)),
            new BlockOccupancy(new Vector3i(0, 3, -8)),
            new BlockOccupancy(new Vector3i(0, 3, -7)),
            new BlockOccupancy(new Vector3i(0, 3, -6)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 4, -16)),
            new BlockOccupancy(new Vector3i(0, 4, -15)),
            new BlockOccupancy(new Vector3i(0, 4, -14)),
            new BlockOccupancy(new Vector3i(0, 4, -13)),
            new BlockOccupancy(new Vector3i(0, 4, -12)),
            new BlockOccupancy(new Vector3i(0, 4, -11)),
            new BlockOccupancy(new Vector3i(0, 4, -10)),
            new BlockOccupancy(new Vector3i(0, 4, -9)),
            new BlockOccupancy(new Vector3i(0, 4, -8)),
            new BlockOccupancy(new Vector3i(0, 4, -7)),
            new BlockOccupancy(new Vector3i(0, 4, -6)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 5, -16)),
            new BlockOccupancy(new Vector3i(0, 5, -15)),
            new BlockOccupancy(new Vector3i(0, 5, -14)),
            new BlockOccupancy(new Vector3i(0, 5, -13)),
            new BlockOccupancy(new Vector3i(0, 5, -12)),
            new BlockOccupancy(new Vector3i(0, 5, -11)),
            new BlockOccupancy(new Vector3i(0, 5, -10)),
            new BlockOccupancy(new Vector3i(0, 5, -9)),
            new BlockOccupancy(new Vector3i(0, 5, -8)),
            new BlockOccupancy(new Vector3i(0, 5, -7)),
            new BlockOccupancy(new Vector3i(0, 5, -6)),
            new BlockOccupancy(new Vector3i(0, 5, -5)),
            new BlockOccupancy(new Vector3i(0, 5, -4)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 0, -16)),
            new BlockOccupancy(new Vector3i(1, 0, -15)),
            new BlockOccupancy(new Vector3i(1, 0, -14)),
            new BlockOccupancy(new Vector3i(1, 0, -13)),
            new BlockOccupancy(new Vector3i(1, 0, -12)),
            new BlockOccupancy(new Vector3i(1, 0, -11)),
            new BlockOccupancy(new Vector3i(1, 0, -10)),
            new BlockOccupancy(new Vector3i(1, 0, -9)),
            new BlockOccupancy(new Vector3i(1, 0, -8)),
            new BlockOccupancy(new Vector3i(1, 0, -7)),
            new BlockOccupancy(new Vector3i(1, 0, -6)),
            new BlockOccupancy(new Vector3i(1, 0, -5)),
            new BlockOccupancy(new Vector3i(1, 0, -4)),
            new BlockOccupancy(new Vector3i(1, 0, -3)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, -16)),
            new BlockOccupancy(new Vector3i(1, 1, -15)),
            new BlockOccupancy(new Vector3i(1, 1, -14)),
            new BlockOccupancy(new Vector3i(1, 1, -13)),
            new BlockOccupancy(new Vector3i(1, 1, -12)),
            new BlockOccupancy(new Vector3i(1, 1, -11)),
            new BlockOccupancy(new Vector3i(1, 1, -10)),
            new BlockOccupancy(new Vector3i(1, 1, -9)),
            new BlockOccupancy(new Vector3i(1, 1, -8)),
            new BlockOccupancy(new Vector3i(1, 1, -7)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, -16)),
            new BlockOccupancy(new Vector3i(1, 2, -15)),
            new BlockOccupancy(new Vector3i(1, 2, -14)),
            new BlockOccupancy(new Vector3i(1, 2, -13)),
            new BlockOccupancy(new Vector3i(1, 2, -12)),
            new BlockOccupancy(new Vector3i(1, 2, -11)),
            new BlockOccupancy(new Vector3i(1, 2, -10)),
            new BlockOccupancy(new Vector3i(1, 2, -9)),
            new BlockOccupancy(new Vector3i(1, 2, -8)),
            new BlockOccupancy(new Vector3i(1, 2, -7)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 3, -16)),
            new BlockOccupancy(new Vector3i(1, 3, -15)),
            new BlockOccupancy(new Vector3i(1, 3, -14)),
            new BlockOccupancy(new Vector3i(1, 3, -13)),
            new BlockOccupancy(new Vector3i(1, 3, -12)),
            new BlockOccupancy(new Vector3i(1, 3, -11)),
            new BlockOccupancy(new Vector3i(1, 3, -10)),
            new BlockOccupancy(new Vector3i(1, 3, -9)),
            new BlockOccupancy(new Vector3i(1, 3, -8)),
            new BlockOccupancy(new Vector3i(1, 3, -7)),
            new BlockOccupancy(new Vector3i(1, 3, -6)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 4, -16)),
            new BlockOccupancy(new Vector3i(1, 4, -15)),
            new BlockOccupancy(new Vector3i(1, 4, -14)),
            new BlockOccupancy(new Vector3i(1, 4, -13)),
            new BlockOccupancy(new Vector3i(1, 4, -12)),
            new BlockOccupancy(new Vector3i(1, 4, -11)),
            new BlockOccupancy(new Vector3i(1, 4, -10)),
            new BlockOccupancy(new Vector3i(1, 4, -9)),
            new BlockOccupancy(new Vector3i(1, 4, -8)),
            new BlockOccupancy(new Vector3i(1, 4, -7)),
            new BlockOccupancy(new Vector3i(1, 4, -6)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 5, -16)),
            new BlockOccupancy(new Vector3i(1, 5, -15)),
            new BlockOccupancy(new Vector3i(1, 5, -14)),
            new BlockOccupancy(new Vector3i(1, 5, -13)),
            new BlockOccupancy(new Vector3i(1, 5, -12)),
            new BlockOccupancy(new Vector3i(1, 5, -11)),
            new BlockOccupancy(new Vector3i(1, 5, -10)),
            new BlockOccupancy(new Vector3i(1, 5, -9)),
            new BlockOccupancy(new Vector3i(1, 5, -8)),
            new BlockOccupancy(new Vector3i(1, 5, -7)),
            new BlockOccupancy(new Vector3i(1, 5, -6)),
            new BlockOccupancy(new Vector3i(1, 5, -5)),
            new BlockOccupancy(new Vector3i(1, 5, -4)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 0, -16)),
            new BlockOccupancy(new Vector3i(2, 0, -15)),
            new BlockOccupancy(new Vector3i(2, 0, -14)),
            new BlockOccupancy(new Vector3i(2, 0, -13)),
            new BlockOccupancy(new Vector3i(2, 0, -12)),
            new BlockOccupancy(new Vector3i(2, 0, -11)),
            new BlockOccupancy(new Vector3i(2, 0, -10)),
            new BlockOccupancy(new Vector3i(2, 0, -9)),
            new BlockOccupancy(new Vector3i(2, 0, -8)),
            new BlockOccupancy(new Vector3i(2, 0, -7)),
            new BlockOccupancy(new Vector3i(2, 0, -6)),
            new BlockOccupancy(new Vector3i(2, 0, -5)),
            new BlockOccupancy(new Vector3i(2, 0, -4)),
            new BlockOccupancy(new Vector3i(2, 0, -3)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, -16)),
            new BlockOccupancy(new Vector3i(2, 1, -15)),
            new BlockOccupancy(new Vector3i(2, 1, -14)),
            new BlockOccupancy(new Vector3i(2, 1, -13)),
            new BlockOccupancy(new Vector3i(2, 1, -12)),
            new BlockOccupancy(new Vector3i(2, 1, -11)),
            new BlockOccupancy(new Vector3i(2, 1, -10)),
            new BlockOccupancy(new Vector3i(2, 1, -9)),
            new BlockOccupancy(new Vector3i(2, 1, -8)),
            new BlockOccupancy(new Vector3i(2, 1, -7)),
            new BlockOccupancy(new Vector3i(2, 1, -6)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 2, -16)),
            new BlockOccupancy(new Vector3i(2, 2, -15)),
            new BlockOccupancy(new Vector3i(2, 2, -14)),
            new BlockOccupancy(new Vector3i(2, 2, -13)),
            new BlockOccupancy(new Vector3i(2, 2, -12)),
            new BlockOccupancy(new Vector3i(2, 2, -11)),
            new BlockOccupancy(new Vector3i(2, 2, -10)),
            new BlockOccupancy(new Vector3i(2, 2, -9)),
            new BlockOccupancy(new Vector3i(2, 2, -8)),
            new BlockOccupancy(new Vector3i(2, 2, -7)),
            new BlockOccupancy(new Vector3i(2, 2, -6)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 3, -16)),
            new BlockOccupancy(new Vector3i(2, 3, -15)),
            new BlockOccupancy(new Vector3i(2, 3, -14)),
            new BlockOccupancy(new Vector3i(2, 3, -13)),
            new BlockOccupancy(new Vector3i(2, 3, -12)),
            new BlockOccupancy(new Vector3i(2, 3, -11)),
            new BlockOccupancy(new Vector3i(2, 3, -10)),
            new BlockOccupancy(new Vector3i(2, 3, -9)),
            new BlockOccupancy(new Vector3i(2, 3, -8)),
            new BlockOccupancy(new Vector3i(2, 3, -7)),
            new BlockOccupancy(new Vector3i(2, 3, -6)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 4, -16)),
            new BlockOccupancy(new Vector3i(2, 4, -15)),
            new BlockOccupancy(new Vector3i(2, 4, -14)),
            new BlockOccupancy(new Vector3i(2, 4, -13)),
            new BlockOccupancy(new Vector3i(2, 4, -12)),
            new BlockOccupancy(new Vector3i(2, 4, -11)),
            new BlockOccupancy(new Vector3i(2, 4, -10)),
            new BlockOccupancy(new Vector3i(2, 4, -9)),
            new BlockOccupancy(new Vector3i(2, 4, -8)),
            new BlockOccupancy(new Vector3i(2, 4, -7)),
            new BlockOccupancy(new Vector3i(2, 4, -6)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 5, -16)),
            new BlockOccupancy(new Vector3i(2, 5, -15)),
            new BlockOccupancy(new Vector3i(2, 5, -14)),
            new BlockOccupancy(new Vector3i(2, 5, -13)),
            new BlockOccupancy(new Vector3i(2, 5, -12)),
            new BlockOccupancy(new Vector3i(2, 5, -11)),
            new BlockOccupancy(new Vector3i(2, 5, -10)),
            new BlockOccupancy(new Vector3i(2, 5, -9)),
            new BlockOccupancy(new Vector3i(2, 5, -8)),
            new BlockOccupancy(new Vector3i(2, 5, -7)),
            new BlockOccupancy(new Vector3i(2, 5, -6)),
            new BlockOccupancy(new Vector3i(2, 5, -5)),
            new BlockOccupancy(new Vector3i(2, 5, -4)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 0, -16)),
            new BlockOccupancy(new Vector3i(3, 0, -15)),
            new BlockOccupancy(new Vector3i(3, 0, -14)),
            new BlockOccupancy(new Vector3i(3, 0, -13)),
            new BlockOccupancy(new Vector3i(3, 0, -12)),
            new BlockOccupancy(new Vector3i(3, 0, -11)),
            new BlockOccupancy(new Vector3i(3, 0, -10)),
            new BlockOccupancy(new Vector3i(3, 0, -9)),
            new BlockOccupancy(new Vector3i(3, 0, -8)),
            new BlockOccupancy(new Vector3i(3, 0, -7)),
            new BlockOccupancy(new Vector3i(3, 0, -6)),
            new BlockOccupancy(new Vector3i(3, 0, -5)),
            new BlockOccupancy(new Vector3i(3, 0, -4)),
            new BlockOccupancy(new Vector3i(3, 0, -3)),
            new BlockOccupancy(new Vector3i(3, 0, -2)),
            new BlockOccupancy(new Vector3i(3, 0, -1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 1, -16)),
            new BlockOccupancy(new Vector3i(3, 1, -15)),
            new BlockOccupancy(new Vector3i(3, 1, -14)),
            new BlockOccupancy(new Vector3i(3, 1, -13)),
            new BlockOccupancy(new Vector3i(3, 1, -12)),
            new BlockOccupancy(new Vector3i(3, 1, -11)),
            new BlockOccupancy(new Vector3i(3, 1, -10)),
            new BlockOccupancy(new Vector3i(3, 1, -9)),
            new BlockOccupancy(new Vector3i(3, 1, -8)),
            new BlockOccupancy(new Vector3i(3, 1, -7)),
            new BlockOccupancy(new Vector3i(3, 1, -6)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 2, -16)),
            new BlockOccupancy(new Vector3i(3, 2, -15)),
            new BlockOccupancy(new Vector3i(3, 2, -14)),
            new BlockOccupancy(new Vector3i(3, 2, -13)),
            new BlockOccupancy(new Vector3i(3, 2, -12)),
            new BlockOccupancy(new Vector3i(3, 2, -11)),
            new BlockOccupancy(new Vector3i(3, 2, -10)),
            new BlockOccupancy(new Vector3i(3, 2, -9)),
            new BlockOccupancy(new Vector3i(3, 2, -8)),
            new BlockOccupancy(new Vector3i(3, 2, -7)),
            new BlockOccupancy(new Vector3i(3, 2, -6)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 3, -16)),
            new BlockOccupancy(new Vector3i(3, 3, -15)),
            new BlockOccupancy(new Vector3i(3, 3, -14)),
            new BlockOccupancy(new Vector3i(3, 3, -13)),
            new BlockOccupancy(new Vector3i(3, 3, -12)),
            new BlockOccupancy(new Vector3i(3, 3, -11)),
            new BlockOccupancy(new Vector3i(3, 3, -10)),
            new BlockOccupancy(new Vector3i(3, 3, -9)),
            new BlockOccupancy(new Vector3i(3, 3, -8)),
            new BlockOccupancy(new Vector3i(3, 3, -7)),
            new BlockOccupancy(new Vector3i(3, 3, -6)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 4, -16)),
            new BlockOccupancy(new Vector3i(3, 4, -15)),
            new BlockOccupancy(new Vector3i(3, 4, -14)),
            new BlockOccupancy(new Vector3i(3, 4, -13)),
            new BlockOccupancy(new Vector3i(3, 4, -12)),
            new BlockOccupancy(new Vector3i(3, 4, -11)),
            new BlockOccupancy(new Vector3i(3, 4, -10)),
            new BlockOccupancy(new Vector3i(3, 4, -9)),
            new BlockOccupancy(new Vector3i(3, 4, -8)),
            new BlockOccupancy(new Vector3i(3, 4, -7)),
            new BlockOccupancy(new Vector3i(3, 4, -6)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 5, -16)),
            new BlockOccupancy(new Vector3i(3, 5, -15)),
            new BlockOccupancy(new Vector3i(3, 5, -14)),
            new BlockOccupancy(new Vector3i(3, 5, -13)),
            new BlockOccupancy(new Vector3i(3, 5, -12)),
            new BlockOccupancy(new Vector3i(3, 5, -11)),
            new BlockOccupancy(new Vector3i(3, 5, -10)),
            new BlockOccupancy(new Vector3i(3, 5, -9)),
            new BlockOccupancy(new Vector3i(3, 5, -8)),
            new BlockOccupancy(new Vector3i(3, 5, -7)),
            new BlockOccupancy(new Vector3i(3, 5, -6)),
            new BlockOccupancy(new Vector3i(3, 5, -5)),
            new BlockOccupancy(new Vector3i(3, 5, -4)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(4, 0, -16)),
            new BlockOccupancy(new Vector3i(4, 0, -15)),
            new BlockOccupancy(new Vector3i(4, 0, -14)),
            new BlockOccupancy(new Vector3i(4, 0, -13)),
            new BlockOccupancy(new Vector3i(4, 0, -12)),
            new BlockOccupancy(new Vector3i(4, 0, -11)),
            new BlockOccupancy(new Vector3i(4, 0, -10)),
            new BlockOccupancy(new Vector3i(4, 0, -9)),
            new BlockOccupancy(new Vector3i(4, 0, -8)),
            new BlockOccupancy(new Vector3i(4, 0, -7)),
            new BlockOccupancy(new Vector3i(4, 0, -6)),
            new BlockOccupancy(new Vector3i(4, 0, -5)),
            new BlockOccupancy(new Vector3i(4, 0, -4)),
            new BlockOccupancy(new Vector3i(4, 0, -3)),
            new BlockOccupancy(new Vector3i(4, 0, -2)),
            new BlockOccupancy(new Vector3i(4, 0, -1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 1, -16)),
            new BlockOccupancy(new Vector3i(4, 1, -15)),
            new BlockOccupancy(new Vector3i(4, 1, -14)),
            new BlockOccupancy(new Vector3i(4, 1, -13)),
            new BlockOccupancy(new Vector3i(4, 1, -12)),
            new BlockOccupancy(new Vector3i(4, 1, -11)),
            new BlockOccupancy(new Vector3i(4, 1, -10)),
            new BlockOccupancy(new Vector3i(4, 1, -9)),
            new BlockOccupancy(new Vector3i(4, 1, -8)),
            new BlockOccupancy(new Vector3i(4, 1, -7)),
            new BlockOccupancy(new Vector3i(4, 1, -6)),
            new BlockOccupancy(new Vector3i(4, 1, -5)),
            new BlockOccupancy(new Vector3i(4, 1, -4)),
            new BlockOccupancy(new Vector3i(4, 1, -3)),
            new BlockOccupancy(new Vector3i(4, 1, -2)),
            new BlockOccupancy(new Vector3i(4, 1, -1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 2, -16)),
            new BlockOccupancy(new Vector3i(4, 2, -15)),
            new BlockOccupancy(new Vector3i(4, 2, -14)),
            new BlockOccupancy(new Vector3i(4, 2, -13)),
            new BlockOccupancy(new Vector3i(4, 2, -12)),
            new BlockOccupancy(new Vector3i(4, 2, -11)),
            new BlockOccupancy(new Vector3i(4, 2, -10)),
            new BlockOccupancy(new Vector3i(4, 2, -9)),
            new BlockOccupancy(new Vector3i(4, 2, -8)),
            new BlockOccupancy(new Vector3i(4, 2, -7)),
            new BlockOccupancy(new Vector3i(4, 2, -6)),
            new BlockOccupancy(new Vector3i(4, 2, -5)),
            new BlockOccupancy(new Vector3i(4, 2, -4)),
            new BlockOccupancy(new Vector3i(4, 2, -3)),
            new BlockOccupancy(new Vector3i(4, 2, -2)),
            new BlockOccupancy(new Vector3i(4, 2, -1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 3, -16)),
            new BlockOccupancy(new Vector3i(4, 3, -15)),
            new BlockOccupancy(new Vector3i(4, 3, -14)),
            new BlockOccupancy(new Vector3i(4, 3, -13)),
            new BlockOccupancy(new Vector3i(4, 3, -12)),
            new BlockOccupancy(new Vector3i(4, 3, -11)),
            new BlockOccupancy(new Vector3i(4, 3, -10)),
            new BlockOccupancy(new Vector3i(4, 3, -9)),
            new BlockOccupancy(new Vector3i(4, 3, -8)),
            new BlockOccupancy(new Vector3i(4, 3, -7)),
            new BlockOccupancy(new Vector3i(4, 3, -6)),
            new BlockOccupancy(new Vector3i(4, 3, -5)),
            new BlockOccupancy(new Vector3i(4, 3, -4)),
            new BlockOccupancy(new Vector3i(4, 3, -3)),
            new BlockOccupancy(new Vector3i(4, 3, -2)),
            new BlockOccupancy(new Vector3i(4, 3, -1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 4, -16)),
            new BlockOccupancy(new Vector3i(4, 4, -15)),
            new BlockOccupancy(new Vector3i(4, 4, -14)),
            new BlockOccupancy(new Vector3i(4, 4, -13)),
            new BlockOccupancy(new Vector3i(4, 4, -12)),
            new BlockOccupancy(new Vector3i(4, 4, -11)),
            new BlockOccupancy(new Vector3i(4, 4, -10)),
            new BlockOccupancy(new Vector3i(4, 4, -9)),
            new BlockOccupancy(new Vector3i(4, 4, -8)),
            new BlockOccupancy(new Vector3i(4, 4, -7)),
            new BlockOccupancy(new Vector3i(4, 4, -6)),
            new BlockOccupancy(new Vector3i(4, 4, -5)),
            new BlockOccupancy(new Vector3i(4, 4, -4)),
            new BlockOccupancy(new Vector3i(4, 4, -3)),
            new BlockOccupancy(new Vector3i(4, 4, -2)),
            new BlockOccupancy(new Vector3i(4, 4, -1)),
            new BlockOccupancy(new Vector3i(4, 4, 0)),
            new BlockOccupancy(new Vector3i(4, 4, 1)),
            new BlockOccupancy(new Vector3i(4, 5, -16)),
            new BlockOccupancy(new Vector3i(4, 5, -15)),
            new BlockOccupancy(new Vector3i(4, 5, -14)),
            new BlockOccupancy(new Vector3i(4, 5, -13)),
            new BlockOccupancy(new Vector3i(4, 5, -12)),
            new BlockOccupancy(new Vector3i(4, 5, -11)),
            new BlockOccupancy(new Vector3i(4, 5, -10)),
            new BlockOccupancy(new Vector3i(4, 5, -9)),
            new BlockOccupancy(new Vector3i(4, 5, -8)),
            new BlockOccupancy(new Vector3i(4, 5, -7)),
            new BlockOccupancy(new Vector3i(4, 5, -6)),
            new BlockOccupancy(new Vector3i(4, 5, -5)),
            new BlockOccupancy(new Vector3i(4, 5, -4)),
            new BlockOccupancy(new Vector3i(4, 5, -3)),
            new BlockOccupancy(new Vector3i(4, 5, -2)),
            new BlockOccupancy(new Vector3i(4, 5, -1)),
            new BlockOccupancy(new Vector3i(4, 5, 0)),
            new BlockOccupancy(new Vector3i(4, 5, 1)),
            });
            // LargeCanoeObject
            WorldObject.AddOccupancy<LargeCanoeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            });
            // MediumFishingTrawlerObject
            WorldObject.AddOccupancy<MediumFishingTrawlerObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 1, -8)),
            new BlockOccupancy(new Vector3i(-2, 1, -7)),
            new BlockOccupancy(new Vector3i(-2, 1, -6)),
            new BlockOccupancy(new Vector3i(-2, 1, -5)),
            new BlockOccupancy(new Vector3i(-2, 1, -4)),
            new BlockOccupancy(new Vector3i(-2, 1, -3)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 2)),
            new BlockOccupancy(new Vector3i(-2, 1, 3)),
            new BlockOccupancy(new Vector3i(-2, 1, 4)),
            new BlockOccupancy(new Vector3i(-2, 1, 5)),
            new BlockOccupancy(new Vector3i(-2, 2, -8)),
            new BlockOccupancy(new Vector3i(-2, 2, -7)),
            new BlockOccupancy(new Vector3i(-2, 2, -6)),
            new BlockOccupancy(new Vector3i(-2, 2, -5)),
            new BlockOccupancy(new Vector3i(-2, 2, -4)),
            new BlockOccupancy(new Vector3i(-2, 2, -3)),
            new BlockOccupancy(new Vector3i(-2, 2, -2)),
            new BlockOccupancy(new Vector3i(-2, 2, -1)),
            new BlockOccupancy(new Vector3i(-2, 2, 0)),
            new BlockOccupancy(new Vector3i(-2, 2, 1)),
            new BlockOccupancy(new Vector3i(-2, 2, 2)),
            new BlockOccupancy(new Vector3i(-2, 2, 3)),
            new BlockOccupancy(new Vector3i(-2, 2, 4)),
            new BlockOccupancy(new Vector3i(-2, 2, 5)),
            new BlockOccupancy(new Vector3i(-2, 3, -8)),
            new BlockOccupancy(new Vector3i(-2, 3, -7)),
            new BlockOccupancy(new Vector3i(-2, 3, -6)),
            new BlockOccupancy(new Vector3i(-2, 3, -5)),
            new BlockOccupancy(new Vector3i(-2, 3, -4)),
            new BlockOccupancy(new Vector3i(-2, 3, -3)),
            new BlockOccupancy(new Vector3i(-2, 3, -2)),
            new BlockOccupancy(new Vector3i(-2, 3, -1)),
            new BlockOccupancy(new Vector3i(-2, 3, 0)),
            new BlockOccupancy(new Vector3i(-2, 3, 1)),
            new BlockOccupancy(new Vector3i(-2, 3, 2)),
            new BlockOccupancy(new Vector3i(-2, 3, 3)),
            new BlockOccupancy(new Vector3i(-2, 3, 4)),
            new BlockOccupancy(new Vector3i(-2, 3, 5)),
            new BlockOccupancy(new Vector3i(-2, 4, -8)),
            new BlockOccupancy(new Vector3i(-2, 4, -7)),
            new BlockOccupancy(new Vector3i(-2, 4, -6)),
            new BlockOccupancy(new Vector3i(-2, 4, -5)),
            new BlockOccupancy(new Vector3i(-2, 4, -4)),
            new BlockOccupancy(new Vector3i(-2, 4, -3)),
            new BlockOccupancy(new Vector3i(-2, 4, -2)),
            new BlockOccupancy(new Vector3i(-2, 4, -1)),
            new BlockOccupancy(new Vector3i(-2, 4, 0)),
            new BlockOccupancy(new Vector3i(-2, 4, 1)),
            new BlockOccupancy(new Vector3i(-2, 4, 2)),
            new BlockOccupancy(new Vector3i(-2, 4, 3)),
            new BlockOccupancy(new Vector3i(-2, 4, 4)),
            new BlockOccupancy(new Vector3i(-2, 4, 5)),
            new BlockOccupancy(new Vector3i(-2, 5, -8)),
            new BlockOccupancy(new Vector3i(-2, 5, -7)),
            new BlockOccupancy(new Vector3i(-2, 5, -6)),
            new BlockOccupancy(new Vector3i(-2, 5, -5)),
            new BlockOccupancy(new Vector3i(-2, 5, -4)),
            new BlockOccupancy(new Vector3i(-2, 5, -3)),
            new BlockOccupancy(new Vector3i(-2, 5, -2)),
            new BlockOccupancy(new Vector3i(-2, 5, -1)),
            new BlockOccupancy(new Vector3i(-2, 5, 0)),
            new BlockOccupancy(new Vector3i(-2, 5, 1)),
            new BlockOccupancy(new Vector3i(-2, 5, 2)),
            new BlockOccupancy(new Vector3i(-2, 5, 3)),
            new BlockOccupancy(new Vector3i(-2, 5, 4)),
            new BlockOccupancy(new Vector3i(-2, 5, 5)),
            new BlockOccupancy(new Vector3i(-2, 6, -8)),
            new BlockOccupancy(new Vector3i(-2, 6, -7)),
            new BlockOccupancy(new Vector3i(-2, 6, -6)),
            new BlockOccupancy(new Vector3i(-2, 6, -5)),
            new BlockOccupancy(new Vector3i(-2, 6, -4)),
            new BlockOccupancy(new Vector3i(-2, 6, -3)),
            new BlockOccupancy(new Vector3i(-2, 6, -2)),
            new BlockOccupancy(new Vector3i(-2, 6, -1)),
            new BlockOccupancy(new Vector3i(-2, 6, 0)),
            new BlockOccupancy(new Vector3i(-2, 6, 1)),
            new BlockOccupancy(new Vector3i(-2, 6, 2)),
            new BlockOccupancy(new Vector3i(-2, 6, 3)),
            new BlockOccupancy(new Vector3i(-2, 6, 4)),
            new BlockOccupancy(new Vector3i(-2, 6, 5)),
            new BlockOccupancy(new Vector3i(-2, 7, -8)),
            new BlockOccupancy(new Vector3i(-2, 7, -7)),
            new BlockOccupancy(new Vector3i(-2, 7, -6)),
            new BlockOccupancy(new Vector3i(-2, 7, -5)),
            new BlockOccupancy(new Vector3i(-2, 7, -4)),
            new BlockOccupancy(new Vector3i(-2, 7, -3)),
            new BlockOccupancy(new Vector3i(-2, 7, -2)),
            new BlockOccupancy(new Vector3i(-2, 7, -1)),
            new BlockOccupancy(new Vector3i(-2, 7, 0)),
            new BlockOccupancy(new Vector3i(-2, 7, 1)),
            new BlockOccupancy(new Vector3i(-2, 7, 2)),
            new BlockOccupancy(new Vector3i(-2, 7, 3)),
            new BlockOccupancy(new Vector3i(-2, 7, 4)),
            new BlockOccupancy(new Vector3i(-2, 7, 5)),
            new BlockOccupancy(new Vector3i(-2, 8, -8)),
            new BlockOccupancy(new Vector3i(-2, 8, -7)),
            new BlockOccupancy(new Vector3i(-2, 8, -6)),
            new BlockOccupancy(new Vector3i(-2, 8, -5)),
            new BlockOccupancy(new Vector3i(-2, 8, -4)),
            new BlockOccupancy(new Vector3i(-2, 8, -3)),
            new BlockOccupancy(new Vector3i(-2, 8, -2)),
            new BlockOccupancy(new Vector3i(-2, 8, -1)),
            new BlockOccupancy(new Vector3i(-2, 8, 0)),
            new BlockOccupancy(new Vector3i(-2, 8, 1)),
            new BlockOccupancy(new Vector3i(-2, 8, 2)),
            new BlockOccupancy(new Vector3i(-2, 8, 3)),
            new BlockOccupancy(new Vector3i(-2, 8, 4)),
            new BlockOccupancy(new Vector3i(-2, 8, 5)),
            new BlockOccupancy(new Vector3i(-2, 9, -8)),
            new BlockOccupancy(new Vector3i(-2, 9, -7)),
            new BlockOccupancy(new Vector3i(-2, 9, -6)),
            new BlockOccupancy(new Vector3i(-2, 9, -5)),
            new BlockOccupancy(new Vector3i(-2, 9, -4)),
            new BlockOccupancy(new Vector3i(-2, 9, -3)),
            new BlockOccupancy(new Vector3i(-2, 9, -2)),
            new BlockOccupancy(new Vector3i(-2, 9, -1)),
            new BlockOccupancy(new Vector3i(-2, 9, 0)),
            new BlockOccupancy(new Vector3i(-2, 9, 1)),
            new BlockOccupancy(new Vector3i(-2, 9, 2)),
            new BlockOccupancy(new Vector3i(-2, 9, 3)),
            new BlockOccupancy(new Vector3i(-2, 9, 4)),
            new BlockOccupancy(new Vector3i(-2, 9, 5)),
            new BlockOccupancy(new Vector3i(-2, 10, -8)),
            new BlockOccupancy(new Vector3i(-2, 10, -7)),
            new BlockOccupancy(new Vector3i(-2, 10, -6)),
            new BlockOccupancy(new Vector3i(-2, 10, -5)),
            new BlockOccupancy(new Vector3i(-2, 10, -4)),
            new BlockOccupancy(new Vector3i(-2, 10, -3)),
            new BlockOccupancy(new Vector3i(-2, 10, -2)),
            new BlockOccupancy(new Vector3i(-2, 10, -1)),
            new BlockOccupancy(new Vector3i(-2, 10, 0)),
            new BlockOccupancy(new Vector3i(-2, 10, 1)),
            new BlockOccupancy(new Vector3i(-2, 10, 2)),
            new BlockOccupancy(new Vector3i(-2, 10, 3)),
            new BlockOccupancy(new Vector3i(-2, 10, 4)),
            new BlockOccupancy(new Vector3i(-2, 10, 5)),
            new BlockOccupancy(new Vector3i(-1, 1, -8)),
            new BlockOccupancy(new Vector3i(-1, 1, -7)),
            new BlockOccupancy(new Vector3i(-1, 1, -6)),
            new BlockOccupancy(new Vector3i(-1, 1, -5)),
            new BlockOccupancy(new Vector3i(-1, 1, -4)),
            new BlockOccupancy(new Vector3i(-1, 1, -3)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, 3)),
            new BlockOccupancy(new Vector3i(-1, 1, 4)),
            new BlockOccupancy(new Vector3i(-1, 1, 5)),
            new BlockOccupancy(new Vector3i(-1, 2, -8)),
            new BlockOccupancy(new Vector3i(-1, 2, -7)),
            new BlockOccupancy(new Vector3i(-1, 2, -6)),
            new BlockOccupancy(new Vector3i(-1, 2, -5)),
            new BlockOccupancy(new Vector3i(-1, 2, -4)),
            new BlockOccupancy(new Vector3i(-1, 2, -3)),
            new BlockOccupancy(new Vector3i(-1, 2, -2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, 3)),
            new BlockOccupancy(new Vector3i(-1, 2, 4)),
            new BlockOccupancy(new Vector3i(-1, 2, 5)),
            new BlockOccupancy(new Vector3i(-1, 3, -8)),
            new BlockOccupancy(new Vector3i(-1, 3, -7)),
            new BlockOccupancy(new Vector3i(-1, 3, -6)),
            new BlockOccupancy(new Vector3i(-1, 3, -5)),
            new BlockOccupancy(new Vector3i(-1, 3, -4)),
            new BlockOccupancy(new Vector3i(-1, 3, -3)),
            new BlockOccupancy(new Vector3i(-1, 3, -2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, 3)),
            new BlockOccupancy(new Vector3i(-1, 3, 4)),
            new BlockOccupancy(new Vector3i(-1, 3, 5)),
            new BlockOccupancy(new Vector3i(-1, 4, -8)),
            new BlockOccupancy(new Vector3i(-1, 4, -7)),
            new BlockOccupancy(new Vector3i(-1, 4, -6)),
            new BlockOccupancy(new Vector3i(-1, 4, -5)),
            new BlockOccupancy(new Vector3i(-1, 4, -4)),
            new BlockOccupancy(new Vector3i(-1, 4, -3)),
            new BlockOccupancy(new Vector3i(-1, 4, -2)),
            new BlockOccupancy(new Vector3i(-1, 4, -1)),
            new BlockOccupancy(new Vector3i(-1, 4, 0)),
            new BlockOccupancy(new Vector3i(-1, 4, 1)),
            new BlockOccupancy(new Vector3i(-1, 4, 2)),
            new BlockOccupancy(new Vector3i(-1, 4, 3)),
            new BlockOccupancy(new Vector3i(-1, 4, 4)),
            new BlockOccupancy(new Vector3i(-1, 4, 5)),
            new BlockOccupancy(new Vector3i(-1, 5, -8)),
            new BlockOccupancy(new Vector3i(-1, 5, -7)),
            new BlockOccupancy(new Vector3i(-1, 5, -6)),
            new BlockOccupancy(new Vector3i(-1, 5, -5)),
            new BlockOccupancy(new Vector3i(-1, 5, -4)),
            new BlockOccupancy(new Vector3i(-1, 5, -3)),
            new BlockOccupancy(new Vector3i(-1, 5, -2)),
            new BlockOccupancy(new Vector3i(-1, 5, -1)),
            new BlockOccupancy(new Vector3i(-1, 5, 0)),
            new BlockOccupancy(new Vector3i(-1, 5, 1)),
            new BlockOccupancy(new Vector3i(-1, 5, 2)),
            new BlockOccupancy(new Vector3i(-1, 5, 3)),
            new BlockOccupancy(new Vector3i(-1, 5, 4)),
            new BlockOccupancy(new Vector3i(-1, 5, 5)),
            new BlockOccupancy(new Vector3i(-1, 6, -8)),
            new BlockOccupancy(new Vector3i(-1, 6, -7)),
            new BlockOccupancy(new Vector3i(-1, 6, -6)),
            new BlockOccupancy(new Vector3i(-1, 6, -5)),
            new BlockOccupancy(new Vector3i(-1, 6, -4)),
            new BlockOccupancy(new Vector3i(-1, 6, -3)),
            new BlockOccupancy(new Vector3i(-1, 6, -2)),
            new BlockOccupancy(new Vector3i(-1, 6, -1)),
            new BlockOccupancy(new Vector3i(-1, 6, 0)),
            new BlockOccupancy(new Vector3i(-1, 6, 1)),
            new BlockOccupancy(new Vector3i(-1, 6, 2)),
            new BlockOccupancy(new Vector3i(-1, 6, 3)),
            new BlockOccupancy(new Vector3i(-1, 6, 4)),
            new BlockOccupancy(new Vector3i(-1, 6, 5)),
            new BlockOccupancy(new Vector3i(-1, 7, -8)),
            new BlockOccupancy(new Vector3i(-1, 7, -7)),
            new BlockOccupancy(new Vector3i(-1, 7, -6)),
            new BlockOccupancy(new Vector3i(-1, 7, -5)),
            new BlockOccupancy(new Vector3i(-1, 7, -4)),
            new BlockOccupancy(new Vector3i(-1, 7, -3)),
            new BlockOccupancy(new Vector3i(-1, 7, -2)),
            new BlockOccupancy(new Vector3i(-1, 7, -1)),
            new BlockOccupancy(new Vector3i(-1, 7, 0)),
            new BlockOccupancy(new Vector3i(-1, 7, 1)),
            new BlockOccupancy(new Vector3i(-1, 7, 2)),
            new BlockOccupancy(new Vector3i(-1, 7, 3)),
            new BlockOccupancy(new Vector3i(-1, 7, 4)),
            new BlockOccupancy(new Vector3i(-1, 7, 5)),
            new BlockOccupancy(new Vector3i(-1, 8, -8)),
            new BlockOccupancy(new Vector3i(-1, 8, -7)),
            new BlockOccupancy(new Vector3i(-1, 8, -6)),
            new BlockOccupancy(new Vector3i(-1, 8, -5)),
            new BlockOccupancy(new Vector3i(-1, 8, -4)),
            new BlockOccupancy(new Vector3i(-1, 8, -3)),
            new BlockOccupancy(new Vector3i(-1, 8, -2)),
            new BlockOccupancy(new Vector3i(-1, 8, -1)),
            new BlockOccupancy(new Vector3i(-1, 8, 0)),
            new BlockOccupancy(new Vector3i(-1, 8, 1)),
            new BlockOccupancy(new Vector3i(-1, 8, 2)),
            new BlockOccupancy(new Vector3i(-1, 8, 3)),
            new BlockOccupancy(new Vector3i(-1, 8, 4)),
            new BlockOccupancy(new Vector3i(-1, 8, 5)),
            new BlockOccupancy(new Vector3i(-1, 9, -8)),
            new BlockOccupancy(new Vector3i(-1, 9, -7)),
            new BlockOccupancy(new Vector3i(-1, 9, -6)),
            new BlockOccupancy(new Vector3i(-1, 9, -5)),
            new BlockOccupancy(new Vector3i(-1, 9, -4)),
            new BlockOccupancy(new Vector3i(-1, 9, -3)),
            new BlockOccupancy(new Vector3i(-1, 9, -2)),
            new BlockOccupancy(new Vector3i(-1, 9, -1)),
            new BlockOccupancy(new Vector3i(-1, 9, 0)),
            new BlockOccupancy(new Vector3i(-1, 9, 1)),
            new BlockOccupancy(new Vector3i(-1, 9, 2)),
            new BlockOccupancy(new Vector3i(-1, 9, 3)),
            new BlockOccupancy(new Vector3i(-1, 9, 4)),
            new BlockOccupancy(new Vector3i(-1, 9, 5)),
            new BlockOccupancy(new Vector3i(-1, 10, -8)),
            new BlockOccupancy(new Vector3i(-1, 10, -7)),
            new BlockOccupancy(new Vector3i(-1, 10, -6)),
            new BlockOccupancy(new Vector3i(-1, 10, -5)),
            new BlockOccupancy(new Vector3i(-1, 10, -4)),
            new BlockOccupancy(new Vector3i(-1, 10, -3)),
            new BlockOccupancy(new Vector3i(-1, 10, -2)),
            new BlockOccupancy(new Vector3i(-1, 10, -1)),
            new BlockOccupancy(new Vector3i(-1, 10, 0)),
            new BlockOccupancy(new Vector3i(-1, 10, 1)),
            new BlockOccupancy(new Vector3i(-1, 10, 2)),
            new BlockOccupancy(new Vector3i(-1, 10, 3)),
            new BlockOccupancy(new Vector3i(-1, 10, 4)),
            new BlockOccupancy(new Vector3i(-1, 10, 5)),
            new BlockOccupancy(new Vector3i(0, 1, -8)),
            new BlockOccupancy(new Vector3i(0, 1, -7)),
            new BlockOccupancy(new Vector3i(0, 1, -6)),
            new BlockOccupancy(new Vector3i(0, 1, -5)),
            new BlockOccupancy(new Vector3i(0, 1, -4)),
            new BlockOccupancy(new Vector3i(0, 1, -3)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 4)),
            new BlockOccupancy(new Vector3i(0, 1, 5)),
            new BlockOccupancy(new Vector3i(0, 2, -8)),
            new BlockOccupancy(new Vector3i(0, 2, -7)),
            new BlockOccupancy(new Vector3i(0, 2, -6)),
            new BlockOccupancy(new Vector3i(0, 2, -5)),
            new BlockOccupancy(new Vector3i(0, 2, -4)),
            new BlockOccupancy(new Vector3i(0, 2, -3)),
            new BlockOccupancy(new Vector3i(0, 2, -2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 4)),
            new BlockOccupancy(new Vector3i(0, 2, 5)),
            new BlockOccupancy(new Vector3i(0, 3, -8)),
            new BlockOccupancy(new Vector3i(0, 3, -7)),
            new BlockOccupancy(new Vector3i(0, 3, -6)),
            new BlockOccupancy(new Vector3i(0, 3, -5)),
            new BlockOccupancy(new Vector3i(0, 3, -4)),
            new BlockOccupancy(new Vector3i(0, 3, -3)),
            new BlockOccupancy(new Vector3i(0, 3, -2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 3, 3)),
            new BlockOccupancy(new Vector3i(0, 3, 4)),
            new BlockOccupancy(new Vector3i(0, 3, 5)),
            new BlockOccupancy(new Vector3i(0, 4, -8)),
            new BlockOccupancy(new Vector3i(0, 4, -7)),
            new BlockOccupancy(new Vector3i(0, 4, -6)),
            new BlockOccupancy(new Vector3i(0, 4, -5)),
            new BlockOccupancy(new Vector3i(0, 4, -4)),
            new BlockOccupancy(new Vector3i(0, 4, -3)),
            new BlockOccupancy(new Vector3i(0, 4, -2)),
            new BlockOccupancy(new Vector3i(0, 4, -1)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 1)),
            new BlockOccupancy(new Vector3i(0, 4, 2)),
            new BlockOccupancy(new Vector3i(0, 4, 3)),
            new BlockOccupancy(new Vector3i(0, 4, 4)),
            new BlockOccupancy(new Vector3i(0, 4, 5)),
            new BlockOccupancy(new Vector3i(0, 5, -8)),
            new BlockOccupancy(new Vector3i(0, 5, -7)),
            new BlockOccupancy(new Vector3i(0, 5, -6)),
            new BlockOccupancy(new Vector3i(0, 5, -5)),
            new BlockOccupancy(new Vector3i(0, 5, -4)),
            new BlockOccupancy(new Vector3i(0, 5, -3)),
            new BlockOccupancy(new Vector3i(0, 5, -2)),
            new BlockOccupancy(new Vector3i(0, 5, -1)),
            new BlockOccupancy(new Vector3i(0, 5, 0)),
            new BlockOccupancy(new Vector3i(0, 5, 1)),
            new BlockOccupancy(new Vector3i(0, 5, 2)),
            new BlockOccupancy(new Vector3i(0, 5, 3)),
            new BlockOccupancy(new Vector3i(0, 5, 4)),
            new BlockOccupancy(new Vector3i(0, 5, 5)),
            new BlockOccupancy(new Vector3i(0, 6, -8)),
            new BlockOccupancy(new Vector3i(0, 6, -7)),
            new BlockOccupancy(new Vector3i(0, 6, -6)),
            new BlockOccupancy(new Vector3i(0, 6, -5)),
            new BlockOccupancy(new Vector3i(0, 6, -4)),
            new BlockOccupancy(new Vector3i(0, 6, -3)),
            new BlockOccupancy(new Vector3i(0, 6, -2)),
            new BlockOccupancy(new Vector3i(0, 6, -1)),
            new BlockOccupancy(new Vector3i(0, 6, 0)),
            new BlockOccupancy(new Vector3i(0, 6, 1)),
            new BlockOccupancy(new Vector3i(0, 6, 2)),
            new BlockOccupancy(new Vector3i(0, 6, 3)),
            new BlockOccupancy(new Vector3i(0, 6, 4)),
            new BlockOccupancy(new Vector3i(0, 6, 5)),
            new BlockOccupancy(new Vector3i(0, 7, -8)),
            new BlockOccupancy(new Vector3i(0, 7, -7)),
            new BlockOccupancy(new Vector3i(0, 7, -6)),
            new BlockOccupancy(new Vector3i(0, 7, -5)),
            new BlockOccupancy(new Vector3i(0, 7, -4)),
            new BlockOccupancy(new Vector3i(0, 7, -3)),
            new BlockOccupancy(new Vector3i(0, 7, -2)),
            new BlockOccupancy(new Vector3i(0, 7, -1)),
            new BlockOccupancy(new Vector3i(0, 7, 0)),
            new BlockOccupancy(new Vector3i(0, 7, 1)),
            new BlockOccupancy(new Vector3i(0, 7, 2)),
            new BlockOccupancy(new Vector3i(0, 7, 3)),
            new BlockOccupancy(new Vector3i(0, 7, 4)),
            new BlockOccupancy(new Vector3i(0, 7, 5)),
            new BlockOccupancy(new Vector3i(0, 8, -8)),
            new BlockOccupancy(new Vector3i(0, 8, -7)),
            new BlockOccupancy(new Vector3i(0, 8, -6)),
            new BlockOccupancy(new Vector3i(0, 8, -5)),
            new BlockOccupancy(new Vector3i(0, 8, -4)),
            new BlockOccupancy(new Vector3i(0, 8, -3)),
            new BlockOccupancy(new Vector3i(0, 8, -2)),
            new BlockOccupancy(new Vector3i(0, 8, -1)),
            new BlockOccupancy(new Vector3i(0, 8, 0)),
            new BlockOccupancy(new Vector3i(0, 8, 1)),
            new BlockOccupancy(new Vector3i(0, 8, 2)),
            new BlockOccupancy(new Vector3i(0, 8, 3)),
            new BlockOccupancy(new Vector3i(0, 8, 4)),
            new BlockOccupancy(new Vector3i(0, 8, 5)),
            new BlockOccupancy(new Vector3i(0, 9, -8)),
            new BlockOccupancy(new Vector3i(0, 9, -7)),
            new BlockOccupancy(new Vector3i(0, 9, -6)),
            new BlockOccupancy(new Vector3i(0, 9, -5)),
            new BlockOccupancy(new Vector3i(0, 9, -4)),
            new BlockOccupancy(new Vector3i(0, 9, -3)),
            new BlockOccupancy(new Vector3i(0, 9, -2)),
            new BlockOccupancy(new Vector3i(0, 9, -1)),
            new BlockOccupancy(new Vector3i(0, 9, 0)),
            new BlockOccupancy(new Vector3i(0, 9, 1)),
            new BlockOccupancy(new Vector3i(0, 9, 2)),
            new BlockOccupancy(new Vector3i(0, 9, 3)),
            new BlockOccupancy(new Vector3i(0, 9, 4)),
            new BlockOccupancy(new Vector3i(0, 9, 5)),
            new BlockOccupancy(new Vector3i(0, 10, -8)),
            new BlockOccupancy(new Vector3i(0, 10, -7)),
            new BlockOccupancy(new Vector3i(0, 10, -6)),
            new BlockOccupancy(new Vector3i(0, 10, -5)),
            new BlockOccupancy(new Vector3i(0, 10, -4)),
            new BlockOccupancy(new Vector3i(0, 10, -3)),
            new BlockOccupancy(new Vector3i(0, 10, -2)),
            new BlockOccupancy(new Vector3i(0, 10, -1)),
            new BlockOccupancy(new Vector3i(0, 10, 0)),
            new BlockOccupancy(new Vector3i(0, 10, 1)),
            new BlockOccupancy(new Vector3i(0, 10, 2)),
            new BlockOccupancy(new Vector3i(0, 10, 3)),
            new BlockOccupancy(new Vector3i(0, 10, 4)),
            new BlockOccupancy(new Vector3i(0, 10, 5)),
            new BlockOccupancy(new Vector3i(1, 1, -8)),
            new BlockOccupancy(new Vector3i(1, 1, -7)),
            new BlockOccupancy(new Vector3i(1, 1, -6)),
            new BlockOccupancy(new Vector3i(1, 1, -5)),
            new BlockOccupancy(new Vector3i(1, 1, -4)),
            new BlockOccupancy(new Vector3i(1, 1, -3)),
            new BlockOccupancy(new Vector3i(1, 1, -2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 4)),
            new BlockOccupancy(new Vector3i(1, 1, 5)),
            new BlockOccupancy(new Vector3i(1, 2, -8)),
            new BlockOccupancy(new Vector3i(1, 2, -7)),
            new BlockOccupancy(new Vector3i(1, 2, -6)),
            new BlockOccupancy(new Vector3i(1, 2, -5)),
            new BlockOccupancy(new Vector3i(1, 2, -4)),
            new BlockOccupancy(new Vector3i(1, 2, -3)),
            new BlockOccupancy(new Vector3i(1, 2, -2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 4)),
            new BlockOccupancy(new Vector3i(1, 2, 5)),
            new BlockOccupancy(new Vector3i(1, 3, -8)),
            new BlockOccupancy(new Vector3i(1, 3, -7)),
            new BlockOccupancy(new Vector3i(1, 3, -6)),
            new BlockOccupancy(new Vector3i(1, 3, -5)),
            new BlockOccupancy(new Vector3i(1, 3, -4)),
            new BlockOccupancy(new Vector3i(1, 3, -3)),
            new BlockOccupancy(new Vector3i(1, 3, -2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 3, 3)),
            new BlockOccupancy(new Vector3i(1, 3, 4)),
            new BlockOccupancy(new Vector3i(1, 3, 5)),
            new BlockOccupancy(new Vector3i(1, 4, -8)),
            new BlockOccupancy(new Vector3i(1, 4, -7)),
            new BlockOccupancy(new Vector3i(1, 4, -6)),
            new BlockOccupancy(new Vector3i(1, 4, -5)),
            new BlockOccupancy(new Vector3i(1, 4, -4)),
            new BlockOccupancy(new Vector3i(1, 4, -3)),
            new BlockOccupancy(new Vector3i(1, 4, -2)),
            new BlockOccupancy(new Vector3i(1, 4, -1)),
            new BlockOccupancy(new Vector3i(1, 4, 0)),
            new BlockOccupancy(new Vector3i(1, 4, 1)),
            new BlockOccupancy(new Vector3i(1, 4, 2)),
            new BlockOccupancy(new Vector3i(1, 4, 3)),
            new BlockOccupancy(new Vector3i(1, 4, 4)),
            new BlockOccupancy(new Vector3i(1, 4, 5)),
            new BlockOccupancy(new Vector3i(1, 5, -8)),
            new BlockOccupancy(new Vector3i(1, 5, -7)),
            new BlockOccupancy(new Vector3i(1, 5, -6)),
            new BlockOccupancy(new Vector3i(1, 5, -5)),
            new BlockOccupancy(new Vector3i(1, 5, -4)),
            new BlockOccupancy(new Vector3i(1, 5, -3)),
            new BlockOccupancy(new Vector3i(1, 5, -2)),
            new BlockOccupancy(new Vector3i(1, 5, -1)),
            new BlockOccupancy(new Vector3i(1, 5, 0)),
            new BlockOccupancy(new Vector3i(1, 5, 1)),
            new BlockOccupancy(new Vector3i(1, 5, 2)),
            new BlockOccupancy(new Vector3i(1, 5, 3)),
            new BlockOccupancy(new Vector3i(1, 5, 4)),
            new BlockOccupancy(new Vector3i(1, 5, 5)),
            new BlockOccupancy(new Vector3i(1, 6, -8)),
            new BlockOccupancy(new Vector3i(1, 6, -7)),
            new BlockOccupancy(new Vector3i(1, 6, -6)),
            new BlockOccupancy(new Vector3i(1, 6, -5)),
            new BlockOccupancy(new Vector3i(1, 6, -4)),
            new BlockOccupancy(new Vector3i(1, 6, -3)),
            new BlockOccupancy(new Vector3i(1, 6, -2)),
            new BlockOccupancy(new Vector3i(1, 6, -1)),
            new BlockOccupancy(new Vector3i(1, 6, 0)),
            new BlockOccupancy(new Vector3i(1, 6, 1)),
            new BlockOccupancy(new Vector3i(1, 6, 2)),
            new BlockOccupancy(new Vector3i(1, 6, 3)),
            new BlockOccupancy(new Vector3i(1, 6, 4)),
            new BlockOccupancy(new Vector3i(1, 6, 5)),
            new BlockOccupancy(new Vector3i(1, 7, -8)),
            new BlockOccupancy(new Vector3i(1, 7, -7)),
            new BlockOccupancy(new Vector3i(1, 7, -6)),
            new BlockOccupancy(new Vector3i(1, 7, -5)),
            new BlockOccupancy(new Vector3i(1, 7, -4)),
            new BlockOccupancy(new Vector3i(1, 7, -3)),
            new BlockOccupancy(new Vector3i(1, 7, -2)),
            new BlockOccupancy(new Vector3i(1, 7, -1)),
            new BlockOccupancy(new Vector3i(1, 7, 0)),
            new BlockOccupancy(new Vector3i(1, 7, 1)),
            new BlockOccupancy(new Vector3i(1, 7, 2)),
            new BlockOccupancy(new Vector3i(1, 7, 3)),
            new BlockOccupancy(new Vector3i(1, 7, 4)),
            new BlockOccupancy(new Vector3i(1, 7, 5)),
            new BlockOccupancy(new Vector3i(1, 8, -8)),
            new BlockOccupancy(new Vector3i(1, 8, -7)),
            new BlockOccupancy(new Vector3i(1, 8, -6)),
            new BlockOccupancy(new Vector3i(1, 8, -5)),
            new BlockOccupancy(new Vector3i(1, 8, -4)),
            new BlockOccupancy(new Vector3i(1, 8, -3)),
            new BlockOccupancy(new Vector3i(1, 8, -2)),
            new BlockOccupancy(new Vector3i(1, 8, -1)),
            new BlockOccupancy(new Vector3i(1, 8, 0)),
            new BlockOccupancy(new Vector3i(1, 8, 1)),
            new BlockOccupancy(new Vector3i(1, 8, 2)),
            new BlockOccupancy(new Vector3i(1, 8, 3)),
            new BlockOccupancy(new Vector3i(1, 8, 4)),
            new BlockOccupancy(new Vector3i(1, 8, 5)),
            new BlockOccupancy(new Vector3i(1, 9, -8)),
            new BlockOccupancy(new Vector3i(1, 9, -7)),
            new BlockOccupancy(new Vector3i(1, 9, -6)),
            new BlockOccupancy(new Vector3i(1, 9, -5)),
            new BlockOccupancy(new Vector3i(1, 9, -4)),
            new BlockOccupancy(new Vector3i(1, 9, -3)),
            new BlockOccupancy(new Vector3i(1, 9, -2)),
            new BlockOccupancy(new Vector3i(1, 9, -1)),
            new BlockOccupancy(new Vector3i(1, 9, 0)),
            new BlockOccupancy(new Vector3i(1, 9, 1)),
            new BlockOccupancy(new Vector3i(1, 9, 2)),
            new BlockOccupancy(new Vector3i(1, 9, 3)),
            new BlockOccupancy(new Vector3i(1, 9, 4)),
            new BlockOccupancy(new Vector3i(1, 9, 5)),
            new BlockOccupancy(new Vector3i(1, 10, -8)),
            new BlockOccupancy(new Vector3i(1, 10, -7)),
            new BlockOccupancy(new Vector3i(1, 10, -6)),
            new BlockOccupancy(new Vector3i(1, 10, -5)),
            new BlockOccupancy(new Vector3i(1, 10, -4)),
            new BlockOccupancy(new Vector3i(1, 10, -3)),
            new BlockOccupancy(new Vector3i(1, 10, -2)),
            new BlockOccupancy(new Vector3i(1, 10, -1)),
            new BlockOccupancy(new Vector3i(1, 10, 0)),
            new BlockOccupancy(new Vector3i(1, 10, 1)),
            new BlockOccupancy(new Vector3i(1, 10, 2)),
            new BlockOccupancy(new Vector3i(1, 10, 3)),
            new BlockOccupancy(new Vector3i(1, 10, 4)),
            new BlockOccupancy(new Vector3i(1, 10, 5)),
            new BlockOccupancy(new Vector3i(2, 1, -8)),
            new BlockOccupancy(new Vector3i(2, 1, -7)),
            new BlockOccupancy(new Vector3i(2, 1, -6)),
            new BlockOccupancy(new Vector3i(2, 1, -5)),
            new BlockOccupancy(new Vector3i(2, 1, -4)),
            new BlockOccupancy(new Vector3i(2, 1, -3)),
            new BlockOccupancy(new Vector3i(2, 1, -2)),
            new BlockOccupancy(new Vector3i(2, 1, -1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 4)),
            new BlockOccupancy(new Vector3i(2, 1, 5)),
            new BlockOccupancy(new Vector3i(2, 2, -8)),
            new BlockOccupancy(new Vector3i(2, 2, -7)),
            new BlockOccupancy(new Vector3i(2, 2, -6)),
            new BlockOccupancy(new Vector3i(2, 2, -5)),
            new BlockOccupancy(new Vector3i(2, 2, -4)),
            new BlockOccupancy(new Vector3i(2, 2, -3)),
            new BlockOccupancy(new Vector3i(2, 2, -2)),
            new BlockOccupancy(new Vector3i(2, 2, -1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 4)),
            new BlockOccupancy(new Vector3i(2, 2, 5)),
            new BlockOccupancy(new Vector3i(2, 3, -8)),
            new BlockOccupancy(new Vector3i(2, 3, -7)),
            new BlockOccupancy(new Vector3i(2, 3, -6)),
            new BlockOccupancy(new Vector3i(2, 3, -5)),
            new BlockOccupancy(new Vector3i(2, 3, -4)),
            new BlockOccupancy(new Vector3i(2, 3, -3)),
            new BlockOccupancy(new Vector3i(2, 3, -2)),
            new BlockOccupancy(new Vector3i(2, 3, -1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 2)),
            new BlockOccupancy(new Vector3i(2, 3, 3)),
            new BlockOccupancy(new Vector3i(2, 3, 4)),
            new BlockOccupancy(new Vector3i(2, 3, 5)),
            new BlockOccupancy(new Vector3i(2, 4, -8)),
            new BlockOccupancy(new Vector3i(2, 4, -7)),
            new BlockOccupancy(new Vector3i(2, 4, -6)),
            new BlockOccupancy(new Vector3i(2, 4, -5)),
            new BlockOccupancy(new Vector3i(2, 4, -4)),
            new BlockOccupancy(new Vector3i(2, 4, -3)),
            new BlockOccupancy(new Vector3i(2, 4, -2)),
            new BlockOccupancy(new Vector3i(2, 4, -1)),
            new BlockOccupancy(new Vector3i(2, 4, 0)),
            new BlockOccupancy(new Vector3i(2, 4, 1)),
            new BlockOccupancy(new Vector3i(2, 4, 2)),
            new BlockOccupancy(new Vector3i(2, 4, 3)),
            new BlockOccupancy(new Vector3i(2, 4, 4)),
            new BlockOccupancy(new Vector3i(2, 4, 5)),
            new BlockOccupancy(new Vector3i(2, 5, -8)),
            new BlockOccupancy(new Vector3i(2, 5, -7)),
            new BlockOccupancy(new Vector3i(2, 5, -6)),
            new BlockOccupancy(new Vector3i(2, 5, -5)),
            new BlockOccupancy(new Vector3i(2, 5, -4)),
            new BlockOccupancy(new Vector3i(2, 5, -3)),
            new BlockOccupancy(new Vector3i(2, 5, -2)),
            new BlockOccupancy(new Vector3i(2, 5, -1)),
            new BlockOccupancy(new Vector3i(2, 5, 0)),
            new BlockOccupancy(new Vector3i(2, 5, 1)),
            new BlockOccupancy(new Vector3i(2, 5, 2)),
            new BlockOccupancy(new Vector3i(2, 5, 3)),
            new BlockOccupancy(new Vector3i(2, 5, 4)),
            new BlockOccupancy(new Vector3i(2, 5, 5)),
            new BlockOccupancy(new Vector3i(2, 6, -8)),
            new BlockOccupancy(new Vector3i(2, 6, -7)),
            new BlockOccupancy(new Vector3i(2, 6, -6)),
            new BlockOccupancy(new Vector3i(2, 6, -5)),
            new BlockOccupancy(new Vector3i(2, 6, -4)),
            new BlockOccupancy(new Vector3i(2, 6, -3)),
            new BlockOccupancy(new Vector3i(2, 6, -2)),
            new BlockOccupancy(new Vector3i(2, 6, -1)),
            new BlockOccupancy(new Vector3i(2, 6, 0)),
            new BlockOccupancy(new Vector3i(2, 6, 1)),
            new BlockOccupancy(new Vector3i(2, 6, 2)),
            new BlockOccupancy(new Vector3i(2, 6, 3)),
            new BlockOccupancy(new Vector3i(2, 6, 4)),
            new BlockOccupancy(new Vector3i(2, 6, 5)),
            new BlockOccupancy(new Vector3i(2, 7, -8)),
            new BlockOccupancy(new Vector3i(2, 7, -7)),
            new BlockOccupancy(new Vector3i(2, 7, -6)),
            new BlockOccupancy(new Vector3i(2, 7, -5)),
            new BlockOccupancy(new Vector3i(2, 7, -4)),
            new BlockOccupancy(new Vector3i(2, 7, -3)),
            new BlockOccupancy(new Vector3i(2, 7, -2)),
            new BlockOccupancy(new Vector3i(2, 7, -1)),
            new BlockOccupancy(new Vector3i(2, 7, 0)),
            new BlockOccupancy(new Vector3i(2, 7, 1)),
            new BlockOccupancy(new Vector3i(2, 7, 2)),
            new BlockOccupancy(new Vector3i(2, 7, 3)),
            new BlockOccupancy(new Vector3i(2, 7, 4)),
            new BlockOccupancy(new Vector3i(2, 7, 5)),
            new BlockOccupancy(new Vector3i(2, 8, -8)),
            new BlockOccupancy(new Vector3i(2, 8, -7)),
            new BlockOccupancy(new Vector3i(2, 8, -6)),
            new BlockOccupancy(new Vector3i(2, 8, -5)),
            new BlockOccupancy(new Vector3i(2, 8, -4)),
            new BlockOccupancy(new Vector3i(2, 8, -3)),
            new BlockOccupancy(new Vector3i(2, 8, -2)),
            new BlockOccupancy(new Vector3i(2, 8, -1)),
            new BlockOccupancy(new Vector3i(2, 8, 0)),
            new BlockOccupancy(new Vector3i(2, 8, 1)),
            new BlockOccupancy(new Vector3i(2, 8, 2)),
            new BlockOccupancy(new Vector3i(2, 8, 3)),
            new BlockOccupancy(new Vector3i(2, 8, 4)),
            new BlockOccupancy(new Vector3i(2, 8, 5)),
            new BlockOccupancy(new Vector3i(2, 9, -8)),
            new BlockOccupancy(new Vector3i(2, 9, -7)),
            new BlockOccupancy(new Vector3i(2, 9, -6)),
            new BlockOccupancy(new Vector3i(2, 9, -5)),
            new BlockOccupancy(new Vector3i(2, 9, -4)),
            new BlockOccupancy(new Vector3i(2, 9, -3)),
            new BlockOccupancy(new Vector3i(2, 9, -2)),
            new BlockOccupancy(new Vector3i(2, 9, -1)),
            new BlockOccupancy(new Vector3i(2, 9, 0)),
            new BlockOccupancy(new Vector3i(2, 9, 1)),
            new BlockOccupancy(new Vector3i(2, 9, 2)),
            new BlockOccupancy(new Vector3i(2, 9, 3)),
            new BlockOccupancy(new Vector3i(2, 9, 4)),
            new BlockOccupancy(new Vector3i(2, 9, 5)),
            new BlockOccupancy(new Vector3i(2, 10, -8)),
            new BlockOccupancy(new Vector3i(2, 10, -7)),
            new BlockOccupancy(new Vector3i(2, 10, -6)),
            new BlockOccupancy(new Vector3i(2, 10, -5)),
            new BlockOccupancy(new Vector3i(2, 10, -4)),
            new BlockOccupancy(new Vector3i(2, 10, -3)),
            new BlockOccupancy(new Vector3i(2, 10, -2)),
            new BlockOccupancy(new Vector3i(2, 10, -1)),
            new BlockOccupancy(new Vector3i(2, 10, 0)),
            new BlockOccupancy(new Vector3i(2, 10, 1)),
            new BlockOccupancy(new Vector3i(2, 10, 2)),
            new BlockOccupancy(new Vector3i(2, 10, 3)),
            new BlockOccupancy(new Vector3i(2, 10, 4)),
            new BlockOccupancy(new Vector3i(2, 10, 5)),
            new BlockOccupancy(new Vector3i(3, 1, -8)),
            new BlockOccupancy(new Vector3i(3, 1, -7)),
            new BlockOccupancy(new Vector3i(3, 1, -6)),
            new BlockOccupancy(new Vector3i(3, 1, -5)),
            new BlockOccupancy(new Vector3i(3, 1, -4)),
            new BlockOccupancy(new Vector3i(3, 1, -3)),
            new BlockOccupancy(new Vector3i(3, 1, -2)),
            new BlockOccupancy(new Vector3i(3, 1, -1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 4)),
            new BlockOccupancy(new Vector3i(3, 1, 5)),
            new BlockOccupancy(new Vector3i(3, 2, -8)),
            new BlockOccupancy(new Vector3i(3, 2, -7)),
            new BlockOccupancy(new Vector3i(3, 2, -6)),
            new BlockOccupancy(new Vector3i(3, 2, -5)),
            new BlockOccupancy(new Vector3i(3, 2, -4)),
            new BlockOccupancy(new Vector3i(3, 2, -3)),
            new BlockOccupancy(new Vector3i(3, 2, -2)),
            new BlockOccupancy(new Vector3i(3, 2, -1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 4)),
            new BlockOccupancy(new Vector3i(3, 2, 5)),
            new BlockOccupancy(new Vector3i(3, 3, -8)),
            new BlockOccupancy(new Vector3i(3, 3, -7)),
            new BlockOccupancy(new Vector3i(3, 3, -6)),
            new BlockOccupancy(new Vector3i(3, 3, -5)),
            new BlockOccupancy(new Vector3i(3, 3, -4)),
            new BlockOccupancy(new Vector3i(3, 3, -3)),
            new BlockOccupancy(new Vector3i(3, 3, -2)),
            new BlockOccupancy(new Vector3i(3, 3, -1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 2)),
            new BlockOccupancy(new Vector3i(3, 3, 3)),
            new BlockOccupancy(new Vector3i(3, 3, 4)),
            new BlockOccupancy(new Vector3i(3, 3, 5)),
            new BlockOccupancy(new Vector3i(3, 4, -8)),
            new BlockOccupancy(new Vector3i(3, 4, -7)),
            new BlockOccupancy(new Vector3i(3, 4, -6)),
            new BlockOccupancy(new Vector3i(3, 4, -5)),
            new BlockOccupancy(new Vector3i(3, 4, -4)),
            new BlockOccupancy(new Vector3i(3, 4, -3)),
            new BlockOccupancy(new Vector3i(3, 4, -2)),
            new BlockOccupancy(new Vector3i(3, 4, -1)),
            new BlockOccupancy(new Vector3i(3, 4, 0)),
            new BlockOccupancy(new Vector3i(3, 4, 1)),
            new BlockOccupancy(new Vector3i(3, 4, 2)),
            new BlockOccupancy(new Vector3i(3, 4, 3)),
            new BlockOccupancy(new Vector3i(3, 4, 4)),
            new BlockOccupancy(new Vector3i(3, 4, 5)),
            new BlockOccupancy(new Vector3i(3, 5, -8)),
            new BlockOccupancy(new Vector3i(3, 5, -7)),
            new BlockOccupancy(new Vector3i(3, 5, -6)),
            new BlockOccupancy(new Vector3i(3, 5, -5)),
            new BlockOccupancy(new Vector3i(3, 5, -4)),
            new BlockOccupancy(new Vector3i(3, 5, -3)),
            new BlockOccupancy(new Vector3i(3, 5, -2)),
            new BlockOccupancy(new Vector3i(3, 5, -1)),
            new BlockOccupancy(new Vector3i(3, 5, 0)),
            new BlockOccupancy(new Vector3i(3, 5, 1)),
            new BlockOccupancy(new Vector3i(3, 5, 2)),
            new BlockOccupancy(new Vector3i(3, 5, 3)),
            new BlockOccupancy(new Vector3i(3, 5, 4)),
            new BlockOccupancy(new Vector3i(3, 5, 5)),
            new BlockOccupancy(new Vector3i(3, 6, -8)),
            new BlockOccupancy(new Vector3i(3, 6, -7)),
            new BlockOccupancy(new Vector3i(3, 6, -6)),
            new BlockOccupancy(new Vector3i(3, 6, -5)),
            new BlockOccupancy(new Vector3i(3, 6, -4)),
            new BlockOccupancy(new Vector3i(3, 6, -3)),
            new BlockOccupancy(new Vector3i(3, 6, -2)),
            new BlockOccupancy(new Vector3i(3, 6, -1)),
            new BlockOccupancy(new Vector3i(3, 6, 0)),
            new BlockOccupancy(new Vector3i(3, 6, 1)),
            new BlockOccupancy(new Vector3i(3, 6, 2)),
            new BlockOccupancy(new Vector3i(3, 6, 3)),
            new BlockOccupancy(new Vector3i(3, 6, 4)),
            new BlockOccupancy(new Vector3i(3, 6, 5)),
            new BlockOccupancy(new Vector3i(3, 7, -8)),
            new BlockOccupancy(new Vector3i(3, 7, -7)),
            new BlockOccupancy(new Vector3i(3, 7, -6)),
            new BlockOccupancy(new Vector3i(3, 7, -5)),
            new BlockOccupancy(new Vector3i(3, 7, -4)),
            new BlockOccupancy(new Vector3i(3, 7, -3)),
            new BlockOccupancy(new Vector3i(3, 7, -2)),
            new BlockOccupancy(new Vector3i(3, 7, -1)),
            new BlockOccupancy(new Vector3i(3, 7, 0)),
            new BlockOccupancy(new Vector3i(3, 7, 1)),
            new BlockOccupancy(new Vector3i(3, 7, 2)),
            new BlockOccupancy(new Vector3i(3, 7, 3)),
            new BlockOccupancy(new Vector3i(3, 7, 4)),
            new BlockOccupancy(new Vector3i(3, 7, 5)),
            new BlockOccupancy(new Vector3i(3, 8, -8)),
            new BlockOccupancy(new Vector3i(3, 8, -7)),
            new BlockOccupancy(new Vector3i(3, 8, -6)),
            new BlockOccupancy(new Vector3i(3, 8, -5)),
            new BlockOccupancy(new Vector3i(3, 8, -4)),
            new BlockOccupancy(new Vector3i(3, 8, -3)),
            new BlockOccupancy(new Vector3i(3, 8, -2)),
            new BlockOccupancy(new Vector3i(3, 8, -1)),
            new BlockOccupancy(new Vector3i(3, 8, 0)),
            new BlockOccupancy(new Vector3i(3, 8, 1)),
            new BlockOccupancy(new Vector3i(3, 8, 2)),
            new BlockOccupancy(new Vector3i(3, 8, 3)),
            new BlockOccupancy(new Vector3i(3, 8, 4)),
            new BlockOccupancy(new Vector3i(3, 8, 5)),
            new BlockOccupancy(new Vector3i(3, 9, -8)),
            new BlockOccupancy(new Vector3i(3, 9, -7)),
            new BlockOccupancy(new Vector3i(3, 9, -6)),
            new BlockOccupancy(new Vector3i(3, 9, -5)),
            new BlockOccupancy(new Vector3i(3, 9, -4)),
            new BlockOccupancy(new Vector3i(3, 9, -3)),
            new BlockOccupancy(new Vector3i(3, 9, -2)),
            new BlockOccupancy(new Vector3i(3, 9, -1)),
            new BlockOccupancy(new Vector3i(3, 9, 0)),
            new BlockOccupancy(new Vector3i(3, 9, 1)),
            new BlockOccupancy(new Vector3i(3, 9, 2)),
            new BlockOccupancy(new Vector3i(3, 9, 3)),
            new BlockOccupancy(new Vector3i(3, 9, 4)),
            new BlockOccupancy(new Vector3i(3, 9, 5)),
            new BlockOccupancy(new Vector3i(3, 10, -8)),
            new BlockOccupancy(new Vector3i(3, 10, -7)),
            new BlockOccupancy(new Vector3i(3, 10, -6)),
            new BlockOccupancy(new Vector3i(3, 10, -5)),
            new BlockOccupancy(new Vector3i(3, 10, -4)),
            new BlockOccupancy(new Vector3i(3, 10, -3)),
            new BlockOccupancy(new Vector3i(3, 10, -2)),
            new BlockOccupancy(new Vector3i(3, 10, -1)),
            new BlockOccupancy(new Vector3i(3, 10, 0)),
            new BlockOccupancy(new Vector3i(3, 10, 1)),
            new BlockOccupancy(new Vector3i(3, 10, 2)),
            new BlockOccupancy(new Vector3i(3, 10, 3)),
            new BlockOccupancy(new Vector3i(3, 10, 4)),
            new BlockOccupancy(new Vector3i(3, 10, 5)),
            });
            // SmallShipyardObject
            WorldObject.AddOccupancy<SmallShipyardObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 3, 0)),
            new BlockOccupancy(new Vector3i(2, 3, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 3, 0)),
            new BlockOccupancy(new Vector3i(3, 3, 1)),
            new BlockOccupancy(new Vector3i(4, 0, 0)),
            new BlockOccupancy(new Vector3i(4, 0, 1)),
            new BlockOccupancy(new Vector3i(4, 1, 0)),
            new BlockOccupancy(new Vector3i(4, 1, 1)),
            new BlockOccupancy(new Vector3i(4, 2, 0)),
            new BlockOccupancy(new Vector3i(4, 2, 1)),
            new BlockOccupancy(new Vector3i(4, 3, 0)),
            new BlockOccupancy(new Vector3i(4, 3, 1)),
            });
            // ImmigrationDeskObject
            WorldObject.AddOccupancy<ImmigrationDeskObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SettlementCraftingTableObject
            WorldObject.AddOccupancy<SettlementCraftingTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // SharkJawsObject
            WorldObject.AddOccupancy<SharkJawsObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            });
            // PunchCardObject
            WorldObject.AddOccupancy<PunchCardObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // GrindstoneObject
            WorldObject.AddOccupancy<GrindstoneObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // DigitalWorkStationObject
            WorldObject.AddOccupancy<DigitalWorkStationObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 0, 1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // BlacksmithTableObject
            WorldObject.AddOccupancy<BlacksmithTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // PowerHammerObject
            WorldObject.AddOccupancy<PowerHammerObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 0, 2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, 2)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, 2)),
            new BlockOccupancy(new Vector3i(-1, 3, -1)),
            new BlockOccupancy(new Vector3i(-1, 3, 0)),
            new BlockOccupancy(new Vector3i(-1, 3, 1)),
            new BlockOccupancy(new Vector3i(-1, 3, 2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 3, -1)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 1)),
            new BlockOccupancy(new Vector3i(0, 3, 2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 3, -1)),
            new BlockOccupancy(new Vector3i(1, 3, 0)),
            new BlockOccupancy(new Vector3i(1, 3, 1)),
            new BlockOccupancy(new Vector3i(1, 3, 2)),
            });
            // FletchingTableObject
            WorldObject.AddOccupancy<FletchingTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LighthouseLampObject
            WorldObject.AddOccupancy<LighthouseLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, 1)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 1)),
            new BlockOccupancy(new Vector3i(-1, 2, -1)),
            new BlockOccupancy(new Vector3i(-1, 2, 0)),
            new BlockOccupancy(new Vector3i(-1, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, -1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, -1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, -1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // TownBellObject
            WorldObject.AddOccupancy<TownBellObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 2)),
            new BlockOccupancy(new Vector3i(0, 2, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 2)),
            new BlockOccupancy(new Vector3i(1, 2, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 2, 0)),
            new BlockOccupancy(new Vector3i(2, 2, 1)),
            new BlockOccupancy(new Vector3i(2, 2, 2)),
            new BlockOccupancy(new Vector3i(2, 2, 3)),
            new BlockOccupancy(new Vector3i(3, 0, 0)),
            new BlockOccupancy(new Vector3i(3, 0, 1)),
            new BlockOccupancy(new Vector3i(3, 0, 2)),
            new BlockOccupancy(new Vector3i(3, 0, 3)),
            new BlockOccupancy(new Vector3i(3, 1, 0)),
            new BlockOccupancy(new Vector3i(3, 1, 1)),
            new BlockOccupancy(new Vector3i(3, 1, 2)),
            new BlockOccupancy(new Vector3i(3, 1, 3)),
            new BlockOccupancy(new Vector3i(3, 2, 0)),
            new BlockOccupancy(new Vector3i(3, 2, 1)),
            new BlockOccupancy(new Vector3i(3, 2, 2)),
            new BlockOccupancy(new Vector3i(3, 2, 3)),
            });
            // PlasticOutdoorBenchObject
            WorldObject.AddOccupancy<PlasticOutdoorBenchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // PlasticOutdoorChairObject
            WorldObject.AddOccupancy<PlasticOutdoorChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // PlasticOutdoorTableObject
            WorldObject.AddOccupancy<PlasticOutdoorTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // WoodWindowPlanterObject
            WorldObject.AddOccupancy<WoodWindowPlanterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // RusticWindowPlanterObject
            WorldObject.AddOccupancy<RusticWindowPlanterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // PlasticWindowPlanterObject
            WorldObject.AddOccupancy<PlasticWindowPlanterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // TikiTorchObject
            WorldObject.AddOccupancy<TikiTorchObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // GraniteTerraceFountainObject
            WorldObject.AddOccupancy<GraniteTerraceFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // GraniteSpiralFountain
            WorldObject.AddOccupancy<GraniteSpiralFountainObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // WindowShuttersRightObject
            WorldObject.AddOccupancy<WindowShuttersRightObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WindowShuttersLeftObject
            WorldObject.AddOccupancy<WindowShuttersLeftObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WindowShuttersCenterObject
            WorldObject.AddOccupancy<WindowShuttersCenterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WoodenWallTorchStandObject
            WorldObject.AddOccupancy<WoodenWallTorchStandObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // MasonSignObject
            WorldObject.AddOccupancy<MasonSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // BakerSignObject
            WorldObject.AddOccupancy<BakerSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // ElectionPosterObject
            WorldObject.AddOccupancy<ElectionPosterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // PeriodicTablePosterObject
            WorldObject.AddOccupancy<PeriodicTablePosterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // RedwoodsPosterObject
            WorldObject.AddOccupancy<RedwoodsPosterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // СartBlueprintPosterObject
            WorldObject.AddOccupancy<CartBlueprintPosterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // EngineerSignObject
            WorldObject.AddOccupancy<EngineerSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // FarmerSignObject
            WorldObject.AddOccupancy<FarmerSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // FoodSignObject
            WorldObject.AddOccupancy<FoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // FriendlyScarecrowObject
            WorldObject.AddOccupancy<FriendlyScarecrowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // ScarecrowObject
            WorldObject.AddOccupancy<ScarecrowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // GardenPondObject
            WorldObject.AddOccupancy<GardenPondObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-2, 0, -2)),
            new BlockOccupancy(new Vector3i(-2, 0, -1)),
            new BlockOccupancy(new Vector3i(-2, 0, 0)),
            new BlockOccupancy(new Vector3i(-2, 1, -2)),
            new BlockOccupancy(new Vector3i(-2, 1, -1)),
            new BlockOccupancy(new Vector3i(-2, 1, 0)),
            new BlockOccupancy(new Vector3i(-1, 0, -2)),
            new BlockOccupancy(new Vector3i(-1, 0, -1)),
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, -2)),
            new BlockOccupancy(new Vector3i(-1, 1, -1)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, -2)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // KoiPondObject
            WorldObject.AddOccupancy<KoiPondObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 2)),
            new BlockOccupancy(new Vector3i(0, 0, 3)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 2)),
            new BlockOccupancy(new Vector3i(0, 1, 3)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 2)),
            new BlockOccupancy(new Vector3i(1, 0, 3)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 2)),
            new BlockOccupancy(new Vector3i(1, 1, 3)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 1)),
            new BlockOccupancy(new Vector3i(2, 0, 2)),
            new BlockOccupancy(new Vector3i(2, 0, 3)),
            new BlockOccupancy(new Vector3i(2, 1, 0)),
            new BlockOccupancy(new Vector3i(2, 1, 1)),
            new BlockOccupancy(new Vector3i(2, 1, 2)),
            new BlockOccupancy(new Vector3i(2, 1, 3)),
            });
            // ShipwrightSignObject
            WorldObject.AddOccupancy<ShipwrightSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // StoreSignObject
            WorldObject.AddOccupancy<StoreSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // TailorSignObject
            WorldObject.AddOccupancy<TailorSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // TapestrySunsetObject
            WorldObject.AddOccupancy<TapestrySunsetObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // TapestryObject
            WorldObject.AddOccupancy<TapestryObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // TapestryFishObject
            WorldObject.AddOccupancy<TapestryFishObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            });
            // WallMountedTrunkObject
            WorldObject.AddOccupancy<WallMountedTrunkObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // WallMountedChestObject
            WorldObject.AddOccupancy<WallMountedChestObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // KiteObject
            WorldObject.AddOccupancy<KiteObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            });
            // FishKitesObject
            WorldObject.AddOccupancy<FishKitesObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 3, 0)),
            new BlockOccupancy(new Vector3i(0, 4, 0)),
            });
            // FancyHewnDoorObject
            WorldObject.AddOccupancy<FancyHewnDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // CartBlueprintPosterObject
            WorldObject.AddOccupancy<CartBlueprintPosterObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // CastIronPlaqueObject
            WorldObject.AddOccupancy<CastIronPlaqueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // OrnateCastIronPlaqueObject
            WorldObject.AddOccupancy<OrnateCastIronPlaqueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // OrnateStonePlaqueObject
            WorldObject.AddOccupancy<OrnateStonePlaqueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // OrnateWoodPlaqueObject
            WorldObject.AddOccupancy<OrnateWoodPlaqueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StonePlaqueObject
            WorldObject.AddOccupancy<StonePlaqueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // WoodPlaqueObject
            WorldObject.AddOccupancy<WoodPlaqueObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AdobeDoorObject
            WorldObject.AddOccupancy<AdobeDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, -1)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // ZatakuTableObject
            WorldObject.AddOccupancy<ZatakuTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, -2)),
            new BlockOccupancy(new Vector3i(2, 0, -1)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            });
            // ChandelierObject
            WorldObject.AddOccupancy<ChandelierObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, -1, 0)),
            new BlockOccupancy(new Vector3i(0, -1, 1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(1, -1, 0)),
            new BlockOccupancy(new Vector3i(1, -1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            });
            // HangingElectricWallLampObject
            WorldObject.AddOccupancy<HangingElectricWallLampObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CarpenterSignObject
            WorldObject.AddOccupancy<CarpenterSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // BisonPeltObject
            WorldObject.AddOccupancy<BisonPeltObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -2)),
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, -2)),
            new BlockOccupancy(new Vector3i(1, 0, -1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // DeerPeltObject
            WorldObject.AddOccupancy<DeerPeltObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // FoxPeltObject
            WorldObject.AddOccupancy<FoxPeltObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HarePeltObject
            WorldObject.AddOccupancy<HarePeltObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WolfPeltObject
            WorldObject.AddOccupancy<WolfPeltObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, -1)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // BonsaiObject
            WorldObject.AddOccupancy<BonsaiObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallHangingWoodSignObject
            WorldObject.AddOccupancy<SmallHangingWoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // LargeHangingWoodSignObject
            WorldObject.AddOccupancy<LargeHangingWoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LargeStandingWoodSignObject
            WorldObject.AddOccupancy<LargeStandingWoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(-1, 0, 0)),
            new BlockOccupancy(new Vector3i(-1, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // SmallStandingWoodSignObject
            WorldObject.AddOccupancy<SmallStandingWoodSignObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // DecorativeBowlObject
            WorldObject.AddOccupancy<DecorativeBowlObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // PaintMixerObject
            WorldObject.AddOccupancy<PaintMixerObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            });
            // SmallPaperMachineObject
            WorldObject.AddOccupancy<SmallPaperMachineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // ShojiDoorObject
            WorldObject.AddOccupancy<ShojiDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(1, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(1, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(2, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(2, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(3, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(3, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            });
            // WoodenSlidingDoorObject
            WorldObject.AddOccupancy<WoodenSlidingDoorObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(0, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(1, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(1, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(2, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(2, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(3, 0, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            new BlockOccupancy(new Vector3i(3, 1, 0), typeof(BuildingWorldObjectBlock), new Quaternion(0f, 0f, 0f, 1f), BlockOccupancyType.None),
            });
            // StumpBedObject
            WorldObject.AddOccupancy<StumpBedObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(2, 0, 0)),
            });
            // StumpChairObject
            WorldObject.AddOccupancy<StumpChairObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // StumpTableObject
            WorldObject.AddOccupancy<StumpTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // StumpLatrineObject
            WorldObject.AddOccupancy<StumpLatrineObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // AnatomyBookObject
            WorldObject.AddOccupancy<AnatomyBookObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // AtlasBookObject
            WorldObject.AddOccupancy<AtlasBookObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // BotanicalBookObject
            WorldObject.AddOccupancy<BotanicalBookObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // EcoBookObject
            WorldObject.AddOccupancy<EcoBookObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ElkGongObject
            WorldObject.AddOccupancy<ElkGongObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // GoldTrimBookObject
            WorldObject.AddOccupancy<GoldTrimBookObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HourglassObject
            WorldObject.AddOccupancy<HourglassObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallClayPotObject
            WorldObject.AddOccupancy<SmallClayPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallFacetedSteelPotObject
            WorldObject.AddOccupancy<SmallFacetedSteelPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallRoundLimestonePotObject
            WorldObject.AddOccupancy<SmallRoundLimestonePotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallSquareClayPotObject
            WorldObject.AddOccupancy<SmallSquareClayPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallSquareLimestonePotObject
            WorldObject.AddOccupancy<SmallSquareLimestonePotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallSteelPotObject
            WorldObject.AddOccupancy<SmallSteelPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SquareLumberPotObject
            WorldObject.AddOccupancy<SquareLumberPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // StandingBasaltPotObject
            WorldObject.AddOccupancy<StandingBasaltPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // StandingClayPotObject
            WorldObject.AddOccupancy<StandingClayPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // TallLimestonePotObject
            WorldObject.AddOccupancy<TallLimestonePotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // LongBasicSoftwoodShelfObject
            WorldObject.AddOccupancy<LongBasicSoftwoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongBasicWoodShelfObject
            WorldObject.AddOccupancy<LongBasicWoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongFloatingHardwoodShelfObject
            WorldObject.AddOccupancy<LongFloatingHardwoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongFloatingSoftwoodShelfObject
            WorldObject.AddOccupancy<LongFloatingSoftwoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongFloatingWoodShelfObject
            WorldObject.AddOccupancy<LongFloatingWoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongHardwoodLumberShelfObject
            WorldObject.AddOccupancy<LongHardwoodLumberShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongHardwoodVeneerShelfObject
            WorldObject.AddOccupancy<LongHardwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongLumberShelfObject
            WorldObject.AddOccupancy<LongLumberShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongSoftwoodLumberShelfObject
            WorldObject.AddOccupancy<LongSoftwoodLumberShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongSoftwoodVeneerShelfObject
            WorldObject.AddOccupancy<LongSoftwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongThinHardwoodVeneerShelfObject
            WorldObject.AddOccupancy<LongThinHardwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongThinSoftwoodVeneerShelfObject
            WorldObject.AddOccupancy<LongThinSoftwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongThinWoodVeneerShelfObject
            WorldObject.AddOccupancy<LongThinWoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LongWoodVeneerShelfObject
            WorldObject.AddOccupancy<LongWoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // ShortBasicHardwoodShelfObject
            WorldObject.AddOccupancy<ShortBasicHardwoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortBasicSoftwoodShelfObject
            WorldObject.AddOccupancy<ShortBasicSoftwoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortBasicWoodShelfObject
            WorldObject.AddOccupancy<ShortBasicWoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortCurvedHardwoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortCurvedHardwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortCurvedSoftwoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortCurvedSoftwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortCurvedWoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortCurvedWoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortFloatingHardwoodShelfObject
            WorldObject.AddOccupancy<ShortFloatingHardwoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortFloatingSoftwoodShelfObject
            WorldObject.AddOccupancy<ShortFloatingSoftwoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortFloatingWoodShelfObject
            WorldObject.AddOccupancy<ShortFloatingWoodShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortHardwoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortHardwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortSoftwoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortSoftwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortThinHardwoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortThinHardwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortThinSoftwoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortThinSoftwoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortThinWoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortThinWoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortWoodVeneerShelfObject
            WorldObject.AddOccupancy<ShortWoodVeneerShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // WoodDoubleShelfObject
            WorldObject.AddOccupancy<WoodDoubleShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // CeramicTeaCupObject
            WorldObject.AddOccupancy<CeramicTeaCupObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CeramicTeapotObject
            WorldObject.AddOccupancy<CeramicTeaPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // CeramicTrayObject
            WorldObject.AddOccupancy<CeramicTrayObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ElkStatuetteObject
            WorldObject.AddOccupancy<ElkStatuetteObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // HangingBasketObject
            WorldObject.AddOccupancy<HangingBasketObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            });
            // HardwoodDoubleShelfObject
            WorldObject.AddOccupancy<HardwoodDoubleShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // LongSteelShelfObject
            WorldObject.AddOccupancy<LongSteelShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // RotatingCubeObject
            WorldObject.AddOccupancy<RotatingCubeObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // ShortSteelShelfObject
            WorldObject.AddOccupancy<ShortSteelShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallRoughBasaltPotObject
            WorldObject.AddOccupancy<SmallRoughBasaltPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SoftwoodDoubleShelfObject
            WorldObject.AddOccupancy<SoftwoodDoubleShelfObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // RefrigeratedDisplayCabinetObject
            WorldObject.AddOccupancy<RefrigeratedDisplayCabinetObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // HeatedDisplayCabinetObject
            WorldObject.AddOccupancy<HeatedDisplayCabinetObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // SmallRoughLimestonePotObject
            WorldObject.AddOccupancy<SmallRoughLimestonePotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SmallSquareBasaltPotObject
            WorldObject.AddOccupancy<SmallSquareBasaltPotObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
            // SoftwoodLumberHallwayTableObject
            WorldObject.AddOccupancy<SoftwoodLumberHallwayTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // HardwoodLumberHallwayTableObject
            WorldObject.AddOccupancy<HardwoodLumberHallwayTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // CoffeeTableObject
            WorldObject.AddOccupancy<CoffeeTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            });
            // LargeLumberStoreWindowObject
            WorldObject.AddOccupancy<LargeLumberStoreWindowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // SmallLumberStoreWindowObject
            WorldObject.AddOccupancy<SmallLumberStoreWindowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            });
            // SmallStumpStoreWindowObject
            WorldObject.AddOccupancy<SmallStumpStoreWindowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            });
            // FancyMediumLumberStoreWindowObject
            WorldObject.AddOccupancy<FancyMediumLumberStoreWindowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            });
            // LargeGlassStoreWindowObject
            WorldObject.AddOccupancy<LargeGlassStoreWindowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(0, 2, 0)),
            new BlockOccupancy(new Vector3i(0, 2, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 2, 0)),
            new BlockOccupancy(new Vector3i(1, 2, 1)),
            });
            // MediumLumberStoreWindowObject
            WorldObject.AddOccupancy<MediumLumberStoreWindowObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(0, 0, 1)),
            new BlockOccupancy(new Vector3i(0, 1, 0)),
            new BlockOccupancy(new Vector3i(0, 1, 1)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 1)),
            new BlockOccupancy(new Vector3i(1, 1, 0)),
            new BlockOccupancy(new Vector3i(1, 1, 1)),
            });
            // BananaRugObject
            WorldObject.AddOccupancy<BananaRugObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            new BlockOccupancy(new Vector3i(1, 0, 0)),
            });
            // LumberHallwayTableObject
            WorldObject.AddOccupancy<LumberHallwayTableObject>(new List<BlockOccupancy>(){
            new BlockOccupancy(new Vector3i(0, 0, 0)),
            });
        }
    }
}
