#!/bin/bash
# Install prerequisites and perform various pre use operations for Eco Server on Linux
# Credits: RHEL Support added by GitHub user Oreloth

# This installation script is unsupported and provided as-is without warranty.
# If it doesn't work for you, please try to install the respective prerequisites manually.

# For more details about requirements for .net, see https://github.com/dotnet/core/blob/main/release-notes/8.0/linux-packages.md

echo "Eco Server prerequisites"
echo "This script will install packages which are required to run the server for supported operating systems."

if [[ $EUID -ne 0 ]]; then
    echo "This script requires root access to install packages." 
fi

# Give Eco server executable permissions
chmod 744 ./EcoServer

# Make sure Steam game server can find necessary SO file by creating a symlink to it
DIR=$(realpath $(dirname $0)) # Get the path to the directory where this script is located
sudo ln -sf $DIR/steamclient.so /usr/lib/steamclient.so

# Install our packages
. /etc/os-release

case $ID in
"alpine")
    case $VERSION_ID in
    "3.18" | "3.19")
        sudo apk add \
            libgcc \
            libssl3 \
            libstdc++ \
            zlib \
            libgdiplus
        ;;
    "3.12" | "3.13" | "3.14" | "3.15" | "3.16" | "3.17")
        sudo apk add \
            krb5-libs \
            libgcc \
            libintl \
            libssl1.1 \
            libstdc++ \
            zlib \
            libgdiplus
        ;;
    *)
        echo "Sorry, your version of Alpine isn't supported."
        ;;
    esac
  ;;

"debian") 
    case $VERSION_CODENAME in
    "bookworm") # Debian 12
        sudo apt-get update \
            && sudo apt-get install -y --no-install-recommends \
            libc6 \
            libgcc-s1 \
            libicu72 \
            libssl3 \
            libstdc++6 \
            tzdata \
            zlib1g \
            libgdiplus
        ;;
    "bullseye") # Debian 11
        sudo apt-get update \
            && sudo apt-get install -y --no-install-recommends \
            libc6 \
            libgcc1 \
            libgssapi-krb5-2 \
            libicu67 \
            libssl1.1 \
            libstdc++6 \
            zlib1g \
            libgdiplus
        ;;
    "buster") # Debian 10
        sudo apt-get update \
            && sudo apt-get install -y --no-install-recommends \
            libc6 \
            libgcc1 \
            libgssapi-krb5-2 \
            libicu63 \
            libssl1.1 \
            libstdc++6 \
            zlib1g \
            libgdiplus
        ;;
    *)
        echo "Sorry, your version of Debian isn't supported."
        ;;
    esac
    ;;

"ubuntu")
    case $VERSION_CODENAME in
    "noble") # Ubuntu 24.04
        sudo apt-get update \
            && sudo apt-get install -y --no-install-recommends \
            libc6 \
            libgcc-s1 \
            libicu74 \
            libssl3 \
            libstdc++6 \
            zlib1g \
            libgdiplus
        ;;
    "jammy") # Ubuntu 22.04
        sudo apt-get update \
            && sudo apt-get install -y --no-install-recommends \
            libc6 \
            libgcc1 \
            libicu70 \
            libssl3 \
            libstdc++6 \
            zlib1g \
            libgdiplus
        ;;
    "focal") # Ubuntu 20.04
        sudo apt-get update \
            && sudo apt-get install -y --no-install-recommends \
            libc6 \
            libgcc1 \
            libgssapi-krb5-2 \
            libicu66 \
            libssl1.1 \
            libstdc++6 \
            zlib1g \
            libgdiplus
        ;;
    "bionic") # Ubuntu 18.04
        sudo apt-get update \
            && sudo apt-get install -y --no-install-recommends \
            libc6 \
            libgcc1 \
            libgssapi-krb5-2 \
            libicu60 \
            libssl1.1 \
            libstdc++6 \
            zlib1g \
            libgdiplus
        ;;
    *)
        echo "Sorry, your version of Ubuntu isn't supported."
        ;;
    esac
    ;;

"arch")
    echo "Your operating system isn't supported, but we'll give it a go."
    sudo pacman -Sy \
        glibc \
        gcc \
        krb5 \
        icu \
        openssl \
        libc++ \
        zlib \
        libgdiplus
    ;;

"almalinux"| "ol" | "rhel" | "rocky")
    echo "Your operating system isn't supported, but we'll give it a go."
    case $PLATFORM_ID in
    "platform:el8")
        sudo dnf -y install \
            glibc.i686 \
            libstdc++.i686 \
            libgss \
            krb5-libs \
            icu \
            openssl \
            zlib \
            libgdiplus \
            giflib
        ;;
    "platform:el9")
        sudo dnf -y install \
            glibc.i686 \
            libstdc++.i686 \
            libgss \
            krb5-libs \
            icu \
            openssl \
            zlib \
            libgdiplus \
            giflib
        ;;
    *)
        echo "Sorry, your version of Enterprise Linux isn't supported."
        ;;
    esac
    ;;

*)
    echo "Sorry, your operating system is not supported."
    echo "Check https://github.com/dotnet/core/blob/main/release-notes/8.0/linux-packages.md"
    echo "for details on what packages your system requires."
    exit 1
    ;;
esac