/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.OIDTokenizer;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public class DERObjectIdentifier
extends ASN1Primitive {
    String identifier;
    private byte[] body;
    private static ASN1ObjectIdentifier[][] cache = new ASN1ObjectIdentifier[255][];

    public static ASN1ObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new ASN1ObjectIdentifier(((DERObjectIdentifier)object).getId());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERObjectIdentifier) {
            return DERObjectIdentifier.getInstance(aSN1Primitive);
        }
        return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(aSN1TaggedObject.getObject()).getOctets());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        BigInteger bigInteger = null;
        boolean bl2 = true;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (l2 < 0x80000000000000L) {
                l2 = l2 * 128L + (long)(n2 & 0x7F);
                if ((n2 & 0x80) != 0) continue;
                if (bl2) {
                    switch ((int)l2 / 40) {
                        case 0: {
                            stringBuffer.append('0');
                            break;
                        }
                        case 1: {
                            stringBuffer.append('1');
                            l2 -= 40L;
                            break;
                        }
                        default: {
                            stringBuffer.append('2');
                            l2 -= 80L;
                        }
                    }
                    bl2 = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(l2);
                l2 = 0L;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.shiftLeft(7);
            bigInteger = bigInteger.or(BigInteger.valueOf(n2 & 0x7F));
            if ((n2 & 0x80) != 0) continue;
            stringBuffer.append('.');
            stringBuffer.append(bigInteger);
            bigInteger = null;
            l2 = 0L;
        }
        this.identifier = stringBuffer.toString();
    }

    public DERObjectIdentifier(String string) {
        if (!DERObjectIdentifier.isValidIdentifier(string)) {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.identifier = string;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, long l2) {
        byte[] byArray = new byte[9];
        int n2 = 8;
        byArray[n2] = (byte)((int)l2 & 0x7F);
        while (l2 >= 128L) {
            byArray[--n2] = (byte)((int)(l2 >>= 7) & 0x7F | 0x80);
        }
        byteArrayOutputStream.write(byArray, n2, 9 - n2);
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n2 = (bigInteger.bitLength() + 6) / 7;
        if (n2 == 0) {
            byteArrayOutputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n2];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byArray[i2] = (byte)(bigInteger2.intValue() & 0x7F | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] & 0x7F);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void doOutput(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        this.writeField(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            String string = oIDTokenizer.nextToken();
            if (string.length() < 18) {
                this.writeField(byteArrayOutputStream, Long.parseLong(string));
                continue;
            }
            this.writeField(byteArrayOutputStream, new BigInteger(string));
        }
    }

    protected byte[] getBody() {
        if (this.body == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.doOutput(byteArrayOutputStream);
            this.body = byteArrayOutputStream.toByteArray();
        }
        return this.body;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() throws IOException {
        int n2 = this.getBody().length;
        return 1 + StreamUtil.calculateBodyLength(n2) + n2;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        byte[] byArray = this.getBody();
        aSN1OutputStream.write(6);
        aSN1OutputStream.writeLength(byArray.length);
        aSN1OutputStream.write(byArray);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)aSN1Primitive).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String string) {
        if (string.length() < 3 || string.charAt(1) != '.') {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 < '0' || c2 > '2') {
            return false;
        }
        boolean bl2 = false;
        for (int i2 = string.length() - 1; i2 >= 2; --i2) {
            char c3 = string.charAt(i2);
            if ('0' <= c3 && c3 <= '9') {
                bl2 = true;
                continue;
            }
            if (c3 == '.') {
                if (!bl2) {
                    return false;
                }
                bl2 = false;
                continue;
            }
            return false;
        }
        return bl2;
    }

    static ASN1ObjectIdentifier fromOctetString(byte[] byArray) {
        int n2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (byArray.length < 3) {
            return new ASN1ObjectIdentifier(byArray);
        }
        int n3 = byArray[byArray.length - 2] & 0xFF;
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = cache[n3];
        if (aSN1ObjectIdentifierArray == null) {
            DERObjectIdentifier.cache[n3] = new ASN1ObjectIdentifier[255];
            aSN1ObjectIdentifierArray = DERObjectIdentifier.cache[n3];
        }
        if ((aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[n2 = byArray[byArray.length - 1] & 0xFF]) == null) {
            aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[n2] = new ASN1ObjectIdentifier(byArray);
            return aSN1ObjectIdentifier;
        }
        if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
            return aSN1ObjectIdentifier;
        }
        aSN1ObjectIdentifierArray = cache[n3 = (n3 + 1) % 256];
        if (aSN1ObjectIdentifierArray == null) {
            DERObjectIdentifier.cache[n3] = new ASN1ObjectIdentifier[255];
            aSN1ObjectIdentifierArray = DERObjectIdentifier.cache[n3];
        }
        if ((aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[n2]) == null) {
            aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[n2] = new ASN1ObjectIdentifier(byArray);
            return aSN1ObjectIdentifier;
        }
        if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
            return aSN1ObjectIdentifier;
        }
        aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[n2 = (n2 + 1) % 256];
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[n2] = new ASN1ObjectIdentifier(byArray);
            return aSN1ObjectIdentifier;
        }
        if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
            return aSN1ObjectIdentifier;
        }
        return new ASN1ObjectIdentifier(byArray);
    }
}

