/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areEqual(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        if (blArray.length != blArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 != blArray.length; ++i2) {
            if (blArray[i2] == blArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            if (cArray[i2] == cArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n2 = 0;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            n2 |= byArray[i2] ^ byArray2[i2];
        }
        return n2 == 0;
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 != nArray.length; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        if (lArray.length != lArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 != lArray.length; ++i2) {
            if (lArray[i2] == lArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        if (bigIntegerArray == bigIntegerArray2) {
            return true;
        }
        if (bigIntegerArray == null || bigIntegerArray2 == null) {
            return false;
        }
        if (bigIntegerArray.length != bigIntegerArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 != bigIntegerArray.length; ++i2) {
            if (bigIntegerArray[i2].equals(bigIntegerArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static void fill(byte[] byArray, byte by2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = by2;
        }
    }

    public static void fill(long[] lArray, long l2) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = l2;
        }
    }

    public static void fill(short[] sArray, short s2) {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray[i2] = s2;
        }
    }

    public static void fill(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = n2;
        }
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n2 = byArray.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= byArray[n2];
        }
        return n3;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = cArray.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= cArray[n2];
        }
        return n3;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= nArray[n2];
        }
        return n3;
    }

    public static int hashCode(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return 0;
        }
        int n2 = bigIntegerArray.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= bigIntegerArray[n2].hashCode();
        }
        return n3;
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static int[] clone(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static BigInteger[] clone(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        System.arraycopy(bigIntegerArray, 0, bigIntegerArray2, 0, bigIntegerArray.length);
        return bigIntegerArray2;
    }

    public static byte[] copyOf(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        if (n2 < byArray.length) {
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    public static int[] copyOf(int[] nArray, int n2) {
        int[] nArray2 = new int[n2];
        if (n2 < nArray.length) {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        return nArray2;
    }

    public static long[] copyOf(long[] lArray, int n2) {
        long[] lArray2 = new long[n2];
        if (n2 < lArray.length) {
            System.arraycopy(lArray, 0, lArray2, 0, n2);
        } else {
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        }
        return lArray2;
    }

    public static BigInteger[] copyOf(BigInteger[] bigIntegerArray, int n2) {
        BigInteger[] bigIntegerArray2 = new BigInteger[n2];
        if (n2 < bigIntegerArray.length) {
            System.arraycopy(bigIntegerArray, 0, bigIntegerArray2, 0, n2);
        } else {
            System.arraycopy(bigIntegerArray, 0, bigIntegerArray2, 0, bigIntegerArray.length);
        }
        return bigIntegerArray2;
    }

    public static byte[] copyOfRange(byte[] byArray, int n2, int n3) {
        int n4 = Arrays.getLength(n2, n3);
        byte[] byArray2 = new byte[n4];
        if (byArray.length - n2 < n4) {
            System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
        } else {
            System.arraycopy(byArray, n2, byArray2, 0, n4);
        }
        return byArray2;
    }

    public static int[] copyOfRange(int[] nArray, int n2, int n3) {
        int n4 = Arrays.getLength(n2, n3);
        int[] nArray2 = new int[n4];
        if (nArray.length - n2 < n4) {
            System.arraycopy(nArray, n2, nArray2, 0, nArray.length - n2);
        } else {
            System.arraycopy(nArray, n2, nArray2, 0, n4);
        }
        return nArray2;
    }

    public static long[] copyOfRange(long[] lArray, int n2, int n3) {
        int n4 = Arrays.getLength(n2, n3);
        long[] lArray2 = new long[n4];
        if (lArray.length - n2 < n4) {
            System.arraycopy(lArray, n2, lArray2, 0, lArray.length - n2);
        } else {
            System.arraycopy(lArray, n2, lArray2, 0, n4);
        }
        return lArray2;
    }

    public static BigInteger[] copyOfRange(BigInteger[] bigIntegerArray, int n2, int n3) {
        int n4 = Arrays.getLength(n2, n3);
        BigInteger[] bigIntegerArray2 = new BigInteger[n4];
        if (bigIntegerArray.length - n2 < n4) {
            System.arraycopy(bigIntegerArray, n2, bigIntegerArray2, 0, bigIntegerArray.length - n2);
        } else {
            System.arraycopy(bigIntegerArray, n2, bigIntegerArray2, 0, n4);
        }
        return bigIntegerArray2;
    }

    private static int getLength(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException(n2 + " > " + n3);
        }
        return n4;
    }
}

