/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.utils.ThreeState;

public final class CharsetIMC {
    public static CharsetIMC INSTANCE = new CharsetIMC();
    private final Multimap<String, ResourceLocation> registryLocs = HashMultimap.create();
    private final Multimap<String, String> registryDomainLocs = HashMultimap.create();
    private final Multimap<String, Consumer<CharsetIMC>> registryChangeListeners = MultimapBuilder.hashKeys().arrayListValues().build();
    private Set<Consumer<CharsetIMC>> queuedListeners = Collections.newSetFromMap(new IdentityHashMap());
    private int registriesFrozen = 0;
    private int buildingCallQueue = 0;

    private CharsetIMC() {
    }

    public void freezeRegistries() {
        ++this.registriesFrozen;
    }

    public void unfreezeRegistries() {
        --this.registriesFrozen;
        if (this.registriesFrozen < 0) {
            ModCharset.logger.warn("unfreezeRegistries called without matching freeze!", new Throwable());
            this.registriesFrozen = 0;
        }
    }

    private boolean checkFrozen(String key) {
        if (this.registriesFrozen > 0) {
            ModCharset.logger.warn("Tried to register for key " + key + " while registries frozen!", new Throwable());
            return true;
        }
        return false;
    }

    public boolean registerListener(String key, Consumer<CharsetIMC> consumer) {
        return this.registryChangeListeners.put((Object)key, consumer);
    }

    public void beginQueueingListeners() {
        ++this.buildingCallQueue;
    }

    public void endQueueingListeners() {
        --this.buildingCallQueue;
        if (this.buildingCallQueue < 0) {
            throw new RuntimeException("endQueueingListeners called without matching begin!");
        }
        if (this.buildingCallQueue == 0) {
            for (Consumer<CharsetIMC> consumer : this.queuedListeners) {
                consumer.accept(this);
            }
            this.queuedListeners.clear();
        }
    }

    private void onChange(String key) {
        if (key.contains(":")) {
            key = key.substring(key.indexOf(":") + 1);
        }
        if (this.buildingCallQueue > 0) {
            this.queuedListeners.addAll(this.registryChangeListeners.get((Object)key));
        } else {
            for (Consumer consumer : this.registryChangeListeners.get((Object)key)) {
                consumer.accept(this);
            }
        }
    }

    public void loadConfig(Configuration config) {
        String[] sSplit;
        this.beginQueueingListeners();
        for (String s : ConfigUtils.getStringList(config, "functionalityRegistry", "whitelist", new String[0], "Functionality registry whitelist (example entry: carry:minecraft:bedrock)", true)) {
            sSplit = s.split(":", 2);
            if (sSplit.length >= 2) {
                this.add("w:" + sSplit[0], new ResourceLocation(sSplit[1]));
                continue;
            }
            ModCharset.logger.warn("Invalid functionality registry config entry: " + s);
        }
        for (String s : ConfigUtils.getStringList(config, "functionalityRegistry", "blacklist", new String[0], "Functionality registry blacklist (example entry: carry:minecraft:bedrock)", true)) {
            sSplit = s.split(":", 2);
            if (sSplit.length >= 2) {
                this.add("b:" + sSplit[0], new ResourceLocation(sSplit[1]));
                continue;
            }
            ModCharset.logger.warn("Invalid functionality registry config entry: " + s);
        }
        config.get("functionalityRegistry", "whitelist", new String[0]);
        this.endQueueingListeners();
    }

    public ThreeState allows(String key, ResourceLocation location) {
        String bKey = "b:" + key;
        String wKey = "w:" + key;
        if (this.registryLocs.get((Object)bKey).contains(location)) {
            return ThreeState.NO;
        }
        if (this.registryLocs.get((Object)wKey).contains(location)) {
            return ThreeState.YES;
        }
        if (this.registryDomainLocs.get((Object)bKey).contains(location.func_110624_b())) {
            return ThreeState.NO;
        }
        if (this.registryDomainLocs.get((Object)wKey).contains(location.func_110624_b())) {
            return ThreeState.YES;
        }
        return ThreeState.MAYBE;
    }

    public ThreeState allows(String key, Collection<ResourceLocation> locations) {
        ThreeState result = ThreeState.MAYBE;
        for (ResourceLocation loc : locations) {
            ThreeState newResult = this.allows(key, loc);
            if (newResult == ThreeState.NO) {
                return ThreeState.NO;
            }
            if (result == ThreeState.YES) continue;
            result = newResult;
        }
        return result;
    }

    private boolean add(Collection<String> entryKeys, ResourceLocation entry) {
        boolean result = false;
        for (String entryKey : entryKeys) {
            result |= this.add(entryKey, entry);
        }
        return result;
    }

    private boolean add(String entryKey, ResourceLocation entry) {
        if (this.checkFrozen(entryKey)) {
            return false;
        }
        boolean result = entry.func_110623_a().equals("*") ? this.registryDomainLocs.put((Object)entryKey, (Object)entry.func_110624_b()) : this.registryLocs.put((Object)entryKey, (Object)entry);
        if (result) {
            this.onChange(entryKey);
        }
        return result;
    }

    private boolean remove(String entryKey, ResourceLocation entry) {
        if (this.checkFrozen(entryKey)) {
            return false;
        }
        boolean result = entry.func_110623_a().equals("*") ? this.registryDomainLocs.remove((Object)entryKey, (Object)entry.func_110624_b()) : this.registryLocs.remove((Object)entryKey, (Object)entry);
        if (result) {
            this.onChange(entryKey);
        }
        return result;
    }

    private String toEntryKey(String entryKey, String prefix) {
        entryKey = entryKey.trim();
        return prefix + entryKey.substring(0, 1).toLowerCase() + entryKey.substring(1);
    }

    private List<String> toList(String entryKey, String prefix) {
        if (entryKey.startsWith("[") && entryKey.endsWith("]")) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : entryKey.substring(1, entryKey.length() - 1).split(",")) {
                keys.add(this.toEntryKey(key, prefix));
            }
            return keys;
        }
        return Lists.newArrayList((Object[])new String[]{this.toEntryKey(entryKey, prefix)});
    }

    public boolean add(ThreeState state, String key, ResourceLocation location) {
        switch (state) {
            case YES: {
                return this.add("w:" + key, location);
            }
            case NO: {
                return this.add("b:" + key, location);
            }
        }
        return false;
    }

    public boolean remove(ThreeState state, String key, ResourceLocation location) {
        switch (state) {
            case YES: {
                return this.remove("w:" + key, location);
            }
            case NO: {
                return this.remove("b:" + key, location);
            }
        }
        return false;
    }

    public void receiveMessage(FMLInterModComms.IMCMessage msg) {
        this.beginQueueingListeners();
        for (String key : msg.key.split(";")) {
            List<String> entryKeys;
            if ((key = key.trim()).startsWith("add")) {
                entryKeys = this.toList(key.substring("add".length()), "w:");
                if (!msg.isResourceLocationMessage()) continue;
                this.add(entryKeys, msg.getResourceLocationValue());
                continue;
            }
            if (!key.startsWith("remove")) continue;
            entryKeys = this.toList(key.substring("remove".length()), "b:");
            if (!msg.isResourceLocationMessage()) continue;
            this.add(entryKeys, msg.getResourceLocationValue());
        }
        this.endQueueingListeners();
    }
}

