/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils.redstone;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.MultipartHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.lib.modcompat.mcmultipart.MCMPUtils;
import pl.asie.charset.lib.utils.redstone.IRedstoneGetter;

public final class RedstoneUtils {
    private static final List<IRedstoneGetter> GETTERS = new ArrayList<IRedstoneGetter>();

    private RedstoneUtils() {
    }

    public static int getComparatorValue(IItemHandler handler, int max) {
        float value = 0.0f;
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            value += (float)(stack.func_190916_E() / Math.min(stack.func_77976_d(), handler.getSlotLimit(i)));
            ++count;
        }
        if (count > 0) {
            return 1 + MathHelper.func_76141_d((float)(value * (float)(max - 1) / (float)handler.getSlots()));
        }
        return 0;
    }

    public static void addRedstoneGetter(IRedstoneGetter getter) {
        GETTERS.add(getter);
    }

    public static int getModdedWeakPower(IBlockAccess w, BlockPos p, EnumFacing face, EnumFacing edge, Predicate<TileEntity> tileEntityPredicate) {
        for (IRedstoneGetter getter : GETTERS) {
            int v = getter.get(w, p, face, edge, tileEntityPredicate);
            if (v < 0) continue;
            return v;
        }
        return -1;
    }

    public static byte[] getModdedBundledPower(IBlockAccess w, BlockPos p, EnumFacing face, EnumFacing edge, Predicate<TileEntity> tileEntityPredicate) {
        for (IRedstoneGetter getter : GETTERS) {
            byte[] v = getter.getBundled(w, p, face, edge, tileEntityPredicate);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static int getRedstonePower(World world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockRedstoneWire) {
            return (Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        }
        return block.shouldCheckWeakPower(iblockstate, (IBlockAccess)world, pos, facing) ? world.func_175676_y(pos) : iblockstate.func_185911_a((IBlockAccess)world, pos, facing);
    }

    public static boolean canConnectFace(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side, EnumFacing face) {
        Block block = state.func_177230_c();
        if ((block instanceof BlockRedstoneDiode || block instanceof BlockRedstoneWire || block instanceof BlockDaylightDetector || block instanceof BlockBasePressurePlate) && face != EnumFacing.DOWN) {
            return false;
        }
        if (block instanceof BlockRedstoneRepeater && ((EnumFacing)state.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D)).func_176740_k() != side.func_176740_k()) {
            return false;
        }
        if (block instanceof BlockLever && face != ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c().func_176734_d()) {
            return false;
        }
        if (block instanceof BlockButton && face != ((EnumFacing)state.func_177229_b((IProperty)BlockButton.field_176387_N)).func_176734_d()) {
            return false;
        }
        if (Loader.isModLoaded((String)"mcmultipart")) {
            return RedstoneUtils.canConnectRedstoneMultipart(state, block, world, pos, side, face);
        }
        return block.canConnectRedstone(state, world, pos, side);
    }

    @Optional.Method(modid="mcmultipart")
    private static boolean canConnectRedstoneMultipart(IBlockState state, Block block, IBlockAccess world, BlockPos pos, EnumFacing side, EnumFacing face) {
        Optional ui = MultipartHelper.getContainer((IBlockAccess)world, (BlockPos)pos);
        if (ui.isPresent()) {
            return MCMPUtils.streamParts((IMultipartContainer)ui.get(), face, side.func_176734_d()).anyMatch(info -> info.getPart().canConnectRedstone((IBlockAccess)info.getPartWorld(), info.getPartPos(), info, side));
        }
        return block.canConnectRedstone(state, world, pos, side);
    }
}

