/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.api.lib.IBlockCapabilityProvider;
import pl.asie.charset.api.lib.ICacheable;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.capability.TileCache;

public class CapabilityCache
extends TileCache {
    protected final boolean blocks;
    protected final boolean tiles;
    protected final boolean entities;
    protected boolean hasBlockCaps;
    protected boolean hasEntityCaps;

    public CapabilityCache(World world, BlockPos pos, boolean blocks, boolean tiles, boolean entities) {
        super(world, pos);
        this.blocks = blocks;
        this.tiles = tiles;
        this.entities = entities;
    }

    @Override
    public void reload() {
        super.reload();
        this.hasBlockCaps = CapabilityHelper.blockProviders.containsRow((Object)this.state.func_177230_c());
        this.hasEntityCaps = this.state.func_185917_h();
    }

    public <T> T get(Capability<T> capability, EnumFacing facing) {
        IBlockCapabilityProvider provider;
        T result;
        TileEntity tile;
        this.getBlock();
        if (this.tiles && this.hasTile && (tile = this.getTile()) != null && (result = CapabilityHelper.get(capability, (ICapabilityProvider)tile, facing)) != null) {
            return result;
        }
        if (this.blocks && this.hasBlockCaps && (provider = (IBlockCapabilityProvider)CapabilityHelper.blockProviders.get((Object)this.state.func_177230_c(), capability)) != null && (result = provider.create((IBlockAccess)this.world, this.pos, this.state, facing)) != null) {
            return result;
        }
        if (this.entities && this.hasEntityCaps) {
            List entityList = this.world.func_72839_b(null, new AxisAlignedBB(this.pos));
            for (Entity entity : entityList) {
                T result2 = CapabilityHelper.get(capability, (ICapabilityProvider)entity, facing);
                if (result2 == null) continue;
                return result2;
            }
        }
        return null;
    }

    public static class Single<T>
    extends CapabilityCache {
        private final Capability<T> capability;
        private final EnumFacing facing;
        private ICacheable object;

        public Single(World world, BlockPos pos, boolean blocks, boolean tiles, boolean entities, Capability<T> capability, EnumFacing facing) {
            super(world, pos, blocks, tiles, entities);
            this.capability = capability;
            this.facing = facing;
        }

        @Override
        public void reload() {
            super.reload();
            this.hasBlockCaps = CapabilityHelper.blockProviders.contains((Object)this.state.func_177230_c(), this.capability);
        }

        public T get() {
            if (this.state == null) {
                this.object = null;
            }
            if (this.object != null && this.object.isCacheValid()) {
                return (T)this.object;
            }
            T result = this.get(this.capability, this.facing);
            this.object = result instanceof ICacheable ? (ICacheable)result : null;
            return result;
        }
    }
}

