/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.api.lib.IDyeableItem;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.recipe.IRecipeResultBuilder;
import pl.asie.charset.lib.recipe.RecipeBase;
import pl.asie.charset.lib.recipe.ingredient.IngredientCharset;
import pl.asie.charset.lib.utils.ColorUtils;

public class DyeableItemRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext jsonContext, JsonObject jsonObject) {
        Ingredient input = CraftingHelper.getIngredient((JsonElement)jsonObject.get("input"), (JsonContext)jsonContext);
        return new Recipe(jsonContext, jsonObject, input);
    }

    public static class Recipe
    extends RecipeBase {
        public final Ingredient DYE = IngredientCharset.wrap(new DyeIngredient());
        public final Ingredient input;

        public Recipe(JsonContext context, JsonObject object, Ingredient ingredient) {
            super(context, object);
            this.input = ingredient;
        }

        public Recipe(String group, Ingredient ingredient) {
            super(group);
            this.input = ingredient;
        }

        protected int[] getColor(ItemStack stack) {
            if (!stack.func_190926_b()) {
                if (stack.hasCapability(Capabilities.DYEABLE_ITEM, null)) {
                    IDyeableItem targetItem = (IDyeableItem)stack.getCapability(Capabilities.DYEABLE_ITEM, null);
                    if (targetItem.hasColor(0)) {
                        int c = targetItem.getColor(0);
                        return new int[]{c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF};
                    }
                } else {
                    EnumDyeColor dyeId = ColorUtils.getDyeColor(stack);
                    if (dyeId != null) {
                        float[] col = dyeId.func_193349_f();
                        return new int[]{(int)(col[0] * 255.0f), (int)(col[1] * 255.0f), (int)(col[2] * 255.0f)};
                    }
                }
            }
            return null;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            ItemStack target = ItemStack.field_190927_a;
            ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack source = inv.func_70301_a(i);
                if (source.func_190926_b()) continue;
                if (this.input.apply(source)) {
                    if (!target.func_190926_b()) {
                        return false;
                    }
                    target = source;
                    continue;
                }
                if (this.getColor(source) != null) {
                    dyes.add(source);
                    continue;
                }
                return false;
            }
            return !target.func_190926_b() && !dyes.isEmpty();
        }

        protected Optional<Integer> getMixedColor(InventoryCrafting inv, ItemStack base, Predicate<Integer> slotFilter) {
            int[] col;
            int[] color = new int[3];
            int scale = 0;
            int count = 0;
            if (!base.func_190926_b() && (col = this.getColor(base)) != null) {
                scale += Math.max(col[0], Math.max(col[1], col[2]));
                color[0] = color[0] + col[0];
                color[1] = color[1] + col[1];
                color[2] = color[2] + col[2];
                ++count;
            }
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                int[] col2;
                ItemStack source;
                if (slotFilter != null && !slotFilter.test(i) || (source = inv.func_70301_a(i)).func_190926_b() || source == base || (col2 = this.getColor(source)) == null) continue;
                scale += Math.max(col2[0], Math.max(col2[1], col2[2]));
                color[0] = color[0] + col2[0];
                color[1] = color[1] + col2[1];
                color[2] = color[2] + col2[2];
                ++count;
            }
            if (count > 0) {
                int i1 = color[0] / count;
                int j1 = color[1] / count;
                int k1 = color[2] / count;
                float f3 = (float)scale / (float)count;
                float f4 = Math.max(i1, Math.max(j1, k1));
                i1 = (int)((float)i1 * f3 / f4);
                j1 = (int)((float)j1 * f3 / f4);
                k1 = (int)((float)k1 * f3 / f4);
                return Optional.of((i1 << 16) + (j1 << 8) + k1);
            }
            return Optional.empty();
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            Optional<Integer> result;
            ItemStack target = ItemStack.field_190927_a;
            IDyeableItem targetItem = null;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack source = inv.func_70301_a(i);
                if (source.func_190926_b() || !source.hasCapability(Capabilities.DYEABLE_ITEM, null)) continue;
                target = source.func_77946_l();
                target.func_190920_e(1);
                targetItem = (IDyeableItem)target.getCapability(Capabilities.DYEABLE_ITEM, null);
            }
            if (targetItem != null && (result = this.getMixedColor(inv, target, null)).isPresent()) {
                targetItem.setColor(0, result.get());
                return target;
            }
            return null;
        }

        @Override
        protected ItemStack toRemainingItem(ItemStack from) {
            if (!from.func_190926_b() && from.hasCapability(Capabilities.DYEABLE_ITEM, null)) {
                return ItemStack.field_190927_a;
            }
            return super.toRemainingItem(from);
        }

        public boolean func_194133_a(int i, int i1) {
            return i * i1 > 1;
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }

        public NonNullList<Ingredient> func_192400_c() {
            return NonNullList.func_193580_a((Object)this.input, (Object[])new Ingredient[]{this.DYE, this.DYE});
        }

        public class DyeIngredient
        extends IngredientCharset {
            private DyeIngredient() {
            }

            @Override
            protected ItemStack[][] createMatchingStacks() {
                NonNullList stacks = OreDictionary.getOres((String)"dye");
                return new ItemStack[][]{stacks.toArray(new ItemStack[stacks.size()])};
            }

            @Override
            public boolean hasMatchingStacks() {
                return true;
            }

            @Override
            public boolean matches(ItemStack stack, IRecipeResultBuilder builder) {
                return Recipe.this.getColor(stack) != null;
            }
        }
    }
}

