/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import pl.asie.charset.lib.recipe.IRecipeResultBuilder;
import pl.asie.charset.lib.recipe.IRecipeView;
import pl.asie.charset.lib.recipe.ingredient.IngredientCharset;
import pl.asie.charset.lib.recipe.ingredient.IngredientWrapper;

public class IngredientMatcher
implements IRecipeResultBuilder {
    private final IRecipeView view;
    private final Map<Ingredient, ItemStack> matchedStacks = new HashMap<Ingredient, ItemStack>();

    public IngredientMatcher(IRecipeView view) {
        this.view = view;
    }

    public Collection<Ingredient> getMatchedIngredients() {
        return this.matchedStacks.keySet();
    }

    @Override
    public Ingredient getIngredient(char c) {
        return this.view.getIngredient(c);
    }

    @Override
    public ItemStack getStack(Ingredient i) {
        return this.matchedStacks.getOrDefault(i, ItemStack.field_190927_a);
    }

    public boolean add(ItemStack stack, Ingredient ingredient) {
        if (ingredient == Ingredient.field_193370_a) {
            return stack.func_190926_b();
        }
        boolean match = false;
        if (ingredient instanceof IngredientWrapper) {
            IngredientCharset ic = ((IngredientWrapper)ingredient).getIngredientCharset();
            if (ic.matches(stack, this)) {
                if (this.matchedStacks.containsKey(ingredient) && !ic.matchSameGrid(this.matchedStacks.get(ingredient), stack)) {
                    return false;
                }
                match = true;
            }
        } else {
            match = ingredient.apply(stack);
        }
        if (match) {
            this.matchedStacks.put(ingredient, stack);
            return true;
        }
        return false;
    }

    public ItemStack apply(ItemStack stack) {
        boolean applied = false;
        for (Map.Entry<Ingredient, ItemStack> entry : this.matchedStacks.entrySet()) {
            if (!(entry.getKey() instanceof IngredientWrapper)) continue;
            if (!applied) {
                applied = true;
                stack = stack.func_77946_l();
            }
            stack = ((IngredientWrapper)entry.getKey()).getIngredientCharset().transform(stack, entry.getValue(), this);
        }
        return stack;
    }
}

