/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.misc.ISimpleLogicSidedEmitter;
import pl.asie.charset.lib.modcompat.mcmultipart.MCMPUtils;
import pl.asie.charset.lib.utils.MultipartUtils;
import pl.asie.charset.lib.wires.BlockWire;
import pl.asie.charset.lib.wires.TileWire;
import pl.asie.charset.lib.wires.Wire;

public final class WireUtils {
    private static final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}};

    private WireUtils() {
    }

    public static EnumFacing[] getConnectionsForRender(WireFace face) {
        return CONNECTION_DIRS[face.ordinal()];
    }

    public static boolean hasCapability(Wire wire, BlockPos pos, Capability<?> capability, EnumFacing face, boolean ignoreWires) {
        Object o;
        boolean result;
        TileWire.isWireCheckingForCaps = ignoreWires;
        Optional container = MultipartHelper.getContainer((IBlockAccess)wire.getContainer().world(), (BlockPos)pos);
        if (container.isPresent()) {
            boolean result2 = MCMPUtils.streamParts((IMultipartContainer)container.get(), wire.getLocation().facing, face).anyMatch(info -> info != null && info.getTile() != null && info.getTile().hasPartCapability(capability, face));
            TileWire.isWireCheckingForCaps = false;
            return result2;
        }
        TileEntity tile = wire.getContainer().world().func_175625_s(pos);
        boolean bl = result = tile != null && tile.hasCapability(capability, face);
        if (result && (o = tile.getCapability(capability, face)) instanceof ISimpleLogicSidedEmitter && ((ISimpleLogicSidedEmitter)o).getEmitterFace() != wire.getLocation().facing) {
            result = false;
        }
        TileWire.isWireCheckingForCaps = false;
        return result;
    }

    public static ICapabilityProvider getCapabilityProvider(Wire searcher, BlockPos pos, boolean ignoreWires) {
        TileEntity tile = searcher.getContainer().world().func_175625_s(pos);
        if (tile != null) {
            return tile;
        }
        return null;
    }

    public static <T> T getCapability(Wire searcher, BlockPos pos, Capability<T> capability, EnumFacing face, boolean ignoreWires) {
        TileWire.isWireCheckingForCaps = ignoreWires;
        Optional container = MultipartHelper.getContainer((IBlockAccess)searcher.getContainer().world(), (BlockPos)pos);
        if (container.isPresent()) {
            T result = MCMPUtils.streamParts((IMultipartContainer)container.get(), searcher.getLocation().facing, face).filter(info -> info != null && info.getTile() != null && info.getTile().hasPartCapability(capability, face)).map(info -> info.getTile().getPartCapability(capability, face)).findFirst().orElse(null);
            TileWire.isWireCheckingForCaps = false;
            return result;
        }
        TileEntity tile = searcher.getContainer().world().func_175625_s(pos);
        Object result = tile != null ? tile.getCapability(capability, face) : null;
        TileWire.isWireCheckingForCaps = false;
        return (T)result;
    }

    public static boolean canConnectInternal(Wire wire, WireFace side) {
        if (side == wire.getLocation()) {
            return false;
        }
        Wire wire2 = WireUtils.getWire((IBlockAccess)wire.getContainer().world(), wire.getContainer().pos(), side);
        return wire2 != null && wire2.canConnectWire(wire);
    }

    public static boolean canConnectExternal(Wire wire, EnumFacing facing) {
        BlockPos pos2 = wire.getContainer().pos().func_177972_a(facing);
        Wire wire2 = WireUtils.getWire((IBlockAccess)wire.getContainer().world(), pos2, wire.getLocation());
        if (wire2 != null) {
            if (wire2.isOccluded(facing.func_176734_d())) {
                return false;
            }
            return wire2.canConnectWire(wire);
        }
        return wire.canConnectBlock(pos2, facing.func_176734_d());
    }

    public static boolean canConnectCorner(Wire wire, EnumFacing direction) {
        if (wire.getLocation() == WireFace.CENTER || wire.isCornerOccluded(direction)) {
            return false;
        }
        EnumFacing side = wire.getLocation().facing;
        BlockPos middlePos = wire.getContainer().pos().func_177972_a(direction);
        BlockPos cornerPos = middlePos.func_177972_a(side);
        Wire wire2 = WireUtils.getWire((IBlockAccess)wire.getContainer().world(), cornerPos, WireFace.get(direction.func_176734_d()));
        if (wire2 == null || wire2.isCornerOccluded(side.func_176734_d()) || !wire2.canConnectWire(wire)) {
            return false;
        }
        AxisAlignedBB mask = wire.getProvider().getCornerCollisionBox(wire.getLocation(), direction.func_176734_d());
        return !MultipartUtils.INSTANCE.intersects(Collections.singletonList(mask), (IBlockAccess)wire.getContainer().world(), middlePos, state -> !(state.func_177230_c() instanceof BlockWire));
    }

    @Nullable
    public static Wire getWire(IBlockAccess access, BlockPos pos, WireFace face) {
        Optional containerOpt;
        IMultipartContainer container = null;
        if (access instanceof IMultipartBlockAccess) {
            access = ((IMultipartBlockAccess)access).getActualWorld();
        }
        if ((containerOpt = MultipartHelper.getContainer((IBlockAccess)access, (BlockPos)pos)).isPresent()) {
            container = (IMultipartContainer)containerOpt.get();
        }
        if (container != null) {
            Wire wire;
            Optional tile = container.getPartTile(WireUtils.toPartSlot(face));
            if (tile.isPresent() && ((IMultipartTile)tile.get()).getTileEntity() instanceof TileWire && (wire = ((TileWire)((IMultipartTile)tile.get()).getTileEntity()).wire) != null && wire.getLocation() == face) {
                return ((TileWire)((IMultipartTile)tile.get()).getTileEntity()).wire;
            }
            return null;
        }
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileWire && ((TileWire)tile).wire != null && ((TileWire)tile).wire.getLocation() == face) {
            return ((TileWire)tile).wire;
        }
        return null;
    }

    @Nullable
    public static Wire getAnyWire(IBlockAccess access, BlockPos pos) {
        IPartInfo info;
        if (access instanceof IMultipartBlockAccess && (info = ((IMultipartBlockAccess)access).getPartInfo()).getPartPos().equals((Object)pos)) {
            return WireUtils.getAnyWire(info.getTile().getTileEntity());
        }
        return WireUtils.getAnyWire(access.func_175625_s(pos));
    }

    public static Collection<Wire> getAllWires(IBlockAccess access, BlockPos pos) {
        Optional containerOpt = MultipartHelper.getContainer((IBlockAccess)access, (BlockPos)pos);
        if (containerOpt.isPresent()) {
            IMultipartContainer container = (IMultipartContainer)containerOpt.get();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (IPartInfo partInfo : container.getParts().values()) {
                if (!(partInfo.getTile() instanceof TileWire) || ((TileWire)partInfo.getTile()).wire == null) continue;
                builder.add((Object)((TileWire)partInfo.getTile()).wire);
            }
            return builder.build();
        }
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileWire && ((TileWire)tile).wire != null) {
            return Collections.singleton(((TileWire)tile).wire);
        }
        return Collections.emptySet();
    }

    @Nullable
    public static Wire getAnyWire(TileEntity tile) {
        if (tile != null && tile instanceof TileWire) {
            return ((TileWire)tile).wire;
        }
        return null;
    }

    public static IPartSlot toPartSlot(WireFace face) {
        return face == WireFace.CENTER ? EnumCenterSlot.CENTER : EnumFaceSlot.fromFace((EnumFacing)face.facing);
    }
}

