/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import gnu.trove.set.hash.TCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.block.model.multipart.Multipart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentScore;
import net.minecraft.util.text.TextComponentSelector;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.Logger;
import pl.asie.foamfix.client.FoamyItemLayerModel;
import pl.asie.foamfix.client.IDeduplicatingStorage;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.foamfix.util.DeduplicatingStorageTrove;
import pl.asie.foamfix.util.HashingStrategies;
import pl.asie.foamfix.util.MethodHandleHelper;

public class Deduplicator {
    private static final Set<Class> BLACKLIST_CLASS = new TCustomHashSet(HashingStrategies.IDENTITY);
    private static final Set<Class> IMMUTABLE_CLASS = new TCustomHashSet(HashingStrategies.IDENTITY);
    private static final Set<Class> TRIM_ARRAYS_CLASSES = new TCustomHashSet(HashingStrategies.IDENTITY);
    private static final Map<Class, Set<MethodHandle[]>> CLASS_FIELDS = new IdentityHashMap<Class, Set<MethodHandle[]>>();
    private static final Map<Class, MethodHandle> COLLECTION_CONSTRUCTORS = new IdentityHashMap<Class, MethodHandle>();
    private static final Style STYLE_EMPTY = new Style();
    private static final MethodHandle EM_KEY_UNIVERSE_GETTER = MethodHandleHelper.findFieldGetter(EnumMap.class, "keyUniverse");
    private static final MethodHandle EM_KEY_UNIVERSE_SETTER = MethodHandleHelper.findFieldSetter(EnumMap.class, "keyUniverse");
    private static final MethodHandle FIELD_UNPACKED_DATA_GETTER = MethodHandleHelper.findFieldGetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle FIELD_UNPACKED_DATA_SETTER = MethodHandleHelper.findFieldSetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle IPAM_MW_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle IPAM_MW_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle BIM_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter("net.minecraftforge.client.model.BakedItemModel", "transforms");
    private static final MethodHandle BIM_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter("net.minecraftforge.client.model.BakedItemModel", "transforms");
    private static final MethodHandle IOL_OVERRIDES_GETTER = MethodHandleHelper.findFieldGetter(ItemOverrideList.class, "overrides", "field_188023_b");
    private static final MethodHandle IOL_OVERRIDES_SETTER = MethodHandleHelper.findFieldSetter(ItemOverrideList.class, "overrides", "field_188023_b");
    public int successfulTrims = 0;
    public int successfuls = 0;
    public int maxRecursion = 0;
    private final Map<Object, Optional> JAVA_OPTIONALS = new IdentityHashMap<Object, Optional>();
    private final Map<Object, com.google.common.base.Optional> GUAVA_OPTIONALS = new IdentityHashMap<Object, com.google.common.base.Optional>();
    private final IDeduplicatingStorage<Object[]> KEY_UNIVERSE_STORAGE = new DeduplicatingStorageTrove<Object[]>(HashingStrategies.OBJECT_ARRAY);
    private final IDeduplicatingStorage<float[]> FLOATA_STORAGE = new DeduplicatingStorageTrove<float[]>(HashingStrategies.FLOAT_ARRAY);
    private final IDeduplicatingStorage<float[][]> FLOATAA_STORAGE = new DeduplicatingStorageTrove<float[][]>(HashingStrategies.FLOAT_ARRAY_ARRAY);
    private final IDeduplicatingStorage OBJECT_STORAGE = new DeduplicatingStorageTrove<Object>(HashingStrategies.GENERIC);
    private final IDeduplicatingStorage<ItemCameraTransforms> ICT_STORAGE = new DeduplicatingStorageTrove<ItemCameraTransforms>(HashingStrategies.ITEM_CAMERA_TRANSFORMS);
    private final Set<Object> deduplicatedObjects = new TCustomHashSet(HashingStrategies.IDENTITY);

    private static void addClassFromName(Set<Class> set, String className) {
        try {
            set.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private boolean shouldCheckClass(Class c) {
        if (BLACKLIST_CLASS.contains(c)) {
            return false;
        }
        if (c.isPrimitive() || c.isEnum() || c.isArray() && !this.shouldCheckClass(c.getComponentType())) {
            BLACKLIST_CLASS.add(c);
            return false;
        }
        return true;
    }

    public void addObject(Object o) {
        this.OBJECT_STORAGE.deduplicate(o);
    }

    public void addObjects(Collection coll) {
        for (Object o : coll) {
            this.OBJECT_STORAGE.deduplicate(o);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deduplicate0(Object o) {
        Object n = o;
        int size = 0;
        if (o instanceof float[]) {
            size = 24 + ((float[])o).length * 4;
            n = this.FLOATA_STORAGE.deduplicate((float[])o);
        } else if (o instanceof float[][]) {
            size = 16 + ((float[][])o).length * 4;
            float[][] arr = this.FLOATAA_STORAGE.deduplicate((float[][])o);
            if (arr != o) {
                n = arr;
                this.successfuls += arr.length;
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (float[])this.deduplicate0(arr[i]);
                }
            }
        } else if (o instanceof float[][][]) {
            float[][][] arr = (float[][][])o;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (float[][])this.deduplicate0(arr[i]);
            }
        } else if (o instanceof ImmutableList || o instanceof ImmutableSet || o instanceof ImmutableMap) {
            n = this.OBJECT_STORAGE.deduplicate(o);
        } else {
            Class<?> c = o.getClass();
            if (o instanceof ResourceLocation) {
                if (ResourceLocation.class != c && ModelResourceLocation.class != c) return o;
                size = 16;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (Vec3d.class == c || Vec3i.class == c || BlockPos.class == c) {
                size = 16;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (Style.class == c) {
                if (!FoamFixShared.isCoremod) return o;
                n = this.deduplicateStyleIfCoremodPresent((Style)o);
            } else if (TRSRTransformation.class == c) {
                size = 257;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else {
                if (ItemCameraTransforms.class != c) throw new RuntimeException("Unsupported: " + c);
                size = 80;
                n = this.ICT_STORAGE.deduplicate((ItemCameraTransforms)o);
            }
        }
        if (n == o) return n;
        ++this.successfuls;
        FoamFixShared.ramSaved += size;
        return n;
    }

    private Style deduplicateStyleIfCoremodPresent(Style s) {
        while (s.field_150248_c == null && s.field_150245_d == null && s.field_150244_g == null && s.field_150243_f == null && s.field_150246_e == null && s.field_150251_h == null && s.field_150252_i == null && s.field_150247_b == null && s.field_179990_j == null) {
            s = s.field_150249_a;
            if (s != null) continue;
            return STYLE_EMPTY;
        }
        return s;
    }

    private boolean trimArray(Object o) {
        if (o instanceof ArrayList) {
            ((ArrayList)o).trimToSize();
            ++this.successfulTrims;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deduplicateObject(Object o, int recursion) {
        boolean deduplicated;
        Object opt;
        boolean canTrim;
        if (o == null) return o;
        if (recursion > this.maxRecursion) {
            return o;
        }
        Class<?> clazz = o.getClass();
        if (!this.shouldCheckClass(clazz)) {
            return o;
        }
        if (!this.deduplicatedObjects.add(o)) {
            return o;
        }
        boolean bl = canTrim = o instanceof Predicate || TRIM_ARRAYS_CLASSES.contains(clazz);
        if (canTrim && clazz == SimpleBakedModel.class) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                List l = ((SimpleBakedModel)o).func_188616_a(null, facing, 0L);
                this.trimArray(l);
            }
        }
        if (o instanceof IBakedModel) {
            Object to;
            if (o instanceof PerspectiveMapWrapper) {
                try {
                    to = IPAM_MW_TRANSFORMS_GETTER.invoke(o);
                    Object toD = this.deduplicate0(to);
                    if (toD != null && to != toD) {
                        IPAM_MW_TRANSFORMS_SETTER.invoke(o, toD);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if ("net.minecraftforge.client.model.BakedItemModel".equals(clazz.getName())) {
                try {
                    to = BIM_TRANSFORMS_GETTER.invoke(o);
                    Object toD = this.deduplicate0(to);
                    if (toD != null && to != toD) {
                        BIM_TRANSFORMS_SETTER.invoke(o, toD);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        if (clazz == BlockPartFace.class) {
            ((BlockPartFace)o).field_178243_e.field_178351_a = (float[])this.deduplicate0(((BlockPartFace)o).field_178243_e.field_178351_a);
            return o;
        }
        if (o instanceof BakedQuad) {
            void var3_5;
            if (clazz == BakedQuad.class && FoamFixShared.config.expUnpackBakedQuads) {
                BakedQuad quad = (BakedQuad)o;
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(quad.getFormat());
                quad.pipe((IVertexConsumer)builder);
                o = builder.build();
                Class<UnpackedBakedQuad> clazz2 = UnpackedBakedQuad.class;
            }
            if (var3_5 != UnpackedBakedQuad.class) return o;
            try {
                float[][][] array = FIELD_UNPACKED_DATA_GETTER.invokeExact((UnpackedBakedQuad)o);
                this.deduplicate0(array);
                return o;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return o;
        }
        if (o instanceof ResourceLocation) return this.deduplicate0(o);
        if (clazz == TRSRTransformation.class) return this.deduplicate0(o);
        if (clazz == Style.class) {
            return this.deduplicate0(o);
        }
        if (clazz == ItemCameraTransforms.class) return this.deduplicate0(o);
        if (clazz == Vec3d.class) return this.deduplicate0(o);
        if (clazz == Vec3i.class) return this.deduplicate0(o);
        if (clazz == BlockPos.class) {
            return this.deduplicate0(o);
        }
        if (o instanceof Item || o instanceof Block || o instanceof World || o instanceof Entity || o instanceof Logger || o instanceof IRegistry) {
            BLACKLIST_CLASS.add(clazz);
            return o;
        }
        if (o instanceof ItemOverrideList && o != ItemOverrideList.field_188022_a) {
            try {
                List list = IOL_OVERRIDES_GETTER.invokeExact((ItemOverrideList)o);
                if (!list.isEmpty()) return o;
                if (clazz == ItemOverrideList.class) {
                    ++this.successfuls;
                    return ItemOverrideList.field_188022_a;
                }
                if (clazz != AnimationItemOverrideList.class) return o;
                IOL_OVERRIDES_SETTER.invokeExact((ItemOverrideList)o, (List)ImmutableList.of());
                ++this.successfuls;
                return o;
            }
            catch (Throwable list) {}
            return o;
        }
        if (o instanceof Optional) {
            opt = (Optional)o;
            if (!((Optional)opt).isPresent()) return opt;
            Object b = this.deduplicateObject(((Optional)opt).get(), recursion + 1);
            if (b == null) return o;
            if (this.JAVA_OPTIONALS.containsKey(b)) {
                ++this.successfuls;
                return this.JAVA_OPTIONALS.get(b);
            }
            if (b != ((Optional)opt).get()) {
                Optional<Object> opt2 = Optional.of(b);
                this.JAVA_OPTIONALS.put(b, opt2);
                return opt2;
            }
            this.JAVA_OPTIONALS.put(((Optional)opt).get(), (Optional)opt);
            return opt;
        }
        if (o instanceof com.google.common.base.Optional) {
            opt = (com.google.common.base.Optional)o;
            if (!opt.isPresent()) return opt;
            Object b = this.deduplicateObject(opt.get(), recursion + 1);
            if (b == null) return o;
            if (this.GUAVA_OPTIONALS.containsKey(b)) {
                ++this.successfuls;
                return this.GUAVA_OPTIONALS.get(b);
            }
            if (b != opt.get()) {
                com.google.common.base.Optional opt2 = com.google.common.base.Optional.of((Object)b);
                this.GUAVA_OPTIONALS.put(b, opt2);
                return opt2;
            }
            this.GUAVA_OPTIONALS.put(opt.get(), (com.google.common.base.Optional)opt);
            return opt;
        }
        if (o instanceof Multimap) {
            if (o instanceof ImmutableMultimap || o instanceof SortedSetMultimap) {
                opt = ((Multimap)o).values().iterator();
                while (opt.hasNext()) {
                    Object value = opt.next();
                    this.deduplicateObject(value, recursion + 1);
                }
                return o;
            }
            opt = ((Multimap)o).keySet().iterator();
            while (opt.hasNext()) {
                Object key = opt.next();
                ArrayList l = Lists.newArrayList((Iterable)((Multimap)o).values());
                for (int i = 0; i < l.size(); ++i) {
                    l.set(i, this.deduplicateObject(l.get(i), recursion + 1));
                }
                ((Multimap)o).replaceValues(key, (Iterable)l);
            }
            return o;
        }
        if (o instanceof Map) {
            Object im;
            for (Object v : ((Map)o).keySet()) {
                this.deduplicateObject(v, recursion + 1);
            }
            if (o instanceof SortedMap || IMMUTABLE_CLASS.contains(clazz)) {
                opt = ((Map)o).values().iterator();
                while (opt.hasNext()) {
                    Object v = opt.next();
                    this.deduplicateObject(v, recursion + 1);
                }
                return o;
            }
            if (o instanceof ImmutableMap) {
                im = (ImmutableMap)o;
                ImmutableBiMap.Builder newMap = o instanceof ImmutableBiMap ? ImmutableBiMap.builder() : ImmutableMap.builder();
                deduplicated = false;
                UnmodifiableIterator i = im.keySet().iterator();
                while (i.hasNext()) {
                    Object key;
                    Object a = im.get(key = i.next());
                    Object b = this.deduplicateObject(a, recursion + 1);
                    newMap.put(key, b != null ? b : a);
                    if (b == null || b == a) continue;
                    deduplicated = true;
                }
                return deduplicated ? newMap.build() : o;
            }
            try {
                im = ((Map)o).keySet().iterator();
                while (im.hasNext()) {
                    Object key = im.next();
                    Object value = ((Map)o).get(key);
                    Object valueD = this.deduplicateObject(value, recursion + 1);
                    if (valueD == null || value == valueD) continue;
                    ((Map)o).put(key, valueD);
                }
                return o;
            }
            catch (UnsupportedOperationException e) {
                IMMUTABLE_CLASS.add(clazz);
                Iterator key = ((Map)o).values().iterator();
                while (key.hasNext()) {
                    Object v = key.next();
                    this.deduplicateObject(v, recursion + 1);
                }
                return o;
            }
        }
        if (o instanceof List) {
            int i;
            List l;
            if (IMMUTABLE_CLASS.contains(clazz)) {
                l = (List)o;
                i = 0;
                while (i < l.size()) {
                    this.deduplicateObject(l.get(i), recursion + 1);
                    ++i;
                }
                return o;
            }
            if (o instanceof ImmutableList) {
                ImmutableList il = (ImmutableList)o;
                ImmutableList.Builder builder = ImmutableList.builder();
                deduplicated = false;
                for (int i2 = 0; i2 < il.size(); ++i2) {
                    Object a = il.get(i2);
                    Object b = this.deduplicateObject(a, recursion + 1);
                    builder.add(b != null ? b : a);
                    if (b == null || b == a) continue;
                    deduplicated = true;
                }
                if (!deduplicated) return o;
                return builder.build();
            }
            l = (List)o;
            try {
                i = 0;
                while (i < l.size()) {
                    l.set(i, this.deduplicateObject(l.get(i), recursion + 1));
                    ++i;
                }
                return o;
            }
            catch (UnsupportedOperationException e) {
                IMMUTABLE_CLASS.add(clazz);
                int i3 = 0;
                while (i3 < l.size()) {
                    this.deduplicateObject(l.get(i3), recursion + 1);
                    ++i3;
                }
                return o;
            }
        }
        if (o instanceof ImmutableSet) {
            Object builder;
            if (!(o instanceof ImmutableSortedSet)) {
                builder = new ImmutableSet.Builder();
                Iterator e = ((Set)o).iterator();
                while (e.hasNext()) {
                    Object o1 = e.next();
                    builder.add(this.deduplicateObject(o1, recursion + 1));
                }
                return builder.build();
            }
            builder = ((Set)o).iterator();
            while (builder.hasNext()) {
                Object o1 = builder.next();
                this.deduplicateObject(o1, recursion + 1);
            }
            return o;
        }
        if (o instanceof Collection) {
            Object constructor;
            if (!(o instanceof SortedSet)) {
                if (!COLLECTION_CONSTRUCTORS.containsKey(clazz)) {
                    try {
                        COLLECTION_CONSTRUCTORS.put(clazz, MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE)));
                    }
                    catch (Exception e) {
                        COLLECTION_CONSTRUCTORS.put(clazz, null);
                    }
                }
                if ((constructor = COLLECTION_CONSTRUCTORS.get(clazz)) != null) {
                    try {
                        Collection nc = constructor.invoke();
                        if (nc != null) {
                            Iterator o1 = ((Collection)o).iterator();
                            while (o1.hasNext()) {
                                Object o12 = o1.next();
                                nc.add(this.deduplicateObject(o12, recursion + 1));
                            }
                            return nc;
                        }
                    }
                    catch (Throwable t) {
                        COLLECTION_CONSTRUCTORS.put(clazz, null);
                    }
                }
            }
            constructor = ((Collection)o).iterator();
            while (constructor.hasNext()) {
                Object o1 = constructor.next();
                this.deduplicateObject(o1, recursion + 1);
            }
            return o;
        }
        if (clazz.isArray()) {
            int i = 0;
            while (i < Array.getLength(o)) {
                Object entry = Array.get(o, i);
                Object entryD = this.deduplicateObject(entry, recursion + 1);
                if (entryD != null && entry != entryD) {
                    Array.set(o, i, entryD);
                }
                ++i;
            }
            return o;
        }
        if (!CLASS_FIELDS.containsKey(clazz)) {
            ImmutableSet.Builder fsBuilder = ImmutableSet.builder();
            Class<?> cc = clazz;
            do {
                for (Field f : cc.getDeclaredFields()) {
                    if ((f.getModifiers() & 8) != 0 || !this.shouldCheckClass(f.getType())) continue;
                    try {
                        f.setAccessible(true);
                        fsBuilder.add((Object)new MethodHandle[]{MethodHandles.lookup().unreflectGetter(f), MethodHandles.lookup().unreflectSetter(f)});
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } while ((cc = cc.getSuperclass()) != Object.class);
            CLASS_FIELDS.put(clazz, (Set<MethodHandle[]>)fsBuilder.build());
        }
        Iterator<MethodHandle[]> iterator = CLASS_FIELDS.get(clazz).iterator();
        while (iterator.hasNext()) {
            MethodHandle[] mh = (MethodHandle[])iterator.next();
            try {
                Object value = mh[0].invoke(o);
                Object valueD = this.deduplicateObject(value, recursion + 1);
                if (canTrim) {
                    this.trimArray(valueD);
                }
                if (valueD == null || value == valueD) continue;
                mh[1].invoke(o, valueD);
            }
            catch (IllegalAccessException value) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return o;
    }

    static {
        TRIM_ARRAYS_CLASSES.add(TextComponentKeybind.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentScore.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentSelector.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentString.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentTranslation.class);
        TRIM_ARRAYS_CLASSES.add(VertexFormat.class);
        TRIM_ARRAYS_CLASSES.add(ModelBlock.class);
        TRIM_ARRAYS_CLASSES.add(ItemOverrideList.class);
        TRIM_ARRAYS_CLASSES.add(FoamyItemLayerModel.DynamicItemModel.class);
        TRIM_ARRAYS_CLASSES.add(SimpleBakedModel.class);
        TRIM_ARRAYS_CLASSES.add(WeightedBakedModel.class);
        TRIM_ARRAYS_CLASSES.add(Multipart.class);
        BLACKLIST_CLASS.add(Object.class);
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(String.class);
        BLACKLIST_CLASS.add(Integer.class);
        BLACKLIST_CLASS.add(Long.class);
        BLACKLIST_CLASS.add(Byte.class);
        BLACKLIST_CLASS.add(Boolean.class);
        BLACKLIST_CLASS.add(Float.class);
        BLACKLIST_CLASS.add(Double.class);
        BLACKLIST_CLASS.add(Short.class);
        BLACKLIST_CLASS.add(TextureAtlasSprite.class);
        BLACKLIST_CLASS.add(ItemStack.class);
        BLACKLIST_CLASS.add(Gson.class);
        BLACKLIST_CLASS.add(EnumBiMap.class);
        BLACKLIST_CLASS.add(ModelLoader.class);
        BLACKLIST_CLASS.add(Minecraft.class);
        BLACKLIST_CLASS.add(BlockModelShapes.class);
        BLACKLIST_CLASS.add(BlockFaceUV.class);
        BLACKLIST_CLASS.add(ModelManager.class);
        BLACKLIST_CLASS.add(BlockPartRotation.class);
        BLACKLIST_CLASS.add(ModelBlockAnimation.class);
        BLACKLIST_CLASS.add(BufferBuilder.class);
        BLACKLIST_CLASS.add(Logger.class);
        BLACKLIST_CLASS.add(Joiner.class);
        BLACKLIST_CLASS.add(Tessellator.class);
        BLACKLIST_CLASS.add(Cache.class);
        BLACKLIST_CLASS.add(LoadingCache.class);
        BLACKLIST_CLASS.add(VertexFormatElement.class);
    }
}

