/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod.injections.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.ITextureMapPopulator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.ProgressManager;

public class ModelLoaderParallelHelper
extends ModelBakery {
    public static Set<ResourceLocation> textures;
    public static final ITextureMapPopulator POPULATOR;

    public ModelLoaderParallelHelper(IResourceManager manager, TextureMap map, BlockModelShapes shapes) {
        super(manager, map, shapes);
    }

    public static void bakeParallel(Map<IModel, IBakedModel> bakedModels, Set<IModel> models, IModel missingModel, IBakedModel missingBaked) {
        ProgressManager.ProgressBar bakeBar = ProgressManager.push((String)"ModelLoader: baking (parallel)", (int)1);
        bakeBar.step("please wait");
        models.parallelStream().forEach(model -> {
            if (model == missingModel) {
                bakedModels.put((IModel)model, missingBaked);
            } else {
                IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                bakedModels.put((IModel)model, bakedModel);
            }
        });
        ProgressManager.pop((ProgressManager.ProgressBar)bakeBar);
    }

    public static void bake(Map<IModel, IBakedModel> bakedModels, Multimap<IModel, ModelResourceLocation> models, IModel missingModel, IBakedModel missingBaked) {
        ProgressManager.ProgressBar bakeBar = ProgressManager.push((String)"ModelLoader: baking", (int)models.size());
        for (IModel model : models.keySet()) {
            bakeBar.step("[" + Joiner.on((String)", ").join((Iterable)models.get((Object)model)) + "]");
            if (model == missingModel) {
                bakedModels.put(model, missingBaked);
                continue;
            }
            IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            bakedModels.put(model, bakedModel);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bakeBar);
    }

    static {
        POPULATOR = new ITextureMapPopulator(){

            public void func_177059_a(TextureMap map) {
                for (ResourceLocation t : textures) {
                    map.func_174942_a(t);
                }
            }
        };
    }
}

