/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.controls.GuiButtonQuestInstance;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api2.storage.DBEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class QuestLineButtonTree {
    private IQuestLine line;
    private ArrayList<GuiButtonQuestInstance> buttonTree = new ArrayList();
    private int treeW = 0;
    private int treeH = 0;

    public QuestLineButtonTree(IQuestLine line) {
        this.line = line;
        this.RebuildTree();
    }

    public int getWidth() {
        return this.treeW;
    }

    public int getHeight() {
        return this.treeH;
    }

    public IQuestLine getQuestLine() {
        return this.line;
    }

    public List<GuiButtonQuestInstance> getButtonTree() {
        return this.buttonTree;
    }

    public GuiButtonQuestInstance getButtonAt(int x, int y) {
        if (this.line == null) {
            return null;
        }
        int id = this.line.getQuestAt(x, y);
        IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).getValue(id);
        if (quest == null) {
            return null;
        }
        for (GuiButtonQuestInstance btn : this.buttonTree) {
            if (btn.getQuest() != quest) continue;
            return btn;
        }
        return null;
    }

    public void RebuildTree() {
        this.buttonTree.clear();
        this.treeW = 0;
        this.treeH = 0;
        if (this.line == null) {
            return;
        }
        for (DBEntry qle : this.line.getEntries()) {
            IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).getValue(qle.getID());
            IQuestLineEntry entry = (IQuestLineEntry)qle.getValue();
            if (quest == null || entry == null) continue;
            this.buttonTree.add(new GuiButtonQuestInstance(0, entry.getPosX(), entry.getPosY(), entry.getSize(), entry.getSize(), quest));
        }
        for (GuiButtonQuestInstance btn : this.buttonTree) {
            if (btn == null) continue;
            this.treeW = Math.max(btn.field_146128_h + btn.field_146120_f, this.treeW);
            this.treeH = Math.max(btn.field_146129_i + btn.field_146121_g, this.treeH);
            for (GuiButtonQuestInstance b2 : this.buttonTree) {
                if (b2 == null || btn == b2 || btn.getQuest() == null || !btn.getQuest().getPrerequisites().contains(b2.getQuest())) continue;
                btn.addParent(b2);
            }
        }
    }
}

