/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.placeholders.PlaceholderConverter;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.utils.BQThreadedIO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.Future;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;

public class JsonHelper {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static JsonArray GetArray(JsonObject json, String id) {
        if (json == null) {
            return new JsonArray();
        }
        if (json.has(id) && json.get(id).isJsonArray()) {
            return json.get(id).getAsJsonArray();
        }
        return new JsonArray();
    }

    public static JsonObject GetObject(JsonObject json, String id) {
        if (json == null) {
            return new JsonObject();
        }
        if (json.has(id) && json.get(id).isJsonObject()) {
            return json.get(id).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static String GetString(JsonObject json, String id, String def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        return def;
    }

    public static Number GetNumber(JsonObject json, String id, Number def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsNumber();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static boolean GetBoolean(JsonObject json, String id, boolean def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsBoolean();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static ArrayList<JsonElement> GetUnderlyingArray(JsonArray array) {
        try {
            Field field = JsonArray.class.getDeclaredField("elements");
            field.setAccessible(true);
            return (ArrayList)field.get(array);
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Unable to retrieve underlying JsonArray:", (Throwable)e);
            return null;
        }
    }

    public static void ClearCompoundTag(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        ArrayList list = new ArrayList(tag.func_150296_c());
        for (String key : list) {
            tag.func_82580_o(key);
        }
    }

    public static JsonObject ReadFromFile(File file) {
        Future<JsonObject> task = BQThreadedIO.INSTANCE.enqueue(() -> {
            if (file == null) return new JsonObject();
            if (!file.exists()) {
                return new JsonObject();
            }
            try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)fr, JsonObject.class);
                return jsonObject;
            }
            catch (Exception e) {
                QuestingAPI.getLogger().log(Level.ERROR, "An error occured while loading JSON from file:", (Throwable)e);
                int i = 0;
                File bkup = new File(file.getParent(), "malformed_" + file.getName() + i + ".json");
                while (true) {
                    if (!bkup.exists()) {
                        QuestingAPI.getLogger().log(Level.ERROR, "Creating backup at: " + bkup.getAbsolutePath());
                        JsonHelper.CopyPaste(file, bkup);
                        return new JsonObject();
                    }
                    bkup = new File(file.getParent(), "malformed_" + file.getName() + ++i + ".json");
                }
            }
        });
        try {
            return task.get();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public static void WriteToFile(File file, JsonObject jObj) {
        BQThreadedIO.INSTANCE.enqueue(() -> {
            try {
                if (!file.exists()) {
                    if (file.getParentFile() != null) {
                        file.getParentFile().mkdirs();
                    }
                    if (!file.createNewFile()) {
                        throw new FileNotFoundException("Unable to create file " + file.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                QuestingAPI.getLogger().log(Level.ERROR, "An error occured while saving JSON to file:", (Throwable)e);
                return;
            }
            try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                GSON.toJson((JsonElement)jObj, (Appendable)fw);
                fw.flush();
            }
            catch (Exception e) {
                QuestingAPI.getLogger().log(Level.ERROR, "An error occured while saving JSON to file:", (Throwable)e);
            }
        });
    }

    public static void CopyPaste(File fileIn, File fileOut) {
        if (!fileIn.exists()) {
            return;
        }
        try {
            if (!fileOut.exists()) {
                if (fileOut.getParentFile() != null) {
                    fileOut.getParentFile().mkdirs();
                }
            } else {
                throw new IOException("File already exists!");
            }
            fileOut.createNewFile();
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed copy paste", (Throwable)e);
            return;
        }
        try (BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileIn), StandardCharsets.UTF_8));
             BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileOut), StandardCharsets.UTF_8));){
            int read;
            char[] buffer = new char[256];
            while ((read = fr.read(buffer)) != -1) {
                fw.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed copy paste", (Throwable)e);
        }
    }

    public static String makeFileNameSafe(String s) {
        for (char c : ChatAllowedCharacters.field_71567_b) {
            s = s.replace(c, '_');
        }
        return s;
    }

    public static boolean isItem(NBTTagCompound json) {
        if (json != null && json.func_74764_b("id") && json.func_150297_b("Count", 99) && json.func_150297_b("Damage", 99)) {
            if (json.func_150297_b("id", 8)) {
                return Item.field_150901_e.func_148741_d((Object)new ResourceLocation(json.func_74779_i("id")));
            }
            return Item.field_150901_e.func_148754_a(json.func_74762_e("id")) != null;
        }
        return false;
    }

    public static boolean isFluid(NBTTagCompound json) {
        return json != null && json.func_150297_b("FluidName", 8) && json.func_150297_b("Amount", 99) && FluidRegistry.getFluid((String)json.func_74779_i("FluidName")) != null;
    }

    public static boolean isEntity(NBTTagCompound tags) {
        return tags.func_74764_b("id") && EntityList.func_180125_b((ResourceLocation)new ResourceLocation(tags.func_74779_i("id")));
    }

    public static BigItemStack JsonToItemStack(NBTTagCompound nbt) {
        String jID;
        Item item;
        if (nbt == null || !nbt.func_74764_b("id")) {
            return new BigItemStack(Blocks.field_150348_b);
        }
        int count = nbt.func_74762_e("Count");
        String oreDict = nbt.func_74779_i("OreDict");
        int damage = nbt.func_150297_b("Damage", 99) ? nbt.func_74762_e("Damage") : -1;
        int n = damage = damage >= 0 ? damage : Short.MAX_VALUE;
        if (nbt.func_150297_b("id", 99)) {
            int id = nbt.func_74762_e("id");
            item = (Item)Item.field_150901_e.func_148754_a(id);
            jID = "" + id;
        } else {
            jID = nbt.func_74779_i("id");
            item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(jID));
        }
        NBTTagCompound tags = null;
        if (nbt.func_150297_b("tag", 10)) {
            tags = nbt.func_74775_l("tag");
        }
        return PlaceholderConverter.convertItem(item, jID, count, damage, oreDict, tags);
    }

    public static NBTTagCompound ItemStackToJson(BigItemStack stack, NBTTagCompound json) {
        if (stack == null) {
            return json;
        }
        ResourceLocation iRes = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.getBaseStack().func_77973_b());
        json.func_74778_a("id", iRes == null ? "" : iRes.toString());
        json.func_74768_a("Count", stack.stackSize);
        json.func_74778_a("OreDict", stack.oreDict);
        json.func_74768_a("Damage", stack.getBaseStack().func_77952_i());
        if (stack.HasTagCompound()) {
            json.func_74782_a("tag", (NBTBase)stack.GetTagCompound());
        }
        return json;
    }

    public static FluidStack JsonToFluidStack(NBTTagCompound json) {
        String name = json.func_150297_b("FluidName", 8) ? json.func_74779_i("FluidName") : "water";
        int amount = json.func_74762_e("Amount");
        NBTTagCompound tags = null;
        if (json.func_150297_b("Tag", 10)) {
            tags = json.func_74775_l("Tag");
        }
        Fluid fluid = FluidRegistry.getFluid((String)name);
        return PlaceholderConverter.convertFluid(fluid, name, amount, tags);
    }

    public static NBTTagCompound FluidStackToJson(FluidStack stack, NBTTagCompound json) {
        if (stack == null) {
            return json;
        }
        json.func_74778_a("FluidName", FluidRegistry.getFluidName((FluidStack)stack));
        json.func_74768_a("Amount", stack.amount);
        if (stack.tag != null) {
            json.func_74782_a("Tag", (NBTBase)stack.tag);
        }
        return json;
    }

    public static Entity JsonToEntity(NBTTagCompound tags, World world) {
        Entity entity = null;
        if (tags.func_74764_b("id") && EntityList.func_180125_b((ResourceLocation)new ResourceLocation(tags.func_74779_i("id")))) {
            entity = EntityList.func_75615_a((NBTTagCompound)tags, (World)world);
        }
        return PlaceholderConverter.convertEntity(entity, world, tags);
    }

    @Deprecated
    public static Entity JsonToEntity(NBTTagCompound tags, World world, boolean allowPlaceholder) {
        return JsonHelper.JsonToEntity(tags, world);
    }

    public static NBTTagCompound EntityToJson(Entity entity, NBTTagCompound json) {
        if (entity == null) {
            return json;
        }
        NBTTagCompound tags = new NBTTagCompound();
        entity.func_70039_c(tags);
        String id = EntityList.func_75621_b((Entity)entity);
        tags.func_74778_a("id", id != null ? id : "");
        json.func_179237_a(tags);
        return json;
    }
}

