/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.controls;

import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class PanelTextField<T>
implements IGuiPanel {
    private final IGuiRect transform;
    private boolean enabled = true;
    private IGuiTexture[] texState = new IGuiTexture[3];
    private IGuiColor[] colStates = new IGuiColor[3];
    private IGuiColor colHighlight;
    private IGuiColor colWatermark;
    private boolean lockFocus = false;
    private boolean isFocused = false;
    private boolean isActive = true;
    private boolean canWrap = false;
    private int maxLength = 32;
    private String text;
    private String watermark = "";
    private int selectStart = 0;
    private int selectEnd = 0;
    private boolean dragging = false;
    private GuiRectangle cursorLine = new GuiRectangle(4, 4, 1, 8);
    private IValueIO<Float> scrollX;
    private IValueIO<Float> scrollY;
    private int scrollWidth = 0;
    private int scrollHeight = 0;
    private final IFieldFilter<T> filter;
    private ICallback<T> callback;

    public PanelTextField(IGuiRect rect, String text, IFieldFilter<T> filter) {
        this.transform = rect;
        this.cursorLine.setParent(this.transform);
        this.filter = filter;
        this.setTextures(PresetTexture.TEXT_BOX_0.getTexture(), PresetTexture.TEXT_BOX_1.getTexture(), PresetTexture.TEXT_BOX_2.getTexture());
        this.setMainColors(PresetColor.TEXT_AUX_0.getColor(), PresetColor.TEXT_AUX_0.getColor(), PresetColor.TEXT_AUX_0.getColor());
        this.setAuxColors(PresetColor.TEXT_WATERMARK.getColor(), PresetColor.TEXT_HIGHLIGHT.getColor());
        this.scrollX = new IValueIO<Float>(){
            private float v = 0.0f;

            @Override
            public Float readValue() {
                return Float.valueOf(this.v);
            }

            @Override
            public void writeValue(Float value) {
                this.v = MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f);
            }
        };
        this.scrollY = new IValueIO<Float>(){
            private float v = 0.0f;

            @Override
            public Float readValue() {
                return Float.valueOf(this.v);
            }

            @Override
            public void writeValue(Float value) {
                this.v = MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f);
            }
        };
        this.setText(text);
    }

    public PanelTextField<T> setCallback(ICallback<T> callback) {
        this.callback = callback;
        return this;
    }

    public PanelTextField<T> setTextures(IGuiTexture disabled, IGuiTexture idle, IGuiTexture focused) {
        this.texState[0] = disabled;
        this.texState[1] = idle;
        this.texState[2] = focused;
        return this;
    }

    public PanelTextField<T> setMainColors(IGuiColor disabled, IGuiColor idle, IGuiColor focused) {
        this.colStates[0] = disabled;
        this.colStates[1] = idle;
        this.colStates[2] = focused;
        return this;
    }

    public PanelTextField<T> setAuxColors(IGuiColor watermark, IGuiColor highlight) {
        this.colWatermark = watermark;
        this.colHighlight = highlight;
        return this;
    }

    public PanelTextField<T> setMaxLength(int size) {
        this.maxLength = size;
        return this;
    }

    public PanelTextField<T> enableWrapping(boolean state) {
        this.canWrap = state;
        this.updateScrollBounds();
        return this;
    }

    public void lockFocus(boolean state) {
        this.lockFocus = state;
        if (state) {
            this.isFocused = true;
        }
    }

    public PanelTextField<T> setScrollDriverX(IValueIO<Float> driver) {
        this.scrollX = driver;
        return this;
    }

    public PanelTextField<T> setScrollDriverY(IValueIO<Float> driver) {
        this.scrollY = driver;
        return this;
    }

    public int getScrollX() {
        if (this.scrollWidth <= 0) {
            return 0;
        }
        return (int)((float)this.scrollWidth * this.scrollX.readValue().floatValue());
    }

    public int getScrollY() {
        if (this.scrollHeight <= 0) {
            return 0;
        }
        return (int)((float)this.scrollHeight * this.scrollY.readValue().floatValue());
    }

    public void setScrollX(int value) {
        if (this.scrollWidth <= 0) {
            this.scrollX.writeValue(Float.valueOf(0.0f));
            return;
        }
        this.scrollX.writeValue(Float.valueOf((float)MathHelper.func_76125_a((int)value, (int)0, (int)this.scrollWidth) / (float)this.scrollWidth));
    }

    public void setScrollY(int value) {
        if (this.scrollHeight <= 0) {
            this.scrollY.writeValue(Float.valueOf(0.0f));
            return;
        }
        this.scrollY.writeValue(Float.valueOf((float)MathHelper.func_76125_a((int)value, (int)0, (int)this.scrollHeight) / (float)this.scrollHeight));
    }

    public void setActive(boolean state) {
        this.isActive = state;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public PanelTextField<T> setWatermark(String text) {
        this.watermark = text;
        return this;
    }

    public void setText(String text) {
        this.text = this.filter.filterText(text);
        this.updateScrollBounds();
        this.setCursorPosition(0);
    }

    public String getRawText() {
        return this.text;
    }

    public T getValue() {
        return this.filter.parseValue(this.getRawText());
    }

    public String getSelectedText() {
        int l = Math.min(this.selectStart, this.selectEnd);
        int r = Math.max(this.selectStart, this.selectEnd);
        return this.text.substring(l, r);
    }

    public void writeText(String in) {
        int used;
        StringBuilder out = new StringBuilder();
        int l = Math.min(this.selectStart, this.selectEnd);
        int r = Math.max(this.selectStart, this.selectEnd);
        int space = this.maxLength - this.text.length() - (l - r);
        if (!this.text.isEmpty()) {
            out.append(this.text, 0, l);
        }
        if (space < 0) {
            out.substring(0, this.maxLength);
            used = 0;
        } else if (space < in.length()) {
            out.append(in, 0, space);
            used = space;
        } else {
            out.append(in);
            used = in.length();
        }
        if (!this.text.isEmpty() && r < this.text.length()) {
            out.append(this.text, r, this.text.length());
        }
        this.text = this.filter.filterText(out.toString());
        this.updateScrollBounds();
        this.moveCursorBy(l - this.selectEnd + used);
        if (this.callback != null) {
            this.callback.setValue(this.filter.parseValue(this.text));
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectEnd != this.selectStart) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.selectStart);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectEnd != this.selectStart) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.selectStart + num : this.selectStart;
                int j = flag ? this.selectStart : this.selectStart + num;
                String s = "";
                if (i >= 0) {
                    s = this.text.substring(0, i);
                }
                if (j < this.text.length()) {
                    s = s + this.text.substring(j);
                }
                this.text = this.filter.filterText(s);
                this.updateScrollBounds();
                if (flag) {
                    this.moveCursorBy(num);
                }
                if (this.callback != null) {
                    this.callback.setValue(this.filter.parseValue(this.text));
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.selectStart);
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.selectEnd + num);
    }

    public void setCursorPosition(int pos) {
        this.selectStart = pos;
        int i = this.text.length();
        this.selectStart = MathHelper.func_76125_a((int)this.selectStart, (int)0, (int)i);
        this.setSelectionPos(this.selectStart);
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.setCursorPosition(this.text.length());
            this.setSelectionPos(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode)) {
            if (this.isActive) {
                this.writeText(GuiScreen.func_146277_j());
            }
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            if (this.isActive) {
                this.writeText("");
            }
            return true;
        }
        switch (keyCode) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isActive) {
                        this.deleteWords(-1);
                    }
                } else if (this.isActive) {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 28: {
                if (this.canWrap) {
                    this.writeText("\n");
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPosition(0);
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.selectEnd));
                    } else {
                        this.setSelectionPos(this.selectEnd - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.selectEnd));
                    } else {
                        this.setSelectionPos(this.selectEnd + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPosition(this.text.length());
                }
                return true;
            }
            case 200: {
                return true;
            }
            case 208: {
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isActive) {
                        this.deleteWords(1);
                    }
                } else if (this.isActive) {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            if (this.isActive) {
                this.writeText(Character.toString(typedChar));
            }
            return true;
        }
        return false;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        if (position > i) {
            position = i;
        }
        if (position < 0) {
            position = 0;
        }
        if (this.selectEnd != position) {
            this.selectEnd = position;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            if (this.canWrap) {
                int sy;
                int y;
                List<String> lines = RenderUtils.splitStringWithoutFormat(this.text, this.getTransform().getWidth() - 8, font);
                String lastFormat = "";
                int idx = 0;
                int x = 0;
                for (y = 0; y < lines.size(); ++y) {
                    String s = lines.get(y);
                    if (this.selectEnd >= idx && this.selectEnd < idx + s.length() + (y == lines.size() - 1 ? 1 : 0)) {
                        x = font.func_78256_a(lastFormat + s.substring(0, this.selectEnd - idx));
                        break;
                    }
                    idx += s.length();
                    lastFormat = FontRenderer.func_78282_e((String)(lastFormat + s));
                }
                if ((y *= font.field_78288_b) < (sy = this.getScrollY())) {
                    this.setScrollY(y);
                } else if (y > sy + (this.transform.getHeight() - 8) - font.field_78288_b) {
                    this.setScrollY(y - (this.transform.getHeight() - 8) + font.field_78288_b);
                }
                this.cursorLine.x = x + 4;
                this.cursorLine.y = y + 4;
                this.cursorLine.w = 1;
                this.cursorLine.h = font.field_78288_b;
            } else {
                int sx;
                int x = font.func_78256_a(this.text.substring(0, this.selectEnd));
                if (x < (sx = this.getScrollX())) {
                    this.setScrollX(x);
                } else if (x > sx + (this.transform.getWidth() - 8)) {
                    this.setScrollX(x - (this.transform.getWidth() - 8));
                }
                this.cursorLine.x = x + 4;
                this.cursorLine.y = 4;
                this.cursorLine.w = 1;
                this.cursorLine.h = font.field_78288_b;
            }
        }
    }

    public void updateScrollBounds() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int prevX = this.getScrollX();
        int prevY = this.getScrollY();
        if (!this.canWrap) {
            this.scrollHeight = 0;
            this.scrollWidth = Math.max(0, font.func_78256_a(this.text) - (this.transform.getWidth() - 8));
        } else {
            this.scrollWidth = 0;
            this.scrollHeight = Math.max(0, RenderUtils.splitString(this.text, this.transform.getWidth() - 8, font).size() * font.field_78288_b - (this.transform.getHeight() - 8));
        }
        this.setScrollX(prevX);
        this.setScrollY(prevY);
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        if (this.isActive && this.dragging && Mouse.isButtonDown((int)0)) {
            if (this.canWrap) {
                this.setSelectionPos(RenderUtils.getCursorPos(this.text, mx - (this.transform.getX() + 4) + this.getScrollX(), my - (this.transform.getY() + 4) + this.getScrollY(), this.transform.getWidth() - 8, Minecraft.func_71410_x().field_71466_p));
            } else {
                this.setSelectionPos(RenderUtils.getCursorPos(this.text, mx - (this.transform.getX() + 4) + this.getScrollX(), Minecraft.func_71410_x().field_71466_p));
            }
        } else if (this.dragging) {
            this.dragging = false;
        }
        IGuiRect bounds = this.getTransform();
        int state = !this.isActive() ? 0 : (this.isFocused ? 2 : 1);
        Minecraft mc = Minecraft.func_71410_x();
        IGuiTexture t = this.texState[state];
        if (t != null) {
            t.drawTexture(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 0.0f, partialTick);
        }
        GlStateManager.func_179094_E();
        RenderUtils.startScissor(bounds);
        GlStateManager.func_179109_b((float)(-this.getScrollX()), (float)(-this.getScrollY()), (float)0.0f);
        if (this.text.length() <= 0) {
            if (!this.isFocused) {
                mc.field_71466_p.func_175065_a(this.watermark, (float)(bounds.getX() + 4), (float)(bounds.getY() + 4), this.colWatermark.getRGB(), false);
            }
        } else {
            IGuiColor c = this.colStates[state];
            if (!this.canWrap) {
                RenderUtils.drawHighlightedString(mc.field_71466_p, this.text, bounds.getX() + 4, bounds.getY() + 4, c.getRGB(), false, this.colHighlight.getRGB(), this.selectStart, this.selectEnd);
            } else {
                RenderUtils.drawHighlightedSplitString(mc.field_71466_p, this.text, bounds.getX() + 4, bounds.getY() + 4, bounds.getWidth() - 8, c.getRGB(), false, this.colHighlight.getRGB(), this.selectStart, this.selectEnd);
            }
        }
        if (this.isFocused && this.selectStart == this.selectEnd && System.currentTimeMillis() / 500L % 2L == 0L) {
            RenderUtils.drawHighlightBox(this.cursorLine, this.colHighlight);
        }
        RenderUtils.endScissor();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int button) {
        if (this.transform.contains(mx, my)) {
            if (!this.isFocused) {
                this.isFocused = true;
                this.updateScrollBounds();
            }
            if (this.canWrap) {
                this.setCursorPosition(RenderUtils.getCursorPos(this.text, mx - (this.transform.getX() + 4) + this.getScrollX(), my - (this.transform.getY() + 4) + this.getScrollY(), this.transform.getWidth() - 8, Minecraft.func_71410_x().field_71466_p));
            } else {
                this.setCursorPosition(RenderUtils.getCursorPos(this.text, mx - (this.transform.getX() + 4) + this.getScrollX(), Minecraft.func_71410_x().field_71466_p));
            }
            this.dragging = true;
        } else if (this.isFocused && !this.lockFocus) {
            this.isFocused = false;
            this.text = this.filter.parseValue(this.text).toString();
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int button) {
        return this.isFocused && this.dragging;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        if (!this.isFocused || !this.transform.contains(mx, my)) {
            return false;
        }
        if (this.canWrap) {
            this.setScrollY(this.getScrollY() + scroll * 4);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }
}

