/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.misc;

import betterquesting.api2.client.gui.misc.IGuiRect;

public class GuiRectangle
implements IGuiRect {
    public int x;
    public int y;
    public int w;
    public int h;
    public int d;
    private IGuiRect parent = null;

    public GuiRectangle(int x, int y, int w, int h) {
        this(x, y, w, h, 0);
    }

    public GuiRectangle(int x, int y, int w, int h, int d) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.d = d;
    }

    public GuiRectangle(IGuiRect rect) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), rect.getDepth());
    }

    @Override
    public int getX() {
        return this.x + (this.parent == null ? 0 : this.parent.getX());
    }

    @Override
    public int getY() {
        return this.y + (this.parent == null ? 0 : this.parent.getY());
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    @Override
    public int getHeight() {
        return this.h;
    }

    @Override
    public int getDepth() {
        return this.d;
    }

    @Override
    public IGuiRect getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IGuiRect rect) {
        this.parent = rect;
    }

    @Override
    public boolean contains(int x, int y) {
        int x1 = this.getX();
        int x2 = x1 + this.w;
        int y1 = this.getY();
        int y2 = y1 + this.h;
        return x >= x1 && x < x2 && y >= y1 && y < y2;
    }

    @Override
    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    @Override
    public int compareTo(IGuiRect o) {
        return (int)Math.signum(o.getDepth() - this.d);
    }
}

