/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.lists.CanvasSearch;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class CanvasFileDirectory
extends CanvasSearch<File, File> {
    private static final FileSort sorter = new FileSort();
    private final FileFilter filter;
    private File curDir;

    public CanvasFileDirectory(IGuiRect rect, @Nonnull File dirStart, FileFilter filter) {
        super(rect);
        this.filter = filter;
        this.curDir = dirStart;
        if (!this.curDir.isDirectory()) {
            this.curDir = this.curDir.getParentFile();
        }
    }

    public void setCurDirectory(@Nonnull File file) {
        this.curDir = file;
        this.refreshSearch();
        this.scrollY.writeValue(Float.valueOf(0.0f));
    }

    @Override
    protected Iterator<File> getIterator() {
        File[] files;
        File[] fileArray = files = !this.curDir.isDirectory() ? new File[]{} : this.curDir.listFiles(this.filter);
        if (files == null) {
            files = new File[]{};
        }
        List<File> fList = Arrays.asList(files);
        fList.sort(sorter);
        return fList.iterator();
    }

    @Override
    protected void queryMatches(File value, String query, ArrayDeque<File> results) {
        if (value.getName().contains(query)) {
            results.add(value);
        }
    }

    private static class FileSort
    implements Comparator<File> {
        private FileSort() {
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                return 0;
            }
            if (f1.isDirectory() == f2.isDirectory()) {
                return f1.getName().compareTo(f2.getName());
            }
            return f1.isDirectory() ? -1 : 1;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

