/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.registry;

import betterquesting.api.misc.IFactory;
import betterquesting.api2.registry.IRegistry;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class SimpleRegistry<T>
implements IRegistry<T> {
    private final HashMap<ResourceLocation, IFactory<T>> factories = new HashMap();
    private final IFactory<T> placeholder;

    public SimpleRegistry(IFactory<T> placeholder) {
        this.placeholder = placeholder;
    }

    @Override
    public void register(IFactory<T> factory) {
        if (factory == null || factory.getRegistryName() == null) {
            throw new NullPointerException("Factory or registry name is null!");
        }
        if (this.factories.containsKey(factory.getRegistryName()) || this.factories.containsValue(factory)) {
            throw new IllegalArgumentException("Cannot register duplicate factory or registry name");
        }
        this.factories.put(factory.getRegistryName(), factory);
    }

    @Override
    public IFactory<T> getFactory(ResourceLocation idName) {
        return this.factories.get(idName);
    }

    @Override
    public IFactory<T> getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public T createNew(ResourceLocation idName) {
        IFactory<T> fact = this.getFactory(idName);
        return fact == null ? null : (T)fact.createNew();
    }

    @Override
    public T loadFromNBT(ResourceLocation idName, NBTTagCompound nbt) {
        IFactory<T> fact = this.getFactory(idName);
        fact = fact != null ? fact : this.getPlaceholder();
        return fact.loadFromNBT(nbt);
    }

    @Override
    public IFactory<T>[] getAll() {
        return this.factories.values().toArray(new IFactory[0]);
    }
}

