/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

public final class DBEntry<T>
implements Comparable<DBEntry<T>> {
    private final int id;
    private final T obj;

    public DBEntry(int id, T obj) {
        if (id < 0) {
            throw new IllegalArgumentException("Entry ID cannot be negative");
        }
        if (obj == null) {
            throw new NullPointerException("Entry value cannot be null");
        }
        this.id = id;
        this.obj = obj;
    }

    public final int getID() {
        return this.id;
    }

    public final T getValue() {
        return this.obj;
    }

    @Override
    public int compareTo(DBEntry<T> o) {
        return Integer.compare(this.id, o.id);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBEntry)) {
            return false;
        }
        DBEntry entry = (DBEntry)obj;
        return this.getID() == entry.getID() && this.getValue().equals(entry.getValue());
    }
}

