/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabase;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class SimpleDatabase<T>
implements IDatabase<T> {
    private final SortedSet<DBEntry<T>> listDB = Collections.synchronizedSortedSet(new TreeSet((o1, o2) -> o1.getValue() == o2.getValue() ? 0 : Integer.compare(o1.getID(), o2.getID())));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextID() {
        if (this.listDB.size() <= 0 || this.listDB.last().getID() == this.listDB.size() - 1) {
            return this.listDB.size();
        }
        SortedSet<DBEntry<T>> sortedSet = this.listDB;
        synchronized (sortedSet) {
            int i;
            Iterator iterator = this.listDB.iterator();
            for (i = 0; iterator.hasNext() && ((DBEntry)iterator.next()).getID() == i; ++i) {
            }
            return i;
        }
    }

    @Override
    public DBEntry<T> add(int id, T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (id < 0) {
            throw new IllegalArgumentException("ID cannot be negative");
        }
        DBEntry<T> entry = new DBEntry<T>(id, value);
        if (this.listDB.add(entry)) {
            return entry;
        }
        throw new IllegalArgumentException("ID or value is already contained within database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeID(int key) {
        if (key < 0) {
            return false;
        }
        SortedSet<DBEntry<T>> sortedSet = this.listDB;
        synchronized (sortedSet) {
            Iterator iter = this.listDB.iterator();
            while (iter.hasNext()) {
                DBEntry entry = (DBEntry)iter.next();
                if (entry.getID() == key) {
                    iter.remove();
                    return true;
                }
                if (entry.getID() <= key) continue;
                break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeValue(T value) {
        if (value == null) {
            return false;
        }
        SortedSet<DBEntry<T>> sortedSet = this.listDB;
        synchronized (sortedSet) {
            Iterator iter = this.listDB.iterator();
            while (iter.hasNext()) {
                if (((DBEntry)iter.next()).getValue() != value) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getID(T value) {
        if (value == null) {
            return -1;
        }
        SortedSet<DBEntry<T>> sortedSet = this.listDB;
        synchronized (sortedSet) {
            for (DBEntry dBEntry : this.listDB) {
                if (dBEntry.getValue() != value) continue;
                return dBEntry.getID();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getValue(int id) {
        if (id < 0 || this.listDB.size() <= 0 || id > this.listDB.last().getID()) {
            return null;
        }
        SortedSet<DBEntry<T>> sortedSet = this.listDB;
        synchronized (sortedSet) {
            for (DBEntry dBEntry : this.listDB) {
                if (dBEntry.getID() > id) {
                    return null;
                }
                if (dBEntry.getID() != id) continue;
                return dBEntry.getValue();
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.listDB.size();
    }

    @Override
    public void reset() {
        this.listDB.clear();
    }

    @Override
    public DBEntry<T>[] getEntries() {
        return this.listDB.toArray(new DBEntry[0]);
    }
}

