/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.inventory;

import betterquesting.api.client.gui.GuiScreenThemed;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public abstract class GuiContainerThemed
extends GuiScreenThemed {
    public static final ResourceLocation INVENTORY_BACKGROUND = new ResourceLocation("textures/gui/container/inventory.png");
    public Container inventorySlots;
    private Slot theSlot;
    private Slot clickedSlot;
    private boolean isRightMouseClick;
    private ItemStack draggedStack = ItemStack.field_190927_a;
    private int touchUpX;
    private int touchUpY;
    private Slot returningStackDestSlot;
    private long returningStackTime;
    private ItemStack returningStack = ItemStack.field_190927_a;
    private Slot currentDragTargetSlot;
    private long dragItemDropDelay;
    protected final Set<Slot> dragSplittingSlots = Sets.newHashSet();
    protected boolean dragSplitting;
    private int dragSplittingLimit;
    private int dragSplittingButton;
    private boolean ignoreMouseUp;
    private int dragSplittingRemnant;
    private long lastClickTime;
    private Slot lastClickSlot;
    private int lastClickButton;
    private boolean doubleClick;
    private ItemStack shiftClickedSlot = ItemStack.field_190927_a;

    public GuiContainerThemed(GuiScreen parent, String title, Container inventorySlotsIn) {
        super(parent, title);
        this.inventorySlots = inventorySlotsIn;
        this.ignoreMouseUp = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.inventorySlots;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ItemStack itemstack;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int i = this.guiLeft;
        int j = this.guiTop;
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)i, (float)j, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        this.theSlot = null;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = 0; i1 < this.inventorySlots.field_75151_b.size(); ++i1) {
            Slot slot = (Slot)this.inventorySlots.field_75151_b.get(i1);
            if (slot.func_111238_b()) {
                this.drawSlot(slot);
            }
            if (!this.isMouseOverSlot(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            this.theSlot = slot;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int j1 = slot.field_75223_e;
            int k1 = slot.field_75221_f;
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        RenderHelper.func_74518_a();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        RenderHelper.func_74520_c();
        InventoryPlayer inventoryplayer = this.field_146297_k.field_71439_g.field_71071_by;
        ItemStack itemStack = itemstack = this.draggedStack.func_190926_b() ? inventoryplayer.func_70445_o() : this.draggedStack;
        if (!itemstack.func_190926_b()) {
            int k2 = this.draggedStack.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.draggedStack.func_190926_b() && this.isRightMouseClick) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathHelper.func_76123_f((float)((float)itemstack.func_190916_E() / 2.0f)));
            } else if (this.dragSplitting && this.dragSplittingSlots.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(this.dragSplittingRemnant);
                if (itemstack.func_190926_b()) {
                    s = "" + TextFormatting.YELLOW + "0";
                }
            }
            this.drawItemStack(itemstack, mouseX - i - 8, mouseY - j - k2, s);
        }
        if (!this.returningStack.func_190926_b()) {
            float f = (float)(Minecraft.func_71386_F() - this.returningStackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.returningStack = ItemStack.field_190927_a;
            }
            int l2 = this.returningStackDestSlot.field_75223_e - this.touchUpX;
            int i3 = this.returningStackDestSlot.field_75221_f - this.touchUpY;
            int l1 = this.touchUpX + (int)((float)l2 * f);
            int i2 = this.touchUpY + (int)((float)i3 * f);
            this.drawItemStack(this.returningStack, l1, i2, null);
        }
        GlStateManager.func_179121_F();
        if (inventoryplayer.func_70445_o().func_190926_b() && this.theSlot != null && this.theSlot.func_75216_d()) {
            ItemStack itemstack1 = this.theSlot.func_75211_c();
            this.func_146285_a(itemstack1, mouseX, mouseY);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y - (this.draggedStack.func_190926_b() ? 0 : 8), altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1, int var2, int var3);

    private void drawSlot(Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == this.clickedSlot && !this.draggedStack.func_190926_b() && !this.isRightMouseClick;
        ItemStack itemstack1 = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == this.clickedSlot && !this.draggedStack.func_190926_b() && this.isRightMouseClick && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.dragSplitting && this.dragSplittingSlots.contains(slotIn) && !itemstack1.func_190926_b()) {
            if (this.dragSplittingSlots.size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && this.inventorySlots.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(this.dragSplittingSlots, (int)this.dragSplittingLimit, (ItemStack)itemstack, (int)(slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E()));
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.dragSplittingSlots.remove(slotIn);
                this.updateDragSplitting();
            }
        }
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(slotIn.getBackgroundLocation());
            this.func_175175_a(i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                GuiContainerThemed.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, itemstack, i, j);
            this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, i, j, s);
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    private void updateDragSplitting() {
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!itemstack.func_190926_b() && this.dragSplitting) {
            if (this.dragSplittingLimit == 2) {
                this.dragSplittingRemnant = itemstack.func_77976_d();
            } else {
                this.dragSplittingRemnant = itemstack.func_190916_E();
                for (Slot slot : this.dragSplittingSlots) {
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    ItemStack itemstack2 = slot.func_75211_c();
                    int i = itemstack2.func_190926_b() ? 0 : itemstack2.func_190916_E();
                    Container.func_94525_a(this.dragSplittingSlots, (int)this.dragSplittingLimit, (ItemStack)itemstack1, (int)i);
                    int j = Math.min(itemstack1.func_77976_d(), slot.func_178170_b(itemstack1));
                    if (itemstack1.func_190916_E() > j) {
                        itemstack1.func_190920_e(j);
                    }
                    this.dragSplittingRemnant -= itemstack1.func_190916_E() - i;
                }
            }
        }
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (int i = 0; i < this.inventorySlots.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.inventorySlots.field_75151_b.get(i);
            if (!this.isMouseOverSlot(slot, x, y) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        boolean flag = this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100);
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        long i = Minecraft.func_71386_F();
        this.doubleClick = this.lastClickSlot == slot && i - this.lastClickTime < 250L && this.lastClickButton == mouseButton;
        this.ignoreMouseUp = false;
        if (mouseButton == 0 || mouseButton == 1 || flag) {
            boolean flag1;
            int j = this.guiLeft;
            int k = this.guiTop;
            boolean bl = flag1 = mouseX < j || mouseY < k || mouseX >= j + this.sizeX || mouseY >= k + this.sizeY;
            if (slot != null) {
                flag1 = false;
            }
            int l = -1;
            if (slot != null) {
                l = slot.field_75222_d;
            }
            if (flag1) {
                l = -999;
            }
            if (this.field_146297_k.field_71474_y.field_85185_A && flag1 && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                return;
            }
            if (l != -1) {
                if (this.field_146297_k.field_71474_y.field_85185_A) {
                    if (slot != null && slot.func_75216_d()) {
                        this.clickedSlot = slot;
                        this.draggedStack = ItemStack.field_190927_a;
                        this.isRightMouseClick = mouseButton == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.dragSplitting) {
                    if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                        if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                            this.handleMouseClick(slot, l, mouseButton, ClickType.CLONE);
                        } else {
                            boolean flag2 = l != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                            ClickType clicktype = ClickType.PICKUP;
                            if (flag2) {
                                this.shiftClickedSlot = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                                clicktype = ClickType.QUICK_MOVE;
                            } else if (l == -999) {
                                clicktype = ClickType.THROW;
                            }
                            this.handleMouseClick(slot, l, mouseButton, clicktype);
                        }
                        this.ignoreMouseUp = true;
                    } else {
                        this.dragSplitting = true;
                        this.dragSplittingButton = mouseButton;
                        this.dragSplittingSlots.clear();
                        if (mouseButton == 0) {
                            this.dragSplittingLimit = 0;
                        } else if (mouseButton == 1) {
                            this.dragSplittingLimit = 1;
                        } else if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                            this.dragSplittingLimit = 2;
                        }
                    }
                }
            }
        }
        this.lastClickSlot = slot;
        this.lastClickTime = i;
        this.lastClickButton = mouseButton;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.clickedSlot != null && this.field_146297_k.field_71474_y.field_85185_A) {
            if (clickedMouseButton == 0 || clickedMouseButton == 1) {
                if (this.draggedStack.func_190926_b()) {
                    if (slot != this.clickedSlot && !this.clickedSlot.func_75211_c().func_190926_b()) {
                        this.draggedStack = this.clickedSlot.func_75211_c().func_77946_l();
                    }
                } else if (this.draggedStack.func_190916_E() > 1 && slot != null && Container.func_94527_a((Slot)slot, (ItemStack)this.draggedStack, (boolean)false)) {
                    long i = Minecraft.func_71386_F();
                    if (this.currentDragTargetSlot == slot) {
                        if (i - this.dragItemDropDelay > 500L) {
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.handleMouseClick(slot, slot.field_75222_d, 1, ClickType.PICKUP);
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.dragItemDropDelay = i + 750L;
                            this.draggedStack.func_190918_g(1);
                        }
                    } else {
                        this.currentDragTargetSlot = slot;
                        this.dragItemDropDelay = i;
                    }
                }
            }
        } else if (this.dragSplitting && slot != null && !itemstack.func_190926_b() && (itemstack.func_190916_E() > this.dragSplittingSlots.size() || this.dragSplittingLimit == 2) && Container.func_94527_a((Slot)slot, (ItemStack)itemstack, (boolean)true) && slot.func_75214_a(itemstack) && this.inventorySlots.func_94531_b(slot)) {
            this.dragSplittingSlots.add(slot);
            this.updateDragSplitting();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        boolean flag;
        super.func_146286_b(mouseX, mouseY, state);
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        int i = this.guiLeft;
        int j = this.guiTop;
        boolean bl = flag = mouseX < i || mouseY < j || mouseX >= i + this.sizeX || mouseY >= j + this.sizeY;
        if (slot != null) {
            flag = false;
        }
        int k = -1;
        if (slot != null) {
            k = slot.field_75222_d;
        }
        if (flag) {
            k = -999;
        }
        if (this.doubleClick && slot != null && state == 0 && this.inventorySlots.func_94530_a(ItemStack.field_190927_a, slot)) {
            if (GuiContainerThemed.func_146272_n()) {
                if (!this.shiftClickedSlot.func_190926_b()) {
                    for (Slot slot2 : this.inventorySlots.field_75151_b) {
                        if (slot2 == null || !slot2.func_82869_a((EntityPlayer)this.field_146297_k.field_71439_g) || !slot2.func_75216_d() || !slot2.isSameInventory(slot) || !Container.func_94527_a((Slot)slot2, (ItemStack)this.shiftClickedSlot, (boolean)true)) continue;
                        this.handleMouseClick(slot2, slot2.field_75222_d, state, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.handleMouseClick(slot, k, state, ClickType.PICKUP_ALL);
            }
            this.doubleClick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.dragSplitting && this.dragSplittingButton != state) {
                this.dragSplitting = false;
                this.dragSplittingSlots.clear();
                this.ignoreMouseUp = true;
                return;
            }
            if (this.ignoreMouseUp) {
                this.ignoreMouseUp = false;
                return;
            }
            if (this.clickedSlot != null && this.field_146297_k.field_71474_y.field_85185_A) {
                if (state == 0 || state == 1) {
                    if (this.draggedStack.func_190926_b() && slot != this.clickedSlot) {
                        this.draggedStack = this.clickedSlot.func_75211_c();
                    }
                    boolean flag2 = Container.func_94527_a((Slot)slot, (ItemStack)this.draggedStack, (boolean)false);
                    if (k != -1 && !this.draggedStack.func_190926_b() && flag2) {
                        this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                        this.handleMouseClick(slot, k, 0, ClickType.PICKUP);
                        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            this.returningStack = ItemStack.field_190927_a;
                        } else {
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                            this.touchUpX = mouseX - i;
                            this.touchUpY = mouseY - j;
                            this.returningStackDestSlot = this.clickedSlot;
                            this.returningStack = this.draggedStack;
                            this.returningStackTime = Minecraft.func_71386_F();
                        }
                    } else if (!this.draggedStack.func_190926_b()) {
                        this.touchUpX = mouseX - i;
                        this.touchUpY = mouseY - j;
                        this.returningStackDestSlot = this.clickedSlot;
                        this.returningStack = this.draggedStack;
                        this.returningStackTime = Minecraft.func_71386_F();
                    }
                    this.draggedStack = ItemStack.field_190927_a;
                    this.clickedSlot = null;
                }
            } else if (this.dragSplitting && !this.dragSplittingSlots.isEmpty()) {
                this.handleMouseClick(null, -999, Container.func_94534_d((int)0, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                for (Slot slot1 : this.dragSplittingSlots) {
                    this.handleMouseClick(slot1, slot1.field_75222_d, Container.func_94534_d((int)1, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                }
                this.handleMouseClick(null, -999, Container.func_94534_d((int)2, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
            } else if (!this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(state - 100)) {
                    this.handleMouseClick(slot, k, state, ClickType.CLONE);
                } else {
                    boolean flag1;
                    boolean bl2 = flag1 = k != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                    if (flag1) {
                        this.shiftClickedSlot = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                    }
                    this.handleMouseClick(slot, k, state, flag1 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.lastClickTime = 0L;
        }
        this.dragSplitting = false;
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.isPointInRegion(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        int i = this.guiLeft;
        int j = this.guiTop;
        return (pointX -= i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= j) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    protected void handleMouseClick(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null) {
            slotId = slotIn.field_75222_d;
        }
        this.field_146297_k.field_71442_b.func_187098_a(this.inventorySlots.field_75152_c, slotId, mouseButton, type, (EntityPlayer)this.field_146297_k.field_71439_g);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.checkHotbarKeys(keyCode);
        if (this.theSlot != null && this.theSlot.func_75216_d()) {
            if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(keyCode)) {
                this.handleMouseClick(this.theSlot, this.theSlot.field_75222_d, 0, ClickType.CLONE);
            } else if (this.field_146297_k.field_71474_y.field_74316_C.isActiveAndMatches(keyCode)) {
                this.handleMouseClick(this.theSlot, this.theSlot.field_75222_d, GuiContainerThemed.func_146271_m() ? 1 : 0, ClickType.THROW);
            }
        }
    }

    protected boolean checkHotbarKeys(int keyCode) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.theSlot != null) {
            for (int i = 0; i < 9; ++i) {
                if (!this.field_146297_k.field_71474_y.field_151456_ac[i].isActiveAndMatches(keyCode)) continue;
                this.handleMouseClick(this.theSlot, this.theSlot.field_75222_d, i, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_146281_b() {
        if (this.field_146297_k.field_71439_g != null) {
            this.inventorySlots.func_75134_a((EntityPlayer)this.field_146297_k.field_71439_g);
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        return this.theSlot;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.sizeX;
    }

    public int getYSize() {
        return this.sizeY;
    }
}

