/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.ICallback;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiFileBrowser;
import betterquesting.client.importers.ImportedQuestLines;
import betterquesting.client.importers.ImportedQuests;
import betterquesting.client.importers.ImporterRegistry;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import java.io.File;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Keyboard;

public class GuiImporters
extends GuiScreenCanvas
implements IPEventListener,
ICallback<File[]> {
    private PanelTextBox impName;
    private CanvasScrolling impDescCV;
    private PanelTextBox impDescTX;
    private PanelButtonStorage<IImporter> impBtn;
    private IImporter lastImport;

    public GuiImporters(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        PanelTextBox panTxt = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.importers", new Object[0])).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(panTxt);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        CanvasScrolling cvImports = new CanvasScrolling(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 16, 24), 0));
        cvBackground.addPanel(cvImports);
        int width = cvImports.getTransform().getWidth();
        List<IImporter> impList = ImporterRegistry.INSTANCE.getImporters();
        for (int i = 0; i < impList.size(); ++i) {
            IImporter imp = impList.get(i);
            cvImports.addPanel(new PanelButtonStorage<IImporter>(new GuiRectangle(0, i * 16, width, 16, 0), 1, QuestTranslation.translate(imp.getUnlocalisedName(), new Object[0]), imp));
        }
        PanelVScrollBar scReq = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(0, 0, -8, 0), 0));
        cvBackground.addPanel(scReq);
        scReq.getTransform().setParent(cvImports.getTransform());
        cvImports.setScrollDriverY(scReq);
        CanvasEmpty cvRight = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 24), 0));
        cvBackground.addPanel(cvRight);
        this.impName = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), "").setAlignment(1);
        cvRight.addPanel(this.impName);
        this.impDescCV = new CanvasScrolling(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 24), 0));
        cvRight.addPanel(this.impDescCV);
        PanelVScrollBar scDesc = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(0, 0, -8, 0), 0));
        cvRight.addPanel(scDesc);
        scDesc.getTransform().setParent(this.impDescCV.getTransform());
        this.impDescCV.setScrollDriverY(scDesc);
        width = this.impDescCV.getTransform().getWidth();
        this.impDescTX = new PanelTextBox(new GuiRectangle(0, 0, width, 16, 0), "", true);
        this.impDescCV.addPanel(this.impDescTX);
        this.impBtn = new PanelButtonStorage<Object>(new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(0, -16, 0, 0), 0), 2, QuestTranslation.translate("betterquesting.btn.import", new Object[0]), null);
        this.impBtn.setActive(false);
        cvRight.addPanel(this.impBtn);
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -24, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine0);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            IImporter imp = (IImporter)((PanelButtonStorage)btn).getStoredValue();
            this.impName.setText(QuestTranslation.translate(imp.getUnlocalisedName(), new Object[0]));
            this.impDescTX.setText(QuestTranslation.translate(imp.getUnlocalisedDescription(), new Object[0]));
            this.impDescCV.refreshScrollBounds();
            this.impBtn.setStoredValue(imp);
            this.impBtn.setActive(true);
        } else if (btn.getButtonID() == 2) {
            this.lastImport = (IImporter)((PanelButtonStorage)btn).getStoredValue();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiFileBrowser(this, this, new File(".").getAbsoluteFile().getParentFile(), this.lastImport.getFileFilter()));
        }
    }

    @Override
    public void setValue(File[] files) {
        if (files == null || files.length <= 0 || this.lastImport == null) {
            return;
        }
        ImportedQuests questDB = new ImportedQuests();
        ImportedQuestLines lineDB = new ImportedQuestLines();
        this.lastImport.loadFiles(questDB, lineDB, files);
        if (questDB.size() > 0 || lineDB.size() > 0) {
            NBTTagCompound jsonBase = new NBTTagCompound();
            jsonBase.func_74782_a("quests", (NBTBase)questDB.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
            jsonBase.func_74782_a("lines", (NBTBase)lineDB.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("data", (NBTBase)jsonBase);
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.IMPORT.GetLocation(), tag));
            this.field_146297_k.func_147108_a(this.parent);
        }
    }
}

