/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui.editors.GuiQuestLineDesigner;
import betterquesting.client.gui2.editors.GuiImporters;
import betterquesting.client.gui2.editors.GuiQuestLineAddRemove;
import betterquesting.client.gui2.editors.GuiTextEditor;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLineDatabase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuestLinesEditor
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen,
INeedsRefresh {
    private CanvasScrolling lineList;
    private PanelTextField<String> tfName;
    private PanelTextField<String> tfDesc;
    private PanelButton btnDesign;
    private IQuestLine selected;
    private int selID = -1;

    public GuiQuestLinesEditor(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void refreshGui() {
        if (this.selID >= 0) {
            this.selected = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(this.selID);
            if (this.selected == null) {
                this.selID = -1;
                this.btnDesign.setActive(false);
                this.tfName.setText("");
                this.tfDesc.setText("");
            } else {
                if (!this.tfName.isFocused()) {
                    this.tfName.setText(this.selected.getUnlocalisedName());
                }
                if (!this.tfDesc.isFocused()) {
                    this.tfDesc.setText(this.selected.getUnlocalisedDescription());
                }
            }
        }
        this.reloadList();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        PanelTextBox panTxt = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.edit_line1", new Object[0])).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(panTxt);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        this.lineList = new CanvasScrolling(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 16, 48), 0));
        cvBackground.addPanel(this.lineList);
        PanelVScrollBar scList = new PanelVScrollBar(new GuiTransform(new Vector4f(0.5f, 0.0f, 0.5f, 1.0f), new GuiPadding(-16, 32, 8, 48), 0));
        cvBackground.addPanel(scList);
        this.lineList.setScrollDriverY(scList);
        PanelButton btnAdd = new PanelButton(new GuiTransform(new Vector4f(0.0f, 1.0f, 0.25f, 1.0f), new GuiPadding(16, -40, 0, 24), 0), 1, QuestTranslation.translate("betterquesting.btn.new", new Object[0]));
        cvBackground.addPanel(btnAdd);
        PanelButton btnImport = new PanelButton(new GuiTransform(new Vector4f(0.25f, 1.0f, 0.5f, 1.0f), new GuiPadding(0, -40, 16, 24), 0), 2, QuestTranslation.translate("betterquesting.btn.import", new Object[0]));
        cvBackground.addPanel(btnImport);
        CanvasEmpty cvRight = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 24), 0));
        cvBackground.addPanel(cvRight);
        PanelTextBox txtName = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 4, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.name", new Object[0]));
        txtName.setColor(PresetColor.TEXT_MAIN.getColor());
        cvRight.addPanel(txtName);
        this.tfName = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), "", FieldFilterString.INSTANCE);
        cvRight.addPanel(this.tfName);
        PanelTextBox txtDesc = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 36, 0, -48), 0), QuestTranslation.translate("betterquesting.gui.description", new Object[0]));
        txtDesc.setColor(PresetColor.TEXT_MAIN.getColor());
        cvRight.addPanel(txtDesc);
        this.tfDesc = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 48, 16, -64), 0), "", FieldFilterString.INSTANCE);
        this.tfDesc.setCallback(value -> {});
        cvRight.addPanel(this.tfDesc);
        PanelButton btnManage = new PanelButton(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 80, 0, -96), 0), 3, QuestTranslation.translate("betterquesting.btn.add_remove_quests", new Object[0]));
        cvRight.addPanel(btnManage);
        this.btnDesign = new PanelButton(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 96, 0, -112), 0), 4, QuestTranslation.translate("betterquesting.btn.designer", new Object[0]));
        this.btnDesign.setActive(this.selected != null);
        cvRight.addPanel(this.btnDesign);
        PanelButton btnTextEditor = new PanelButton(new GuiTransform(GuiAlign.TOP_RIGHT, new GuiPadding(-16, 48, 0, -64), 0), 8, "Aa");
        cvRight.addPanel(btnTextEditor);
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -24, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine0);
        if (this.selID >= 0) {
            this.selected = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(this.selID);
            if (this.selected == null) {
                this.selID = -1;
                this.btnDesign.setActive(false);
                this.tfName.setText("");
                this.tfDesc.setText("");
            } else {
                if (!this.tfName.isFocused()) {
                    this.tfName.setText(this.selected.getUnlocalisedName());
                }
                if (!this.tfDesc.isFocused()) {
                    this.tfDesc.setText(this.selected.getUnlocalisedDescription());
                }
            }
        }
        this.reloadList();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (this.selected != null) {
            boolean changed = false;
            if (!this.tfName.getValue().equals(this.selected.getUnlocalisedName())) {
                this.selected.getProperties().setProperty(NativeProps.NAME, this.tfName.getValue());
                changed = true;
            }
            if (!this.tfDesc.getValue().equals(this.selected.getUnlocalisedDescription())) {
                this.selected.getProperties().setProperty(NativeProps.DESC, this.tfDesc.getValue());
                changed = true;
            }
            if (changed) {
                this.SendChanges(EnumPacketAction.EDIT, new DBEntry<IQuestLine>(this.selID, this.selected));
            }
        }
        return super.onMouseClick(mx, my, click);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            this.SendChanges(EnumPacketAction.ADD, null);
        } else if (btn.getButtonID() == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiImporters(this));
        } else if (btn.getButtonID() == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLineAddRemove(this, this.selected));
        } else if (btn.getButtonID() == 4 && this.selected != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLineDesigner((GuiScreen)this, this.selected));
        } else if (btn.getButtonID() == 5 && btn instanceof PanelButtonStorage) {
            DBEntry entry = (DBEntry)((PanelButtonStorage)btn).getStoredValue();
            this.selected = (IQuestLine)entry.getValue();
            this.selID = entry.getID();
            this.tfName.setText(this.selected.getUnlocalisedName());
            this.tfDesc.setText(this.selected.getUnlocalisedDescription());
            this.btnDesign.setActive(true);
            this.reloadList();
        } else if (btn.getButtonID() == 6 && btn instanceof PanelButtonStorage) {
            DBEntry entry = (DBEntry)((PanelButtonStorage)btn).getStoredValue();
            this.SendChanges(EnumPacketAction.REMOVE, entry);
        } else if (btn.getButtonID() == 7 && btn instanceof PanelButtonStorage) {
            DBEntry entry = (DBEntry)((PanelButtonStorage)btn).getStoredValue();
            int order = QuestLineDatabase.INSTANCE.getOrderIndex(entry.getID());
            if (order > 0) {
                this.SendChanges(EnumPacketAction.EDIT, entry, order - 1);
            }
        } else if (btn.getButtonID() == 8) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiTextEditor(this, this.tfDesc.getRawText(), value -> {
                if (this.selected != null) {
                    this.tfDesc.setText((String)value);
                    this.selected.getProperties().setProperty(NativeProps.DESC, value);
                    this.SendChanges(EnumPacketAction.EDIT, new DBEntry<IQuestLine>(this.selID, this.selected));
                }
            }));
        }
    }

    private void reloadList() {
        this.lineList.resetCanvas();
        int w = this.lineList.getTransform().getWidth();
        int i = 0;
        for (DBEntry<IQuestLine> entry : QuestLineDatabase.INSTANCE.getSortedEntries()) {
            IQuestLine ql = entry.getValue();
            PanelButtonStorage<DBEntry<IQuestLine>> tmp = new PanelButtonStorage<DBEntry<IQuestLine>>(new GuiRectangle(0, i * 16, w - 32, 16, 0), 5, QuestTranslation.translate(ql.getUnlocalisedName(), new Object[0]), entry);
            tmp.setActive(entry.getID() != this.selID);
            this.lineList.addPanel(tmp);
            this.lineList.addPanel(new PanelButtonStorage<DBEntry<IQuestLine>>(new GuiRectangle(w - 32, i * 16, 16, 16, 0), 6, "", entry).setIcon(PresetIcon.ICON_TRASH.getTexture()));
            this.lineList.addPanel(new PanelButtonStorage<DBEntry<IQuestLine>>(new GuiRectangle(w - 16, i * 16, 16, 16, 0), 7, "", entry).setIcon(PresetIcon.ICON_UP.getTexture()));
            ++i;
        }
    }

    private void SendChanges(EnumPacketAction action, DBEntry<IQuestLine> entry) {
        this.SendChanges(action, entry, entry == null ? -1 : QuestLineDatabase.INSTANCE.getOrderIndex(entry.getID()));
    }

    private void SendChanges(EnumPacketAction action, DBEntry<IQuestLine> entry, int order) {
        if (action == null) {
            return;
        }
        NBTTagCompound tags = new NBTTagCompound();
        if (action == EnumPacketAction.EDIT && entry != null) {
            NBTTagCompound base = new NBTTagCompound();
            base.func_74782_a("line", (NBTBase)entry.getValue().writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG));
            tags.func_74782_a("data", (NBTBase)base);
        }
        tags.func_74768_a("lineID", entry == null ? -1 : entry.getID());
        tags.func_74768_a("order", order);
        tags.func_74768_a("action", action.ordinal());
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tags));
    }
}

