/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.nbt;

import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelEntityPreview;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasEntityDatabase;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import org.lwjgl.input.Keyboard;

public class GuiEntitySelection
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen {
    private final ICallback<Entity> callback;
    private Entity selEntity;
    private PanelEntityPreview pnPreview;

    public GuiEntitySelection(GuiScreen parent, NBTTagCompound tag, ICallback<Entity> callback) {
        this(parent, JsonHelper.JsonToEntity(tag, (World)Minecraft.func_71410_x().field_71441_e), callback);
    }

    public GuiEntitySelection(GuiScreen parent, Entity entity, ICallback<Entity> callback) {
        super(parent);
        this.selEntity = entity;
        this.callback = callback;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.done", new Object[0])));
        PanelTextBox txTitle = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.select_entity", new Object[0])).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(txTitle);
        CanvasEmpty cvRight = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 32), 0));
        cvBackground.addPanel(cvRight);
        CanvasEntityDatabase cvDatabase = new CanvasEntityDatabase(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0), 1);
        cvRight.addPanel(cvDatabase);
        PanelTextField<String> searchBox = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 8, -16), 0), "", FieldFilterString.INSTANCE);
        searchBox.setCallback(cvDatabase::setSearchFilter).setWatermark("Search...");
        cvRight.addPanel(searchBox);
        PanelVScrollBar scEdit = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        cvDatabase.setScrollDriverY(scEdit);
        cvRight.addPanel(scEdit);
        this.pnPreview = new PanelEntityPreview(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 8, 32), 0), this.selEntity);
        cvBackground.addPanel(this.pnPreview);
        this.pnPreview.setRotationDriven(new IValueIO<Float>(){

            @Override
            public Float readValue() {
                return Float.valueOf(15.0f);
            }

            @Override
            public void writeValue(Float value) {
            }
        }, new IValueIO<Float>(){

            @Override
            public Float readValue() {
                return Float.valueOf((float)((double)(Minecraft.func_71386_F() % 30000L) / 30000.0 * 360.0));
            }

            @Override
            public void writeValue(Float value) {
            }
        });
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -32, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine0);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        Entity e;
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            if (this.callback != null) {
                this.callback.setValue(this.selEntity);
            }
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1 && btn instanceof PanelButtonStorage && (e = EntityList.func_191304_a((Class)((EntityEntry)((PanelButtonStorage)btn).getStoredValue()).getEntityClass(), (World)this.field_146297_k.field_71441_e)) != null) {
            this.selEntity = e;
            this.pnPreview.setEntity(this.selEntity);
        }
    }
}

