/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.themes;

import betterquesting.api.client.themes.ITheme;
import betterquesting.api.client.themes.IThemeLoader;
import betterquesting.api.client.themes.IThemeRegistry;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.client.themes.ThemeLoaderStandard;
import betterquesting.client.themes.ThemeStandard;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ThemeRegistry
implements IThemeRegistry {
    public static final ThemeRegistry INSTANCE = new ThemeRegistry();
    private final ITheme fallbackTheme = new ThemeStandard("Standard", new ResourceLocation("betterquesting", "textures/gui/editor_gui.png"), new ResourceLocation("betterquesting:fallback"));
    private ITheme currentTheme = null;
    private final HashMap<ResourceLocation, ITheme> themeList = new HashMap();
    private final HashMap<ResourceLocation, ITheme> resThemes = new HashMap();
    private final HashMap<ResourceLocation, IThemeLoader> themeLoaders = new HashMap();

    private ThemeRegistry() {
        this.registerLoader(new ThemeLoaderStandard());
    }

    @Override
    public void registerTheme(ITheme theme) {
        if (theme == null) {
            throw new NullPointerException("Tried to register null theme");
        }
        if (theme.getThemeID() == null) {
            throw new IllegalArgumentException("Tried to register a theme with a null name");
        }
        if (this.themeList.containsKey(theme.getThemeID()) || this.themeList.containsValue(theme)) {
            throw new IllegalArgumentException("Cannot register dupliate theme '" + theme.getThemeID() + "'");
        }
        if (this.resThemes.containsKey(theme.getThemeID()) || this.resThemes.containsValue(theme)) {
            throw new IllegalArgumentException("Cannot register dupliate theme '" + theme.getThemeID() + "'");
        }
        this.themeList.put(theme.getThemeID(), theme);
    }

    @Override
    public ITheme getTheme(ResourceLocation name) {
        ITheme tmp = this.themeList.get(name);
        tmp = tmp != null ? tmp : this.resThemes.get(name);
        return tmp;
    }

    @Override
    public List<ITheme> getAllThemes() {
        ArrayList<ITheme> list = new ArrayList<ITheme>();
        list.addAll(this.themeList.values());
        list.addAll(this.resThemes.values());
        return list;
    }

    @Override
    public void registerLoader(IThemeLoader loader) {
        if (loader == null) {
            throw new NullPointerException("Tried to register null theme loader");
        }
        if (loader.getLoaderID() == null) {
            throw new IllegalArgumentException("Tried to register a theme loader with a null name");
        }
        if (this.themeLoaders.containsKey(loader.getLoaderID()) || this.themeList.containsValue(loader)) {
            throw new IllegalArgumentException("Cannot register dupliate theme loader '" + loader.getLoaderID() + "'");
        }
        this.themeLoaders.put(loader.getLoaderID(), loader);
    }

    @Override
    public IThemeLoader getLoader(ResourceLocation name) {
        return this.themeLoaders.get(name);
    }

    @Override
    public List<IThemeLoader> getAllLoaders() {
        return new ArrayList<IThemeLoader>(this.themeLoaders.values());
    }

    @Override
    public ITheme getCurrentTheme() {
        if (this.currentTheme == null) {
            this.currentTheme = this.getTheme(new ResourceLocation(BQ_Settings.curTheme));
        }
        return this.currentTheme != null ? this.currentTheme : this.fallbackTheme;
    }

    @Override
    public void setCurrentTheme(ITheme theme) {
        if (theme == null) {
            BetterQuesting.logger.log(Level.WARN, "Tried to set theme to NULL");
            return;
        }
        this.currentTheme = theme;
        BQ_Settings.curTheme = theme.getThemeID().toString();
        if (ConfigHandler.config != null) {
            ConfigHandler.config.get("general", "Theme", "").set(BQ_Settings.curTheme);
            ConfigHandler.config.save();
            BetterQuesting.logger.log(Level.INFO, "Theme set to " + this.currentTheme.getDisplayName());
        } else {
            BetterQuesting.logger.log(Level.WARN, "Unable to save theme setting");
        }
    }

    public void setCurrentTheme(ResourceLocation res) {
        this.setCurrentTheme(this.getTheme(res));
    }

    @Override
    public void reloadThemes() {
        this.resThemes.clear();
        IResourceManager resManager = Minecraft.func_71410_x().func_110442_L();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String domain : resManager.func_135055_a()) {
            try {
                ResourceLocation res = new ResourceLocation(domain, "bq_themes.json");
                List list = resManager.func_135056_b(res);
                for (IResource iresource : list) {
                    try {
                        InputStreamReader isr = new InputStreamReader(iresource.func_110527_b());
                        JsonArray jAry = (JsonArray)gson.fromJson((Reader)isr, JsonArray.class);
                        isr.close();
                        for (JsonElement je : jAry) {
                            ITheme theme;
                            if (je == null || !je.isJsonObject()) {
                                BetterQuesting.logger.log(Level.WARN, "Invalid theme in " + domain);
                                continue;
                            }
                            JsonObject jThm = je.getAsJsonObject();
                            ResourceLocation loadID = new ResourceLocation(JsonHelper.GetString(jThm, "themeType", "betterquesting:standard"));
                            IThemeLoader loader = this.getLoader(loadID);
                            if (loader == null || (theme = loader.loadTheme(jThm, domain)) == null) continue;
                            this.resThemes.put(theme.getThemeID(), theme);
                        }
                    }
                    catch (Exception e) {
                        BetterQuesting.logger.log(Level.ERROR, "Error reading bq_themes.json from " + domain, (Throwable)e);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }
}

