/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.questing.tasks.ITickableTask;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.QuestCache;
import betterquesting.api2.client.gui.GuiScreenTest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.BQ_Keybindings;
import betterquesting.client.gui2.GuiHome;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (BQ_Keybindings.openQuests.func_151468_f()) {
            if (mc.field_71439_g.func_70093_af() && mc.field_71439_g.func_70005_c_().equalsIgnoreCase("Funwayguy")) {
                mc.func_147108_a((GuiScreen)new GuiScreenTest(mc.field_71462_r));
            } else if (BQ_Settings.useBookmark && GuiHome.bookmark != null) {
                mc.func_147108_a(GuiHome.bookmark);
            } else {
                mc.func_147108_a((GuiScreen)new GuiHome(mc.field_71462_r));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            if (QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            UUID uuid = QuestingAPI.getQuestingUUID(player);
            boolean refreshCache = false;
            for (IQuest quest : QuestCache.INSTANCE.getActiveQuests(uuid)) {
                if (quest.getTasks().size() <= 0 || quest.canSubmit(player)) {
                    boolean syncMe = quest.getTasks().size() <= 0;
                    boolean wat = true;
                    for (DBEntry task : quest.getTasks().getEntries()) {
                        if (!(task.getValue() instanceof ITickableTask) || ((ITask)task.getValue()).isComplete(uuid)) continue;
                        wat = false;
                        ((ITickableTask)task.getValue()).updateTask(player, quest);
                        if (!((ITask)task.getValue()).isComplete(uuid)) continue;
                        syncMe = true;
                    }
                    if (!syncMe && (!wat || player.field_70173_aa % 60 != 0)) continue;
                    quest.update(player);
                    if (!quest.isComplete(uuid)) {
                        PacketSender.INSTANCE.sendToAll(quest.getSyncPacket());
                        continue;
                    }
                    refreshCache = true;
                    continue;
                }
                if (quest.isComplete(uuid)) {
                    if (player.field_70173_aa % 20 == 0 && quest.getProperties().getProperty(NativeProps.REPEAT_TIME) >= 0) {
                        quest.update(player);
                        continue;
                    }
                    refreshCache = true;
                    continue;
                }
                if (player.field_70173_aa % 60 != 0) continue;
                quest.update(player);
                if (!quest.isComplete(uuid)) continue;
                refreshCache = true;
            }
            if (refreshCache || player.field_70173_aa % 200 == 0) {
                QuestCache.INSTANCE.updateCache(player);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterquesting")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && BQ_Settings.curWorldDir != null && event.getWorld().field_73011_w.getDimension() == 0) {
            SaveLoadHandler.INSTANCE.saveDatabases();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.player.func_184102_h() == null || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        if (BetterQuesting.proxy.isClient() && !event.player.func_184102_h().func_71262_S() && event.player.func_184102_h().func_71214_G().equals(event.player.func_146103_bH().getName())) {
            return;
        }
        EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
        NameCache.INSTANCE.updateNames(event.player.func_184102_h());
        PacketSender.INSTANCE.sendToPlayer(QuestSettings.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(QuestDatabase.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(QuestLineDatabase.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(LifeDatabase.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(PartyManager.INSTANCE.getSyncPacket(), mpPlayer);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue() && event.player instanceof EntityPlayerMP && !((EntityPlayerMP)event.player).field_71136_j) {
            int lives;
            EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
            IParty party = PartyManager.INSTANCE.getUserParty(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer));
            int n = lives = party == null || party.getProperties().getProperty(NativeProps.PARTY_LIVES) == false ? LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer)) : LifeDatabase.INSTANCE.getLives(party);
            if (lives <= 0) {
                MinecraftServer server = mpPlayer.func_184102_h();
                if (server == null) {
                    return;
                }
                mpPlayer.func_71033_a(GameType.SPECTATOR);
                mpPlayer.func_71121_q().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false");
            } else if (lives == 1) {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString("This is your last life!"), true);
            } else {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString(lives + " lives remaining!"), true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || !QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue()) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)event.getEntityLiving());
            IParty party = PartyManager.INSTANCE.getUserParty(uuid);
            if (party == null || !party.getProperties().getProperty(NativeProps.PARTY_LIVES).booleanValue()) {
                int lives = LifeDatabase.INSTANCE.getLives(uuid);
                LifeDatabase.INSTANCE.setLives(uuid, lives - 1);
            } else {
                int lives = LifeDatabase.INSTANCE.getLives(party);
                LifeDatabase.INSTANCE.setLives(party, lives - 1);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(FluidPlaceholder.fluidPlaceholder.getStill());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDataUpdated(DatabaseEvent.Update event) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof INeedsRefresh) {
            ((INeedsRefresh)screen).refreshGui();
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (event.getCommand().func_71517_b().equalsIgnoreCase("op") || event.getCommand().func_71517_b().equalsIgnoreCase("deop"))) {
            NameCache.INSTANCE.updateNames(server);
        }
    }
}

