/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network;

import betterquesting.core.BetterQuesting;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public final class PacketAssembly {
    public static final PacketAssembly INSTANCE = new PacketAssembly();
    private final ConcurrentHashMap<UUID, byte[]> buffer = new ConcurrentHashMap();
    private byte[] serverBuf = null;
    private int id = 0;

    private PacketAssembly() {
    }

    public ArrayList<NBTTagCompound> splitPacket(NBTTagCompound tags) {
        ArrayList<NBTTagCompound> pkts = new ArrayList<NBTTagCompound>();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)tags, (OutputStream)baos);
            baos.flush();
            byte[] data = baos.toByteArray();
            baos.close();
            int req = MathHelper.func_76123_f((float)((float)data.length / 30000.0f));
            for (int p = 0; p < req; ++p) {
                int idx = p * 30000;
                int s = Math.min(data.length - idx, 30000);
                NBTTagCompound container = new NBTTagCompound();
                byte[] part = new byte[s];
                System.arraycopy(data, idx, part, 0, s);
                container.func_74768_a("size", data.length);
                container.func_74768_a("index", idx);
                container.func_74757_a("end", p == req - 1);
                container.func_74782_a("data", (NBTBase)new NBTTagByteArray(part));
                pkts.add(container);
            }
        }
        catch (Exception e) {
            BetterQuesting.logger.error("Unable to split build packet!", (Throwable)e);
            return pkts;
        }
        this.id = (this.id + 1) % 100;
        return pkts;
    }

    public NBTTagCompound assemblePacket(UUID owner, NBTTagCompound tags) {
        int size = tags.func_74762_e("size");
        int index = tags.func_74762_e("index");
        boolean end = tags.func_74767_n("end");
        byte[] data = tags.func_74770_j("data");
        byte[] tmp = this.getBuffer(owner);
        if (tmp == null) {
            tmp = new byte[size];
            this.setBuffer(owner, tmp);
        } else if (tmp.length != size) {
            BetterQuesting.logger.error("Unexpected change in BQ packet byte length: " + size + " > " + tmp.length);
            this.clearBuffer(owner);
            return null;
        }
        for (int i = 0; i < data.length && index + i < size; ++i) {
            tmp[index + i] = data[i];
        }
        if (end) {
            this.clearBuffer(owner);
            try {
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(tmp))));
                NBTTagCompound tag = CompressedStreamTools.func_152456_a((DataInput)dis, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                dis.close();
                return tag;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to assemble BQ packet", e);
            }
        }
        return null;
    }

    public byte[] getBuffer(UUID owner) {
        if (owner == null) {
            return this.serverBuf;
        }
        return this.buffer.get(owner);
    }

    public void setBuffer(UUID owner, byte[] value) {
        if (owner == null) {
            this.serverBuf = value;
        } else {
            if (this.buffer.containsKey(owner)) {
                throw new IllegalStateException("Attepted to start more than one BQ packet assembly for UUID " + owner.toString());
            }
            this.buffer.put(owner, value);
        }
    }

    public void clearBuffer(UUID owner) {
        if (owner == null) {
            this.serverBuf = null;
        } else {
            this.buffer.remove(owner);
        }
    }
}

