/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.IPacketHandler;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.importers.ImportedQuestLines;
import betterquesting.client.importers.ImportedQuests;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.Level;

public class PktHandlerImport
implements IPacketHandler {
    @Override
    public ResourceLocation getRegistryName() {
        return PacketTypeNative.IMPORT.GetLocation();
    }

    @Override
    public void handleServer(NBTTagCompound tag, EntityPlayerMP sender) {
        if (sender == null) {
            return;
        }
        boolean isOP = sender.field_70170_p.func_73046_m().func_184103_al().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to import quests without OP permissions!");
            sender.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit quests!"), false);
            return;
        }
        NBTTagCompound jsonBase = tag.func_74775_l("data");
        ImportedQuests impQuestDB = new ImportedQuests();
        ImportedQuestLines impQuestLineDB = new ImportedQuestLines();
        impQuestDB.readFromNBT(jsonBase.func_150295_c("quests", 10), EnumSaveType.CONFIG);
        impQuestLineDB.readFromNBT(jsonBase.func_150295_c("lines", 10), EnumSaveType.CONFIG);
        BetterQuesting.logger.log(Level.INFO, "Importing " + impQuestDB.size() + " quest(s) and " + impQuestLineDB.size() + " quest line(s) from " + sender.func_146103_bH().getName());
        HashMap<Integer, Integer> remapped = this.getRemappedIDs(impQuestDB.getEntries());
        for (Map.Entry<Integer, Integer> entry : remapped.entrySet()) {
            QuestDatabase.INSTANCE.add(entry.getValue(), impQuestDB.getValue(entry.getKey()));
        }
        for (DBEntry questLine : impQuestLineDB.getEntries()) {
            for (DBEntry qle : ((IQuestLine)questLine.getValue()).getEntries()) {
                int oldID = qle.getID();
                ((IQuestLine)questLine.getValue()).removeID(qle.getID());
                ((IQuestLine)questLine.getValue()).add(remapped.get(oldID), qle.getValue());
            }
            QuestLineDatabase.INSTANCE.add(QuestLineDatabase.INSTANCE.nextID(), questLine.getValue());
        }
        PacketSender.INSTANCE.sendToAll(QuestDatabase.INSTANCE.getSyncPacket());
        PacketSender.INSTANCE.sendToAll(QuestLineDatabase.INSTANCE.getSyncPacket());
    }

    @Override
    public void handleClient(NBTTagCompound tag) {
    }

    private HashMap<Integer, Integer> getRemappedIDs(DBEntry<IQuest>[] idList) {
        ArrayList<Integer> existing = new ArrayList<Integer>();
        for (DBEntry entry : QuestDatabase.INSTANCE.getEntries()) {
            existing.add(entry.getID());
        }
        HashMap<Integer, Integer> remapped = new HashMap<Integer, Integer>();
        int n = 0;
        for (DBEntry<IQuest> id : idList) {
            while (existing.contains(n) || remapped.containsValue(n)) {
                ++n;
            }
            remapped.put(id.getID(), n);
        }
        return remapped;
    }
}

