/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.storage.BigDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestInstance;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class QuestDatabase
extends BigDatabase<IQuest>
implements IQuestDatabase {
    public static final QuestDatabase INSTANCE = new QuestDatabase();

    @Override
    public IQuest createNew(int id) {
        QuestInstance q = new QuestInstance();
        q.setParentDatabase(this);
        this.add(id, q);
        return q;
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("config", (NBTBase)this.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
        base.func_74782_a("progress", (NBTBase)this.writeToNBT(new NBTTagList(), EnumSaveType.PROGRESS));
        tags.func_74782_a("data", (NBTBase)base);
        return new QuestingPacket(PacketTypeNative.QUEST_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        NBTTagCompound base = payload.func_74775_l("data");
        this.readFromNBT(base.func_150295_c("config", 10), EnumSaveType.CONFIG);
        this.readFromNBT(base.func_150295_c("progress", 10), EnumSaveType.PROGRESS);
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                return this.writeToJson_Config(json);
            }
            case PROGRESS: {
                return this.writeToJson_Progress(json);
            }
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.readFromJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.readFromJson_Progress(json);
                break;
            }
        }
    }

    private NBTTagList writeToJson_Config(NBTTagList json) {
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jq = new NBTTagCompound();
            ((IQuest)entry.getValue()).writeToNBT(jq, EnumSaveType.CONFIG);
            jq.func_74768_a("questID", entry.getID());
            json.func_74742_a((NBTBase)jq);
        }
        return json;
    }

    private void readFromJson_Config(NBTTagList nbt) {
        this.reset();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            int qID;
            NBTBase entry = nbt.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound qTag = (NBTTagCompound)entry;
            int n = qID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (qID < 0) continue;
            IQuest quest = (IQuest)this.getValue(qID);
            quest = quest != null ? quest : this.createNew(qID);
            quest.readFromNBT(qTag, EnumSaveType.CONFIG);
        }
    }

    private NBTTagList writeToJson_Progress(NBTTagList json) {
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jq = new NBTTagCompound();
            ((IQuest)entry.getValue()).writeToNBT(jq, EnumSaveType.PROGRESS);
            jq.func_74768_a("questID", entry.getID());
            json.func_74742_a((NBTBase)jq);
        }
        return json;
    }

    private void readFromJson_Progress(NBTTagList json) {
        for (int i = 0; i < json.func_74745_c(); ++i) {
            IQuest quest;
            int qID;
            NBTBase entry = json.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound qTag = (NBTTagCompound)entry;
            int n = qID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (qID < 0 || (quest = (IQuest)this.getValue(qID)) == null) continue;
            quest.readFromNBT(qTag, EnumSaveType.PROGRESS);
        }
    }
}

