/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.core.BetterQuesting;
import betterquesting.misc.UserEntry;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.questing.rewards.RewardStorage;
import betterquesting.questing.tasks.TaskStorage;
import betterquesting.storage.PropertyContainer;
import betterquesting.storage.QuestSettings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class QuestInstance
implements IQuest {
    private final TaskStorage tasks = new TaskStorage();
    private final RewardStorage rewards = new RewardStorage();
    private final List<UserEntry> completeUsers = new CopyOnWriteArrayList<UserEntry>();
    private final List<IQuest> preRequisites = new CopyOnWriteArrayList<IQuest>();
    private PropertyContainer qInfo = new PropertyContainer();
    private IQuestDatabase parentDB = QuestingAPI.getAPI(ApiReference.QUEST_DB);
    private final Boolean syncLock = true;

    public QuestInstance() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.ICON, new BigItemStack(Items.field_151156_bN));
        this.setupValue(NativeProps.SOUND_COMPLETE);
        this.setupValue(NativeProps.SOUND_UPDATE);
        this.setupValue(NativeProps.LOGIC_QUEST, EnumLogic.AND);
        this.setupValue(NativeProps.LOGIC_TASK, EnumLogic.AND);
        this.setupValue(NativeProps.REPEAT_TIME, -1);
        this.setupValue(NativeProps.LOCKED_PROGRESS, false);
        this.setupValue(NativeProps.AUTO_CLAIM, false);
        this.setupValue(NativeProps.SILENT, false);
        this.setupValue(NativeProps.MAIN, false);
        this.setupValue(NativeProps.PARTY_LOOT, false);
        this.setupValue(NativeProps.GLOBAL_SHARE, false);
        this.setupValue(NativeProps.SIMULTANEOUS, false);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.qInfo.setProperty(prop, this.qInfo.getProperty(prop, def));
    }

    @Override
    public void setParentDatabase(IQuestDatabase questDB) {
        this.parentDB = questDB;
    }

    @Override
    public String getUnlocalisedName() {
        String def = "New Quest";
        if (!this.qInfo.hasProperty(NativeProps.NAME)) {
            this.qInfo.setProperty(NativeProps.NAME, def);
            return def;
        }
        return this.qInfo.getProperty(NativeProps.NAME, def);
    }

    @Override
    public String getUnlocalisedDescription() {
        String def = "No Description";
        if (!this.qInfo.hasProperty(NativeProps.DESC)) {
            this.qInfo.setProperty(NativeProps.DESC, def);
            return def;
        }
        return this.qInfo.getProperty(NativeProps.DESC, def);
    }

    @Override
    public BigItemStack getItemIcon() {
        BigItemStack def = new BigItemStack(Items.field_151156_bN);
        if (!this.qInfo.hasProperty(NativeProps.ICON)) {
            this.qInfo.setProperty(NativeProps.ICON, def);
            return def;
        }
        return this.qInfo.getProperty(NativeProps.ICON, def);
    }

    @Override
    public IPropertyContainer getProperties() {
        return this.qInfo;
    }

    @Override
    public void update(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(playerID)) {
            UserEntry entry = this.GetUserEntry(playerID);
            if (!this.hasClaimed(playerID)) {
                if (this.canClaim(player)) {
                    if (this.qInfo.getProperty(NativeProps.AUTO_CLAIM).booleanValue() && player.field_70173_aa % 20 == 0) {
                        this.claimReward(player);
                    }
                    return;
                }
                if (this.qInfo.getProperty(NativeProps.REPEAT_TIME) < 0 || this.rewards.size() <= 0) {
                    return;
                }
            } else {
                if (this.rewards.size() > 0 && this.qInfo.getProperty(NativeProps.REPEAT_TIME) >= 0 && player.field_70170_p.func_82737_E() - entry.getTimestamp() >= (long)this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue()) {
                    if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
                        this.resetAll(false);
                    } else {
                        this.resetUser(playerID, false);
                    }
                    if (!QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                        this.postPresetNotice(player, 1);
                    }
                    PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
                    return;
                }
                return;
            }
        }
        if (this.isUnlocked(playerID) || this.qInfo.getProperty(NativeProps.LOCKED_PROGRESS).booleanValue()) {
            int done = 0;
            for (DBEntry entry : this.tasks.getEntries()) {
                if (!((ITask)entry.getValue()).isComplete(playerID)) continue;
                IParty party = PartyManager.INSTANCE.getUserParty(playerID);
                if (party != null) {
                    for (UUID mem : party.getMembers()) {
                        ((ITask)entry.getValue()).setComplete(mem);
                    }
                }
                ++done;
            }
            if (!this.isUnlocked(playerID)) {
                return;
            }
            if (!(this.isComplete(playerID) || this.tasks.size() <= 0 && QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() || !this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size()))) {
                this.setComplete(playerID, player.field_70170_p.func_82737_E());
                PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
                if (!QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                    this.postPresetNotice(player, 2);
                }
            } else if (!this.isComplete(playerID) && done > 0 && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
                this.resetUser(playerID, false);
                PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
            }
        }
    }

    @Override
    public void detect(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(playerID) && (this.qInfo.getProperty(NativeProps.REPEAT_TIME) < 0 || this.rewards.size() <= 0)) {
            return;
        }
        if (!this.canSubmit(player)) {
            return;
        }
        if (this.isUnlocked(playerID) || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            int done = 0;
            boolean update = false;
            for (DBEntry entry : this.tasks.getEntries()) {
                if (!((ITask)entry.getValue()).isComplete(playerID)) {
                    ((ITask)entry.getValue()).detect(player, this);
                    if (!((ITask)entry.getValue()).isComplete(playerID)) continue;
                    IParty party = PartyManager.INSTANCE.getUserParty(playerID);
                    if (party != null) {
                        for (UUID mem : party.getMembers()) {
                            ((ITask)entry.getValue()).setComplete(mem);
                        }
                    }
                    ++done;
                    update = true;
                    continue;
                }
                ++done;
            }
            if (this.tasks.size() <= 0 || this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size())) {
                this.setComplete(playerID, player.field_70170_p.func_82737_E());
                if (!QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                    this.postPresetNotice(player, 2);
                }
            } else if (update && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
                this.resetUser(playerID, false);
                PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
            } else if (update && !QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                this.postPresetNotice(player, 1);
            }
            PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
        }
    }

    public void postPresetNotice(EntityPlayer player, int preset) {
        switch (preset) {
            case 0: {
                this.postNotice(player, "betterquesting.notice.unlock", this.getUnlocalisedName(), this.qInfo.getProperty(NativeProps.SOUND_UNLOCK), this.getItemIcon());
                break;
            }
            case 1: {
                this.postNotice(player, "betterquesting.notice.update", this.getUnlocalisedName(), this.qInfo.getProperty(NativeProps.SOUND_UPDATE), this.getItemIcon());
                break;
            }
            case 2: {
                this.postNotice(player, "betterquesting.notice.complete", this.getUnlocalisedName(), this.qInfo.getProperty(NativeProps.SOUND_COMPLETE), this.getItemIcon());
            }
        }
    }

    public void postNotice(EntityPlayer player, String mainTxt, String subTxt, String sound, BigItemStack icon) {
        if (QuestDatabase.INSTANCE.getID(this) < 0) {
            BetterQuesting.logger.error("Non-existant quest is posting notifications!", (Throwable)new Exception());
        }
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Main", mainTxt);
        tags.func_74778_a("Sub", subTxt);
        tags.func_74778_a("Sound", sound);
        tags.func_74782_a("Icon", (NBTBase)icon.writeToNBT(new NBTTagCompound()));
        QuestingPacket payload = new QuestingPacket(PacketTypeNative.NOTIFICATION.GetLocation(), tags);
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            PacketSender.INSTANCE.sendToAll(payload);
        } else if (player instanceof EntityPlayerMP) {
            List<EntityPlayerMP> tarList = this.getPartyPlayers((EntityPlayerMP)player);
            for (EntityPlayerMP p : tarList) {
                PacketSender.INSTANCE.sendToPlayer(payload, p);
            }
        }
    }

    private List<EntityPlayerMP> getPartyPlayers(EntityPlayerMP player) {
        ArrayList<EntityPlayerMP> list = new ArrayList<EntityPlayerMP>();
        IParty party = PartyManager.INSTANCE.getUserParty(QuestingAPI.getQuestingUUID((EntityPlayer)player));
        if (party == null) {
            list.add(player);
            return list;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (UUID mem : party.getMembers()) {
            for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                if (p == null || !QuestingAPI.getQuestingUUID((EntityPlayer)p).equals(mem)) continue;
                list.add(p);
            }
        }
        return list;
    }

    @Override
    public boolean hasClaimed(UUID uuid) {
        UserEntry entry;
        if (this.rewards.size() <= 0) {
            return true;
        }
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            if (this.GetParticipation(uuid) < this.qInfo.getProperty(NativeProps.PARTICIPATION).floatValue()) {
                return true;
            }
            if (!this.qInfo.getProperty(NativeProps.GLOBAL_SHARE).booleanValue()) {
                for (UserEntry entry2 : this.completeUsers) {
                    if (!entry2.hasClaimed()) continue;
                    return true;
                }
                return false;
            }
        }
        if ((entry = this.GetUserEntry(uuid)) == null) {
            return false;
        }
        return entry.hasClaimed();
    }

    @Override
    public boolean canClaim(EntityPlayer player) {
        UserEntry entry = this.GetUserEntry(QuestingAPI.getQuestingUUID(player));
        if (entry == null || this.hasClaimed(QuestingAPI.getQuestingUUID(player))) {
            return false;
        }
        if (this.canSubmit(player)) {
            return false;
        }
        for (DBEntry rew : this.rewards.getEntries()) {
            if (((IReward)rew.getValue()).canClaim(player, this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void claimReward(EntityPlayer player) {
        for (DBEntry rew : this.rewards.getEntries()) {
            ((IReward)rew.getValue()).claimReward(player, this);
        }
        UUID pID = QuestingAPI.getQuestingUUID(player);
        IParty party = PartyManager.INSTANCE.getUserParty(pID);
        if (party != null && this.qInfo.getProperty(NativeProps.PARTY_LOOT).booleanValue()) {
            for (UUID mem : party.getMembers()) {
                EnumPartyStatus pStat = party.getStatus(mem);
                if (pStat == null || pStat == EnumPartyStatus.INVITE) continue;
                UserEntry entry = this.GetUserEntry(mem);
                if (entry == null) {
                    entry = new UserEntry(mem);
                    this.completeUsers.add(entry);
                }
                entry.setClaimed(true, player.field_70170_p.func_82737_E());
            }
        } else {
            UserEntry entry = this.GetUserEntry(pID);
            if (entry == null) {
                entry = new UserEntry(pID);
                this.completeUsers.add(entry);
            }
            entry.setClaimed(true, player.field_70170_p.func_82737_E());
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public boolean canSubmit(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        UserEntry entry = this.GetUserEntry(playerID);
        if (entry == null) {
            return true;
        }
        if (!entry.hasClaimed() && this.getProperties().getProperty(NativeProps.REPEAT_TIME) >= 0) {
            if (this.tasks.size() <= 0) {
                return true;
            }
            int done = 0;
            for (DBEntry tsk : this.tasks.getEntries()) {
                if (!((ITask)tsk.getValue()).isComplete(playerID)) continue;
                ++done;
            }
            return !this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size());
        }
        return false;
    }

    private float GetParticipation(UUID uuid) {
        if (this.tasks.size() <= 0) {
            return 0.0f;
        }
        float total = 0.0f;
        for (DBEntry t : this.tasks.getEntries()) {
            if (!(t.getValue() instanceof IProgression)) continue;
            total += ((IProgression)t.getValue()).getParticipation(uuid);
        }
        return total / (float)this.tasks.size();
    }

    @Override
    public List<String> getTooltip(EntityPlayer player) {
        List<String> tooltip = this.getStandardTooltip(player);
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip.add("");
            tooltip.addAll(this.getAdvancedTooltip(player));
        }
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getStandardTooltip(EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(QuestTranslation.translate(this.getUnlocalisedName(), new Object[0]) + (!Minecraft.func_71410_x().field_71474_y.field_82882_x ? "" : " #" + this.parentDB.getID(this)));
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(playerID)) {
            list.add(TextFormatting.GREEN + QuestTranslation.translate("betterquesting.tooltip.complete", new Object[0]));
            if (!this.hasClaimed(playerID)) {
                list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.rewards_pending", new Object[0]));
            } else if (this.qInfo.getProperty(NativeProps.REPEAT_TIME) > 0) {
                long time = this.getRepeatSeconds(player);
                DecimalFormat df = new DecimalFormat("00");
                String timeTxt = "";
                if (time >= 3600L) {
                    timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
                } else if (time >= 60L) {
                    timeTxt = timeTxt + time / 60L + "m ";
                }
                timeTxt = timeTxt + df.format(time % 60L) + "s";
                list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
            }
        } else if (!this.isUnlocked(playerID)) {
            list.add(TextFormatting.RED + "" + TextFormatting.UNDERLINE + QuestTranslation.translate("betterquesting.tooltip.requires", new Object[0]) + " (" + this.qInfo.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase() + ")");
            for (IQuest req : this.preRequisites) {
                if (req.isComplete(playerID)) continue;
                list.add(TextFormatting.RED + "- " + QuestTranslation.translate(req.getUnlocalisedName(), new Object[0]));
            }
        } else {
            int n = 0;
            for (DBEntry task : this.tasks.getEntries()) {
                if (!((ITask)task.getValue()).isComplete(playerID)) continue;
                ++n;
            }
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.tasks_complete", n, this.tasks.size()));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getAdvancedTooltip(EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.main_quest", this.qInfo.getProperty(NativeProps.MAIN)));
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_quest", this.qInfo.getProperty(NativeProps.GLOBAL)));
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_share", this.qInfo.getProperty(NativeProps.GLOBAL_SHARE)));
        }
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.task_logic", this.qInfo.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase()));
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.simultaneous", this.qInfo.getProperty(NativeProps.SIMULTANEOUS)));
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.auto_claim", this.qInfo.getProperty(NativeProps.AUTO_CLAIM)));
        if (this.qInfo.getProperty(NativeProps.REPEAT_TIME) >= 0) {
            long time = this.qInfo.getProperty(NativeProps.REPEAT_TIME) / 20;
            DecimalFormat df = new DecimalFormat("00");
            String timeTxt = "";
            if (time >= 3600L) {
                timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
            } else if (time >= 60L) {
                timeTxt = timeTxt + time / 60L + "m ";
            }
            timeTxt = timeTxt + df.format(time % 60L) + "s";
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
        } else {
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", false));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public long getRepeatSeconds(EntityPlayer player) {
        if (this.qInfo.getProperty(NativeProps.REPEAT_TIME) < 0) {
            return -1L;
        }
        UserEntry ue = this.GetUserEntry(QuestingAPI.getQuestingUUID(player));
        if (ue == null) {
            return 0L;
        }
        return ((long)this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() - (player.field_70170_p.func_82737_E() - ue.getTimestamp())) / 20L;
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("config", (NBTBase)this.writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG));
        base.func_74782_a("progress", (NBTBase)this.writeToNBT(new NBTTagCompound(), EnumSaveType.PROGRESS));
        tags.func_74782_a("data", (NBTBase)base);
        tags.func_74768_a("questID", this.parentDB.getID(this));
        return new QuestingPacket(PacketTypeNative.QUEST_SYNC.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        NBTTagCompound base = payload.func_74775_l("data");
        this.readFromNBT(base.func_74775_l("config"), EnumSaveType.CONFIG);
        this.readFromNBT(base.func_74775_l("progress"), EnumSaveType.PROGRESS);
    }

    @Override
    public boolean isUnlocked(UUID uuid) {
        int A = 0;
        int B = this.preRequisites.size();
        if (B <= 0) {
            return true;
        }
        for (IQuest quest : this.preRequisites) {
            if (quest == null || !quest.isComplete(uuid)) continue;
            ++A;
        }
        return this.qInfo.getProperty(NativeProps.LOGIC_QUEST).getResult(A, B);
    }

    @Override
    public void setComplete(UUID uuid, long timestamp) {
        IParty party = PartyManager.INSTANCE.getUserParty(uuid);
        if (party == null) {
            UserEntry entry = this.GetUserEntry(uuid);
            if (entry != null) {
                entry.setClaimed(false, timestamp);
            } else {
                this.completeUsers.add(new UserEntry(uuid, timestamp));
            }
        } else {
            for (UUID mem : party.getMembers()) {
                UserEntry entry = this.GetUserEntry(mem);
                if (entry != null) {
                    entry.setClaimed(false, timestamp);
                    continue;
                }
                this.completeUsers.add(new UserEntry(mem, timestamp));
            }
        }
    }

    @Override
    public boolean isComplete(UUID uuid) {
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            return this.completeUsers.size() > 0;
        }
        return this.GetUserEntry(uuid) != null;
    }

    private void RemoveUserEntry(UUID ... uuid) {
        boolean flag = false;
        block0: for (int i = this.completeUsers.size() - 1; i >= 0; --i) {
            UserEntry entry = this.completeUsers.get(i);
            for (UUID id : uuid) {
                if (!entry.getUUID().equals(id)) continue;
                this.completeUsers.remove(i);
                flag = true;
                continue block0;
            }
        }
        if (flag) {
            PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
        }
    }

    @Override
    public EnumQuestState getState(UUID uuid) {
        if (this.isComplete(uuid)) {
            if (this.hasClaimed(uuid)) {
                return EnumQuestState.COMPLETED;
            }
            return EnumQuestState.UNCLAIMED;
        }
        if (this.isUnlocked(uuid)) {
            return EnumQuestState.UNLOCKED;
        }
        return EnumQuestState.LOCKED;
    }

    private UserEntry GetUserEntry(UUID uuid) {
        for (UserEntry entry : this.completeUsers) {
            if (!entry.getUUID().equals(uuid)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void resetUser(UUID uuid, boolean fullReset) {
        if (fullReset) {
            this.RemoveUserEntry(uuid);
        } else {
            UserEntry entry = this.GetUserEntry(uuid);
            if (entry != null) {
                entry.setClaimed(false, 0L);
            }
        }
        for (DBEntry t : this.tasks.getEntries()) {
            ((ITask)t.getValue()).resetUser(uuid);
        }
    }

    @Override
    public void resetAll(boolean fullReset) {
        if (fullReset) {
            this.completeUsers.clear();
        } else {
            for (UserEntry entry : this.completeUsers) {
                entry.setClaimed(false, 0L);
            }
        }
        for (DBEntry t : this.tasks.getEntries()) {
            ((ITask)t.getValue()).resetAll();
        }
    }

    @Override
    public IDatabaseNBT<ITask, NBTTagList> getTasks() {
        return this.tasks;
    }

    @Override
    public IDatabaseNBT<IReward, NBTTagList> getRewards() {
        return this.rewards;
    }

    @Override
    public List<IQuest> getPrerequisites() {
        return this.preRequisites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            switch (saveType) {
                case CONFIG: {
                    return this.writeToJson_Config(json);
                }
                case PROGRESS: {
                    return this.writeToJson_Progress(json);
                }
            }
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            switch (saveType) {
                case CONFIG: {
                    this.readFromJson_Config(json);
                    break;
                }
                case PROGRESS: {
                    this.readFromJson_Progress(json);
                    break;
                }
            }
        }
    }

    private NBTTagCompound writeToJson_Config(NBTTagCompound jObj) {
        jObj.func_74782_a("properties", (NBTBase)this.qInfo.writeToNBT(new NBTTagCompound()));
        jObj.func_74782_a("tasks", (NBTBase)this.tasks.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
        jObj.func_74782_a("rewards", (NBTBase)this.rewards.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
        IQuest[] pri = this.preRequisites.toArray(new IQuest[0]);
        int[] reqArr = new int[this.preRequisites.size()];
        for (int i = 0; i < pri.length; ++i) {
            reqArr[i] = this.parentDB.getID(pri[i]);
        }
        jObj.func_74782_a("preRequisites", (NBTBase)new NBTTagIntArray(reqArr));
        return jObj;
    }

    private void readFromJson_Config(NBTTagCompound jObj) {
        this.qInfo.readFromNBT(jObj.func_74775_l("properties"));
        this.tasks.readFromNBT(jObj.func_150295_c("tasks", 10), EnumSaveType.CONFIG);
        this.rewards.readFromNBT(jObj.func_150295_c("rewards", 10), EnumSaveType.CONFIG);
        this.preRequisites.clear();
        if (jObj.func_150299_b("preRequisites") == 11) {
            for (int prID : jObj.func_74759_k("preRequisites")) {
                if (prID < 0) continue;
                IQuest tmp = (IQuest)this.parentDB.getValue(prID);
                if (tmp == null) {
                    tmp = this.parentDB.createNew(prID);
                }
                this.preRequisites.add(tmp);
            }
        } else {
            NBTTagList rList = jObj.func_150295_c("preRequisites", 4);
            for (int i = 0; i < rList.func_74745_c(); ++i) {
                int prID;
                NBTBase pTag = rList.func_179238_g(i);
                int n = prID = pTag instanceof NBTPrimitive ? ((NBTPrimitive)pTag).func_150287_d() : -1;
                if (prID < 0) continue;
                IQuest tmp = (IQuest)this.parentDB.getValue(prID);
                if (tmp == null) {
                    tmp = this.parentDB.createNew(prID);
                }
                this.preRequisites.add(tmp);
            }
        }
        this.setupProps();
    }

    private NBTTagCompound writeToJson_Progress(NBTTagCompound json) {
        NBTTagList comJson = new NBTTagList();
        for (UserEntry entry : this.completeUsers) {
            comJson.func_74742_a((NBTBase)entry.writeToJson(new NBTTagCompound()));
        }
        json.func_74782_a("completed", (NBTBase)comJson);
        NBTTagList tskJson = this.tasks.writeToNBT(new NBTTagList(), EnumSaveType.PROGRESS);
        json.func_74782_a("tasks", (NBTBase)tskJson);
        return json;
    }

    private void readFromJson_Progress(NBTTagCompound json) {
        this.completeUsers.clear();
        NBTTagList comList = json.func_150295_c("completed", 10);
        for (int i = 0; i < comList.func_74745_c(); ++i) {
            NBTBase entry = comList.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            try {
                NBTTagCompound eTag = (NBTTagCompound)entry;
                UUID uuid = UUID.fromString(eTag.func_74779_i("uuid"));
                UserEntry user = new UserEntry(uuid);
                user.readFromJson(eTag);
                this.completeUsers.add(user);
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for quest", (Throwable)e);
            }
        }
        this.tasks.readFromNBT(json.func_150295_c("tasks", 10), EnumSaveType.PROGRESS);
    }

    public void setClaimed(UUID uuid, long timestamp) {
        IParty party = PartyManager.INSTANCE.getUserParty(uuid);
        if (party == null) {
            UserEntry entry = this.GetUserEntry(uuid);
            if (entry != null) {
                entry.setClaimed(true, timestamp);
            } else {
                entry = new UserEntry(uuid, timestamp);
                entry.setClaimed(true, timestamp);
                this.completeUsers.add(entry);
            }
        } else {
            for (UUID mem : party.getMembers()) {
                UserEntry entry = this.GetUserEntry(mem);
                if (entry != null) {
                    entry.setClaimed(true, timestamp);
                    continue;
                }
                entry = new UserEntry(mem, timestamp);
                entry.setClaimed(true, timestamp);
                this.completeUsers.add(entry);
            }
        }
    }
}

