/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLineEntry;
import betterquesting.storage.PropertyContainer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QuestLine
extends SimpleDatabase<IQuestLineEntry>
implements IQuestLine {
    private IPropertyContainer info = new PropertyContainer();
    private IQuestLineDatabase parentDB = QuestingAPI.getAPI(ApiReference.LINE_DB);

    public QuestLine() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest Line");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.BG_IMAGE);
        this.setupValue(NativeProps.BG_SIZE);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.info.setProperty(prop, this.info.getProperty(prop, def));
    }

    @Override
    public void setParentDatabase(IQuestLineDatabase lineDB) {
        this.parentDB = lineDB;
    }

    @Override
    public String getUnlocalisedName() {
        String def = "New Quest Line";
        if (!this.info.hasProperty(NativeProps.NAME)) {
            this.info.setProperty(NativeProps.NAME, def);
            return def;
        }
        return this.info.getProperty(NativeProps.NAME, def);
    }

    @Override
    public String getUnlocalisedDescription() {
        String def = "No Description";
        if (!this.info.hasProperty(NativeProps.DESC)) {
            this.info.setProperty(NativeProps.DESC, def);
            return def;
        }
        return this.info.getProperty(NativeProps.DESC, def);
    }

    @Override
    public IQuestLineEntry createNewEntry(int id) {
        return this.add(id, new QuestLineEntry(0, 0, 24)).getValue();
    }

    @Override
    public IPropertyContainer getProperties() {
        return this.info;
    }

    @Override
    public int getQuestAt(int x, int y) {
        for (DBEntry entry : this.getEntries()) {
            int i1 = ((IQuestLineEntry)entry.getValue()).getPosX();
            int j1 = ((IQuestLineEntry)entry.getValue()).getPosY();
            int i2 = i1 + ((IQuestLineEntry)entry.getValue()).getSize();
            int j2 = j1 + ((IQuestLineEntry)entry.getValue()).getSize();
            if (x < i1 || x >= i2 || y < j1 || y >= j2) continue;
            return entry.getID();
        }
        return -1;
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("line", (NBTBase)this.writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG));
        tags.func_74782_a("data", (NBTBase)base);
        tags.func_74768_a("lineID", this.parentDB.getID(this));
        return new QuestingPacket(PacketTypeNative.LINE_SYNC.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        this.readFromNBT(payload.func_74775_l("data").func_74775_l("line"), EnumSaveType.CONFIG);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        json.func_74782_a("properties", (NBTBase)this.info.writeToNBT(new NBTTagCompound()));
        NBTTagList jArr = new NBTTagList();
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound qle = ((IQuestLineEntry)entry.getValue()).writeToNBT(new NBTTagCompound(), saveType);
            qle.func_74768_a("id", entry.getID());
            jArr.func_74742_a((NBTBase)qle);
        }
        json.func_74782_a("quests", (NBTBase)jArr);
        return json;
    }

    @Override
    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.info.readFromNBT(json.func_74775_l("properties"));
        this.reset();
        NBTTagList qList = json.func_150295_c("quests", 10);
        for (int i = 0; i < qList.func_74745_c(); ++i) {
            int id;
            NBTBase entry = qList.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound qTag = (NBTTagCompound)entry;
            int n = id = qTag.func_150297_b("id", 99) ? qTag.func_74762_e("id") : -1;
            if (id < 0) continue;
            this.add(id, new QuestLineEntry(qTag));
        }
        this.setupProps();
    }
}

