/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyInstance;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PartyManager
extends SimpleDatabase<IParty>
implements IPartyDatabase {
    public static final PartyManager INSTANCE = new PartyManager();

    @Override
    public IParty getUserParty(UUID uuid) {
        for (DBEntry entry : this.getEntries()) {
            EnumPartyStatus status = ((IParty)entry.getValue()).getStatus(uuid);
            if (status == null || status == EnumPartyStatus.INVITE) continue;
            return (IParty)entry.getValue();
        }
        return null;
    }

    @Override
    public List<Integer> getPartyInvites(UUID uuid) {
        ArrayList<Integer> invites = new ArrayList<Integer>();
        boolean isOp = NameCache.INSTANCE.isOP(uuid);
        for (DBEntry entry : this.getEntries()) {
            if (!isOp && ((IParty)entry.getValue()).getStatus(uuid) != EnumPartyStatus.INVITE) continue;
            invites.add(entry.getID());
        }
        return invites;
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("data", (NBTBase)this.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
        return new QuestingPacket(PacketTypeNative.PARTY_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        this.readFromNBT(payload.func_150295_c("data", 10), EnumSaveType.CONFIG);
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jp = ((IParty)entry.getValue()).writeToNBT(new NBTTagCompound(), saveType);
            jp.func_74768_a("partyID", entry.getID());
            json.func_74742_a((NBTBase)jp);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.reset();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            int partyID;
            NBTBase element = json.func_179238_g(i);
            if (element.func_74732_a() != 10) continue;
            NBTTagCompound jp = (NBTTagCompound)element;
            int n = partyID = jp.func_150297_b("partyID", 99) ? jp.func_74762_e("partyID") : -1;
            if (partyID < 0) continue;
            PartyInstance party = new PartyInstance();
            party.readFromNBT(jp, EnumSaveType.CONFIG);
            if (party.getMembers().size() <= 0) continue;
            this.add(partyID, party);
        }
    }
}

