/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.api.misc.IFactory;
import betterquesting.api.placeholders.tasks.FactoryTaskPlaceholder;
import betterquesting.api.placeholders.tasks.TaskPlaceholder;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.questing.tasks.ITaskRegistry;
import betterquesting.core.BetterQuesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskRegistry
implements ITaskRegistry {
    public static final TaskRegistry INSTANCE = new TaskRegistry();
    private HashMap<ResourceLocation, IFactory<? extends ITask>> taskRegistry = new HashMap();

    private TaskRegistry() {
    }

    @Override
    public void registerTask(IFactory<? extends ITask> factory) {
        if (factory == null) {
            throw new NullPointerException("Tried to register null task");
        }
        if (factory.getRegistryName() == null) {
            throw new IllegalArgumentException("Tried to register a task with a null name: " + factory.getClass());
        }
        if (this.taskRegistry.containsKey(factory.getRegistryName()) || this.taskRegistry.containsValue(factory)) {
            throw new IllegalArgumentException("Cannot register dupliate task type: " + factory.getRegistryName());
        }
        this.taskRegistry.put(factory.getRegistryName(), factory);
    }

    @Override
    public IFactory<? extends ITask> getFactory(ResourceLocation registryName) {
        return this.taskRegistry.get(registryName);
    }

    @Override
    public List<IFactory<? extends ITask>> getAll() {
        return new ArrayList<IFactory<? extends ITask>>(this.taskRegistry.values());
    }

    @Override
    public ITask createTask(ResourceLocation registryName) {
        try {
            IFactory<TaskPlaceholder> factory = null;
            factory = FactoryTaskPlaceholder.INSTANCE.getRegistryName().equals((Object)registryName) ? FactoryTaskPlaceholder.INSTANCE : this.getFactory(registryName);
            if (factory == null) {
                BetterQuesting.logger.log(Level.ERROR, "Tried to load missing task type '" + registryName + "'! Are you missing an expansion pack?");
                return null;
            }
            return factory.createNew();
        }
        catch (Exception e) {
            BetterQuesting.logger.log(Level.ERROR, "Unable to instatiate task: " + registryName, (Throwable)e);
            return null;
        }
    }
}

