/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.storage.INameCache;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public final class NameCache
implements INameCache {
    public static final NameCache INSTANCE = new NameCache();
    private final ConcurrentHashMap<UUID, NBTTagCompound> cache = new ConcurrentHashMap();

    private NameCache() {
    }

    @Override
    public String getName(UUID uuid) {
        if (!this.cache.containsKey(uuid)) {
            return uuid.toString();
        }
        return this.cache.get(uuid).func_74779_i("name");
    }

    @Override
    public UUID getUUID(String name) {
        for (Map.Entry<UUID, NBTTagCompound> entry : this.cache.entrySet()) {
            if (!entry.getValue().func_74779_i("name").equalsIgnoreCase(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean isOP(UUID uuid) {
        if (!this.cache.containsKey(uuid)) {
            return false;
        }
        return this.cache.get(uuid).func_74767_n("isOP");
    }

    @Override
    public void updateNames(MinecraftServer server) {
        String[] names;
        for (String name : names = server.func_152358_ax().func_152654_a()) {
            GameProfile prof;
            EntityPlayerMP player = server.func_184103_al().func_152612_a(name);
            GameProfile gameProfile = prof = player == null ? null : player.func_146103_bH();
            if (prof == null) continue;
            UUID oldID = this.getUUID(prof.getName());
            while (oldID != null) {
                this.cache.remove(oldID);
                oldID = this.getUUID(prof.getName());
            }
            NBTTagCompound json = new NBTTagCompound();
            json.func_74778_a("name", prof.getName());
            json.func_74757_a("isOP", server.func_184103_al().func_152596_g(prof));
            this.cache.put(prof.getId(), json);
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("data", (NBTBase)this.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
        return new QuestingPacket(PacketTypeNative.NAME_CACHE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        this.readFromNBT(payload.func_150295_c("data", 10), EnumSaveType.CONFIG);
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (Map.Entry<UUID, NBTTagCompound> entry : this.cache.entrySet()) {
            NBTTagCompound jn = new NBTTagCompound();
            jn.func_74778_a("uuid", entry.getKey().toString());
            jn.func_74778_a("name", entry.getValue().func_74779_i("name"));
            jn.func_74757_a("isOP", entry.getValue().func_74767_n("isOP"));
            json.func_74742_a((NBTBase)jn);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.cache.clear();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTBase element = json.func_179238_g(i);
            if (element == null || element.func_74732_a() != 10) continue;
            NBTTagCompound jn = (NBTTagCompound)element;
            try {
                UUID uuid = UUID.fromString(jn.func_74779_i("uuid"));
                String name = jn.func_74779_i("name");
                boolean isOP = jn.func_74767_n("isOP");
                NBTTagCompound j2 = new NBTTagCompound();
                j2.func_74778_a("name", name);
                j2.func_74757_a("isOP", isOP);
                this.cache.put(uuid, j2);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.cache.clear();
    }

    @Override
    public List<String> getAllNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (NBTTagCompound json : this.cache.values()) {
            if (json == null || !json.func_150297_b("name", 8)) continue;
            list.add(json.func_74779_i("name"));
        }
        return list;
    }
}

