/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels;

import betterquesting.api2.client.gui.misc.ComparatorGuiDepth;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class CanvasEmpty
implements IGuiCanvas {
    private final List<IGuiPanel> guiPanels = new CopyOnWriteArrayList<IGuiPanel>();
    private final IGuiRect transform;
    private boolean enabled = true;

    public CanvasEmpty(IGuiRect rect) {
        this.transform = rect;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void initPanel() {
        this.guiPanels.clear();
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        for (IGuiPanel entry : this.guiPanels) {
            if (!entry.isEnabled()) continue;
            entry.drawPanel(mx, my, partialTick);
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseClick(mx, my, click)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseRelease(mx, my, click)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseScroll(mx, my, scroll)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onKeyTyped(c, keycode)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            List<String> tt;
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || (tt = entry.getTooltip(mx, my)) == null) continue;
            return tt;
        }
        return null;
    }

    @Override
    public void addPanel(IGuiPanel panel) {
        if (panel == null || this.guiPanels.contains(panel)) {
            return;
        }
        this.guiPanels.add(panel);
        this.guiPanels.sort(ComparatorGuiDepth.INSTANCE);
        panel.getTransform().setParent(this.getTransform());
        panel.initPanel();
    }

    @Override
    public boolean removePanel(IGuiPanel panel) {
        return this.guiPanels.remove(panel);
    }

    @Override
    public void resetCanvas() {
        this.guiPanels.clear();
    }
}

