/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.resources.textures.SimpleTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiQuestLines;
import betterquesting.client.gui2.GuiThemes;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.client.gui2.party.GuiPartyCreate;
import betterquesting.client.gui2.party.GuiPartyManage;
import betterquesting.client.gui3.GuiStatus;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.network.handlers.NetSettingSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.QuestSettings;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class GuiHome
extends GuiScreenCanvas
implements IPEventListener {
    public static GuiScreen bookmark;

    public GuiHome(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initPanel() {
        PanelButton tstBtn;
        super.initPanel();
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        ResourceLocation homeGui = new ResourceLocation(QuestSettings.INSTANCE.getProperty(NativeProps.HOME_IMAGE));
        SimpleTexture homeSplashBG = new SimpleTexture(homeGui, new GuiRectangle(0, 0, 256, 128));
        SimpleTexture homeSplashTitle = new SimpleTexture(homeGui, new GuiRectangle(0, 128, 256, 128)).maintainAspect(true);
        float ancX = QuestSettings.INSTANCE.getProperty(NativeProps.HOME_ANC_X).floatValue();
        float ancY = QuestSettings.INSTANCE.getProperty(NativeProps.HOME_ANC_Y).floatValue();
        int offX = QuestSettings.INSTANCE.getProperty(NativeProps.HOME_OFF_X);
        int offY = QuestSettings.INSTANCE.getProperty(NativeProps.HOME_OFF_Y);
        CanvasTextured bgCan = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(bgCan);
        CanvasEmpty inCan = new CanvasEmpty(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 16, 16, 16), 0));
        bgCan.addPanel(inCan);
        CanvasTextured splashCan = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 32), 0), homeSplashBG);
        inCan.addPanel(splashCan);
        CanvasTextured splashTitle = new CanvasTextured(new GuiTransform(new Vector4f(ancX, ancY, ancX, ancY), new GuiPadding(offX, offY, -256 - offX, -128 - offY), 0), homeSplashTitle);
        splashCan.addPanel(splashTitle);
        PanelButton btnExit = new PanelButton(new GuiTransform(new Vector4f(0.0f, 1.0f, 0.25f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 0, QuestTranslation.translate("betterquesting.home.exit", new Object[0]));
        inCan.addPanel(btnExit);
        PanelButton btnQuests = new PanelButton(new GuiTransform(new Vector4f(0.25f, 1.0f, 0.5f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 1, QuestTranslation.translate("betterquesting.home.quests", new Object[0]));
        inCan.addPanel(btnQuests);
        PanelButton btnParty = new PanelButton(new GuiTransform(new Vector4f(0.5f, 1.0f, 0.75f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 2, QuestTranslation.translate("betterquesting.home.party", new Object[0]));
        btnParty.setActive(QuestSettings.INSTANCE.getProperty(NativeProps.PARTY_ENABLE));
        inCan.addPanel(btnParty);
        PanelButton btnTheme = new PanelButton(new GuiTransform(new Vector4f(0.75f, 1.0f, 1.0f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 3, QuestTranslation.translate("betterquesting.home.theme", new Object[0]));
        inCan.addPanel(btnTheme);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            PanelButton btnEdit = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, new GuiPadding(0, 0, -16, -16), 0), 4, "").setIcon(PresetIcon.ICON_GEAR.getTexture());
            inCan.addPanel(btnEdit);
        }
        if (Minecraft.func_71410_x().func_71387_A() && SaveLoadHandler.INSTANCE.hasUpdate()) {
            tstBtn = new PanelButton(new GuiTransform(GuiAlign.TOP_RIGHT, -16, 0, 16, 16, 0), 5, "");
            tstBtn.setIcon(PresetIcon.ICON_NOTICE.getTexture(), PresetColor.UPDATE_NOTICE.getColor(), 0);
            tstBtn.setTooltip(Collections.singletonList(QuestTranslation.translateTrimmed("betterquesting.tooltip.update_quests", true)));
            inCan.addPanel(tstBtn);
        }
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            tstBtn = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 0, 16, 16, 16, 0), 6, "?");
            inCan.addPanel(tstBtn);
        }
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        Minecraft mc = Minecraft.func_71410_x();
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            mc.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            mc.func_147108_a((GuiScreen)new GuiQuestLines(this));
        } else if (btn.getButtonID() == 2) {
            DBEntry<IParty> party = PartyManager.INSTANCE.getParty(QuestingAPI.getQuestingUUID((EntityPlayer)mc.field_71439_g));
            if (party != null) {
                mc.func_147108_a((GuiScreen)new GuiPartyManage(this));
            } else {
                mc.func_147108_a((GuiScreen)new GuiPartyCreate(this));
            }
        } else if (btn.getButtonID() == 3) {
            mc.func_147108_a((GuiScreen)new GuiThemes(this));
        } else if (btn.getButtonID() == 4) {
            mc.func_147108_a((GuiScreen)new GuiNbtEditor((GuiScreen)this, QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()), value -> {
                QuestSettings.INSTANCE.readFromNBT((NBTTagCompound)value);
                NetSettingSync.requestEdit();
            }));
        } else if (btn.getButtonID() == 5) {
            File qFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
            if (qFile.exists()) {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                    boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
                    boolean hardMode = QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
                    NBTTagList jsonP = QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), (List<UUID>)null);
                    NBTTagCompound j1 = NBTConverter.JSONtoNBT_Object(JsonHelper.ReadFromFile(qFile), new NBTTagCompound(), true);
                    QuestSettings.INSTANCE.readFromNBT(j1.func_74775_l("questSettings"));
                    QuestDatabase.INSTANCE.readFromNBT(j1.func_150295_c("questDatabase", 10), false);
                    QuestLineDatabase.INSTANCE.readFromNBT(j1.func_150295_c("questLines", 10), false);
                    QuestDatabase.INSTANCE.readProgressFromNBT(jsonP, false);
                    QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
                    QuestSettings.INSTANCE.setProperty(NativeProps.HARDCORE, hardMode);
                    NetSettingSync.sendSync(null);
                    NetQuestSync.quickSync(-1, true, true);
                    NetChapterSync.sendSync(null, null);
                    SaveLoadHandler.INSTANCE.resetUpdate();
                    SaveLoadHandler.INSTANCE.markDirty();
                });
                mc.func_147108_a(null);
            }
        } else if (btn.getButtonID() == 6) {
            mc.func_147108_a((GuiScreen)new GuiStatus(this));
        }
    }
}

