/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.client.gui2.editors.GuiQuestLinesEditor;
import betterquesting.network.handlers.NetQuestAction;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class GuiQuestLines
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private IQuestLine selectedLine = null;
    private int selectedLineId = -1;
    private final List<PanelButtonStorage> qlBtns = new ArrayList<PanelButtonStorage>();
    private CanvasQuestLine cvQuest;
    private CanvasScrolling cvDesc;
    private PanelVScrollBar scDesc;
    private CanvasScrolling cvLines;
    private PanelVScrollBar scLines;
    private PanelTextBox paDesc;
    private PanelButton claimAll;

    public GuiQuestLines(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void refreshGui() {
        this.refreshList();
        this.refreshContent();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        if (this.selectedLineId >= 0) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(this.selectedLineId);
            if (this.selectedLine == null) {
                this.selectedLineId = -1;
            }
        } else {
            this.selectedLine = null;
        }
        boolean canEdit = QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        if (canEdit) {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 100, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -16, 100, 16, 0), 3, QuestTranslation.translate("betterquesting.btn.edit", new Object[0])));
        } else {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        }
        this.cvLines = new CanvasScrolling(new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(16, 16, -158, 16), 0));
        cvBackground.addPanel(this.cvLines);
        this.scLines = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(0, 0, -8, 0), 0));
        this.cvLines.setScrollDriverY(this.scLines);
        cvBackground.addPanel(this.scLines);
        this.scLines.getTransform().setParent(this.cvLines.getTransform());
        this.refreshList();
        CanvasTextured cvFrame = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(174, 16, 16, 66), 0), PresetTexture.AUX_FRAME_0.getTexture());
        cvBackground.addPanel(cvFrame);
        CanvasQuestLine oldCvQuest = this.cvQuest;
        this.cvQuest = new CanvasQuestLine(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), 2);
        cvFrame.addPanel(this.cvQuest);
        this.cvDesc = new CanvasScrolling(new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(174, -66, 24, 16), 0));
        cvBackground.addPanel(this.cvDesc);
        this.paDesc = new PanelTextBox(new GuiRectangle(0, 0, this.cvDesc.getTransform().getWidth(), 0, 0), "", true);
        this.paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
        this.cvDesc.addCulledPanel(this.paDesc, false);
        this.scDesc = new PanelVScrollBar(new GuiTransform(GuiAlign.BOTTOM_RIGHT, new GuiPadding(-24, -66, 16, 16), 0));
        this.cvDesc.setScrollDriverY(this.scDesc);
        cvBackground.addPanel(this.scDesc);
        if (this.selectedLine != null) {
            this.cvQuest.setQuestLine(this.selectedLine);
            if (oldCvQuest != null) {
                this.cvQuest.setZoom(oldCvQuest.getZoom());
                this.cvQuest.setScrollX(oldCvQuest.getScrollX());
                this.cvQuest.setScrollY(oldCvQuest.getScrollY());
                this.cvQuest.refreshScrollBounds();
                this.cvQuest.updatePanelScroll();
            }
            this.paDesc.setText(QuestTranslation.translate(this.selectedLine.getUnlocalisedDescription(), new Object[0]));
            this.cvDesc.refreshScrollBounds();
            this.scDesc.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
        }
        PanelButton fitView = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_RIGHT, -16, -16, 16, 16, -2), 5, "");
        fitView.setIcon(PresetIcon.ICON_BOX_FIT.getTexture());
        cvFrame.addPanel(fitView);
        this.claimAll = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_RIGHT, -32, -16, 16, 16, -2), 4, "");
        this.claimAll.setIcon(PresetIcon.ICON_CHEST.getTexture());
        cvFrame.addPanel(this.claimAll);
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_LEFT, 16, 16, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.TOP_LEFT, 166, 16, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), -1);
        cvBackground.addPanel(paLine0);
        GuiTransform ls1 = new GuiTransform(GuiAlign.BOTTOM_LEFT, 16, -16, 0, 0, 0);
        ls1.setParent(cvBackground.getTransform());
        GuiTransform le1 = new GuiTransform(GuiAlign.BOTTOM_LEFT, 166, -16, 0, 0, 0);
        le1.setParent(cvBackground.getTransform());
        PanelLine paLine1 = new PanelLine(ls1, le1, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine1);
        GuiTransform ls3 = new GuiTransform(GuiAlign.BOTTOM_LEFT, 174, -16, 0, 0, 0);
        ls3.setParent(cvBackground.getTransform());
        GuiTransform le3 = new GuiTransform(GuiAlign.BOTTOM_RIGHT, -16, -16, 0, 0, 0);
        le3.setParent(cvBackground.getTransform());
        PanelLine paLine3 = new PanelLine(ls3, le3, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine3);
        this.refreshClaimAll();
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        Minecraft mc = Minecraft.func_71410_x();
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            mc.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1 && btn instanceof PanelButtonStorage) {
            IQuestLine ql;
            for (PanelButtonStorage b : this.qlBtns) {
                if (b.getStoredValue() != this.selectedLine) continue;
                b.setActive(true);
                break;
            }
            this.selectedLine = ql = (IQuestLine)((PanelButtonStorage)btn).getStoredValue();
            this.selectedLineId = QuestLineDatabase.INSTANCE.getID(ql);
            this.cvQuest.setQuestLine(ql);
            this.paDesc.setText(QuestTranslation.translate(ql.getUnlocalisedDescription(), new Object[0]));
            this.cvDesc.refreshScrollBounds();
            this.refreshClaimAll();
            this.scDesc.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
            btn.setActive(false);
        } else if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            DBEntry quest = (DBEntry)((PanelButtonStorage)btn).getStoredValue();
            GuiHome.bookmark = new GuiQuest(this, quest.getID());
            mc.func_147108_a(GuiHome.bookmark);
        } else if (btn.getButtonID() == 3) {
            mc.func_147108_a((GuiScreen)new GuiQuestLinesEditor(this));
        } else if (btn.getButtonID() == 4) {
            if (this.cvQuest.getQuestButtons().size() <= 0) {
                return;
            }
            ArrayList<Integer> claimIdList = new ArrayList<Integer>();
            for (PanelButtonQuest pbQuest : this.cvQuest.getQuestButtons()) {
                IQuest q = (IQuest)((DBEntry)pbQuest.getStoredValue()).getValue();
                if (q.getRewards().size() <= 0 || !q.canClaim((EntityPlayer)mc.field_71439_g)) continue;
                claimIdList.add(((DBEntry)pbQuest.getStoredValue()).getID());
            }
            int[] cIDs = new int[claimIdList.size()];
            for (int i = 0; i < cIDs.length; ++i) {
                cIDs[i] = (Integer)claimIdList.get(i);
            }
            NetQuestAction.requestClaim(cIDs);
        } else if (btn.getButtonID() == 5) {
            if (this.cvQuest.getQuestLine() == null) {
                return;
            }
            this.cvQuest.fitToWindow();
        }
    }

    private void refreshList() {
        for (PanelButtonStorage btn : this.qlBtns) {
            this.cvLines.removePanel(btn);
        }
        boolean canEdit = QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        List<DBEntry<IQuestLine>> lineList = QuestLineDatabase.INSTANCE.getSortedEntries();
        this.qlBtns.clear();
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        int n = 0;
        for (DBEntry<IQuestLine> iQuestLineDBEntry : lineList) {
            IQuestLine ql = iQuestLineDBEntry.getValue();
            EnumQuestVisibility vis = ql.getProperty(NativeProps.VISIBILITY);
            if (!canEdit && vis == EnumQuestVisibility.HIDDEN) continue;
            boolean show = false;
            boolean unlocked = false;
            boolean complete = false;
            boolean allComplete = true;
            boolean pendingClaim = false;
            if (canEdit) {
                show = true;
                unlocked = true;
                complete = true;
            }
            for (DBEntry qID : ql.getEntries()) {
                IQuest q = (IQuest)QuestDatabase.INSTANCE.getValue(qID.getID());
                if (q == null) continue;
                if (allComplete && !q.isComplete(playerID)) {
                    allComplete = false;
                }
                if (!pendingClaim && q.isComplete(playerID) && !q.hasClaimed(playerID)) {
                    pendingClaim = true;
                }
                if (!unlocked && q.isUnlocked(playerID)) {
                    unlocked = true;
                }
                if (!complete && q.isComplete(playerID)) {
                    complete = true;
                }
                if (!show && QuestCache.isQuestShown(q, playerID, (EntityPlayer)this.field_146297_k.field_71439_g)) {
                    show = true;
                }
                if (!unlocked || !complete || !show || !pendingClaim || allComplete) continue;
                break;
            }
            if (vis == EnumQuestVisibility.COMPLETED && !complete || vis == EnumQuestVisibility.UNLOCKED && !unlocked) continue;
            this.cvLines.addPanel(new PanelGeneric(new GuiRectangle(126, n * 16, 16, 16, 0), new OreDictTexture(1.0f, ql.getProperty(NativeProps.ICON), false, true)));
            if (pendingClaim) {
                this.cvLines.addPanel(new PanelGeneric(new GuiRectangle(134, n * 16 + 8, 8, 8, -1), new GuiTextureColored(PresetIcon.ICON_NOTICE.getTexture(), new GuiColorStatic(-256))));
            } else if (allComplete) {
                this.cvLines.addPanel(new PanelGeneric(new GuiRectangle(134, n * 16 + 8, 8, 8, -1), new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), new GuiColorStatic(-16711936))));
            }
            PanelButtonStorage<IQuestLine> btnLine = new PanelButtonStorage<IQuestLine>(new GuiRectangle(0, n++ * 16, 126, 16, 0), 1, QuestTranslation.translate(ql.getUnlocalisedName(), new Object[0]), ql);
            if (!show || ql == this.selectedLine) {
                btnLine.setActive(false);
            }
            this.cvLines.addPanel(btnLine);
            this.qlBtns.add(btnLine);
        }
        this.scLines.setEnabled(this.cvLines.getScrollBounds().getHeight() > 0);
    }

    private void refreshContent() {
        if (this.selectedLineId >= 0) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(this.selectedLineId);
            if (this.selectedLine == null) {
                this.selectedLineId = -1;
            }
        } else {
            this.selectedLine = null;
        }
        this.cvQuest.setQuestLine(this.selectedLine);
        if (this.selectedLine != null) {
            this.paDesc.setText(QuestTranslation.translate(this.selectedLine.getUnlocalisedDescription(), new Object[0]));
        } else {
            this.paDesc.setText("");
        }
        this.cvDesc.refreshScrollBounds();
        this.refreshClaimAll();
        this.scDesc.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
    }

    private void refreshClaimAll() {
        if (this.cvQuest.getQuestLine() == null || this.cvQuest.getQuestButtons().size() <= 0) {
            this.claimAll.setActive(false);
            return;
        }
        for (PanelButtonQuest btn : this.cvQuest.getQuestButtons()) {
            if (!((IQuest)((DBEntry)btn.getStoredValue()).getValue()).canClaim((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            this.claimAll.setActive(true);
            return;
        }
        this.claimAll.setActive(false);
    }
}

