/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.ui_builder;

import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.INBTSaveLoad;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.util.vector.Vector4f;

public class ComponentPanel
implements INBTSaveLoad<NBTTagCompound> {
    private String refName = "New Panel";
    private NBTTagCompound transTag = new NBTTagCompound();
    private NBTTagCompound panelData = new NBTTagCompound();
    private final List<String> scripts = new ArrayList<String>();
    private final List<ComponentPanel> children = new ArrayList<ComponentPanel>();

    public List<ComponentPanel> getChildren() {
        return this.children;
    }

    public IGuiPanel build(@Nullable IGuiCanvas parent) {
        Vector4f anchor = new Vector4f(this.transTag.func_74760_g("anchor_left"), this.transTag.func_74760_g("anchor_top"), this.transTag.func_74760_g("anchor_right"), this.transTag.func_74760_g("anchor_bottom"));
        GuiPadding padding = new GuiPadding(this.transTag.func_74762_e("pad_left"), this.transTag.func_74762_e("pad_top"), this.transTag.func_74762_e("pad_right"), this.transTag.func_74762_e("pad_bottom"));
        GuiTransform transform = new GuiTransform(anchor, padding, this.transTag.func_74762_e("depth"));
        CanvasTextured canvas = new CanvasTextured(transform, PresetTexture.PANEL_MAIN.getTexture());
        if (parent != null) {
            parent.addPanel(canvas);
        }
        this.children.forEach(child -> child.build(canvas));
        return canvas;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("transform", (NBTBase)this.transTag);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.refName = nbt.func_74779_i("ref_name");
        this.transTag = nbt.func_74775_l("transform");
        this.panelData = nbt.func_74775_l("panel_data");
        this.scripts.clear();
        NBTTagList sList = nbt.func_150295_c("script_hooks", 8);
        for (int i = 0; i < sList.func_74745_c(); ++i) {
            this.scripts.add(sList.func_150307_f(i));
        }
        NBTTagList cList = nbt.func_150295_c("children", 10);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            ComponentPanel child = new ComponentPanel();
            child.readFromNBT(cList.func_150305_b(i));
            this.children.add(child);
        }
    }
}

