/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.themes.ITheme;
import betterquesting.api.placeholders.ThemeDummy;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.config.GuiUtils;

public abstract class GuiElement {
    public float zLevel = 0.0f;

    public static ITheme currentTheme() {
        if (QuestingAPI.getAPI(ApiReference.THEME_REG) != null) {
            return QuestingAPI.getAPI(ApiReference.THEME_REG).getCurrentTheme();
        }
        return ThemeDummy.INSTANCE;
    }

    public static int getTextColor() {
        return GuiElement.currentTheme().getTextColor();
    }

    public void drawCenteredString(FontRenderer font, String text, int x, int y, int color, boolean shadow) {
        font.func_175065_a(text, (float)(x - font.func_78256_a(text) / 2), (float)y, color, shadow);
    }

    public void drawString(FontRenderer font, String text, int x, int y, int color, boolean shadow) {
        font.func_175065_a(text, (float)x, (float)y, color, shadow);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int w, int h) {
        GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)u, (int)v, (int)w, (int)h, (float)this.zLevel);
    }

    public void drawTexturedModelRectFromIcon(int x, int y, TextureAtlasSprite sprite, int w, int h) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + h), (double)this.zLevel).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)(y + h), (double)this.zLevel).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)(y + 0), (double)this.zLevel).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.zLevel).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        GuiUtils.drawGradientRect((int)((int)this.zLevel), (int)left, (int)top, (int)right, (int)bottom, (int)startColor, (int)endColor);
    }

    public void drawTooltip(List<String> textLines, int x, int y, FontRenderer fontRendererObj) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.drawHoveringText(textLines, (int)x, (int)y, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)fontRendererObj);
    }

    public boolean isWithin(int xIn, int yIn, int x, int y, int w, int h) {
        return xIn >= x && xIn < x + w && yIn >= y && yIn < y + h;
    }
}

