/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui.controls;

import betterquesting.api.client.gui.controls.GuiButtonStorage;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GuiButtonJson<T extends JsonElement>
extends GuiButtonStorage<T> {
    private T json = null;
    private boolean isItem = false;
    private boolean isFluid = false;
    private boolean isEntity = false;

    public GuiButtonJson(int id, int posX, int posY, T json) {
        this(id, posX, posY, 200, 20, json, true);
    }

    public GuiButtonJson(int id, int posX, int posY, int width, int height, T json, boolean shadow) {
        super(id, posX, posY, width, height, "", shadow);
        this.json = json;
        this.refreshJson();
    }

    @Override
    public T getStored() {
        return this.json;
    }

    @Override
    public void setStored(T value) {
        this.json = value;
    }

    public void refreshJson() {
        if (this.json == null) {
            this.field_146126_j = "?";
            return;
        }
        if (this.json.isJsonObject()) {
            if (JsonHelper.isItem(this.json.getAsJsonObject())) {
                this.isItem = true;
            } else if (JsonHelper.isFluid(this.json.getAsJsonObject())) {
                this.isFluid = true;
            } else if (JsonHelper.isEntity(this.json.getAsJsonObject())) {
                this.isEntity = true;
            }
        }
        if (this.isItem) {
            BigItemStack stack = JsonHelper.JsonToItemStack(this.json.getAsJsonObject());
            this.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.item", (Object[])new Object[0]) + ": " + stack.getBaseStack().func_82833_r();
        } else if (this.isFluid) {
            FluidStack fluid = JsonHelper.JsonToFluidStack(this.json.getAsJsonObject());
            this.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.fluid", (Object[])new Object[0]) + ": " + fluid.getLocalizedName();
        } else if (this.isEntity) {
            Entity entity = JsonHelper.JsonToEntity(this.json.getAsJsonObject(), (World)this.mc.field_71441_e);
            this.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.entity", (Object[])new Object[0]) + ": " + entity.func_70005_c_();
        } else {
            this.field_146126_j = this.getJsonName();
        }
    }

    private String getJsonName() {
        if (this.json == null) {
            return "?";
        }
        if (this.json instanceof JsonObject) {
            return I18n.func_135052_a((String)"betterquesting.btn.object", (Object[])new Object[0]) + "...";
        }
        if (this.json instanceof JsonArray) {
            return I18n.func_135052_a((String)"betterquesting.btn.list", (Object[])new Object[0]) + "...";
        }
        if (this.json instanceof JsonPrimitive) {
            JsonPrimitive jPrim = this.json.getAsJsonPrimitive();
            if (jPrim.isBoolean()) {
                return "" + jPrim.getAsBoolean();
            }
            return I18n.func_135052_a((String)"betterquesting.btn.text", (Object[])new Object[0]);
        }
        return this.json.getClass().getSimpleName();
    }

    public boolean isItem() {
        return this.isItem;
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public boolean isEntity() {
        return this.isEntity;
    }
}

