/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui.controls;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiButtonQuestInstance
extends GuiButtonThemed {
    private IQuest quest;
    private List<GuiButtonQuestInstance> parents = new ArrayList<GuiButtonQuestInstance>();

    public GuiButtonQuestInstance(int id, int x, int y, int w, int h, IQuest quest) {
        super(id, x, y, w, h, "", false);
        this.quest = quest;
    }

    public void addParent(GuiButtonQuestInstance btn) {
        this.parents.add(btn);
    }

    public List<GuiButtonQuestInstance> getParents() {
        return this.parents;
    }

    public IQuest getQuest() {
        return this.quest;
    }

    @Override
    public void func_146112_a(Minecraft mc, int mx, int my) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)mc.field_71439_g);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).getProperty(NativeProps.HARDCORE).booleanValue()) {
            this.field_146125_m = true;
            this.field_146124_l = true;
        } else if (mc.field_71439_g == null) {
            this.field_146124_l = false;
            this.field_146125_m = true;
        } else {
            this.field_146125_m = this.isQuestShown(playerID);
            boolean bl = this.field_146124_l = this.field_146125_m && this.quest.isUnlocked(playerID);
        }
        if (this.field_146125_m) {
            mc.func_110434_K().func_110577_a(this.currentTheme().getGuiTexture());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = this.func_146116_c(mc, mx, my);
            for (GuiButtonQuestInstance p : this.parents) {
                if (!p.field_146125_m) continue;
                float lsx = (float)p.field_146128_h + (float)p.field_146120_f / 2.0f;
                float lsy = (float)p.field_146129_i + (float)p.field_146121_g / 2.0f;
                float lsw = (float)p.field_146120_f / 2.0f;
                float lsh = (float)p.field_146121_g / 2.0f;
                float lex = (float)this.field_146128_h + (float)this.field_146120_f / 2.0f;
                float ley = (float)this.field_146129_i + (float)this.field_146121_g / 2.0f;
                float lew = (float)this.field_146120_f / 2.0f;
                float leh = (float)this.field_146121_g / 2.0f;
                double la = Math.atan2(ley - lsy, lex - lsx);
                double dx = Math.cos(la) * 16.0;
                double dy = Math.sin(la) * 16.0;
                la = Math.atan2((lsy += MathHelper.func_76131_a((float)((float)dy), (float)(-lsh), (float)lsh)) - ley, (lsx += MathHelper.func_76131_a((float)((float)dx), (float)(-lsw), (float)lsw)) - lex);
                dx = Math.cos(la) * 16.0;
                dy = Math.sin(la) * 16.0;
                this.currentTheme().getRenderer().drawLine(this.quest, playerID, lsx, lsy, lex += MathHelper.func_76131_a((float)((float)dx), (float)(-lew), (float)lew), ley += MathHelper.func_76131_a((float)((float)dy), (float)(-leh), (float)leh), mx, my, 1.0f);
            }
            this.currentTheme().getRenderer().drawIcon(this.quest, playerID, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, mx, my, 1.0f);
            this.func_146119_b(mc, mx, my);
        }
    }

    public boolean isQuestShown(UUID uuid) {
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.mc.field_71439_g) || this.quest.getProperties().getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.ALWAYS) {
            return true;
        }
        if (this.quest.getProperties().getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.HIDDEN) {
            return false;
        }
        if (this.quest.getProperties().getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.UNLOCKED) {
            return this.quest.isUnlocked(uuid) || this.quest.isComplete(uuid);
        }
        if (this.quest.getProperties().getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.NORMAL) {
            if (!this.quest.isComplete(uuid)) {
                for (GuiButtonQuestInstance p : this.parents) {
                    if (p.quest.isUnlocked(uuid)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.quest.getProperties().getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.COMPLETED) {
            return this.quest.isComplete(uuid);
        }
        if (this.quest.getProperties().getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.CHAIN) {
            for (GuiButtonQuestInstance q : this.parents) {
                if (!q.isQuestShown(uuid)) continue;
                return true;
            }
            return this.parents.size() <= 0;
        }
        return true;
    }
}

