/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui.lists;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiScrollingBase<T extends IScrollingEntry>
extends GuiElement
implements IGuiEmbedded {
    private List<T> entries = new ArrayList<T>();
    private final Minecraft mc;
    private int scroll = 0;
    private int posX = 0;
    private int posY = 0;
    private int width = 0;
    private int height = 0;
    private boolean dragScroll = false;
    private boolean hideBounds = false;
    private int dragState = -1;
    private int myDrag = 0;
    private int scrollDrag = 0;

    public GuiScrollingBase(Minecraft mc, int x, int y, int w, int h) {
        this.mc = mc;
        this.posX = x;
        this.posY = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public void drawBackground(int mx, int my, float partialTick) {
        int my2;
        int listY = this.posY - this.scroll;
        int maxScroll = Math.max(0, this.getListHeight() - this.height);
        boolean isHovering = this.isWithin(mx, my, this.posX, this.posY, this.width - 8, this.height);
        int mx2 = !isHovering ? -256 : mx;
        int n = my2 = !isHovering ? -256 : my;
        if (maxScroll > 0 && (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)2))) {
            if (this.dragScroll && (this.dragState == 0 || this.dragState == -1 && isHovering)) {
                this.setScrollPos(this.scrollDrag - (my - this.myDrag));
                this.dragState = 0;
            } else if (this.dragState == 1 || this.dragState == -1 && this.isWithin(mx, my, this.posX + this.width - 8, this.posY, 8, this.height)) {
                this.setScrollPos((int)((float)(my - this.posY - 8) / ((float)this.height - 20.0f) * (float)maxScroll));
                this.dragState = 1;
            } else {
                this.dragState = 3;
            }
        } else {
            this.dragState = -1;
            this.scrollDrag = this.scroll;
            this.myDrag = my;
        }
        this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)maxScroll);
        GlStateManager.func_179094_E();
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean scissor;
            IScrollingEntry e = (IScrollingEntry)this.entries.get(i);
            boolean bl = scissor = !e.canDrawOutsideBox(false);
            if (scissor) {
                GL11.glEnable((int)3089);
                RenderUtils.guiScissor(this.mc, this.posX, this.posY, this.width - 8, this.height);
            }
            e.drawBackground(mx2, my2, this.posX, listY, this.width - 8);
            if (scissor) {
                GL11.glDisable((int)3089);
            }
            listY += e.getHeight();
        }
        if (!this.hideBounds) {
            RenderUtils.DrawLine(this.posX, this.posY, this.posX + this.width - 8, this.posY, 1.0f, GuiScrollingBase.getTextColor());
            RenderUtils.DrawLine(this.posX, this.posY + this.height, this.posX + this.width - 8, this.posY + this.height, 1.0f, GuiScrollingBase.getTextColor());
        }
        this.mc.field_71446_o.func_110577_a(GuiScrollingBase.currentTheme().getGuiTexture());
        if (maxScroll > 0) {
            this.drawTexturedModalRect(this.posX + this.width - 8, this.posY, 248, 0, 8, 20);
            int n2 = 20;
            while (n2 + 20 < this.height) {
                this.drawTexturedModalRect(this.posX + this.width - 8, this.posY + n2, 248, 20, 8, 20);
                n2 += 20;
            }
            if (this.height % 20 != 0) {
                n2 -= 20 - this.height % 20;
            }
            this.drawTexturedModalRect(this.posX + this.width - 8, this.posY + n2, 248, 40, 8, 20);
            this.drawTexturedModalRect(this.posX + this.width - 8, this.posY + (int)Math.max(0.0f, (float)n2 * (float)this.scroll / (float)maxScroll), 248, 60, 8, 20);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawForeground(int mx, int my, float partialTick) {
        int count = this.entries.size();
        int listY = this.posY - this.scroll;
        boolean isHovering = this.isWithin(mx, my, this.posX, this.posY, this.width, this.height);
        int mx2 = !isHovering ? -99 : mx;
        int my2 = !isHovering ? -99 : my;
        GlStateManager.func_179094_E();
        for (int i = 0; i < count; ++i) {
            boolean scissor;
            IScrollingEntry e = (IScrollingEntry)this.entries.get(i);
            boolean bl = scissor = !e.canDrawOutsideBox(true);
            if (scissor) {
                GL11.glEnable((int)3089);
                RenderUtils.guiScissor(this.mc, this.posX, this.posY, this.width - 8, this.height);
            }
            e.drawForeground(mx2, my2, this.posX, listY, this.width - 8);
            if (scissor) {
                GL11.glDisable((int)3089);
            }
            listY += e.getHeight();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void onMouseClick(int mx, int my, int click) {
        int listY = this.posY - this.scroll;
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            IScrollingEntry e = (IScrollingEntry)this.entries.get(i);
            e.onMouseClick(mx, my, this.posX, listY, click, i);
            listY += e.getHeight();
        }
    }

    @Override
    public void onMouseScroll(int mx, int my, int dx) {
        if (this.isWithin(mx, my, this.posX, this.posY, this.width, this.height)) {
            int maxScroll = Math.max(0, this.getListHeight() - this.height);
            this.scroll = MathHelper.func_76125_a((int)(this.scroll + dx * this.getScrollSpeed()), (int)0, (int)maxScroll);
        }
    }

    @Override
    public void onKeyTyped(char c, int keyCode) {
    }

    public void allowDragScroll(boolean state) {
        this.dragScroll = state;
    }

    public void hideBounds(boolean state) {
        this.hideBounds = state;
    }

    public int getEntryUnderMouse(int mx, int my) {
        IScrollingEntry e;
        if (!this.isWithin(mx, my, this.posX, this.posY, this.width - 8, this.height)) {
            return -1;
        }
        int listY = this.posY - this.scroll;
        for (int i = 0; i < this.entries.size() && listY <= this.posY + this.height; listY += e.getHeight(), ++i) {
            e = (IScrollingEntry)this.entries.get(i);
            if (my < listY || my >= listY + e.getHeight()) continue;
            return i;
        }
        return -1;
    }

    public int getListHeight() {
        int n = 0;
        for (IScrollingEntry e : this.getEntryList()) {
            n += e.getHeight();
        }
        return n;
    }

    public int getListWidth() {
        return this.width - 8;
    }

    public List<T> getEntryList() {
        return this.entries;
    }

    public int getScrollSpeed() {
        return 8;
    }

    public void setScrollPos(int value) {
        int maxScroll = Math.max(0, this.getListHeight() - this.height);
        this.scroll = MathHelper.func_76125_a((int)value, (int)0, (int)maxScroll);
    }
}

