/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui.lists;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingBase;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import java.util.List;
import net.minecraft.client.Minecraft;

public class GuiScrollingButtons
extends GuiScrollingBase<ScrollingEntryButtonRow> {
    public GuiScrollingButtons(Minecraft mc, int x, int y, int w, int h) {
        super(mc, x, y, w, h);
    }

    public void addButtonRow(GuiButtonThemed ... buttons) {
        this.getEntryList().add(new ScrollingEntryButtonRow(buttons));
    }

    public GuiButtonThemed getButtonUnderMouse(int mx, int my) {
        int idx = this.getEntryUnderMouse(mx, my);
        if (idx < 0) {
            return null;
        }
        for (GuiButtonThemed btn : ((ScrollingEntryButtonRow)this.getEntryList().get(idx)).getButtons()) {
            if (!this.isWithin(mx, my, btn.field_146128_h, btn.field_146129_i, btn.field_146120_f, btn.field_146121_g)) continue;
            return btn;
        }
        return null;
    }

    public static class ScrollingEntryButtonRow
    extends GuiElement
    implements IScrollingEntry {
        private final GuiButtonThemed[] buttons;

        private ScrollingEntryButtonRow(GuiButtonThemed ... buttons) {
            this.buttons = buttons;
        }

        public GuiButtonThemed[] getButtons() {
            return this.buttons;
        }

        @Override
        public void drawBackground(int mx, int my, int px, int py, int width) {
            int n = 0;
            for (GuiButtonThemed btn : this.buttons) {
                btn.field_146128_h = px + n;
                btn.field_146129_i = py;
                btn.func_146112_a(btn.mc, mx, my);
                n += btn.field_146120_f;
            }
        }

        @Override
        public void drawForeground(int mx, int my, int px, int py, int width) {
            for (GuiButtonThemed btn : this.buttons) {
                List<String> tooltip;
                if (!this.isWithin(mx, my, btn.field_146128_h, btn.field_146129_i, btn.field_146120_f, btn.field_146121_g) || (tooltip = btn.getTooltip()) == null || tooltip.size() <= 0) continue;
                this.drawTooltip(tooltip, mx, my, btn.mc.field_71466_p);
                break;
            }
        }

        @Override
        public void onMouseClick(int mx, int my, int px, int py, int click, int index) {
        }

        @Override
        public int getHeight() {
            int max = 0;
            for (GuiButtonThemed btn : this.buttons) {
                if (btn.field_146121_g <= max) continue;
                max = btn.field_146121_g;
            }
            return max;
        }

        @Override
        public boolean canDrawOutsideBox(boolean isForeground) {
            return isForeground;
        }
    }
}

