/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui.lists;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.GuiScrollingBase;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import betterquesting.api.utils.RenderUtils;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.FluidStack;

public class GuiScrollingFluids
extends GuiScrollingBase<ScrollingEntryFluid> {
    private final Minecraft mc;

    public GuiScrollingFluids(Minecraft mc, int x, int y, int w, int h) {
        super(mc, x, y, w, h);
        this.mc = mc;
        this.allowDragScroll(true);
    }

    public void addFluid(FluidStack stack) {
        String desc = stack.getLocalizedName();
        desc = desc + "\n" + stack.amount + "mB";
        this.addFluid(stack, desc);
    }

    public void addFluid(FluidStack stack, String description) {
        this.getEntryList().add(new ScrollingEntryFluid(this.mc, stack, description));
    }

    public static class ScrollingEntryFluid
    extends GuiElement
    implements IScrollingEntry {
        private final Minecraft mc;
        private FluidStack stack;
        private String desc = "";

        public ScrollingEntryFluid(Minecraft mc, FluidStack stack, String desc) {
            this.mc = mc;
            this.stack = stack;
            this.setDescription(desc);
        }

        public void setDescription(String desc) {
            this.desc = desc == null ? "" : desc;
        }

        @Override
        public void drawBackground(int mx, int my, int px, int py, int width) {
            GlStateManager.func_179094_E();
            RenderUtils.DrawLine(px, py, px + width, py, 1.0f, ScrollingEntryFluid.getTextColor());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)px, (float)py, (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.mc.field_71446_o.func_110577_a(ScrollingEntryFluid.currentTheme().getGuiTexture());
            this.drawTexturedModalRect(0, 0, 0, 48, 18, 18);
            GlStateManager.func_179126_j();
            this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            if (this.stack != null) {
                try {
                    TextureAtlasSprite fluidTx = this.mc.func_147117_R().func_110572_b(this.stack.getFluid().getStill().toString());
                    fluidTx = fluidTx != null ? fluidTx : this.mc.func_147117_R().func_110572_b("missingno");
                    this.drawTexturedModelRectFromIcon(1, 1, fluidTx, 16, 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
            RenderUtils.drawSplitString(this.mc.field_71466_p, this.desc, px + 40, py + 4, width - 40, ScrollingEntryFluid.getTextColor(), false, 0, 2);
        }

        @Override
        public void drawForeground(int mx, int my, int px, int py, int width) {
            if (this.stack != null && this.isWithin(mx, my, px + 2, py + 2, 32, 32)) {
                try {
                    ArrayList<String> tt = new ArrayList<String>();
                    tt.add(this.stack.getLocalizedName());
                    tt.add(ChatFormatting.GRAY + "" + this.stack.amount + "mB");
                    this.drawTooltip(tt, mx, my, this.mc.field_71466_p);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onMouseClick(int mx, int my, int px, int py, int click, int index) {
        }

        @Override
        public int getHeight() {
            return 36;
        }

        @Override
        public boolean canDrawOutsideBox(boolean isForeground) {
            return isForeground;
        }
    }
}

