/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.client.gui.lists;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.GuiScrollingBase;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import betterquesting.api.utils.RenderUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;

public class GuiScrollingText
extends GuiScrollingBase<ScrollingEntryText> {
    private final FontRenderer fontRenderer;
    private String rawText = "";

    public GuiScrollingText(Minecraft mc, int x, int y, int width, int height) {
        this(mc, x, y, width, height, "");
    }

    public GuiScrollingText(Minecraft mc, int x, int y, int width, int height, String text) {
        super(mc, x, y, width, height);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.SetText(text);
        this.allowDragScroll(true);
    }

    public void SetText(String txt) {
        this.rawText = txt.replaceAll("\r", "");
        if (this.getEntryList().size() != 1) {
            this.getEntryList().clear();
            this.getEntryList().add(new ScrollingEntryText(this.fontRenderer, this.rawText, this.getListWidth()));
        } else {
            ((ScrollingEntryText)this.getEntryList().get(0)).setText(this.rawText);
        }
    }

    public String getText() {
        return this.rawText;
    }

    public int getCursorPos(int mx, int my) {
        if (this.getEntryList().size() > 0) {
            return ((ScrollingEntryText)this.getEntryList().get(0)).getCursorPos(mx, my);
        }
        return 0;
    }

    public static class ScrollingEntryText
    extends GuiElement
    implements IScrollingEntry {
        private final FontRenderer font;
        private String text = "";
        private int lw = 1;
        private int lh = 8;
        private int lx = 0;
        private int ly = 0;

        public ScrollingEntryText(FontRenderer font, String text, int width) {
            this.font = font;
            this.setText(text);
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public void drawBackground(int mx, int my, int px, int py, int width) {
            List tLines = this.font.func_78271_c(this.text, width);
            this.lw = width;
            this.lh = tLines.size() * this.font.field_78288_b + 2;
            this.lx = px;
            this.ly = py;
            RenderUtils.drawSplitString(this.font, this.text, px, py + 2, width, ScrollingEntryText.getTextColor(), false);
        }

        @Override
        public void drawForeground(int mx, int my, int px, int py, int width) {
        }

        @Override
        public void onMouseClick(int mx, int my, int px, int py, int click, int index) {
        }

        public int getCursorPos(int mx, int my) {
            List<String> tLines = RenderUtils.splitStringWithoutFormat(this.text, this.lw, this.font);
            if (tLines.size() <= 0) {
                return 0;
            }
            int idx = 0;
            int row = MathHelper.func_76125_a((int)((my - this.ly - 2) / this.font.field_78288_b), (int)0, (int)(tLines.size() - 1));
            String lastFormat = "";
            for (int i = 0; i < row; ++i) {
                String line = tLines.get(i);
                idx += line.length();
                lastFormat = FontRenderer.func_78282_e((String)(lastFormat + line));
            }
            String line = tLines.get(row);
            for (int i = 0; i < line.length() && this.font.func_78256_a(lastFormat + line.substring(0, i + 1)) <= mx - this.lx; ++i) {
                ++idx;
            }
            return idx;
        }

        @Override
        public int getHeight() {
            return this.lh;
        }

        @Override
        public boolean canDrawOutsideBox(boolean isForeground) {
            return false;
        }
    }
}

